/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.AbstractSpringArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"org.springframework.web.bind.annotation.MatrixVariable"})
public class MatrixVariableArgumentResolver
extends AbstractSpringArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.MatrixVariable.type();
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param, AnnotationMeta<Annotation> ann) {
        return new MatrixNamedValueMeta(ann.getValue(), Helper.isRequired(ann), Helper.defaultValue(ann), Helper.defaultValue(ann, "pathVar"));
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return CollectionUtils.first(MatrixVariableArgumentResolver.doResolveCollectionValue(meta, request));
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return MatrixVariableArgumentResolver.doResolveCollectionValue(meta, request);
    }

    private static List<String> doResolveCollectionValue(NamedValueMeta meta, HttpRequest request) {
        String name = meta.name();
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        if (variableMap == null) {
            return Collections.emptyList();
        }
        List result = null;
        String pathVar = ((MatrixNamedValueMeta)meta).pathVar;
        if (pathVar == null) {
            result = RequestUtils.parseMatrixVariableValues((Map)variableMap, (String)name);
        } else {
            List values;
            Map matrixVariables;
            String value = (String)variableMap.get(pathVar);
            if (value != null && (matrixVariables = RequestUtils.parseMatrixVariables((String)value)) != null && (values = (List)matrixVariables.get(name)) != null) {
                return values;
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        if (variableMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List> result = null;
        String pathVar = ((MatrixNamedValueMeta)meta).pathVar;
        if (pathVar == null) {
            for (Map.Entry entry : variableMap.entrySet()) {
                Map matrixVariables = RequestUtils.parseMatrixVariables((String)((String)entry.getValue()));
                if (matrixVariables == null) continue;
                if (result == null) {
                    result = new HashMap<String, List>();
                }
                for (Map.Entry matrixEntry : matrixVariables.entrySet()) {
                    result.computeIfAbsent((String)matrixEntry.getKey(), k -> new ArrayList()).addAll((Collection)matrixEntry.getValue());
                }
            }
        } else {
            String value = (String)variableMap.get(pathVar);
            if (value != null) {
                result = RequestUtils.parseMatrixVariables((String)value);
            }
        }
        return result == null ? Collections.emptyMap() : result;
    }

    private static class MatrixNamedValueMeta
    extends NamedValueMeta {
        private final String pathVar;

        public MatrixNamedValueMeta(String name, boolean required, String defaultValue, String pathVar) {
            super(name, required, defaultValue);
            this.pathVar = pathVar;
        }
    }
}

