/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

final class BeanArgumentBinder {
    private final ArgumentResolver argumentResolver;
    private final ConversionService conversionService;
    private final Map<Class<?>, ConstructorMeta> cache = CollectionUtils.newConcurrentHashMap();

    BeanArgumentBinder(FrameworkModel frameworkModel, ConversionService conversionService) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.argumentResolver = (ArgumentResolver)beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
        this.conversionService = conversionService;
    }

    public Object bind(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        String name = StringUtils.defaultIf((String)parameter.getName(), (String)"target");
        try {
            Object bean = this.buildBean(parameter, request, response);
            WebDataBinder binder = new WebDataBinder(bean, name);
            binder.setConversionService(this.conversionService);
            binder.bind((PropertyValues)new MutablePropertyValues(RequestUtils.getParametersMap((HttpRequest)request)));
            BindingResult result = binder.getBindingResult();
            if (result.hasErrors()) {
                throw new BindException(result);
            }
            return binder.getTarget();
        }
        catch (Exception e) {
            throw new RestException((Throwable)e, Messages.ARGUMENT_BIND_ERROR, new Object[]{name, parameter.getType()});
        }
    }

    private Object buildBean(ParameterMeta parameter, HttpRequest request, HttpResponse response) throws Exception {
        Class type = parameter.getActualType();
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalStateException(Messages.ARGUMENT_COULD_NOT_RESOLVED.format(new Object[]{parameter.getDescription()}));
        }
        ConstructorMeta ct = this.cache.computeIfAbsent(type, k -> this.resolveConstructor(parameter.getToolKit(), (Class<?>)k));
        ConstructorParameterMeta[] parameters = ct.parameters;
        int len = parameters.length;
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            args[i] = this.argumentResolver.resolve((ParameterMeta)parameters[i], request, response);
        }
        return ct.newInstance(args);
    }

    private ConstructorMeta resolveConstructor(RestToolKit toolKit, Class<?> type) {
        Constructor<?>[] constructors = type.getConstructors();
        Constructor<?> ct = null;
        if (constructors.length == 1) {
            ct = constructors[0];
        } else {
            try {
                ct = type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (ct == null) {
            throw new IllegalArgumentException("No available default constructor found in " + type);
        }
        return new ConstructorMeta(toolKit, ct);
    }

    private static final class ConstructorMeta {
        private final Constructor<?> constructor;
        private final ConstructorParameterMeta[] parameters;

        ConstructorMeta(RestToolKit toolKit, Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameters = this.initParameters(toolKit, constructor);
        }

        private ConstructorParameterMeta[] initParameters(RestToolKit toolKit, Constructor<?> ct) {
            Parameter[] cps = ct.getParameters();
            int len = cps.length;
            ConstructorParameterMeta[] parameters = new ConstructorParameterMeta[len];
            for (int i = 0; i < len; ++i) {
                parameters[i] = new ConstructorParameterMeta(toolKit, cps[i]);
            }
            return parameters;
        }

        Object newInstance(Object[] args) throws Exception {
            return this.constructor.newInstance(args);
        }
    }

    public static final class ConstructorParameterMeta
    extends ParameterMeta {
        private final Parameter parameter;

        ConstructorParameterMeta(RestToolKit toolKit, Parameter parameter) {
            super(toolKit, parameter.isNamePresent() ? parameter.getName() : null);
            this.parameter = parameter;
        }

        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        public Class<?> getType() {
            return this.parameter.getType();
        }

        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }
    }
}

