/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.p2p.support;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.p2p.Group;
import org.apache.dubbo.remoting.p2p.Peer;
import org.apache.dubbo.remoting.transport.ServerDelegate;

public class ServerPeer
extends ServerDelegate
implements Peer {
    private static final Logger logger = LoggerFactory.getLogger(ServerPeer.class);
    private final Map<URL, Client> clients;
    private final Group group;

    public ServerPeer(RemotingServer server, Map<URL, Client> clients, Group group) {
        super(server);
        this.clients = clients;
        this.group = group;
    }

    @Override
    public void leave() throws RemotingException {
        this.group.leave(this.getUrl());
    }

    public void close() {
        try {
            this.leave();
        }
        catch (RemotingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Channel> getChannels() {
        ArrayList<Client> channels = super.getChannels();
        if (this.clients.size() > 0) {
            channels = channels == null ? new ArrayList<Client>() : new ArrayList(channels);
            channels.addAll(this.clients.values());
        }
        return channels;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        String host = remoteAddress.getAddress() != null ? remoteAddress.getAddress().getHostAddress() : remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        Channel channel = super.getChannel(remoteAddress);
        if (channel == null) {
            for (Map.Entry<URL, Client> entry : this.clients.entrySet()) {
                URL url = entry.getKey();
                if (!url.getIp().equals(host) || url.getPort() != port) continue;
                return (Channel)entry.getValue();
            }
        }
        return channel;
    }

    public void send(Object message) throws RemotingException {
        this.send(message, this.getUrl().getParameter("sent", false));
    }

    public void send(Object message, boolean sent) throws RemotingException {
        Throwable last = null;
        try {
            super.send(message, sent);
        }
        catch (Throwable t) {
            last = t;
        }
        for (Client client : this.clients.values()) {
            try {
                client.send(message, sent);
            }
            catch (Throwable t) {
                last = t;
            }
        }
        if (last != null) {
            if (last instanceof RemotingException) {
                throw (RemotingException)last;
            }
            if (last instanceof RuntimeException) {
                throw (RuntimeException)last;
            }
            throw new RuntimeException(last.getMessage(), last);
        }
    }
}

