/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="shutdown", summary="Shutdown Dubbo Application.", example={"shutdown -t <milliseconds>"})
public class ShutdownTelnet
implements BaseCommand {
    private final FrameworkModel frameworkModel;

    public ShutdownTelnet(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public String execute(CommandContext commandContext, String[] args) {
        int sleepMilliseconds = 0;
        if (args != null && args.length > 0) {
            if (args.length == 2 && "-t".equals(args[0]) && StringUtils.isNumber((String)args[1])) {
                sleepMilliseconds = Integer.parseInt(args[1]);
            } else {
                return "Invalid parameter,please input like shutdown -t 10000";
            }
        }
        long start = System.currentTimeMillis();
        if (sleepMilliseconds > 0) {
            try {
                Thread.sleep(sleepMilliseconds);
            }
            catch (InterruptedException e) {
                return "Failed to invoke shutdown command, cause: " + e.getMessage();
            }
        }
        StringBuilder buf = new StringBuilder();
        List applicationModels = this.frameworkModel.getApplicationModels();
        for (ApplicationModel applicationModel : new ArrayList(applicationModels)) {
            applicationModel.destroy();
        }
        long end = System.currentTimeMillis();
        buf.append("Application has shutdown successfully");
        buf.append("\r\nelapsed: ");
        buf.append(end - start);
        buf.append(" ms.");
        return buf.toString();
    }
}

