/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.pu;

import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;

public class QosHTTP1Detector
implements ProtocolDetector {
    private static boolean isHttp(int magic) {
        return magic == 71 || magic == 80;
    }

    public ProtocolDetector.Result detect(ChannelBuffer in) {
        if (in.readableBytes() < 2) {
            return ProtocolDetector.Result.NEED_MORE_DATA;
        }
        byte magic = in.getByte(in.readerIndex());
        if (QosHTTP1Detector.isHttp(magic) && in.getByte(in.readerIndex() + 1) != 82) {
            return ProtocolDetector.Result.RECOGNIZED;
        }
        return ProtocolDetector.Result.UNRECOGNIZED;
    }
}

