/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.common.QosConfiguration;

public class ForeignHostPermitHandler
extends ChannelHandlerAdapter {
    private final boolean acceptForeignIp;
    private final String acceptForeignIpWhitelist;
    private Predicate<String> whitelistPredicate = foreignIp -> false;
    private final QosConfiguration qosConfiguration;

    public ForeignHostPermitHandler(QosConfiguration qosConfiguration) {
        this.qosConfiguration = qosConfiguration;
        this.acceptForeignIp = qosConfiguration.isAcceptForeignIp();
        this.acceptForeignIpWhitelist = qosConfiguration.getAcceptForeignIpWhitelist();
        if (StringUtils.isNotEmpty((String)this.acceptForeignIpWhitelist)) {
            this.whitelistPredicate = Arrays.stream(this.acceptForeignIpWhitelist.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).map(foreignIpPattern -> foreignIp -> {
                try {
                    return NetUtils.matchIpExpression((String)foreignIpPattern, (String)foreignIp, (int)-1);
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }).reduce(Predicate::or).orElse(s -> false);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.acceptForeignIp) {
            return;
        }
        if (this.qosConfiguration.isAllowAnonymousAccess()) {
            return;
        }
        InetAddress inetAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        if (inetAddress.isLoopbackAddress()) {
            return;
        }
        if (this.checkForeignIpInWhiteList(inetAddress)) {
            return;
        }
        ByteBuf cb = Unpooled.wrappedBuffer((byte[])"\r\nForeign Ip Not Permitted, Consider Config It In Whitelist.\r\n".getBytes());
        ctx.writeAndFlush((Object)cb).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private boolean checkForeignIpInWhiteList(InetAddress inetAddress) {
        if (StringUtils.isEmpty((String)this.acceptForeignIpWhitelist)) {
            return false;
        }
        String foreignIp = inetAddress.getHostAddress();
        return this.whitelistPredicate.test(foreignIp);
    }
}

