/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command;

import io.netty.channel.Channel;
import org.apache.dubbo.qos.common.QosConfiguration;
import org.apache.dubbo.qos.permission.PermissionLevel;

public class CommandContext {
    private String commandName;
    private String[] args;
    private Channel remote;
    private boolean isHttp;
    private Object originRequest;
    private int httpCode = 200;
    private QosConfiguration qosConfiguration;

    public CommandContext(String commandName) {
        this.commandName = commandName;
    }

    public CommandContext(String commandName, String[] args, boolean isHttp) {
        this.commandName = commandName;
        this.args = args;
        this.isHttp = isHttp;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public Channel getRemote() {
        return this.remote;
    }

    public void setRemote(Channel remote) {
        this.remote = remote;
    }

    public boolean isHttp() {
        return this.isHttp;
    }

    public void setHttp(boolean http) {
        this.isHttp = http;
    }

    public Object getOriginRequest() {
        return this.originRequest;
    }

    public void setOriginRequest(Object originRequest) {
        this.originRequest = originRequest;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    public void setQosConfiguration(QosConfiguration qosConfiguration) {
        this.qosConfiguration = qosConfiguration;
    }

    public boolean hasPermission(PermissionLevel cmdRequiredPermissionLevel) {
        return cmdRequiredPermissionLevel.getLevel() <= this.qosConfiguration.getAnonymousAccessPermissionLevel().getLevel();
    }

    public boolean isAllowAnonymousAccess() {
        return this.qosConfiguration.isAllowAnonymousAccess();
    }
}

