/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.probe.impl;

import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.qos.probe.ReadinessProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

@Activate
public class ProviderReadinessProbe
implements ReadinessProbe {
    private FrameworkModel frameworkModel;
    private FrameworkServiceRepository serviceRepository;

    public ProviderReadinessProbe(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel != null ? frameworkModel : FrameworkModel.defaultModel();
        this.serviceRepository = this.frameworkModel.getServiceRepository();
    }

    @Override
    public boolean check() {
        List providerModelList = this.serviceRepository.allProviderModels();
        if (providerModelList.isEmpty()) {
            return true;
        }
        boolean hasService = false;
        boolean anyOnline = false;
        for (ProviderModel providerModel : providerModelList) {
            if (providerModel.getModuleModel().isInternal()) continue;
            hasService = true;
            anyOnline = anyOnline || providerModel.getStatedUrl().isEmpty() || providerModel.getStatedUrl().stream().anyMatch(ProviderModel.RegisterStatedURL::isRegistered);
        }
        return !hasService || anyOnline;
    }
}

