/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ProviderModel;

public class ServiceCheckUtils {
    public static String getRegisterStatus(ProviderModel providerModel) {
        LinkedList<String> statuses = new LinkedList<String>();
        for (ProviderModel.RegisterStatedURL registerStatedURL : providerModel.getStatedUrl()) {
            URL registryUrl = registerStatedURL.getRegistryUrl();
            boolean isServiceDiscovery = UrlUtils.isServiceDiscoveryURL((URL)registryUrl);
            String protocol = isServiceDiscovery ? registryUrl.getParameter("registry") : registryUrl.getProtocol();
            statuses.add(protocol + "-" + (isServiceDiscovery ? "A" : "I") + "(" + (registerStatedURL.isRegistered() ? "Y" : "N") + ")");
        }
        return String.join((CharSequence)"/", statuses.toArray(new String[0]));
    }

    public static String getConsumerAddressNum(ConsumerModel consumerModel) {
        boolean num = false;
        Object object = consumerModel.getServiceMetadata().getAttribute("currentClusterInvoker");
        LinkedList<String> nums = new LinkedList<String>();
        if (object instanceof Map) {
            Map invokerMap = (Map)object;
            for (Map.Entry entry : invokerMap.entrySet()) {
                String size;
                String step;
                URL registryUrl = ((Registry)entry.getKey()).getUrl();
                boolean isServiceDiscovery = UrlUtils.isServiceDiscoveryURL((URL)registryUrl);
                String protocol = isServiceDiscovery ? registryUrl.getParameter("registry") : registryUrl.getProtocol();
                MigrationInvoker migrationInvoker = (MigrationInvoker)entry.getValue();
                MigrationStep migrationStep = migrationInvoker.getMigrationStep();
                String interfaceSize = Optional.ofNullable(migrationInvoker.getInvoker()).map(ClusterInvoker::getDirectory).map(Directory::getAllInvokers).map(List::size).map(String::valueOf).orElse("-");
                String applicationSize = Optional.ofNullable(migrationInvoker.getServiceDiscoveryInvoker()).map(ClusterInvoker::getDirectory).map(Directory::getAllInvokers).map(List::size).map(String::valueOf).orElse("-");
                switch (migrationStep) {
                    case APPLICATION_FIRST: {
                        step = "AF";
                        size = "I-" + interfaceSize + ",A-" + applicationSize;
                        break;
                    }
                    case FORCE_INTERFACE: {
                        step = "I";
                        size = interfaceSize;
                        break;
                    }
                    default: {
                        step = "A";
                        size = applicationSize;
                    }
                }
                nums.add(protocol + "-" + step + "(" + size + ")");
            }
        }
        return String.join((CharSequence)"/", nums.toArray(new String[0]));
    }
}

