/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Locale;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;

@Cmd(name="switchLogLevel", summary="Switch log level", example={"switchLogLevel info"})
public class SwitchLogLevel
implements BaseCommand {
    @Override
    public String execute(CommandContext commandContext, String[] args) {
        Level level;
        if (args.length != 1) {
            return "Unexpected argument length.";
        }
        switch (args[0]) {
            case "0": {
                level = Level.ALL;
                break;
            }
            case "1": {
                level = Level.TRACE;
                break;
            }
            case "2": {
                level = Level.DEBUG;
                break;
            }
            case "3": {
                level = Level.INFO;
                break;
            }
            case "4": {
                level = Level.WARN;
                break;
            }
            case "5": {
                level = Level.ERROR;
                break;
            }
            case "6": {
                level = Level.OFF;
                break;
            }
            default: {
                level = Level.valueOf((String)args[0].toUpperCase(Locale.ROOT));
            }
        }
        LoggerFactory.setLevel((Level)level);
        return "OK";
    }
}

