/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.probe.ReadinessProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="ready", summary="Judge if service is ready to work? ")
public class Ready
implements BaseCommand {
    private FrameworkModel frameworkModel;

    public Ready(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        String config = this.frameworkModel.getApplicationModels().stream().map(applicationModel -> applicationModel.getApplicationConfigManager().getApplication()).map(o -> o.orElse(null)).filter(Objects::nonNull).map(ApplicationConfig::getReadinessProbe).filter(Objects::nonNull).collect(Collectors.joining(","));
        URL url = URL.valueOf((String)"application://").addParameter("dubbo.application.readiness-probe", config);
        List readinessProbes = this.frameworkModel.getExtensionLoader(ReadinessProbe.class).getActivateExtension(url, "dubbo.application.readiness-probe");
        if (!readinessProbes.isEmpty()) {
            for (ReadinessProbe readinessProbe : readinessProbes) {
                if (readinessProbe.check()) continue;
                commandContext.setHttpCode(503);
                return "false";
            }
        }
        commandContext.setHttpCode(200);
        return "true";
    }
}

