/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;

public class ThreadPoolRejectMetric
implements Metric {
    private String applicationName;
    private String threadPoolName;

    public ThreadPoolRejectMetric(String applicationName, String threadPoolName) {
        this.applicationName = applicationName;
        this.threadPoolName = threadPoolName;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadPoolRejectMetric that = (ThreadPoolRejectMetric)o;
        return Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.threadPoolName, that.threadPoolName);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.threadPoolName);
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("pid", ConfigUtils.getPid() + "");
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("thread.pool.name", this.threadPoolName);
        return tags;
    }
}

