/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.MethodStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;
import org.apache.dubbo.rpc.Invocation;

public abstract class BaseStatComposite
implements MetricsExport {
    private final ApplicationStatComposite applicationStatComposite = new ApplicationStatComposite();
    private final ServiceStatComposite serviceStatComposite = new ServiceStatComposite();
    private final MethodStatComposite methodStatComposite = new MethodStatComposite();
    private final RtStatComposite rtStatComposite = new RtStatComposite();

    public BaseStatComposite() {
        this.init(this.applicationStatComposite);
        this.init(this.serviceStatComposite);
        this.init(this.methodStatComposite);
        this.init(this.rtStatComposite);
    }

    protected void init(ApplicationStatComposite applicationStatComposite) {
    }

    protected void init(ServiceStatComposite serviceStatComposite) {
    }

    protected void init(MethodStatComposite methodStatComposite) {
    }

    protected void init(RtStatComposite rtStatComposite) {
    }

    public void calcApplicationRt(String applicationName, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcApplicationRt(applicationName, registryOpType, responseTime);
    }

    public void calcServiceKeyRt(String applicationName, String serviceKey, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcServiceKeyRt(applicationName, serviceKey, registryOpType, responseTime);
    }

    public void calcMethodKeyRt(String applicationName, Invocation invocation, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcMethodKeyRt(applicationName, invocation, registryOpType, responseTime);
    }

    public void setServiceKey(MetricsKeyWrapper metricsKey, String applicationName, String serviceKey, int num) {
        this.serviceStatComposite.setServiceKey(metricsKey, applicationName, serviceKey, num);
    }

    public void incrementApp(MetricsKey metricsKey, String applicationName, int size) {
        this.applicationStatComposite.incrementSize(metricsKey, applicationName, size);
    }

    public void incrementServiceKey(MetricsKeyWrapper metricsKeyWrapper, String applicationName, String attServiceKey, int size) {
        this.serviceStatComposite.incrementServiceKey(metricsKeyWrapper, applicationName, attServiceKey, size);
    }

    public void incrementMethodKey(MetricsKeyWrapper metricsKeyWrapper, String applicationName, Invocation invocation, int size) {
        this.methodStatComposite.incrementMethodKey(metricsKeyWrapper, applicationName, invocation, size);
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        list.addAll(this.applicationStatComposite.export(category));
        list.addAll(this.rtStatComposite.export(category));
        list.addAll(this.serviceStatComposite.export(category));
        list.addAll(this.methodStatComposite.export(category));
        return list;
    }

    public ApplicationStatComposite getApplicationStatComposite() {
        return this.applicationStatComposite;
    }

    public RtStatComposite getRtStatComposite() {
        return this.rtStatComposite;
    }
}

