/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics;

import java.lang.reflect.Method;
import org.apache.dubbo.metrics.BucketCounter;
import org.apache.dubbo.metrics.Compass;
import org.apache.dubbo.metrics.Counter;
import org.apache.dubbo.metrics.IMetricManager;
import org.apache.dubbo.metrics.Metric;
import org.apache.dubbo.metrics.MetricName;
import org.apache.dubbo.metrics.NOPMetricManager;

public class MetricManager {
    private static final String BINDER_CLASS = "org.apache.dubbo.metrics.MetricManagerBinder";
    private static final IMetricManager NOP_METRIC_MANAGER = new NOPMetricManager();
    private static volatile IMetricManager iMetricManager;

    public static Counter getCounter(String group, MetricName name) {
        IMetricManager manager = MetricManager.getIMetricManager();
        return manager.getCounter(group, name);
    }

    public static BucketCounter getBucketCounters(String group, MetricName name) {
        IMetricManager manager = MetricManager.getIMetricManager();
        return manager.getBucketCounter(group, name);
    }

    public static Compass getCompass(String group, MetricName name) {
        IMetricManager manager = MetricManager.getIMetricManager();
        return manager.getCompass(group, name);
    }

    public static void register(String group, MetricName name, Metric metric) {
        IMetricManager manager = MetricManager.getIMetricManager();
        manager.register(group, name, metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMetricManager getIMetricManager() {
        if (iMetricManager != null) return iMetricManager;
        Class<MetricManager> clazz = MetricManager.class;
        synchronized (MetricManager.class) {
            if (iMetricManager != null) return iMetricManager;
            try {
                Class<?> binderClazz = MetricManager.class.getClassLoader().loadClass(BINDER_CLASS);
                Method getSingleton = binderClazz.getMethod("getSingleton", new Class[0]);
                Object binderObject = getSingleton.invoke(null, new Object[0]);
                Method getMetricManager = binderClazz.getMethod("getMetricManager", new Class[0]);
                iMetricManager = (IMetricManager)getMetricManager.invoke(binderObject, new Object[0]);
            }
            catch (Exception e) {
                iMetricManager = NOP_METRIC_MANAGER;
            }
            return iMetricManager;
        }
    }
}

