/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metadata.definition.builder.ArrayTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.CollectionTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.EnumTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.MapTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class TypeDefinitionBuilder {
    private static final TypeBuilder ARRAY_BUILDER = new ArrayTypeBuilder();
    private static final TypeBuilder COLLECTION_BUILDER = new CollectionTypeBuilder();
    private static final TypeBuilder MAP_BUILDER = new MapTypeBuilder();
    private static final TypeBuilder ENUM_BUILDER = new EnumTypeBuilder();
    private static final List<TypeBuilder> BUILDERS = Arrays.asList(ARRAY_BUILDER, COLLECTION_BUILDER, MAP_BUILDER, ENUM_BUILDER);
    private Map<Class<?>, TypeDefinition> typeCache = new HashMap();

    public static TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        TypeDefinition td = builder != null ? builder.build(type, clazz, typeCache) : DefaultTypeBuilder.build(clazz, typeCache);
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : BUILDERS) {
            if (!builder.accept(type, clazz)) continue;
            return builder;
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz) {
        return TypeDefinitionBuilder.build(type, clazz, this.typeCache);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeCache.values());
    }
}

