/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.protoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPlugin;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPluginWrapper;
import org.apache.maven.plugin.logging.Log;

public class LinuxDubboProtocPluginWrapper
implements DubboProtocPluginWrapper {
    @Override
    public File createProtocPlugin(DubboProtocPlugin dubboProtocPlugin, Log log) {
        List<File> resolvedJars = dubboProtocPlugin.getResolvedJars();
        this.createPluginDirectory(dubboProtocPlugin.getPluginDirectory());
        File pluginExecutableFile = new File(dubboProtocPlugin.getPluginDirectory(), dubboProtocPlugin.getPluginName());
        File javaLocation = new File(dubboProtocPlugin.getJavaHome(), "bin/java");
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("javaLocation=" + javaLocation.getAbsolutePath()));
        }
        PrintWriter out = new PrintWriter(new FileWriter(pluginExecutableFile));
        try {
            out.println("#!/bin/sh");
            out.println();
            out.print("CP=");
            for (int i = 0; i < resolvedJars.size(); ++i) {
                if (i > 0) {
                    out.print(":");
                }
                out.print("\"" + resolvedJars.get(i).getAbsolutePath() + "\"");
            }
            out.println();
            out.print("ARGS=\"");
            for (String arg : dubboProtocPlugin.getArgs()) {
                out.print(arg + " ");
            }
            out.println("\"");
            out.print("JVMARGS=\"");
            for (String jvmArg : dubboProtocPlugin.getJvmArgs()) {
                out.print(jvmArg + " ");
            }
            out.println("\"");
            out.println();
            out.println("\"" + javaLocation.getAbsolutePath() + "\" $JVMARGS -cp $CP " + dubboProtocPlugin.getMainClass() + " $ARGS");
            out.println();
            boolean b = pluginExecutableFile.setExecutable(true);
            if (!b) {
                throw new RuntimeException("Could not make plugin executable: " + pluginExecutableFile);
            }
            File file = pluginExecutableFile;
            out.close();
            return file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write plugin script file: " + pluginExecutableFile, e);
            }
        }
    }

    private void createPluginDirectory(File pluginDirectory) {
        pluginDirectory.mkdirs();
        if (!pluginDirectory.isDirectory()) {
            throw new RuntimeException("Could not create protoc plugin directory: " + pluginDirectory.getAbsolutePath());
        }
    }
}

