/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.schema;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.ServiceBean;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.env.Environment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DubboBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger logger = LoggerFactory.getLogger(DubboBeanDefinitionParser.class);
    private static final Pattern GROUP_AND_VERSION = Pattern.compile("^[\\-.0-9_a-zA-Z]+(\\:[\\-.0-9_a-zA-Z]+)?$");
    private static final String ONRETURN = "onreturn";
    private static final String ONTHROW = "onthrow";
    private static final String ONINVOKE = "oninvoke";
    private static final String METHOD = "Method";
    private final Class<?> beanClass;
    private final boolean required;
    private static Map<String, Map<String, Class>> beanPropsCache = new HashMap<String, Map<String, Class>>();

    public DubboBeanDefinitionParser(Class<?> beanClass, boolean required) {
        this.beanClass = beanClass;
        this.required = required;
    }

    private static RootBeanDefinition parse(Element element, ParserContext parserContext, Class<?> beanClass, boolean required) {
        String value;
        Map<String, Class> beanPropsMap;
        String className;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(beanClass);
        beanDefinition.setLazyInit(false);
        String id = DubboBeanDefinitionParser.resolveAttribute(element, "id", parserContext);
        if (StringUtils.isEmpty((String)id) && required) {
            String generatedBeanName = DubboBeanDefinitionParser.resolveAttribute(element, "name", parserContext);
            if (StringUtils.isEmpty((String)generatedBeanName)) {
                generatedBeanName = ProtocolConfig.class.equals(beanClass) ? "dubbo" : DubboBeanDefinitionParser.resolveAttribute(element, "interface", parserContext);
            }
            if (StringUtils.isEmpty((String)generatedBeanName)) {
                generatedBeanName = beanClass.getName();
            }
            id = generatedBeanName;
            int counter = 2;
            while (parserContext.getRegistry().containsBeanDefinition(id)) {
                id = generatedBeanName + counter++;
            }
        }
        HashSet<String> processedProps = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)id)) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
            beanDefinition.getPropertyValues().addPropertyValue("id", (Object)id);
        }
        if (ProtocolConfig.class.equals(beanClass)) {
            for (String name : parserContext.getRegistry().getBeanDefinitionNames()) {
                Object value2;
                BeanDefinition definition = parserContext.getRegistry().getBeanDefinition(name);
                PropertyValue property = definition.getPropertyValues().getPropertyValue("protocol");
                if (property == null || !((value2 = property.getValue()) instanceof ProtocolConfig) || !id.equals(((ProtocolConfig)value2).getName())) continue;
                definition.getPropertyValues().addPropertyValue("protocol", (Object)new RuntimeBeanReference(id));
            }
        } else if (ServiceBean.class.equals(beanClass) && StringUtils.isNotEmpty((String)(className = DubboBeanDefinitionParser.resolveAttribute(element, "class", parserContext)))) {
            RootBeanDefinition classDefinition = new RootBeanDefinition();
            classDefinition.setBeanClass(ReflectUtils.forName((String)className));
            classDefinition.setLazyInit(false);
            DubboBeanDefinitionParser.parseProperties(element.getChildNodes(), classDefinition, parserContext);
            beanDefinition.getPropertyValues().addPropertyValue("ref", (Object)new BeanDefinitionHolder((BeanDefinition)classDefinition, id + "Impl"));
        }
        if ((beanPropsMap = beanPropsCache.get(beanClass.getName())) == null) {
            beanPropsMap = new HashMap<String, Class>();
            beanPropsCache.put(beanClass.getName(), beanPropsMap);
            if (ReferenceBean.class.equals(beanClass)) {
                DubboBeanDefinitionParser.getPropertyMap(ReferenceConfig.class, beanPropsMap);
            } else {
                DubboBeanDefinitionParser.getPropertyMap(beanClass, beanPropsMap);
            }
        }
        ManagedMap parameters = null;
        for (Map.Entry<String, Class> entry : beanPropsMap.entrySet()) {
            String reference;
            String beanProperty = entry.getKey();
            Class type = entry.getValue();
            String property = StringUtils.camelToSplitName((String)beanProperty, (String)"-");
            processedProps.add(property);
            if ("parameters".equals(property)) {
                parameters = DubboBeanDefinitionParser.parseParameters(element.getChildNodes(), beanDefinition, parserContext);
                continue;
            }
            if ("methods".equals(property)) {
                DubboBeanDefinitionParser.parseMethods(id, element.getChildNodes(), beanDefinition, parserContext);
                continue;
            }
            if ("arguments".equals(property)) {
                DubboBeanDefinitionParser.parseArguments(id, element.getChildNodes(), beanDefinition, parserContext);
                continue;
            }
            value = DubboBeanDefinitionParser.resolveAttribute(element, property, parserContext);
            if (value == null || (value = value.trim()).length() <= 0) continue;
            if ("registry".equals(property) && "N/A".equalsIgnoreCase(value)) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress("N/A");
                beanDefinition.getPropertyValues().addPropertyValue(beanProperty, (Object)registryConfig);
                continue;
            }
            if ("provider".equals(property) || "registry".equals(property) || "protocol".equals(property) && AbstractServiceConfig.class.isAssignableFrom(beanClass)) {
                beanDefinition.getPropertyValues().addPropertyValue(beanProperty + "Ids", (Object)value);
                continue;
            }
            if (DubboBeanDefinitionParser.isPrimitive(type)) {
                reference = value = DubboBeanDefinitionParser.getCompatibleDefaultValue(property, value);
            } else if (ONRETURN.equals(property) || ONTHROW.equals(property) || ONINVOKE.equals(property)) {
                int index = value.lastIndexOf(".");
                String ref = value.substring(0, index);
                String method = value.substring(index + 1);
                reference = new RuntimeBeanReference(ref);
                beanDefinition.getPropertyValues().addPropertyValue(property + METHOD, (Object)method);
            } else {
                BeanDefinition refBean;
                if ("ref".equals(property) && parserContext.getRegistry().containsBeanDefinition(value) && !(refBean = parserContext.getRegistry().getBeanDefinition(value)).isSingleton()) {
                    throw new IllegalStateException("The exported service ref " + value + " must be singleton! Please set the " + value + " bean scope to singleton, eg: <bean id=\"" + value + "\" scope=\"singleton\" ...>");
                }
                reference = new RuntimeBeanReference(value);
            }
            beanDefinition.getPropertyValues().addPropertyValue(beanProperty, (Object)reference);
        }
        NamedNodeMap attributes = element.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = attributes.item(i);
            String name = node.getLocalName();
            if (processedProps.contains(name)) continue;
            if (parameters == null) {
                parameters = new ManagedMap();
            }
            value = node.getNodeValue();
            parameters.put((Object)name, (Object)new TypedStringValue(value, String.class));
        }
        if (parameters != null) {
            beanDefinition.getPropertyValues().addPropertyValue("parameters", parameters);
        }
        if (ProviderConfig.class.equals(beanClass)) {
            DubboBeanDefinitionParser.parseNested(element, parserContext, ServiceBean.class, true, "service", "provider", id, (BeanDefinition)beanDefinition);
        } else if (ConsumerConfig.class.equals(beanClass)) {
            DubboBeanDefinitionParser.parseNested(element, parserContext, ReferenceBean.class, false, "reference", "consumer", id, (BeanDefinition)beanDefinition);
        } else if (ReferenceBean.class.equals(beanClass)) {
            DubboBeanDefinitionParser.configReferenceBean(element, parserContext, beanDefinition, null);
        }
        return beanDefinition;
    }

    private static void configReferenceBean(Element element, ParserContext parserContext, RootBeanDefinition beanDefinition, BeanDefinition consumerDefinition) {
        String interfaceClassName = DubboBeanDefinitionParser.resolveAttribute(element, "interface", parserContext);
        String generic = DubboBeanDefinitionParser.resolveAttribute(element, "generic", parserContext);
        if (StringUtils.isBlank((CharSequence)generic) && consumerDefinition != null) {
            generic = (String)consumerDefinition.getPropertyValues().get("generic");
        }
        if (generic != null) {
            Environment environment = parserContext.getReaderContext().getEnvironment();
            generic = environment.resolvePlaceholders(generic);
            beanDefinition.getPropertyValues().add("generic", (Object)generic);
        }
        Class interfaceClass = ReferenceConfig.determineInterfaceClass((String)generic, (String)interfaceClassName);
        GenericBeanDefinition targetDefinition = new GenericBeanDefinition();
        targetDefinition.setBeanClass(interfaceClass);
        String id = (String)beanDefinition.getPropertyValues().get("id");
        beanDefinition.setDecoratedDefinition(new BeanDefinitionHolder((BeanDefinition)targetDefinition, id + "_decorated"));
        List propertyValues = beanDefinition.getPropertyValues().getPropertyValueList();
        for (PropertyValue propertyValue : propertyValues) {
            propertyValue.setOptional(true);
        }
    }

    private static void getPropertyMap(Class<?> beanClass, Map<String, Class> beanPropsMap) {
        for (Method setter : beanClass.getMethods()) {
            String name = setter.getName();
            if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(setter.getModifiers()) || setter.getParameterTypes().length != 1) continue;
            Class<?> type = setter.getParameterTypes()[0];
            String beanProperty = name.substring(3, 4).toLowerCase() + name.substring(4);
            Method getter = null;
            try {
                getter = beanClass.getMethod("get" + name.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getter = beanClass.getMethod("is" + name.substring(3), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (getter == null || !Modifier.isPublic(getter.getModifiers()) || !type.equals(getter.getReturnType())) continue;
            beanPropsMap.put(beanProperty, type);
        }
    }

    private static String getCompatibleDefaultValue(String property, String value) {
        if ("async".equals(property) && "false".equals(value) || "timeout".equals(property) && "0".equals(value) || "delay".equals(property) && "0".equals(value) || "version".equals(property) && "0.0.0".equals(value) || "stat".equals(property) && "-1".equals(value) || "reliable".equals(property) && "false".equals(value)) {
            value = null;
        }
        return value;
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == Date.class || cls == Class.class;
    }

    private static void parseNested(Element element, ParserContext parserContext, Class<?> beanClass, boolean required, String tag, String property, String ref, BeanDefinition beanDefinition) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null) {
            return;
        }
        boolean first = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            RootBeanDefinition subDefinition;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tag.equals(node.getNodeName()) && !tag.equals(node.getLocalName())) continue;
            if (first) {
                first = false;
                String isDefault = DubboBeanDefinitionParser.resolveAttribute(element, "default", parserContext);
                if (StringUtils.isEmpty((String)isDefault)) {
                    beanDefinition.getPropertyValues().addPropertyValue("default", (Object)"false");
                }
            }
            if ((subDefinition = DubboBeanDefinitionParser.parse((Element)node, parserContext, beanClass, required)) == null) continue;
            if (StringUtils.isNotEmpty((String)ref)) {
                subDefinition.getPropertyValues().addPropertyValue(property, (Object)new RuntimeBeanReference(ref));
            }
            if (!ReferenceBean.class.equals(beanClass)) continue;
            DubboBeanDefinitionParser.configReferenceBean((Element)node, parserContext, subDefinition, beanDefinition);
        }
    }

    private static void parseProperties(NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String name;
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"property".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"property".equals(element.getLocalName()) || !StringUtils.isNotEmpty((String)(name = DubboBeanDefinitionParser.resolveAttribute(element, "name", parserContext)))) continue;
            String value = DubboBeanDefinitionParser.resolveAttribute(element, "value", parserContext);
            String ref = DubboBeanDefinitionParser.resolveAttribute(element, "ref", parserContext);
            if (StringUtils.isNotEmpty((String)value)) {
                beanDefinition.getPropertyValues().addPropertyValue(name, (Object)value);
                continue;
            }
            if (StringUtils.isNotEmpty((String)ref)) {
                beanDefinition.getPropertyValues().addPropertyValue(name, (Object)new RuntimeBeanReference(ref));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported <property name=\"" + name + "\"> sub tag, Only supported <property name=\"" + name + "\" ref=\"...\" /> or <property name=\"" + name + "\" value=\"...\" />");
        }
    }

    private static ManagedMap parseParameters(NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return null;
        }
        ManagedMap parameters = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"parameter".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"parameter".equals(element.getLocalName())) continue;
            if (parameters == null) {
                parameters = new ManagedMap();
            }
            String key = DubboBeanDefinitionParser.resolveAttribute(element, "key", parserContext);
            String value = DubboBeanDefinitionParser.resolveAttribute(element, "value", parserContext);
            boolean hide = "true".equals(DubboBeanDefinitionParser.resolveAttribute(element, "hide", parserContext));
            if (hide) {
                key = "." + key;
            }
            parameters.put((Object)key, (Object)new TypedStringValue(value, String.class));
        }
        return parameters;
    }

    private static void parseMethods(String id, NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return;
        }
        ManagedList methods = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"method".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"method".equals(element.getLocalName())) continue;
            String methodName = DubboBeanDefinitionParser.resolveAttribute(element, "name", parserContext);
            if (StringUtils.isEmpty((String)methodName)) {
                throw new IllegalStateException("<dubbo:method> name attribute == null");
            }
            if (methods == null) {
                methods = new ManagedList();
            }
            RootBeanDefinition methodBeanDefinition = DubboBeanDefinitionParser.parse(element, parserContext, MethodConfig.class, false);
            String beanName = id + "." + methodName;
            if (!DubboBeanDefinitionParser.hasPropertyValue((AbstractBeanDefinition)methodBeanDefinition, "id")) {
                DubboBeanDefinitionParser.addPropertyValue((AbstractBeanDefinition)methodBeanDefinition, "id", beanName);
            }
            BeanDefinitionHolder methodBeanDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)methodBeanDefinition, beanName);
            methods.add((Object)methodBeanDefinitionHolder);
        }
        if (methods != null) {
            beanDefinition.getPropertyValues().addPropertyValue("methods", methods);
        }
    }

    private static boolean hasPropertyValue(AbstractBeanDefinition beanDefinition, String propertyName) {
        return beanDefinition.getPropertyValues().contains(propertyName);
    }

    private static void addPropertyValue(AbstractBeanDefinition beanDefinition, String propertyName, String propertyValue) {
        if (StringUtils.isBlank((CharSequence)propertyName) || StringUtils.isBlank((CharSequence)propertyValue)) {
            return;
        }
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)propertyValue);
    }

    private static void parseArguments(String id, NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return;
        }
        ManagedList arguments = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"argument".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"argument".equals(element.getLocalName())) continue;
            String argumentIndex = DubboBeanDefinitionParser.resolveAttribute(element, "index", parserContext);
            if (arguments == null) {
                arguments = new ManagedList();
            }
            RootBeanDefinition argumentBeanDefinition = DubboBeanDefinitionParser.parse(element, parserContext, ArgumentConfig.class, false);
            String name = id + "." + argumentIndex;
            BeanDefinitionHolder argumentBeanDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)argumentBeanDefinition, name);
            arguments.add((Object)argumentBeanDefinitionHolder);
        }
        if (arguments != null) {
            beanDefinition.getPropertyValues().addPropertyValue("arguments", arguments);
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return DubboBeanDefinitionParser.parse(element, parserContext, this.beanClass, this.required);
    }

    private static String resolveAttribute(Element element, String attributeName, ParserContext parserContext) {
        String attributeValue = element.getAttribute(attributeName);
        return attributeValue;
    }
}

