/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import com.alibaba.spring.util.BeanFactoryUtils;
import com.alibaba.spring.util.ObjectUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class ReferenceBeanBuilder {
    static final String[] IGNORE_FIELD_NAMES = (String[])ObjectUtils.of((Object[])new String[]{"application", "module", "consumer", "monitor", "registry", "interfaceClass"});
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AnnotationAttributes attributes;
    protected final ApplicationContext applicationContext;
    protected final ClassLoader classLoader;
    protected Class<?> defaultInterfaceClass;

    private ReferenceBeanBuilder(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        Assert.notNull((Object)attributes, (String)"The Annotation attributes must not be null!");
        Assert.notNull((Object)applicationContext, (String)"The ApplicationContext must not be null!");
        this.attributes = attributes;
        this.applicationContext = applicationContext;
        this.classLoader = applicationContext.getClassLoader() != null ? applicationContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public final ReferenceConfig build() throws Exception {
        ReferenceConfig configBean = new ReferenceConfig();
        this.configureBean(configBean);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("The configBean[type:" + configBean.getClass().getSimpleName() + "] has been built."));
        }
        return configBean;
    }

    protected void configureBean(ReferenceConfig configBean) throws Exception {
        this.populateBean(this.attributes, configBean);
        this.configureRegistryConfigs(configBean);
        this.configureMonitorConfig(configBean);
        this.configureApplicationConfig(configBean);
        this.configureModuleConfig(configBean);
        this.configureInterface(this.attributes, configBean);
        this.configureConsumerConfig(this.attributes, configBean);
        this.configureMethodConfig(this.attributes, configBean);
    }

    private void configureRegistryConfigs(ReferenceConfig configBean) {
        String[] registryConfigBeanIds = (String[])AnnotationUtils.getAttribute((Map)this.attributes, (String)"registry");
        List registryConfigs = BeanFactoryUtils.getBeans((ListableBeanFactory)this.applicationContext, (String[])registryConfigBeanIds, RegistryConfig.class);
        configBean.setRegistries(registryConfigs);
    }

    private void configureMonitorConfig(ReferenceConfig configBean) {
        String monitorBeanName = (String)AnnotationUtils.getAttribute((Map)this.attributes, (String)"monitor");
        MonitorConfig monitorConfig = (MonitorConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)monitorBeanName, MonitorConfig.class);
        configBean.setMonitor(monitorConfig);
    }

    private void configureApplicationConfig(ReferenceConfig configBean) {
        String applicationConfigBeanName = (String)AnnotationUtils.getAttribute((Map)this.attributes, (String)"application");
        ApplicationConfig applicationConfig = (ApplicationConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)applicationConfigBeanName, ApplicationConfig.class);
        configBean.setApplication(applicationConfig);
    }

    private void configureModuleConfig(ReferenceConfig configBean) {
        String moduleConfigBeanName = (String)AnnotationUtils.getAttribute((Map)this.attributes, (String)"module");
        ModuleConfig moduleConfig = (ModuleConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)moduleConfigBeanName, ModuleConfig.class);
        configBean.setModule(moduleConfig);
    }

    private void configureInterface(AnnotationAttributes attributes, ReferenceConfig referenceBean) {
        if (referenceBean.getInterface() == null) {
            Object genericValue = AnnotationUtils.getAttribute((Map)attributes, (String)"generic");
            String generic = genericValue != null ? genericValue.toString() : null;
            referenceBean.setGeneric(generic);
            String interfaceClassName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceName");
            if (StringUtils.hasText((String)interfaceClassName)) {
                referenceBean.setInterface(interfaceClassName);
            } else {
                Class<?> interfaceClass = (Class<?>)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceClass");
                if (Void.TYPE.equals(interfaceClass)) {
                    interfaceClass = null;
                }
                if (interfaceClass != null) {
                    Assert.isTrue((boolean)interfaceClass.isInterface(), (String)("The interfaceClass of @DubboReference is not an interface: " + interfaceClass.getName()));
                }
                if (interfaceClass == null && this.defaultInterfaceClass != null) {
                    interfaceClass = this.defaultInterfaceClass;
                    Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The class of field or method that was annotated @DubboReference is not an interface!");
                }
                referenceBean.setInterface(interfaceClass.getName());
            }
        }
    }

    private void configureConsumerConfig(AnnotationAttributes attributes, ReferenceConfig<?> referenceBean) {
        ConsumerConfig consumerConfig = null;
        Object consumer = AnnotationUtils.getAttribute((Map)attributes, (String)"consumer");
        if (consumer != null) {
            if (consumer instanceof String) {
                consumerConfig = (ConsumerConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)((String)consumer), ConsumerConfig.class);
            } else if (consumer instanceof ConsumerConfig) {
                consumerConfig = (ConsumerConfig)consumer;
            } else {
                throw new IllegalArgumentException("Unexpected 'consumer' attribute value: " + consumer);
            }
            referenceBean.setConsumer(consumerConfig);
        }
    }

    void configureMethodConfig(AnnotationAttributes attributes, ReferenceConfig<?> referenceBean) {
        Object value = attributes.get((Object)"methods");
        if (value instanceof Method[]) {
            Method[] methods = (Method[])value;
            List methodConfigs = MethodConfig.constructMethodConfig((Method[])methods);
            if (!methodConfigs.isEmpty()) {
                referenceBean.setMethods(methodConfigs);
            }
        } else if (value instanceof MethodConfig[]) {
            MethodConfig[] methodConfigs = (MethodConfig[])value;
            referenceBean.setMethods(Arrays.asList(methodConfigs));
        }
    }

    protected void populateBean(AnnotationAttributes attributes, ReferenceConfig referenceBean) {
        Assert.notNull(this.defaultInterfaceClass, (String)"The default interface class must set first!");
        DataBinder dataBinder = new DataBinder((Object)referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace((String)text);
                if (!StringUtils.hasText((String)content)) {
                    return;
                }
                content = StringUtils.replace((String)content, (String)"=", (String)",");
                content = StringUtils.replace((String)content, (String)":", (String)",");
                Map parameters = CollectionUtils.toStringMap((String[])StringUtils.commaDelimitedListToStringArray((String)content));
                this.setValue(parameters);
            }
        });
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Map<String, Object>)attributes, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    public static ReferenceBeanBuilder create(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        return new ReferenceBeanBuilder(attributes, applicationContext);
    }

    public ReferenceBeanBuilder defaultInterfaceClass(Class<?> interfaceClass) {
        this.defaultInterfaceClass = interfaceClass;
        return this;
    }
}

