/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.ReferenceBeanManager;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ReferenceAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor {
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private static final int CACHE_SIZE = Integer.getInteger("referenceAnnotationBeanPostProcessor.cache.size", 32);
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedFieldReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedMethodReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private ApplicationContext applicationContext;
    private ReferenceBeanManager referenceBeanManager;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public ReferenceAnnotationBeanPostProcessor() {
        super(DubboReference.class, Reference.class, com.alibaba.dubbo.config.annotation.Reference.class);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanDefinitionRegistry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        DubboBeanUtils.registerBeansIfNotExists(this.beanDefinitionRegistry);
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            Class beanType;
            if (beanFactory.isFactoryBean(beanName)) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                if (this.isReferenceBean(beanDefinition)) continue;
                String beanClassName = beanDefinition.getBeanClassName();
                beanType = ClassUtils.resolveClass((String)beanClassName, (ClassLoader)this.getClassLoader());
            } else {
                beanType = beanFactory.getType(beanName);
            }
            if (beanType == null) continue;
            AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            try {
                this.prepareInjection(metadata);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Prepare dubbo reference injection element failed", (Throwable)e);
            }
        }
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        block5: {
            if (beanType == null) break block5;
            if (this.isReferenceBean((BeanDefinition)beanDefinition)) {
                List propertyValues = beanDefinition.getPropertyValues().getPropertyValueList();
                for (PropertyValue propertyValue : propertyValues) {
                    propertyValue.setOptional(true);
                }
            } else {
                AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
                metadata.checkConfigMembers(beanDefinition);
                try {
                    this.prepareInjection(metadata);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Prepare dubbo reference injection element failed", (Throwable)e);
                }
            }
        }
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        try {
            AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, bean.getClass(), pvs);
            this.prepareInjection(metadata);
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.getAnnotationType().getSimpleName() + " dependencies is failed", ex);
        }
        return pvs;
    }

    private boolean isReferenceBean(BeanDefinition beanDefinition) {
        return ReferenceBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    @Override
    protected void prepareInjection(AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata) throws Exception {
        ReferenceBean referenceBean;
        AnnotationAttributes attributes;
        Class<?> injectedType;
        for (AbstractAnnotationBeanPostProcessor.AnnotatedFieldElement fieldElement : metadata.getFieldElements()) {
            if (fieldElement.refKey != null) continue;
            injectedType = fieldElement.field.getType();
            attributes = fieldElement.attributes;
            referenceBean = this.getReferenceBean(injectedType, attributes);
            fieldElement.refKey = referenceBean.getId();
            this.injectedFieldReferenceBeanCache.put(fieldElement, referenceBean);
        }
        for (AbstractAnnotationBeanPostProcessor.AnnotatedMethodElement methodElement : metadata.getMethodElements()) {
            if (methodElement.refKey != null) continue;
            injectedType = methodElement.getInjectedType();
            attributes = methodElement.attributes;
            referenceBean = this.getReferenceBean(injectedType, attributes);
            methodElement.refKey = referenceBean.getId();
            this.injectedMethodReferenceBeanCache.put(methodElement, referenceBean);
        }
    }

    private ReferenceBean getReferenceBean(Class<?> injectedType, AnnotationAttributes attributes) throws Exception {
        String referenceBeanName = this.getReferenceBeanName(attributes, injectedType);
        ReferenceBean referenceBean = this.referenceBeanManager.get(referenceBeanName);
        if (referenceBean == null) {
            String localServiceBeanName = this.buildReferencedBeanName(attributes, injectedType);
            boolean localServiceBean = this.isLocalServiceBean(localServiceBeanName, attributes);
            if (localServiceBean) {
                attributes.put((Object)"injvm", (Object)Boolean.TRUE);
            }
            if (attributes.get((Object)"interfaceName") == null && attributes.get((Object)"interfaceClass") == null) {
                Class<?> interfaceClass = injectedType;
                Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The class of field or method that was annotated @DubboReference is not an interface!");
                attributes.put((Object)"interfaceClass", interfaceClass);
            }
            try {
                RootBeanDefinition beanDefinition = new RootBeanDefinition();
                beanDefinition.setBeanClassName(ReferenceBean.class.getName());
                beanDefinition.setAutowireCandidate(!localServiceBean);
                referenceBean = new ReferenceBean((Map<String, Object>)attributes);
                referenceBean.setId(referenceBeanName);
                referenceBean.setApplicationContext(this.applicationContext);
                referenceBean.setBeanClassLoader(this.getClassLoader());
                referenceBean.afterPropertiesSet();
                this.beanDefinitionRegistry.registerBeanDefinition(referenceBeanName, (BeanDefinition)beanDefinition);
                this.getBeanFactory().registerSingleton(referenceBeanName, referenceBean);
                this.referenceBeanManager.addReference(referenceBean);
            }
            catch (Exception e) {
                throw new Exception("Create dubbo reference bean failed", e);
            }
        }
        return referenceBean;
    }

    @Override
    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement injectedElement) throws Exception {
        if (injectedElement.refKey == null) {
            throw new IllegalStateException("The AnnotatedInjectElement of @DubboReference should be inited before injection");
        }
        return this.getBeanFactory().getBean(injectedElement.refKey);
    }

    private String getReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        String beanName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"id");
        if (!StringUtils.hasText((String)beanName)) {
            beanName = this.generateReferenceBeanName(attributes, interfaceClass);
        }
        return beanName;
    }

    private String generateReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        StringBuilder beanNameBuilder = new StringBuilder("@Reference");
        if (!attributes.isEmpty()) {
            beanNameBuilder.append('(');
            ArrayList sortedAttrKeys = new ArrayList(attributes.keySet());
            Collections.sort(sortedAttrKeys);
            for (String key : sortedAttrKeys) {
                Object value = attributes.get((Object)key);
                if (value != null && value.getClass().isArray()) {
                    Object[] array = ObjectUtils.toObjectArray((Object)value);
                    value = Arrays.toString(array);
                }
                beanNameBuilder.append(key).append('=').append(value).append(',');
            }
            beanNameBuilder.setCharAt(beanNameBuilder.lastIndexOf(","), ')');
        }
        beanNameBuilder.append(" ").append(interfaceClass.getName());
        return beanNameBuilder.toString();
    }

    private boolean isLocalServiceBean(String referencedBeanName, AnnotationAttributes attributes) {
        return this.existsServiceBean(referencedBeanName) && !this.isRemoteReferenceBean(attributes);
    }

    private boolean existsServiceBean(String referencedBeanName) {
        return this.applicationContext.containsBean(referencedBeanName) && this.applicationContext.isTypeMatch(referencedBeanName, ServiceBean.class);
    }

    private boolean isRemoteReferenceBean(AnnotationAttributes attributes) {
        boolean remote = Boolean.FALSE.equals(attributes.get((Object)"injvm"));
        return remote;
    }

    private void exportServiceBeanIfNecessary(String referencedBeanName) {
        ServiceBean serviceBean;
        if (this.existsServiceBean(referencedBeanName) && !(serviceBean = this.getServiceBean(referencedBeanName)).isExported()) {
            serviceBean.export();
        }
    }

    private ServiceBean getServiceBean(String referencedBeanName) {
        return (ServiceBean)((Object)this.applicationContext.getBean(referencedBeanName, ServiceBean.class));
    }

    @Override
    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement injectedElement) {
        return this.generateReferenceBeanName(attributes, injectedType);
    }

    private String buildReferencedBeanName(AnnotationAttributes attributes, Class<?> serviceInterfaceType) {
        ServiceBeanNameBuilder serviceBeanNameBuilder = ServiceBeanNameBuilder.create(attributes, serviceInterfaceType, this.getEnvironment());
        return serviceBeanNameBuilder.build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.referenceBeanManager = (ReferenceBeanManager)applicationContext.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.injectedFieldReferenceBeanCache.clear();
        this.injectedMethodReferenceBeanCache.clear();
    }

    @Deprecated
    public Collection<ReferenceBean<?>> getReferenceBeans() {
        return Collections.emptyList();
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedFieldReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedFieldReferenceBeanCache);
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedMethodReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedMethodReferenceBeanCache);
    }
}

