/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
DisposableBean {
    private static final int CACHE_SIZE = Integer.getInteger("", 32);
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Class<? extends Annotation>[] annotationTypes;
    private final ConcurrentMap<String, AnnotatedInjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, AnnotatedInjectionMetadata>(CACHE_SIZE);
    private final ConcurrentMap<String, Object> injectedObjectsCache = new ConcurrentHashMap<String, Object>(CACHE_SIZE);
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader classLoader;
    private int order = 0x7FFFFFFC;

    public AbstractAnnotationBeanPostProcessor(Class<? extends Annotation> ... annotationTypes) {
        Assert.notEmpty((Object[])annotationTypes, (String)"The argument of annotations' types must not empty");
        this.annotationTypes = annotationTypes;
    }

    private static <T> Collection<T> combine(Collection<? extends T> ... elements) {
        ArrayList<? extends T> allElements = new ArrayList<T>();
        for (Collection<? extends T> e : elements) {
            allElements.addAll(e);
        }
        return allElements;
    }

    @Deprecated
    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationTypes[0];
    }

    protected final Class<? extends Annotation>[] getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"AnnotationInjectedBeanPostProcessor requires a ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            metadata.checkConfigMembers(beanDefinition);
            try {
                this.prepareInjection(metadata);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Prepare injection of @" + this.getAnnotationType().getSimpleName() + " failed"), (Throwable)e);
            }
        }
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        try {
            AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, bean.getClass(), pvs);
            this.prepareInjection(metadata);
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.getAnnotationType().getSimpleName() + " dependencies is failed", ex);
        }
        return pvs;
    }

    private List<AnnotatedFieldElement> findFieldAnnotationMetadata(Class<?> beanClass) {
        final LinkedList<AnnotatedFieldElement> elements = new LinkedList<AnnotatedFieldElement>();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                for (Class<? extends Annotation> annotationType : AbstractAnnotationBeanPostProcessor.this.getAnnotationTypes()) {
                    AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)field, annotationType, (PropertyResolver)AbstractAnnotationBeanPostProcessor.this.getEnvironment(), (boolean)true, (boolean)true, (String[])new String[0]);
                    if (attributes == null) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (AbstractAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                            AbstractAnnotationBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " is not supported on static fields: " + field));
                        }
                        return;
                    }
                    elements.add(new AnnotatedFieldElement(field, attributes));
                }
            }
        });
        return elements;
    }

    private List<AnnotatedMethodElement> findAnnotatedMethodMetadata(final Class<?> beanClass) {
        final LinkedList<AnnotatedMethodElement> elements = new LinkedList<AnnotatedMethodElement>();
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                for (Class<? extends Annotation> annotationType : AbstractAnnotationBeanPostProcessor.this.getAnnotationTypes()) {
                    AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)bridgedMethod, annotationType, (PropertyResolver)AbstractAnnotationBeanPostProcessor.this.getEnvironment(), (boolean)true, (boolean)true, (String[])new String[0]);
                    if (attributes == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) continue;
                    if (Modifier.isStatic(method.getModifiers())) {
                        if (AbstractAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                            AbstractAnnotationBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " annotation is not supported on static methods: " + method));
                        }
                        return;
                    }
                    if (method.getParameterTypes().length == 0 && AbstractAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                        AbstractAnnotationBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " annotation should only be used on methods with parameters: " + method));
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                    elements.add(new AnnotatedMethodElement(method, pd, attributes));
                }
            }
        });
        return elements;
    }

    private AnnotatedInjectionMetadata buildAnnotatedMetadata(Class<?> beanClass) {
        List<AnnotatedFieldElement> fieldElements = this.findFieldAnnotationMetadata(beanClass);
        List<AnnotatedMethodElement> methodElements = this.findAnnotatedMethodMetadata(beanClass);
        return new AnnotatedInjectionMetadata(beanClass, fieldElements, methodElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotatedInjectionMetadata findInjectionMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        AnnotatedInjectionMetadata metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            ConcurrentMap<String, AnnotatedInjectionMetadata> concurrentMap = this.injectionMetadataCache;
            synchronized (concurrentMap) {
                metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    try {
                        metadata = this.buildAnnotatedMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect object class [" + clazz.getName() + "] for annotation metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void destroy() throws Exception {
        for (Object object : this.injectedObjectsCache.values()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(object + " was destroying!"));
            }
            if (!(object instanceof DisposableBean)) continue;
            ((DisposableBean)object).destroy();
        }
        this.injectionMetadataCache.clear();
        this.injectedObjectsCache.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(((Object)((Object)this)).getClass() + " was destroying!"));
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Object getInjectedObject(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, AnnotatedInjectElement injectedElement) throws Exception {
        String cacheKey = this.buildInjectedObjectCacheKey(attributes, bean, beanName, injectedType, injectedElement);
        Object injectedObject = this.injectedObjectsCache.get(cacheKey);
        if (injectedObject == null) {
            injectedObject = this.doGetInjectedBean(attributes, bean, beanName, injectedType, injectedElement);
            this.injectedObjectsCache.put(cacheKey, injectedObject);
        }
        return injectedObject;
    }

    protected void prepareInjection(AnnotatedInjectionMetadata metadata) throws Exception {
    }

    protected abstract Object doGetInjectedBean(AnnotationAttributes var1, Object var2, String var3, Class<?> var4, AnnotatedInjectElement var5) throws Exception;

    protected abstract String buildInjectedObjectCacheKey(AnnotationAttributes var1, Object var2, String var3, Class<?> var4, AnnotatedInjectElement var5);

    public class AnnotatedFieldElement
    extends AnnotatedInjectElement {
        protected final Field field;

        protected AnnotatedFieldElement(Field field, AnnotationAttributes attributes) {
            super(field, null, attributes);
            this.field = field;
        }
    }

    protected class AnnotatedMethodElement
    extends AnnotatedInjectElement {
        protected final Method method;

        protected AnnotatedMethodElement(Method method, PropertyDescriptor pd, AnnotationAttributes attributes) {
            super(method, pd, attributes);
            this.method = method;
        }
    }

    protected class AnnotatedInjectElement
    extends InjectionMetadata.InjectedElement {
        protected final AnnotationAttributes attributes;
        protected volatile String refKey;

        protected AnnotatedInjectElement(Member member, PropertyDescriptor pd, AnnotationAttributes attributes) {
            super(member, pd);
            this.attributes = attributes;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Class injectedType = this.getResourceType();
            Object injectedObject = AbstractAnnotationBeanPostProcessor.this.getInjectedObject(this.attributes, bean, beanName, injectedType, this);
            if (this.member instanceof Field) {
                Field field = (Field)this.member;
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, injectedObject);
            } else if (this.member instanceof Method) {
                Method method = (Method)this.member;
                ReflectionUtils.makeAccessible((Method)method);
                method.invoke(bean, injectedObject);
            }
        }

        public Class<?> getInjectedType() {
            return this.getResourceType();
        }
    }

    protected class AnnotatedInjectionMetadata
    extends InjectionMetadata {
        private final Collection<AnnotatedFieldElement> fieldElements;
        private final Collection<AnnotatedMethodElement> methodElements;

        public AnnotatedInjectionMetadata(Class<?> targetClass, Collection<AnnotatedFieldElement> fieldElements, Collection<AnnotatedMethodElement> methodElements) {
            super(targetClass, AbstractAnnotationBeanPostProcessor.combine(new Collection[]{fieldElements, methodElements}));
            this.fieldElements = fieldElements;
            this.methodElements = methodElements;
        }

        public Collection<AnnotatedFieldElement> getFieldElements() {
            return this.fieldElements;
        }

        public Collection<AnnotatedMethodElement> getMethodElements() {
            return this.methodElements;
        }
    }
}

