/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceBeanBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.validation.DataBinder;

public class ReferenceBeanManager
implements ApplicationContextAware {
    public static final String BEAN_NAME = "dubboReferenceBeanManager";
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, ReferenceBean> configMap = new ConcurrentHashMap<String, ReferenceBean>();
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;

    public void addReference(ReferenceBean referenceBean) throws Exception {
        Assert.notNull((Object)referenceBean.getId(), (String)"The id of ReferenceBean cannot be empty");
        String key = referenceBean.getId();
        ReferenceBean oldReferenceBean = this.configMap.get(key);
        if (oldReferenceBean != null) {
            if (referenceBean != oldReferenceBean) {
                this.logger.warn((Object)("Found duplicated ReferenceBean id: " + key));
            }
            return;
        }
        this.configMap.put(key, referenceBean);
        if (this.initialized) {
            this.initReferenceBean(referenceBean);
        }
    }

    public ReferenceBean get(String id) {
        return this.configMap.get(id);
    }

    public Collection<ReferenceBean> getReferences() {
        return this.configMap.values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void prepareReferenceBeans() throws Exception {
        Map referenceBeanMap = this.applicationContext.getBeansOfType(ReferenceBean.class, true, false);
        for (ReferenceBean referenceBean : referenceBeanMap.values()) {
            this.addReference(referenceBean);
        }
        for (ReferenceBean referenceBean : this.getReferences()) {
            this.initReferenceBean(referenceBean);
        }
        this.initialized = true;
    }

    private void initReferenceBean(ReferenceBean referenceBean) throws Exception {
        if (referenceBean.getReferenceConfig() != null) {
            return;
        }
        Environment environment = this.applicationContext.getEnvironment();
        Map<String, Object> referenceProps = referenceBean.getReferenceProps();
        if (referenceProps == null) {
            MutablePropertyValues propertyValues = referenceBean.getPropertyValues();
            if (propertyValues == null) {
                throw new RuntimeException("ReferenceBean is invalid, missing 'propertyValues'");
            }
            referenceProps = this.toReferenceProps(propertyValues, (PropertyResolver)environment);
        }
        this.resolvePlaceholders(referenceProps, (PropertyResolver)environment);
        ReferenceConfig referenceConfig = ReferenceBeanBuilder.create(new AnnotationAttributes(new LinkedHashMap<String, Object>(referenceProps)), this.applicationContext).defaultInterfaceClass(referenceBean.getObjectType()).build();
        referenceBean.setReferenceConfig(referenceConfig);
        DubboBootstrap.getInstance().reference(referenceConfig);
    }

    private void resolvePlaceholders(Map<String, Object> referenceProps, PropertyResolver propertyResolver) {
        for (Map.Entry<String, Object> entry : referenceProps.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String valueToResovle = (String)value;
                entry.setValue(propertyResolver.resolveRequiredPlaceholders(valueToResovle));
                continue;
            }
            if (!(value instanceof String[])) continue;
            String[] strings = (String[])value;
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = propertyResolver.resolveRequiredPlaceholders(strings[i]);
            }
            entry.setValue(strings);
        }
    }

    private Map<String, Object> toReferenceProps(MutablePropertyValues propertyValues, PropertyResolver propertyResolver) {
        LinkedHashMap<String, Object> referenceProps = new LinkedHashMap<String, Object>();
        for (PropertyValue propertyValue : propertyValues.getPropertyValueList()) {
            String propertyName = propertyValue.getName();
            MethodConfig[] value = propertyValue.getValue();
            if ("methods".equals(propertyName)) {
                ManagedList managedList = (ManagedList)value;
                ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>();
                for (Object el : managedList) {
                    MethodConfig methodConfig = this.createMethodConfig(((BeanDefinitionHolder)el).getBeanDefinition(), propertyResolver);
                    methodConfigs.add(methodConfig);
                }
                value = methodConfigs.toArray(new MethodConfig[0]);
            } else if ("parameters".equals(propertyName)) {
                value = this.createParameterMap((ManagedMap)value, propertyResolver);
            }
            if (value instanceof RuntimeBeanReference) {
                RuntimeBeanReference beanReference = (RuntimeBeanReference)value;
                value = this.applicationContext.getBean(beanReference.getBeanName());
            }
            referenceProps.put(propertyName, value);
        }
        return referenceProps;
    }

    private MethodConfig createMethodConfig(BeanDefinition beanDefinition, PropertyResolver propertyResolver) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        for (PropertyValue propertyValue : pvs.getPropertyValueList()) {
            String propertyName = propertyValue.getName();
            ArgumentConfig[] value = propertyValue.getValue();
            if ("arguments".equals(propertyName)) {
                ManagedList managedList = (ManagedList)value;
                ArrayList<ArgumentConfig> argumentConfigs = new ArrayList<ArgumentConfig>();
                for (Object el : managedList) {
                    ArgumentConfig argumentConfig = this.createArgumentConfig(((BeanDefinitionHolder)el).getBeanDefinition(), propertyResolver);
                    argumentConfigs.add(argumentConfig);
                }
                value = argumentConfigs.toArray(new ArgumentConfig[0]);
            } else if ("parameters".equals(propertyName)) {
                value = this.createParameterMap((ManagedMap)value, propertyResolver);
            }
            if (value instanceof RuntimeBeanReference) {
                RuntimeBeanReference beanReference = (RuntimeBeanReference)value;
                value = this.applicationContext.getBean(beanReference.getBeanName());
            }
            attributes.put(propertyName, value);
        }
        MethodConfig methodConfig = new MethodConfig();
        DataBinder dataBinder = new DataBinder((Object)methodConfig);
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter(attributes, propertyResolver, new String[0]));
        return methodConfig;
    }

    private ArgumentConfig createArgumentConfig(BeanDefinition beanDefinition, PropertyResolver propertyResolver) {
        ArgumentConfig argumentConfig = new ArgumentConfig();
        DataBinder dataBinder = new DataBinder((Object)argumentConfig);
        dataBinder.bind((PropertyValues)beanDefinition.getPropertyValues());
        return argumentConfig;
    }

    private Map<String, String> createParameterMap(ManagedMap managedMap, PropertyResolver propertyResolver) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set entrySet = managedMap.entrySet();
        for (Map.Entry entry : entrySet) {
            map.put((String)entry.getKey(), ((TypedStringValue)entry.getValue()).getValue());
        }
        return map;
    }
}

