/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.Map;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.proxy.AbstractProxyFactory;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
implements FactoryBean,
ApplicationContextAware,
BeanClassLoaderAware,
InitializingBean,
DisposableBean {
    private transient ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;
    private DubboReferenceLazyInitTargetSource referenceTargetSource;
    private Object referenceLazyProxy;
    protected Class<?> interfaceClass;
    protected String id;
    private Map<String, Object> referenceProps;
    private MutablePropertyValues propertyValues;
    private ReferenceConfig referenceConfig;
    private String generic;
    private String interfaceName;

    public ReferenceBean() {
    }

    public ReferenceBean(Map<String, Object> referenceProps) {
        this.referenceProps = referenceProps;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public Object getObject() {
        if (this.referenceLazyProxy == null) {
            this.createReferenceLazyProxy();
        }
        return this.referenceLazyProxy;
    }

    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.referenceProps == null) {
            Assert.notEmptyString((String)this.getId(), (String)"The id of ReferenceBean cannot be empty");
            ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.getId());
            this.propertyValues = beanDefinition.getPropertyValues();
        }
    }

    private ConfigurableListableBeanFactory getBeanFactory() {
        return (ConfigurableListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
    }

    public void destroy() {
    }

    @Deprecated
    public Object get() {
        throw new UnsupportedOperationException("Should not call this method");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroup() {
        return this.referenceConfig.getGroup();
    }

    public String getVersion() {
        return this.referenceConfig.getVersion();
    }

    public Map<String, Object> getReferenceProps() {
        return this.referenceProps;
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public ReferenceConfig getReferenceConfig() {
        return this.referenceConfig;
    }

    public void setReferenceConfig(ReferenceConfig referenceConfig) {
        this.referenceConfig = referenceConfig;
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass == null) {
            if (this.referenceProps != null) {
                BeanDefinition consumerBeanDefinition;
                Class clazz;
                String interfaceName = (String)this.referenceProps.get("interfaceName");
                if (interfaceName == null && (clazz = (Class)this.referenceProps.get("interfaceClass")) != null) {
                    interfaceName = clazz.getName();
                }
                if (StringUtils.isBlank((CharSequence)interfaceName)) {
                    throw new RuntimeException("Need to specify the 'interfaceName' or 'interfaceClass' attribute of '@DubboReference'");
                }
                this.interfaceName = interfaceName;
                Object genericValue = this.referenceProps.get("generic");
                this.generic = genericValue != null ? genericValue.toString() : null;
                String consumer = (String)this.referenceProps.get("consumer");
                if (StringUtils.isBlank((CharSequence)this.generic) && consumer != null && (consumerBeanDefinition = this.getBeanFactory().getBeanDefinition(consumer)) != null) {
                    this.generic = (String)consumerBeanDefinition.getPropertyValues().get("generic");
                }
            } else if (this.propertyValues != null) {
                this.generic = (String)this.propertyValues.get("generic");
                this.interfaceName = (String)this.propertyValues.get("interface");
            } else {
                throw new RuntimeException("Required 'referenceProps' or beanDefinition");
            }
            this.interfaceClass = ReferenceConfig.determineInterfaceClass((String)this.generic, (String)this.interfaceName);
        }
        return this.interfaceClass;
    }

    private void createReferenceLazyProxy() {
        Class[] internalInterfaces;
        this.referenceTargetSource = new DubboReferenceLazyInitTargetSource();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource((TargetSource)this.referenceTargetSource);
        proxyFactory.addInterface(this.getInterfaceClass());
        for (Class anInterface : internalInterfaces = AbstractProxyFactory.getInternalInterfaces()) {
            proxyFactory.addInterface(anInterface);
        }
        if (ProtocolUtils.isGeneric((String)this.generic)) {
            proxyFactory.addInterface(ReflectUtils.forName((String)this.interfaceName));
        }
        this.referenceLazyProxy = proxyFactory.getProxy(this.beanClassLoader);
    }

    private Object getCallProxy() throws Exception {
        if (this.referenceConfig == null) {
            throw new IllegalStateException("ReferenceBean is not ready yet, maybe dubbo engine is not started");
        }
        return ReferenceConfigCache.getCache().get((ReferenceConfigBase)this.referenceConfig);
    }

    private class DubboReferenceLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private DubboReferenceLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return ReferenceBean.this.getCallProxy();
        }

        public synchronized Class<?> getTargetClass() {
            return ReferenceBean.this.getInterfaceClass();
        }
    }
}

