/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NoopAggregator;
import org.apache.druid.query.aggregation.NoopBufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.query.aggregation.variance.VarianceBufferAggregator;
import org.apache.druid.query.aggregation.variance.VarianceDoubleVectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceFloatVectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceFoldingAggregatorFactory;
import org.apache.druid.query.aggregation.variance.VarianceLongVectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceObjectVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

@JsonTypeName(value="variance")
public class VarianceAggregatorFactory
extends AggregatorFactory {
    private static final String VARIANCE_TYPE_NAME = "variance";
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"variance");
    protected final String fieldName;
    protected final String name;
    @Nullable
    protected final String estimator;
    @Nullable
    private final String inputType;
    protected final boolean isVariancePop;

    @JsonCreator
    public VarianceAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="estimator") @Nullable String estimator, @JsonProperty(value="inputType") @Nullable String inputType) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.estimator = estimator;
        this.isVariancePop = VarianceAggregatorCollector.isVariancePop(estimator);
        this.inputType = inputType;
    }

    @VisibleForTesting
    VarianceAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, null);
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    public ColumnType getResultType() {
        return ColumnType.DOUBLE;
    }

    public int getMaxIntermediateSize() {
        return VarianceAggregatorCollector.getMaxIntermediateSize();
    }

    public AggregatorFactory withName(String newName) {
        return new VarianceAggregatorFactory(newName, this.getFieldName(), this.getEstimator(), this.inputType);
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopAggregator.instance();
        }
        String type = this.getTypeString((ColumnInspector)metricFactory);
        if (ValueType.FLOAT.name().equalsIgnoreCase(type)) {
            return new VarianceAggregator.FloatVarianceAggregator((BaseFloatColumnValueSelector)selector);
        }
        if (ValueType.DOUBLE.name().equalsIgnoreCase(type)) {
            return new VarianceAggregator.DoubleVarianceAggregator((BaseDoubleColumnValueSelector)selector);
        }
        if (ValueType.LONG.name().equalsIgnoreCase(type)) {
            return new VarianceAggregator.LongVarianceAggregator((BaseLongColumnValueSelector)selector);
        }
        if (VARIANCE_TYPE_NAME.equalsIgnoreCase(type) || ValueType.COMPLEX.name().equalsIgnoreCase(type)) {
            return new VarianceAggregator.ObjectVarianceAggregator((BaseObjectColumnValueSelector<?>)selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a float, double, long, or variance, but got a %s", new Object[]{this.fieldName, this.inputType});
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopBufferAggregator.instance();
        }
        String type = this.getTypeString((ColumnInspector)metricFactory);
        if (ValueType.FLOAT.name().equalsIgnoreCase(type)) {
            return new VarianceBufferAggregator.FloatVarianceAggregator((BaseFloatColumnValueSelector)selector);
        }
        if (ValueType.DOUBLE.name().equalsIgnoreCase(type)) {
            return new VarianceBufferAggregator.DoubleVarianceAggregator((BaseDoubleColumnValueSelector)selector);
        }
        if (ValueType.LONG.name().equalsIgnoreCase(type)) {
            return new VarianceBufferAggregator.LongVarianceAggregator((BaseLongColumnValueSelector)selector);
        }
        if (VARIANCE_TYPE_NAME.equalsIgnoreCase(type) || ValueType.COMPLEX.name().equalsIgnoreCase(type)) {
            return new VarianceBufferAggregator.ObjectVarianceAggregator((BaseObjectColumnValueSelector)selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a float, double, long, or variance, but got a %s", new Object[]{this.fieldName, type});
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        String type = this.getTypeString((ColumnInspector)selectorFactory);
        if (ValueType.FLOAT.name().equalsIgnoreCase(type)) {
            return new VarianceFloatVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
        }
        if (ValueType.DOUBLE.name().equalsIgnoreCase(type)) {
            return new VarianceDoubleVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
        }
        if (ValueType.LONG.name().equalsIgnoreCase(type)) {
            return new VarianceLongVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
        }
        if (VARIANCE_TYPE_NAME.equalsIgnoreCase(type) || ValueType.COMPLEX.name().equalsIgnoreCase(type)) {
            return new VarianceObjectVectorAggregator(selectorFactory.makeObjectSelector(this.fieldName));
        }
        throw new IAE("Incompatible type for metric[%s], expected a float, double, long, or variance, but got a %s", new Object[]{this.fieldName, type});
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public Object combine(Object lhs, Object rhs) {
        return VarianceAggregatorCollector.combineValues(lhs, rhs);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<VarianceAggregatorCollector>(){
            private final VarianceAggregatorCollector combined = new VarianceAggregatorCollector();

            public void reset(ColumnValueSelector selector) {
                VarianceAggregatorCollector first = (VarianceAggregatorCollector)selector.getObject();
                this.combined.copyFrom(first);
            }

            public void fold(ColumnValueSelector selector) {
                VarianceAggregatorCollector other = (VarianceAggregatorCollector)selector.getObject();
                this.combined.fold(other);
            }

            public Class<VarianceAggregatorCollector> classOfObject() {
                return VarianceAggregatorCollector.class;
            }

            public VarianceAggregatorCollector getObject() {
                return this.combined;
            }
        };
    }

    public AggregatorFactory getCombiningFactory() {
        return new VarianceFoldingAggregatorFactory(this.name, this.name, this.estimator);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new VarianceAggregatorFactory(this.fieldName, this.fieldName, this.estimator, this.inputType));
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (Objects.equals(this.getName(), other.getName()) && other instanceof VarianceAggregatorFactory) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public Comparator getComparator() {
        return VarianceAggregatorCollector.COMPARATOR;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? NullHandling.defaultDoubleValue() : ((VarianceAggregatorCollector)object).getVariance(this.isVariancePop);
    }

    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            return VarianceAggregatorCollector.from(ByteBuffer.wrap((byte[])object));
        }
        if (object instanceof ByteBuffer) {
            return VarianceAggregatorCollector.from((ByteBuffer)object);
        }
        if (object instanceof String) {
            return VarianceAggregatorCollector.from(ByteBuffer.wrap(StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)))));
        }
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    public String getEstimator() {
        return this.estimator;
    }

    @JsonProperty
    public String getInputType() {
        return this.inputType == null ? StringUtils.toLowerCase((String)ValueType.FLOAT.name()) : this.inputType;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(26).appendString(this.fieldName).appendString(this.inputType).appendBoolean(this.isVariancePop).appendString(this.estimator).build();
    }

    public String toString() {
        return "VarianceAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", estimator='" + this.estimator + '\'' + ", inputType='" + this.inputType + '\'' + ", isVariancePop=" + this.isVariancePop + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VarianceAggregatorFactory that = (VarianceAggregatorFactory)((Object)o);
        return this.isVariancePop == that.isVariancePop && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.name, that.name) && Objects.equals(this.estimator, that.estimator) && Objects.equals(this.inputType, that.inputType);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.estimator, this.inputType, this.isVariancePop);
    }

    private String getTypeString(ColumnInspector columnInspector) {
        String type = this.inputType;
        if (type == null) {
            ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
            type = capabilities != null ? StringUtils.toLowerCase((String)capabilities.getType().name()) : StringUtils.toLowerCase((String)ValueType.FLOAT.name());
        }
        return type;
    }
}

