/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramAggregatorFactory;
import org.apache.druid.query.aggregation.histogram.QuantilePostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DefaultOperandTypeChecker;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class FixedBucketsHistogramQuantileSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new FixedBucketsHistogramQuantileSqlAggFunction();
    private static final String NAME = "APPROX_QUANTILE_FIXED_BUCKETS";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        FixedBucketsHistogramAggregatorFactory aggregatorFactory;
        FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode;
        RexNode upperLimitArg;
        RexNode lowerLimitArg;
        RexNode numBucketsArg;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue()));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        RexNode probabilityArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
        if (!probabilityArg.isA(SqlKind.LITERAL)) {
            return null;
        }
        float probability = ((Number)((Object)RexLiteral.value((RexNode)probabilityArg))).floatValue();
        if (aggregateCall.getArgList().size() >= 3) {
            numBucketsArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(2)).intValue());
            if (!numBucketsArg.isA(SqlKind.LITERAL)) {
                return null;
            }
        } else {
            return null;
        }
        int numBuckets = ((Number)((Object)RexLiteral.value((RexNode)numBucketsArg))).intValue();
        if (aggregateCall.getArgList().size() >= 4) {
            lowerLimitArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(3)).intValue());
            if (!lowerLimitArg.isA(SqlKind.LITERAL)) {
                return null;
            }
        } else {
            return null;
        }
        double lowerLimit = ((Number)((Object)RexLiteral.value((RexNode)lowerLimitArg))).doubleValue();
        if (aggregateCall.getArgList().size() >= 5) {
            upperLimitArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(4)).intValue());
            if (!upperLimitArg.isA(SqlKind.LITERAL)) {
                return null;
            }
        } else {
            return null;
        }
        double upperLimit = ((Number)((Object)RexLiteral.value((RexNode)upperLimitArg))).doubleValue();
        if (aggregateCall.getArgList().size() >= 6) {
            RexNode outlierHandlingModeArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(5)).intValue());
            if (!outlierHandlingModeArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            outlierHandlingMode = FixedBucketsHistogram.OutlierHandlingMode.fromString(RexLiteral.stringValue((RexNode)outlierHandlingModeArg));
        } else {
            outlierHandlingMode = FixedBucketsHistogram.OutlierHandlingMode.IGNORE;
        }
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                FixedBucketsHistogramAggregatorFactory theFactory;
                DruidExpression virtualInput;
                boolean inputMatches;
                boolean matches;
                if (!(factory instanceof FixedBucketsHistogramAggregatorFactory) || !(matches = (inputMatches = (virtualInput = (DruidExpression)virtualColumnRegistry.findVirtualColumnExpressions((theFactory = (FixedBucketsHistogramAggregatorFactory)factory).requiredFields()).stream().findFirst().orElse(null)) == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(theFactory.getFieldName()) : virtualInput.equals((Object)input)) && theFactory.getOutlierHandlingMode() == outlierHandlingMode && theFactory.getNumBuckets() == numBuckets && theFactory.getLowerLimit() == lowerLimit && theFactory.getUpperLimit() == upperLimit)) continue;
                return Aggregation.create((List)ImmutableList.of(), (PostAggregator)new QuantilePostAggregator(name, factory.getName(), probability));
            }
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = new FixedBucketsHistogramAggregatorFactory(histogramName, input.getDirectColumn(), numBuckets, lowerLimit, upperLimit, outlierHandlingMode, false);
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new FixedBucketsHistogramAggregatorFactory(histogramName, virtualColumnName, numBuckets, lowerLimit, upperLimit, outlierHandlingMode, false);
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)new QuantilePostAggregator(name, histogramName, probability));
    }

    private static class FixedBucketsHistogramQuantileSqlAggFunction
    extends SqlAggFunction {
        FixedBucketsHistogramQuantileSqlAggFunction() {
            super(FixedBucketsHistogramQuantileSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), null, (SqlOperandTypeChecker)DefaultOperandTypeChecker.builder().operandNames(new String[]{"column", "probability", "numBuckets", "lowerLimit", "upperLimit", "outlierHandlingMode"}).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING}).literalOperands(new int[]{1, 2, 3, 4, 5}).requiredOperandCount(Integer.valueOf(5)).build(), SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
        }
    }
}

