/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.HistogramAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="buckets")
public class BucketsPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float bucketSize;
    private final float offset;

    @JsonCreator
    public BucketsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="bucketSize") float bucketSize, @JsonProperty(value="offset") float offset) {
        super(name, fieldName);
        this.bucketSize = bucketSize;
        if (this.bucketSize <= 0.0f) {
            throw new IAE("Illegal bucketSize [%s], must be > 0", new Object[]{Float.valueOf(this.bucketSize)});
        }
        this.offset = offset;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return ah.toHistogram(this.bucketSize, this.offset);
    }

    public ColumnType getType(ColumnInspector signature) {
        return HistogramAggregatorFactory.TYPE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float getBucketSize() {
        return this.bucketSize;
    }

    @JsonProperty
    public float getOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        return "BucketsPostAggregator{name='" + this.getName() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", bucketSize=" + this.getBucketSize() + ", offset=" + this.getOffset() + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(10).appendString(this.fieldName).appendFloat(this.bucketSize).appendFloat(this.offset).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BucketsPostAggregator that = (BucketsPostAggregator)o;
        return Float.compare(that.bucketSize, this.bucketSize) == 0 && Float.compare(that.offset, this.offset) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.bucketSize), Float.valueOf(this.offset));
    }
}

