/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;

final class ApproximateHistogramBufferAggregatorHelper {
    private final int resolution;

    public ApproximateHistogramBufferAggregatorHelper(int resolution) {
        this.resolution = resolution;
    }

    public void init(ByteBuffer buf, int position) {
        ApproximateHistogram histogram = new ApproximateHistogram(this.resolution);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        histogram.toBytesDense(mutationBuffer);
    }

    public ApproximateHistogram get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        return ApproximateHistogram.fromBytesDense(mutationBuffer);
    }

    public void put(ByteBuffer buf, int position, ApproximateHistogram histogram) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        histogram.toBytesDense(mutationBuffer);
    }

    public void aggregate(ByteBuffer buf, int position, float value) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        ApproximateHistogram h0 = ApproximateHistogram.fromBytesDense(mutationBuffer);
        h0.offer(value);
        mutationBuffer.position(position);
        h0.toBytesDense(mutationBuffer);
    }
}

