/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.util.Comparator;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class ApproximateHistogramAggregator
implements Aggregator {
    public static final Comparator<ApproximateHistogram> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(ApproximateHistogram::count));
    private final BaseFloatColumnValueSelector selector;
    private ApproximateHistogram histogram;

    static ApproximateHistogram combineHistograms(Object lhs, Object rhs) {
        return ((ApproximateHistogram)lhs).foldFast((ApproximateHistogram)rhs);
    }

    public ApproximateHistogramAggregator(BaseFloatColumnValueSelector selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.histogram = new ApproximateHistogram(resolution, lowerLimit, upperLimit);
    }

    public void aggregate() {
        if (NullHandling.replaceWithDefault() || !this.selector.isNull()) {
            this.histogram.offer(this.selector.getFloat());
        }
    }

    public Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getDouble()");
    }

    public void close() {
    }
}

