/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

abstract class KllSketchBuildBufferAggregatorHelper<SketchType extends KllSketch> {
    private static final MemoryRequestServer MEM_REQ_SERVER = new DefaultMemoryRequestServer();
    private final int size;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<SketchType>> sketches = new IdentityHashMap();

    public KllSketchBuildBufferAggregatorHelper(int size, int maxIntermediateSize) {
        this.size = size;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        SketchType sketch = this.newDirectInstance(this.size, region, MEM_REQ_SERVER);
        this.putSketch(buffer, position, sketch);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldRegion;
        Object sketch = (KllSketch)this.sketches.get(oldBuffer).get(oldPosition);
        if (sketch.isSameResource((Memory)(oldRegion = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newRegion = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            sketch = this.writableWrap(newRegion, MEM_REQ_SERVER);
        }
        this.putSketch(newBuffer, newPosition, sketch);
        Int2ObjectMap<SketchType> map = this.sketches.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.sketches.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    public void clear() {
        this.sketches.clear();
        this.memCache.clear();
    }

    public SketchType getSketchAtPosition(ByteBuffer buf, int position) {
        return (SketchType)((KllSketch)this.sketches.get(buf).get(position));
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)MEM_REQ_SERVER));
    }

    private void putSketch(ByteBuffer buffer, int position, SketchType sketch) {
        Int2ObjectMap map = this.sketches.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, sketch);
    }

    abstract SketchType newDirectInstance(int var1, WritableMemory var2, MemoryRequestServer var3);

    abstract SketchType writableWrap(WritableMemory var1, MemoryRequestServer var2);

    abstract SketchType get(ByteBuffer var1, int var2);
}

