/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.initialization.jetty.HttpException;
import org.apache.druid.sql.http.SqlQuery;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SqlQueryTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    @Test
    public void testFromHttpServletRequestWithJsonContentType() throws Exception {
        String jsonQuery = "{\"query\":\"SELECT 1\"}";
        HttpServletRequest request = this.createMockRequest("application/json", jsonQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 1", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithJsonContentTypeAndCharset() throws Exception {
        String jsonQuery = "{\"query\":\"SELECT 2\"}";
        HttpServletRequest request = this.createMockRequest("application/json; charset=UTF-8", jsonQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 2", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithJsonContentTypeAndMultipleParams() throws Exception {
        String jsonQuery = "{\"query\":\"SELECT 3\"}";
        HttpServletRequest request = this.createMockRequest("application/json; charset=UTF-8; boundary=something", jsonQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 3", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithTextPlainContentType() throws Exception {
        String textQuery = "SELECT 4";
        HttpServletRequest request = this.createMockRequest("text/plain", textQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 4", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithTextPlainContentTypeAndCharset() throws Exception {
        String textQuery = "SELECT 5";
        HttpServletRequest request = this.createMockRequest("text/plain; charset=ISO-8859-1", textQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 5", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithFormUrlencodedContentType() throws Exception {
        String formQuery = "SELECT 6";
        HttpServletRequest request = this.createMockRequest("application/x-www-form-urlencoded", formQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 6", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithFormUrlencodedContentTypeAndCharset() throws Exception {
        String formQuery = "SELECT 7";
        HttpServletRequest request = this.createMockRequest("application/x-www-form-urlencoded; charset=UTF-8", formQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 7", (Object)result.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithNullContentType() throws Exception {
        String content = "SELECT 8";
        HttpServletRequest request = this.createMockRequest(null, content);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertEquals((Object)"Missing Content-Type header", (Object)exception.getMessage());
    }

    @Test
    public void testFromHttpServletRequestWithUnsupportedContentType() throws Exception {
        String xmlQuery = "<query>SELECT 9</query>";
        HttpServletRequest request = this.createMockRequest("application/xml", xmlQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.UNSUPPORTED_MEDIA_TYPE, (Object)exception.getStatusCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("Unsupported Content-Type"));
        Assert.assertTrue((boolean)exception.getMessage().contains("application/xml"));
    }

    @Test
    public void testFromHttpServletRequestWithUnsupportedContentTypeWithParams() throws Exception {
        String xmlQuery = "<query>SELECT 10</query>";
        HttpServletRequest request = this.createMockRequest("application/xml; charset=UTF-8", xmlQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.UNSUPPORTED_MEDIA_TYPE, (Object)exception.getStatusCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("Unsupported Content-Type"));
        Assert.assertTrue((boolean)exception.getMessage().contains("application/xml"));
    }

    @Test
    public void testFromHttpServletRequestWithInvalidContentTypeFormat() throws Exception {
        String content = "SELECT 11";
        HttpServletRequest request = this.createMockRequest("invalid-content-type-format", content);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("Invalid Content-Type header"));
    }

    @Test
    public void testFromHttpServletRequestWithEmptyJsonQuery() throws Exception {
        String jsonQuery = "{}";
        HttpServletRequest request = this.createMockRequest("application/json", jsonQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("Unable to read query from request: Cannot construct instance of "));
    }

    @Test
    public void testFromHttpServletRequestWithNullJsonQuery() throws Exception {
        String jsonQuery = "{\"query\": null}";
        HttpServletRequest request = this.createMockRequest("application/json", jsonQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
    }

    @Test
    public void testFromHttpServletRequestWithEmptyTextQuery() throws Exception {
        String textQuery = "";
        HttpServletRequest request = this.createMockRequest("text/plain", textQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertEquals((Object)"Empty query", (Object)exception.getMessage());
    }

    @Test
    public void testFromHttpServletRequestWithWhitespaceOnlyTextQuery() throws Exception {
        String textQuery = "   \n\t  ";
        HttpServletRequest request = this.createMockRequest("text/plain", textQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertEquals((Object)"Empty query", (Object)exception.getMessage());
    }

    @Test
    public void testFromHttpServletRequestWithEmptyFormUrlencodedQuery() throws Exception {
        String formQuery = "";
        HttpServletRequest request = this.createMockRequest("application/x-www-form-urlencoded", formQuery);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertEquals((Object)"Empty query", (Object)exception.getMessage());
    }

    @Test
    public void testFromHttpServletRequestWithMalformedJson() throws Exception {
        String malformedJson = "{\"query\":\"SELECT 12\"";
        HttpServletRequest request = this.createMockRequest("application/json", malformedJson);
        HttpException exception = (HttpException)Assert.assertThrows(HttpException.class, () -> SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper));
        Assert.assertEquals((Object)Response.Status.BAD_REQUEST, (Object)exception.getStatusCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("Malformed SQL query wrapped in JSON: Unexpected end-of-input:"));
    }

    @Test
    public void testFromHttpServletRequestWithCaseInsensitiveContentType() throws Exception {
        String jsonQuery = "{\"query\":\"SELECT 13\"}";
        HttpServletRequest request1 = this.createMockRequest("APPLICATION/JSON", jsonQuery);
        SqlQuery result1 = SqlQuery.from((HttpServletRequest)request1, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 13", (Object)result1.getQuery());
        HttpServletRequest request2 = this.createMockRequest("Application/Json; Charset=UTF-8", jsonQuery);
        SqlQuery result2 = SqlQuery.from((HttpServletRequest)request2, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 13", (Object)result2.getQuery());
        String textQuery = "SELECT 14";
        HttpServletRequest request3 = this.createMockRequest("TEXT/PLAIN", textQuery);
        SqlQuery result3 = SqlQuery.from((HttpServletRequest)request3, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT 14", (Object)result3.getQuery());
    }

    @Test
    public void testFromHttpServletRequestWithComplexJsonQuery() throws Exception {
        String complexJsonQuery = "{\"query\":\"SELECT COUNT(*) FROM table WHERE col > 100\", \"context\":{\"timeout\":30000}, \"header\":true}";
        HttpServletRequest request = this.createMockRequest("application/json; charset=UTF-8", complexJsonQuery);
        SqlQuery result = SqlQuery.from((HttpServletRequest)request, (ObjectMapper)this.objectMapper);
        Assert.assertEquals((Object)"SELECT COUNT(*) FROM table WHERE col > 100", (Object)result.getQuery());
        Assert.assertTrue((boolean)result.includeHeader());
        Assert.assertNotNull((Object)result.getContext());
    }

    private HttpServletRequest createMockRequest(String contentType, String content) throws IOException {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)contentType).anyTimes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)request.getInputStream()).andReturn((Object)new ServletInputStreamWrapper(inputStream)).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        return request;
    }

    private static class ServletInputStreamWrapper
    extends ServletInputStream {
        private final InputStream inputStream;

        public ServletInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean isFinished() {
            try {
                return this.inputStream.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

