/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.guice;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.NoopCoordinatorClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.guice.security.PolicyModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.rpc.indexing.NoopOverlordClient;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.AuthenticatorMapperModule;
import org.apache.druid.server.log.NoopRequestLogger;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.view.DruidViewMacro;
import org.apache.druid.sql.calcite.view.NoopViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.guice.SqlModule;
import org.apache.druid.sql.http.SqlResourceTest;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SqlModuleTest {
    @Mock
    private ServiceEmitter serviceEmitter;
    @Mock
    private FilteredServerInventoryView inventoryView;
    @Mock
    private TimelineServerView timelineServerView;
    @Mock
    private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    @Mock
    private GenericQueryMetricsFactory genericQueryMetricsFactory;
    @Mock
    private QuerySegmentWalker querySegmentWalker;
    @Mock
    private QueryToolChestWarehouse queryToolChestWarehouse;
    @Mock
    private LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;
    @Mock
    private JoinableFactory joinableFactory;
    @Mock
    private SegmentCacheManager segmentCacheManager;
    @Mock
    private QueryRunnerFactoryConglomerate conglomerate;
    private Injector injector;

    @Before
    public void setUp() {
        EasyMock.replay((Object[])new Object[]{this.serviceEmitter, this.inventoryView, this.timelineServerView, this.druidNodeDiscoveryProvider, this.genericQueryMetricsFactory, this.querySegmentWalker, this.queryToolChestWarehouse, this.lookupExtractorFactoryContainerProvider, this.joinableFactory, this.segmentCacheManager});
    }

    @Test
    public void testDefaultViewManagerBind() {
        Properties props = new Properties();
        props.setProperty("druid.sql.enable", "true");
        props.setProperty("druid.sql.avatica.enable", "true");
        props.setProperty("druid.sql.http.enable", "true");
        this.injector = this.makeInjectorWithProperties(props);
        ViewManager viewManager = (ViewManager)this.injector.getInstance(Key.get(ViewManager.class));
        Assert.assertNotNull((Object)viewManager);
        Assert.assertTrue((boolean)(viewManager instanceof NoopViewManager));
    }

    @Test
    public void testNonDefaultViewManagerBind() {
        Properties props = new Properties();
        props.setProperty("druid.sql.enable", "true");
        props.setProperty("druid.sql.avatica.enable", "true");
        props.setProperty("druid.sql.http.enable", "true");
        props.setProperty("druid.sql.viewmanager.type", "bindtest");
        this.injector = this.makeInjectorWithProperties(props);
        ViewManager viewManager = (ViewManager)this.injector.getInstance(Key.get(ViewManager.class));
        Assert.assertNotNull((Object)viewManager);
        Assert.assertTrue((boolean)(viewManager instanceof BindTestViewManager));
    }

    private Injector makeInjectorWithProperties(Properties props) {
        SqlModule sqlModule = new SqlModule();
        sqlModule.setProps(props);
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new LifecycleModule(), (Object)new ServerModule(), (Object)new JacksonModule(), (Object)new PolicyModule(), (Object)new AuthenticatorMapperModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bind(JsonConfigurator.class).in(LazySingleton.class);
            binder.bind(Properties.class).toInstance((Object)props);
            binder.bind(ExprMacroTable.class).toInstance((Object)ExprMacroTable.nil());
            binder.bind(AuthorizerMapper.class).toInstance((Object)CalciteTests.TEST_AUTHORIZER_MAPPER);
            binder.bind(Escalator.class).toInstance((Object)new NoopEscalator());
            binder.bind(ServiceEmitter.class).toInstance((Object)this.serviceEmitter);
            binder.bind(RequestLogger.class).toInstance((Object)NoopRequestLogger.instance());
            binder.bind((TypeLiteral)new TypeLiteral<Supplier<DefaultQueryConfig>>(){}).toInstance((Object)Suppliers.ofInstance((Object)new DefaultQueryConfig(null)));
            binder.bind(FilteredServerInventoryView.class).toInstance((Object)this.inventoryView);
            binder.bind(TimelineServerView.class).toInstance((Object)this.timelineServerView);
            binder.bind(DruidNodeDiscoveryProvider.class).toInstance((Object)this.druidNodeDiscoveryProvider);
            binder.bind(GenericQueryMetricsFactory.class).toInstance((Object)this.genericQueryMetricsFactory);
            binder.bind(QuerySegmentWalker.class).toInstance((Object)this.querySegmentWalker);
            binder.bind(QueryToolChestWarehouse.class).toInstance((Object)this.queryToolChestWarehouse);
            binder.bind(QueryRunnerFactoryConglomerate.class).toInstance((Object)this.conglomerate);
            binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)this.lookupExtractorFactoryContainerProvider);
            binder.bind(JoinableFactory.class).toInstance((Object)this.joinableFactory);
            binder.bind(SegmentCacheManager.class).toInstance((Object)this.segmentCacheManager);
            binder.bind(QuerySchedulerProvider.class).in(LazySingleton.class);
            binder.bind(QueryScheduler.class).toProvider(QuerySchedulerProvider.class).in(LazySingleton.class);
            binder.bind(ResponseContextConfig.class).toInstance((Object)SqlResourceTest.TEST_RESPONSE_CONTEXT_CONFIG);
            binder.bind(CatalogResolver.class).toInstance((Object)CatalogResolver.NULL_RESOLVER);
            binder.bind(OverlordClient.class).to(NoopOverlordClient.class);
            binder.bind(CoordinatorClient.class).to(NoopCoordinatorClient.class);
            binder.bind(CentralizedDatasourceSchemaConfig.class).toInstance((Object)CentralizedDatasourceSchemaConfig.enabled((boolean)false));
            binder.bind(DefaultQueryConfig.class).toInstance((Object)DefaultQueryConfig.NIL);
        }, (Object)sqlModule, (Object)new TestViewManagerModule()));
    }

    private static class BindTestViewManager
    implements ViewManager {
        private BindTestViewManager() {
        }

        public void createView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        }

        public void alterView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        }

        public void dropView(String viewName) {
        }

        public Map<String, DruidViewMacro> getViews() {
            return null;
        }
    }

    private static class TestViewManagerModule
    implements DruidModule {
        private TestViewManagerModule() {
        }

        public void configure(Binder binder) {
            PolyBind.optionBinder((Binder)binder, (Key)Key.get(ViewManager.class)).addBinding((Object)"bindtest").to(BindTestViewManager.class).in(LazySingleton.class);
        }
    }
}

