/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.Resource;

public class TestAuthorizer {
    AuthenticationResult authenticationResult;
    Resource resource;
    Action action;
    Optional<Access> access;
    String superuserName;
    Policy defaultPolicyRestriction;

    public static Authorizer simple(String superuserName, Policy defaultPolicy) {
        return (authenticationResult, resource, action) -> new TestAuthorizer(authenticationResult, resource, action).defaultPolicyOnReadTable(defaultPolicy).allowIfSuperuser(superuserName).denyIfResourceNameHasKeyword("forbidden").denyExternalRead().allowIfResourceTypeIs(Set.of("DATASOURCE", "VIEW", "QUERY_CONTEXT", "EXTERNAL")).access().orElse(Access.DENIED);
    }

    public TestAuthorizer(AuthenticationResult authenticationResult, Resource resource, Action action) {
        this.authenticationResult = authenticationResult;
        this.resource = resource;
        this.action = action;
        this.access = Optional.empty();
    }

    public TestAuthorizer defaultPolicyOnReadTable(Policy defaultPolicy) {
        this.defaultPolicyRestriction = defaultPolicy;
        return this;
    }

    public TestAuthorizer allowIfSuperuser(String superuserName) {
        this.superuserName = superuserName;
        if (this.access.isPresent()) {
            return this;
        }
        if (superuserName.equals(this.authenticationResult.getIdentity())) {
            this.access = Optional.of(this.allow(this.resource, this.action, this.authenticationResult.getIdentity()));
        }
        return this;
    }

    public TestAuthorizer denyIfResourceNameHasKeyword(String keyword) {
        if (this.access.isPresent()) {
            return this;
        }
        if (this.resource.getName().contains(keyword)) {
            this.access = Optional.of(Access.DENIED);
        }
        return this;
    }

    public TestAuthorizer denyExternalRead() {
        if (this.access.isPresent()) {
            return this;
        }
        if ("EXTERNAL".equals(this.resource.getType()) && Action.READ.equals((Object)this.action)) {
            this.access = Optional.of(Access.DENIED);
        }
        return this;
    }

    public TestAuthorizer allowIfResourceTypeIs(Set<String> resourceTypes) {
        if (this.access.isPresent()) {
            return this;
        }
        if (resourceTypes.contains(this.resource.getType())) {
            this.access = Optional.of(this.allow(this.resource, this.action, this.authenticationResult.getIdentity()));
        }
        return this;
    }

    public TestAuthorizer allowResourceAccessForUsers(String resourceType, Action resourceAction, Set<String> users) {
        if (this.access.isPresent()) {
            return this;
        }
        if (this.resource.getType().equals(resourceType) && this.action.equals((Object)resourceAction) && users.contains(this.authenticationResult.getIdentity())) {
            this.access = Optional.of(this.allow(this.resource, this.action, this.authenticationResult.getIdentity()));
        }
        return this;
    }

    public Optional<Access> access() {
        return this.access;
    }

    private Access allow(Resource resource, Action action, String user) {
        if (this.defaultPolicyRestriction == null) {
            return Access.OK;
        }
        NoRestrictionPolicy policy = user.equals(this.superuserName) ? NoRestrictionPolicy.instance() : this.defaultPolicyRestriction;
        boolean readRestrictedTable = resource.getType().equals("DATASOURCE") && resource.getName().contains("restricted") && action.equals((Object)Action.READ);
        return readRestrictedTable ? Access.allowWithRestriction((Policy)policy) : Access.OK;
    }
}

