/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.InformationSchema;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryFrameworkUtils;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InformationSchemaTest
extends BaseCalciteQueryTest {
    private InformationSchema informationSchema;
    private SqlTestFramework qf;

    @BeforeEach
    public void setUp() {
        this.qf = this.queryFramework();
        DruidSchemaCatalog rootSchema = QueryFrameworkUtils.createMockRootSchema(CalciteTests.INJECTOR, this.qf.conglomerate(), this.qf.walker(), new PlannerConfig(), null, (DruidSchemaManager)new NoopDruidSchemaManager(), CalciteTests.TEST_AUTHORIZER_MAPPER, CatalogResolver.NULL_RESOLVER);
        this.informationSchema = new InformationSchema(rootSchema, CalciteTests.TEST_AUTHORIZER_MAPPER, this.qf.operatorTable());
    }

    @Test
    public void testGetTableNamesMap() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"SCHEMATA", (Object)"TABLES", (Object)"COLUMNS", (Object)"ROUTINES"), (Object)this.informationSchema.getTableNames());
    }

    @Test
    public void testScanRoutinesTable() {
        DataContext dataContext;
        DruidOperatorTable operatorTable = this.qf.operatorTable();
        InformationSchema.RoutinesTable routinesTable = new InformationSchema.RoutinesTable(operatorTable);
        List rows = routinesTable.scan(dataContext = this.createDataContext()).toList();
        Assert.assertTrue((String)"There should at least be 1 built-in function that gets statically loaded by default", (rows.size() > 0 ? 1 : 0) != 0);
        RelDataType rowType = routinesTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        Assert.assertEquals((long)6L, (long)rowType.getFieldCount());
        for (Object[] row : rows) {
            Assert.assertEquals((long)rowType.getFieldCount(), (long)row.length);
            Assert.assertEquals((Object)"druid", (Object)row[0]);
            Assert.assertEquals((Object)"INFORMATION_SCHEMA", (Object)row[1]);
            Assert.assertNotNull((Object)row[2]);
            Assert.assertNotNull((Object)row[3]);
            String isAggregator = row[4].toString();
            Assert.assertTrue((isAggregator.contains("YES") || isAggregator.contains("NO") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScanRoutinesTableWithCustomOperators() {
        Set<SqlOperatorConversion> sqlOperatorConversions = InformationSchemaTest.customOperatorsToOperatorConversions();
        List sqlOperators = sqlOperatorConversions.stream().map(SqlOperatorConversion::calciteOperator).collect(Collectors.toList());
        DruidOperatorTable mockOperatorTable = (DruidOperatorTable)Mockito.mock(DruidOperatorTable.class);
        Mockito.when((Object)mockOperatorTable.getOperatorList()).thenReturn(sqlOperators);
        InformationSchema.RoutinesTable routinesTable = new InformationSchema.RoutinesTable(mockOperatorTable);
        DataContext dataContext = this.createDataContext();
        List rows = routinesTable.scan(dataContext).toList();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((String)"There should be exactly 2 rows; any non-function syntax operator should get filtered out", (long)2L, (long)rows.size());
        Object[] expectedRow1 = new Object[]{"druid", "INFORMATION_SCHEMA", "FOO", "FUNCTION", "NO", "'FOO([<ANY>])'"};
        Assert.assertTrue((boolean)rows.stream().anyMatch(row -> Arrays.equals(row, expectedRow1)));
        Object[] expectedRow2 = new Object[]{"druid", "INFORMATION_SCHEMA", "BAR", "FUNCTION", "NO", "'BAR(<INTEGER>, <INTEGER>)'"};
        Assert.assertTrue((boolean)rows.stream().anyMatch(row -> Arrays.equals(row, expectedRow2)));
    }

    @Test
    public void testScanRoutinesTableWithAnEmptyOperatorTable() {
        DruidOperatorTable mockOperatorTable = (DruidOperatorTable)Mockito.mock(DruidOperatorTable.class);
        ArrayList emptyOperatorList = new ArrayList();
        Mockito.when((Object)mockOperatorTable.getOperatorList()).thenReturn(emptyOperatorList);
        InformationSchema.RoutinesTable routinesTable = new InformationSchema.RoutinesTable(mockOperatorTable);
        DataContext dataContext = this.createDataContext();
        List rows = routinesTable.scan(dataContext).toList();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)0L, (long)rows.size());
    }

    private static Set<SqlOperatorConversion> customOperatorsToOperatorConversions() {
        SqlFunction operator1 = OperatorConversions.operatorBuilder((String)"FOO").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY}).requiredOperandCount(0).returnTypeInference(opBinding -> RowSignatures.makeComplexType((RelDataTypeFactory)opBinding.getTypeFactory(), (ColumnType)ColumnType.ofComplex((String)"fooComplex"), (boolean)true)).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
        SqlFunction operator2 = OperatorConversions.operatorBuilder((String)"BAR").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}).requiredOperandCount(2).returnTypeInference(opBinding -> RowSignatures.makeComplexType((RelDataTypeFactory)opBinding.getTypeFactory(), (ColumnType)ColumnType.ofComplex((String)"barComplex"), (boolean)true)).functionCategory(SqlFunctionCategory.NUMERIC).build();
        HashSet<SqlOperatorConversion> extractionOperators = new HashSet<SqlOperatorConversion>();
        extractionOperators.add((SqlOperatorConversion)new DirectOperatorConversion((SqlOperator)operator1, "foo_fn"));
        extractionOperators.add((SqlOperatorConversion)new DirectOperatorConversion((SqlOperator)operator2, "bar_fn"));
        extractionOperators.add((SqlOperatorConversion)new DirectOperatorConversion(InformationSchemaTest.createNonFunctionOperator("not_a_fn_1"), "not_a_fn_1"));
        extractionOperators.add((SqlOperatorConversion)new DirectOperatorConversion(InformationSchemaTest.createNonFunctionOperator("not_a_fn_2"), "not_a_fn_2"));
        return extractionOperators;
    }

    private static SqlOperator createNonFunctionOperator(String operatorName) {
        return new SqlOperator(operatorName, SqlKind.PLUS_PREFIX, 0, false, null, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC){

            public SqlSyntax getSyntax() {
                return SqlSyntax.POSTFIX;
            }

            public boolean isDynamicFunction() {
                return true;
            }
        };
    }

    private DataContext createDataContext() {
        return new DataContext(){

            public SchemaPlus getRootSchema() {
                return null;
            }

            public JavaTypeFactory getTypeFactory() {
                return null;
            }

            public QueryProvider getQueryProvider() {
                return null;
            }

            public Object get(String authorizerName) {
                return CalciteTests.SUPER_USER_AUTH_RESULT;
            }
        };
    }
}

