/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.NoopCoordinatorClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.rpc.indexing.NoopOverlordClient;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.DruidCalciteSchemaModule;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.InformationSchema;
import org.apache.druid.sql.calcite.schema.LookupSchema;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedLookupSchema;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.schema.NamedSystemSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.easymock.EasyMock;
import org.easymock.EasyMockExtension;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={EasyMockExtension.class})
public class DruidCalciteSchemaModuleTest
extends CalciteTestBase {
    private static final String DRUID_SCHEMA_NAME = "druid";
    @Mock
    private QueryLifecycleFactory queryLifecycleFactory;
    @Mock
    private TimelineServerView serverView;
    @Mock
    private PlannerConfig plannerConfig;
    @Mock
    private ViewManager viewManager;
    @Mock
    private Escalator escalator;
    @Mock
    AuthorizerMapper authorizerMapper;
    @Mock
    private FilteredServerInventoryView serverInventoryView;
    @Mock
    private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    @Mock
    private ObjectMapper objectMapper;
    @Mock
    private LookupReferencesManager lookupReferencesManager;
    @Mock
    private SegmentManager segmentManager;
    @Mock
    private DruidOperatorTable druidOperatorTable;
    private DruidCalciteSchemaModule target;
    private Injector injector;

    @BeforeEach
    public void setUp() {
        EasyMock.replay((Object[])new Object[]{this.plannerConfig});
        this.target = new DruidCalciteSchemaModule();
        this.injector = Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(QueryLifecycleFactory.class).toInstance((Object)this.queryLifecycleFactory);
            binder.bind(TimelineServerView.class).toInstance((Object)this.serverView);
            binder.bind(JoinableFactory.class).toInstance((Object)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()));
            binder.bind(PlannerConfig.class).toInstance((Object)this.plannerConfig);
            binder.bind(ViewManager.class).toInstance((Object)this.viewManager);
            binder.bind(Escalator.class).toInstance((Object)this.escalator);
            binder.bind(AuthorizerMapper.class).toInstance((Object)this.authorizerMapper);
            binder.bind(FilteredServerInventoryView.class).toInstance((Object)this.serverInventoryView);
            binder.bind(SegmentManager.class).toInstance((Object)this.segmentManager);
            binder.bind(DruidOperatorTable.class).toInstance((Object)this.druidOperatorTable);
            binder.bind(DruidNodeDiscoveryProvider.class).toInstance((Object)this.druidNodeDiscoveryProvider);
            binder.bind(DruidSchemaManager.class).toInstance((Object)new NoopDruidSchemaManager());
            binder.bind(ObjectMapper.class).annotatedWith(Json.class).toInstance((Object)this.objectMapper);
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(LookupExtractorFactoryContainerProvider.class).toInstance((Object)this.lookupReferencesManager);
            binder.bind(CatalogResolver.class).toInstance((Object)CatalogResolver.NULL_RESOLVER);
            binder.bind(ServiceEmitter.class).toInstance((Object)new ServiceEmitter("", "", null));
            binder.bind(OverlordClient.class).to(NoopOverlordClient.class);
            binder.bind(CoordinatorClient.class).to(NoopCoordinatorClient.class);
            binder.bind(CentralizedDatasourceSchemaConfig.class).toInstance((Object)CentralizedDatasourceSchemaConfig.create());
        }, new LifecycleModule(), this.target});
    }

    @Test
    public void testDruidSchemaNameIsInjected() {
        String schemaName = (String)this.injector.getInstance(Key.get(String.class, DruidSchemaName.class));
        Assert.assertEquals((Object)DRUID_SCHEMA_NAME, (Object)schemaName);
    }

    @Test
    public void testDruidSqlSchemaIsInjectedAsSingleton() {
        NamedDruidSchema namedDruidSchema = (NamedDruidSchema)this.injector.getInstance(NamedDruidSchema.class);
        Assert.assertNotNull((Object)namedDruidSchema);
        NamedDruidSchema other = (NamedDruidSchema)this.injector.getInstance(NamedDruidSchema.class);
        Assert.assertSame((Object)other, (Object)namedDruidSchema);
    }

    @Test
    public void testSystemSqlSchemaIsInjectedAsSingleton() {
        NamedSystemSchema namedSystemSchema = (NamedSystemSchema)this.injector.getInstance(NamedSystemSchema.class);
        Assert.assertNotNull((Object)namedSystemSchema);
        NamedSystemSchema other = (NamedSystemSchema)this.injector.getInstance(NamedSystemSchema.class);
        Assert.assertSame((Object)other, (Object)namedSystemSchema);
    }

    @Test
    public void testDruidCalciteSchemasAreInjected() {
        Set sqlSchemas = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<NamedSchema>>(){}));
        ImmutableSet expectedSchemas = ImmutableSet.of(NamedSystemSchema.class, NamedDruidSchema.class, NamedLookupSchema.class, NamedViewSchema.class);
        Assert.assertEquals((long)expectedSchemas.size(), (long)sqlSchemas.size());
        Assert.assertEquals((Object)expectedSchemas, sqlSchemas.stream().map(Object::getClass).collect(Collectors.toSet()));
    }

    @Test
    public void testDruidSchemaIsInjectedAsSingleton() {
        DruidSchema schema = (DruidSchema)this.injector.getInstance(DruidSchema.class);
        Assert.assertNotNull((Object)schema);
        DruidSchema other = (DruidSchema)this.injector.getInstance(DruidSchema.class);
        Assert.assertSame((Object)other, (Object)schema);
    }

    @Test
    public void testSystemSchemaIsInjectedAsSingleton() {
        SystemSchema schema = (SystemSchema)this.injector.getInstance(SystemSchema.class);
        Assert.assertNotNull((Object)schema);
        SystemSchema other = (SystemSchema)this.injector.getInstance(SystemSchema.class);
        Assert.assertSame((Object)other, (Object)schema);
    }

    @Test
    public void testInformationSchemaIsInjectedAsSingleton() {
        InformationSchema schema = (InformationSchema)this.injector.getInstance(InformationSchema.class);
        Assert.assertNotNull((Object)schema);
        InformationSchema other = (InformationSchema)this.injector.getInstance(InformationSchema.class);
        Assert.assertSame((Object)other, (Object)schema);
    }

    @Test
    public void testLookupSchemaIsInjectedAsSingleton() {
        LookupSchema schema = (LookupSchema)this.injector.getInstance(LookupSchema.class);
        Assert.assertNotNull((Object)schema);
        LookupSchema other = (LookupSchema)this.injector.getInstance(LookupSchema.class);
        Assert.assertSame((Object)other, (Object)schema);
    }

    @Test
    public void testRootSchemaAnnotatedIsInjectedAsSingleton() {
        DruidSchemaCatalog rootSchema = (DruidSchemaCatalog)this.injector.getInstance(Key.get(DruidSchemaCatalog.class, (Annotation)Names.named((String)"INCOMPLETE_SCHEMA")));
        Assert.assertNotNull((Object)rootSchema);
        DruidSchemaCatalog other = (DruidSchemaCatalog)this.injector.getInstance(Key.get(DruidSchemaCatalog.class, (Annotation)Names.named((String)"INCOMPLETE_SCHEMA")));
        Assert.assertSame((Object)other, (Object)rootSchema);
    }

    @Test
    public void testRootSchemaIsInjectedAsSingleton() {
        DruidSchemaCatalog rootSchema = (DruidSchemaCatalog)this.injector.getInstance(Key.get(DruidSchemaCatalog.class));
        Assert.assertNotNull((Object)rootSchema);
        DruidSchemaCatalog other = (DruidSchemaCatalog)this.injector.getInstance(Key.get(DruidSchemaCatalog.class, (Annotation)Names.named((String)"INCOMPLETE_SCHEMA")));
        Assert.assertSame((Object)other, (Object)rootSchema);
    }

    @Test
    public void testRootSchemaIsInjectedAndHasInformationSchema() {
        DruidSchemaCatalog rootSchema = (DruidSchemaCatalog)this.injector.getInstance(Key.get(DruidSchemaCatalog.class));
        InformationSchema expectedSchema = (InformationSchema)this.injector.getInstance(InformationSchema.class);
        Assert.assertNotNull((Object)rootSchema);
        Assert.assertSame((Object)expectedSchema, (Object)rootSchema.getSubSchema("INFORMATION_SCHEMA").unwrap(InformationSchema.class));
    }
}

