/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.expression.builtin.ConcatOperatorConversion;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.rule.FilterDecomposeConcatRule;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class FilterDecomposeConcatRuleTest
extends InitializedNullHandlingTest {
    private final RelDataTypeFactory typeFactory = DruidTypeSystem.TYPE_FACTORY;
    private final RexBuilder rexBuilder = new RexBuilder(this.typeFactory);
    private final RexShuttle shuttle = new FilterDecomposeConcatRule.DecomposeConcatShuttle(this.rexBuilder);

    @Test
    public void test_notConcat() {
        RexNode call = this.equals(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LOWER, new RexNode[]{this.inputRef(0)}), this.literal("2"));
        Assert.assertEquals((Object)call, (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_oneInput() {
        RexNode concatCall = this.concat(this.literal("it's "), this.inputRef(0));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("2"))), (Object)this.shuttle.apply(this.equals(concatCall, this.literal("it's 2"))));
    }

    @Test
    public void test_oneInput_lhsLiteral() {
        RexNode concatCall = this.concat(this.literal("it's "), this.inputRef(0));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("2"))), (Object)this.shuttle.apply(this.equals(this.literal("it's 2"), concatCall)));
    }

    @Test
    public void test_oneInput_noLiteral() {
        RexNode concatCall = this.concat(this.inputRef(0));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("it's 2"))), (Object)this.shuttle.apply(this.equals(this.literal("it's 2"), concatCall)));
    }

    @Test
    public void test_twoInputs() {
        RexNode concatCall = this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("2")), this.equals(this.inputRef(1), this.literal("3"))), (Object)this.shuttle.apply(this.equals(concatCall, this.literal("2x3"))));
    }

    @Test
    public void test_twoInputs_castNumberInputRef() {
        RexNode numericInputRef = this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), true), (RexNode)this.rexBuilder.makeInputRef(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BIGINT), true), 0));
        RexNode concatCall = this.concat(numericInputRef, this.literal("x"), this.inputRef(1));
        Assert.assertEquals((Object)this.and(this.equals(numericInputRef, this.literal("2")), this.equals(this.inputRef(1), this.literal("3"))), (Object)this.shuttle.apply(this.equals(concatCall, this.literal("2x3"))));
    }

    @Test
    public void test_twoInputs_notEquals() {
        RexNode call = this.notEquals(this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1)), this.literal("2x3"));
        Assert.assertEquals((Object)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.and(this.equals(this.inputRef(0), this.literal("2")), this.equals(this.inputRef(1), this.literal("3")))}), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_castNumberLiteral() {
        RexNode three = this.rexBuilder.makeCast(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), (RexNode)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L)));
        RexNode concatCall = this.concat(this.inputRef(0), three, this.inputRef(1), this.literal("4"));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("x")), this.equals(this.inputRef(1), this.literal("y"))), (Object)this.shuttle.apply(this.equals(concatCall, this.literal("x3y4"))));
    }

    @Test
    public void test_twoInputs_noLiteral() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.inputRef(1)), this.literal("2x3"));
        Assert.assertEquals((Object)call, (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_isNull() {
        RexNode call = this.isNull(this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1)));
        Assert.assertEquals((Object)this.or(this.isNull(this.inputRef(0)), this.isNull(this.inputRef(1))), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_isNotNull() {
        RexNode call = this.notNull(this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1)));
        Assert.assertEquals((Object)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.or(this.isNull(this.inputRef(0)), this.isNull(this.inputRef(1)))}), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_tooManyXes() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1)), this.literal("2xx3"));
        Assert.assertEquals((Object)call, (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_notEnoughXes() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal("x"), this.inputRef(1)), this.literal("2z3"));
        RexLiteral unknown = this.rexBuilder.makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        Assert.assertEquals((Object)this.or(this.and(new RexNode[]{this.isNull(this.inputRef(0)), unknown}), this.and(new RexNode[]{this.isNull(this.inputRef(1)), unknown})), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_delimitersWrongOrder() {
        RexNode call = this.equals(this.concat(this.literal("z"), this.inputRef(0), this.literal("x"), this.inputRef(1)), this.literal("x2z3"));
        RexLiteral unknown = this.rexBuilder.makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        Assert.assertEquals((Object)this.or(this.and(new RexNode[]{this.isNull(this.inputRef(0)), unknown}), this.and(new RexNode[]{this.isNull(this.inputRef(1)), unknown})), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_emptyDelimiter() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal(""), this.inputRef(1)), this.literal("23"));
        Assert.assertEquals((Object)call, (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_ambiguousOverlappingDeliminters() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal("--"), this.inputRef(1)), this.literal("2---3"));
        Assert.assertEquals((Object)call, (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_impossibleOverlappingDelimiters() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal("--"), this.inputRef(1), this.literal("--")), this.literal("2---3"));
        RexLiteral unknown = this.rexBuilder.makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        Assert.assertEquals((Object)this.or(this.and(new RexNode[]{this.isNull(this.inputRef(0)), unknown}), this.and(new RexNode[]{this.isNull(this.inputRef(1)), unknown})), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_threeInputs_delimitersIgnoredWhenOutOfPosition() {
        RexNode call = this.equals(this.concat(this.inputRef(0), this.literal(" ("), this.inputRef(1), this.literal("x"), this.inputRef(2), this.literal(")")), this.literal("xxx (4x5)"));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("xxx")), this.equals(this.inputRef(1), this.literal("4")), this.equals(this.inputRef(2), this.literal("5"))), (Object)this.shuttle.apply(call));
    }

    @Test
    public void test_twoInputs_backToBackLiterals() {
        RexNode concatCall = this.concat(this.inputRef(0), this.literal("x"), this.literal("y"), this.inputRef(1));
        Assert.assertEquals((Object)this.and(this.equals(this.inputRef(0), this.literal("2")), this.equals(this.inputRef(1), this.literal("3"))), (Object)this.shuttle.apply(this.equals(concatCall, this.literal("2xy3"))));
    }

    private RexNode concat(RexNode ... args) {
        return this.rexBuilder.makeCall((SqlOperator)ConcatOperatorConversion.SQL_FUNCTION, args);
    }

    private RexNode inputRef(int i) {
        return this.rexBuilder.makeInputRef(this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), true), i);
    }

    private RexNode or(RexNode ... args) {
        return RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, Arrays.asList(args));
    }

    private RexNode and(RexNode ... args) {
        return RexUtil.composeConjunction((RexBuilder)this.rexBuilder, Arrays.asList(args));
    }

    private RexNode equals(RexNode arg, RexNode value) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{arg, value});
    }

    private RexNode notEquals(RexNode arg, RexNode value) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{arg, value});
    }

    private RexNode isNull(RexNode arg) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg});
    }

    private RexNode notNull(RexNode arg) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{arg});
    }

    private RexNode literal(String s) {
        return this.rexBuilder.makeLiteral(s);
    }
}

