/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.junit.Assert;
import org.junit.Test;

public class PlannerConfigTest {
    @Test
    public void testPlannerConfigDefaults() {
        PlannerConfig config = new PlannerConfig();
        Assert.assertFalse((boolean)config.isUseLexicographicTopN());
        Assert.assertTrue((boolean)config.isUseApproximateTopN());
        Assert.assertTrue((boolean)config.isUseApproximateCountDistinct());
    }

    @Test
    public void testPlannerConfigBuilder() {
        PlannerConfig config = PlannerConfig.builder().useLexicographicTopN(true).build();
        Assert.assertTrue((boolean)config.isUseLexicographicTopN());
        Assert.assertTrue((boolean)config.isUseApproximateTopN());
    }

    @Test
    public void testPlannerConfigBuilderBothTopNFlagsDisabled() {
        PlannerConfig config = PlannerConfig.builder().useLexicographicTopN(false).useApproximateTopN(false).build();
        Assert.assertFalse((boolean)config.isUseLexicographicTopN());
        Assert.assertFalse((boolean)config.isUseApproximateTopN());
    }

    @Test
    public void testPlannerConfigEqualsAndHashCode() {
        EqualsVerifier.forClass(PlannerConfig.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }
}

