/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.rel.Windowing;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.junit.Assert;
import org.junit.Test;

public class DruidOperatorTableTest {
    @Test
    public void testBuiltInOperatorTable() {
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of(), (Set)ImmutableSet.of());
        List operatorList = operatorTable.getOperatorList();
        Assert.assertNotNull((Object)operatorList);
        Assert.assertTrue((String)"Built-in operators should be loaded by default", (operatorList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsFunctionSyntax() {
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.FUNCTION));
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.FUNCTION_STAR));
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.FUNCTION_ID));
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.SPECIAL));
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.INTERNAL));
        Assert.assertFalse((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.BINARY));
        Assert.assertFalse((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.PREFIX));
        Assert.assertFalse((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)SqlSyntax.POSTFIX));
    }

    @Test
    public void testCustomOperatorTable() {
        SqlFunction operator1 = OperatorConversions.operatorBuilder((String)"FOO").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY}).requiredOperandCount(0).returnTypeInference(opBinding -> RowSignatures.makeComplexType((RelDataTypeFactory)opBinding.getTypeFactory(), (ColumnType)ColumnType.ofComplex((String)"fooComplex"), (boolean)true)).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
        SqlBinaryOperator operator2 = SqlStdOperatorTable.PLUS;
        HashSet<DirectOperatorConversion> extractionOperators = new HashSet<DirectOperatorConversion>();
        extractionOperators.add(new DirectOperatorConversion((SqlOperator)operator1, "foo_fn"));
        extractionOperators.add(new DirectOperatorConversion((SqlOperator)operator2, "plus_is_not_a_fn"));
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of(), extractionOperators);
        List operatorList = operatorTable.getOperatorList();
        Assert.assertNotNull((Object)operatorList);
        Assert.assertTrue((String)"We should have at least two operators -- the ones we loaded above plus the built-in operators that gets loaded by default", (operatorList.size() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)operatorList.contains(operator1));
        Assert.assertTrue((boolean)operatorList.contains(operator2));
        Assert.assertTrue((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)operator1.getSyntax()));
        Assert.assertFalse((boolean)DruidOperatorTable.isFunctionSyntax((SqlSyntax)operator2.getSyntax()));
    }

    @Test
    public void testBuiltinWindowOperatorsSupportFramingAsExpected() {
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of(), (Set)ImmutableSet.of());
        ImmutableSet keySet = Windowing.KNOWN_WINDOW_FNS.keySet();
        Set windowOps = operatorTable.getOperatorList().stream().filter(o -> keySet.contains((Object)o.getKind().toString())).collect(Collectors.toSet());
        block3: for (SqlOperator operator : windowOps) {
            switch (operator.kind) {
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTILE: {
                    continue block3;
                }
            }
            Assert.assertFalse((String)(operator + " allows framing; should be supported or rejected and then exclude from this check"), (boolean)operator.allowsFraming());
        }
    }
}

