/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.security.PolicyModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.parser.DruidSqlParser;
import org.apache.druid.sql.calcite.planner.CalcitePlannerModule;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.rule.ExtensionCalciteRuleProvider;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.easymock.EasyMock;
import org.easymock.EasyMockExtension;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={EasyMockExtension.class})
public class CalcitePlannerModuleTest
extends CalciteTestBase {
    private static final String SCHEMA_1 = "SCHEMA_1";
    private static final String SCHEMA_2 = "SCHEMA_2";
    private static final String DRUID_SCHEMA_NAME = "DRUID_SCHEMA_NAME";
    private static final int BLOAT = 1200;
    @Mock
    private NamedSchema druidSchema1;
    @Mock
    private NamedSchema druidSchema2;
    @Mock
    private Schema schema1;
    @Mock
    private Schema schema2;
    @Mock
    private QueryLifecycleFactory queryLifecycleFactory;
    @Mock
    private ExprMacroTable macroTable;
    @Mock
    private JoinableFactoryWrapper joinableFactoryWrapper;
    @Mock
    private AuthorizerMapper authorizerMapper;
    @Mock
    private DruidSchemaCatalog rootSchema;
    private Set<SqlAggregator> aggregators;
    private Set<SqlOperatorConversion> operatorConversions;
    private CalcitePlannerModule target;
    private Injector injector;
    private RelOptRule customRule;

    @BeforeEach
    public void setUp() {
        EasyMock.expect((Object)this.druidSchema1.getSchema()).andStubReturn((Object)this.schema1);
        EasyMock.expect((Object)this.druidSchema2.getSchema()).andStubReturn((Object)this.schema2);
        EasyMock.expect((Object)this.druidSchema1.getSchemaName()).andStubReturn((Object)SCHEMA_1);
        EasyMock.expect((Object)this.druidSchema2.getSchemaName()).andStubReturn((Object)SCHEMA_2);
        EasyMock.expect((Object)this.druidSchema1.getSchemaResourceType(EasyMock.anyString())).andStubReturn((Object)"DATASOURCE");
        EasyMock.expect((Object)this.druidSchema2.getSchemaResourceType(EasyMock.anyString())).andStubReturn((Object)"test");
        EasyMock.replay((Object[])new Object[]{this.druidSchema1, this.druidSchema2});
        this.aggregators = ImmutableSet.of();
        this.operatorConversions = ImmutableSet.of();
        this.target = new CalcitePlannerModule();
        this.customRule = new RelOptRule(RelOptRule.operand(LogicalTableScan.class, (RelOptRuleOperandChildren)RelOptRule.any()), "customRule"){

            public void onMatch(RelOptRuleCall call) {
            }
        };
        this.injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), new PolicyModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(QueryLifecycleFactory.class).toInstance((Object)this.queryLifecycleFactory);
            binder.bind(ExprMacroTable.class).toInstance((Object)this.macroTable);
            binder.bind(AuthorizerMapper.class).toInstance((Object)this.authorizerMapper);
            binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)DRUID_SCHEMA_NAME);
            binder.bind(Key.get((TypeLiteral)new TypeLiteral<Set<SqlAggregator>>(){})).toInstance(this.aggregators);
            binder.bind(Key.get((TypeLiteral)new TypeLiteral<Set<SqlOperatorConversion>>(){})).toInstance(this.operatorConversions);
            binder.bind(DruidSchemaCatalog.class).toInstance((Object)this.rootSchema);
            binder.bind(JoinableFactoryWrapper.class).toInstance((Object)this.joinableFactoryWrapper);
            binder.bind(CatalogResolver.class).toInstance((Object)CatalogResolver.NULL_RESOLVER);
        }, this.target, binder -> Multibinder.newSetBinder((Binder)binder, ExtensionCalciteRuleProvider.class).addBinding().toInstance(plannerContext -> this.customRule)});
    }

    @Test
    public void testDruidOperatorTableIsInjectable() {
        DruidOperatorTable operatorTable = (DruidOperatorTable)this.injector.getInstance(DruidOperatorTable.class);
        Assert.assertNotNull((Object)operatorTable);
        DruidOperatorTable other = (DruidOperatorTable)this.injector.getInstance(DruidOperatorTable.class);
        Assert.assertSame((Object)other, (Object)operatorTable);
    }

    @Test
    public void testPlannerFactoryIsInjectable() {
        PlannerFactory plannerFactory = (PlannerFactory)this.injector.getInstance(PlannerFactory.class);
        Assert.assertNotNull(PlannerFactory.class);
        PlannerFactory other = (PlannerFactory)this.injector.getInstance(PlannerFactory.class);
        Assert.assertSame((Object)other, (Object)plannerFactory);
    }

    @Test
    public void testPlannerConfigIsInjected() {
        PlannerConfig plannerConfig = (PlannerConfig)this.injector.getInstance(PlannerConfig.class);
        Assert.assertNotNull((Object)plannerConfig);
    }

    @Test
    public void testExtensionCalciteRule() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        PlannerToolbox toolbox = (PlannerToolbox)this.injector.getInstance(PlannerFactory.class);
        String sql = "SELECT 1";
        PlannerContext context = PlannerContext.create((PlannerToolbox)toolbox, (String)"SELECT 1", (SqlNode)DruidSqlParser.parse((String)"SELECT 1", (boolean)false).getMainStatement(), (SqlEngine)new NativeSqlEngine(this.queryLifecycleFactory, (ObjectMapper)mapper, (SqlStatementFactory)null), Collections.emptySet(), Collections.emptyMap(), null);
        boolean containsCustomRule = ((CalciteRulesManager)this.injector.getInstance(CalciteRulesManager.class)).druidConventionRuleSet(context).contains(this.customRule);
        Assert.assertTrue((boolean)containsCustomRule);
    }

    @Test
    public void testConfigurableBloat() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        PlannerToolbox toolbox = (PlannerToolbox)this.injector.getInstance(PlannerFactory.class);
        String sql = "SELECT 1";
        PlannerContext contextWithBloat = PlannerContext.create((PlannerToolbox)toolbox, (String)"SELECT 1", (SqlNode)DruidSqlParser.parse((String)"SELECT 1", (boolean)false).getMainStatement(), (SqlEngine)new NativeSqlEngine(this.queryLifecycleFactory, (ObjectMapper)mapper, (SqlStatementFactory)null), Collections.emptySet(), Collections.singletonMap("sqlPlannerBloat", 1200), null);
        PlannerContext contextWithoutBloat = PlannerContext.create((PlannerToolbox)toolbox, (String)"SELECT 1", (SqlNode)DruidSqlParser.parse((String)"SELECT 1", (boolean)false).getMainStatement(), (SqlEngine)new NativeSqlEngine(this.queryLifecycleFactory, (ObjectMapper)mapper, (SqlStatementFactory)null), Collections.emptySet(), Collections.emptyMap(), null);
        this.assertBloat(contextWithBloat, 1200);
        this.assertBloat(contextWithoutBloat, 1000);
    }

    private void assertBloat(PlannerContext context, int expectedBloat) {
        Optional<ProjectMergeRule> firstProjectMergeRule = ((CalciteRulesManager)this.injector.getInstance(CalciteRulesManager.class)).baseRuleSet(context, false).stream().filter(rule -> rule instanceof ProjectMergeRule).map(rule -> (ProjectMergeRule)rule).findAny();
        Assert.assertTrue((firstProjectMergeRule.isPresent() && ((ProjectMergeRule.Config)firstProjectMergeRule.get().config).bloat() == expectedBloat ? 1 : 0) != 0);
    }
}

