/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class DruidSqlParserUtilsTest {

    public static class NonParameterizedTests {
        private static final DateTimeZone TZ_LOS_ANGELES = DateTimes.inferTzFromString((String)"America/Los_Angeles");

        @Test
        public void test_parseTimeStampWithTimeZone_timestamp_utc() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678");
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)DateTimeZone.UTC), (int)3, (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)DateTimeZone.UTC);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_timestamp_losAngeles() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678").withZone(TZ_LOS_ANGELES);
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)TZ_LOS_ANGELES), (int)3, (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)TZ_LOS_ANGELES);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_timestampWithLocalTimeZone() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678");
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (TimestampString)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)DateTimeZone.UTC), (int)3, (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)DateTimeZone.UTC);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_timestampWithLocalTimeZone_losAngeles() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678").withZone(TZ_LOS_ANGELES);
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (TimestampString)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)TZ_LOS_ANGELES), (int)3, (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)TZ_LOS_ANGELES);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_unknownTimestamp() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678");
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createUnknown((String)SqlTypeName.TIMESTAMP.getSpaceName(), (String)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)DateTimeZone.UTC).toString(), (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)DateTimeZone.UTC);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_unknownTimestampWithLocalTimeZone() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678");
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createUnknown((String)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.getSpaceName(), (String)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)DateTimeZone.UTC).toString(), (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)DateTimeZone.UTC);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_unknownTimestamp_losAngeles() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678").withZone(TZ_LOS_ANGELES);
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createUnknown((String)SqlTypeName.TIMESTAMP.getSpaceName(), (String)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)TZ_LOS_ANGELES).toString(), (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)TZ_LOS_ANGELES);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_unknownTimestampWithLocalTimeZone_losAngeles() {
            DateTime ts = DateTimes.of((String)"2000-01-02T03:04:05.678").withZone(TZ_LOS_ANGELES);
            String s = DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createUnknown((String)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.getSpaceName(), (String)Calcites.jodaToCalciteTimestampString((DateTime)ts, (DateTimeZone)TZ_LOS_ANGELES).toString(), (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)TZ_LOS_ANGELES);
            Assert.assertEquals((Object)String.valueOf(ts.getMillis()), (Object)s);
        }

        @Test
        public void test_parseTimeStampWithTimeZone_unknownTimestamp_invalid() {
            DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)SqlLiteral.createUnknown((String)SqlTypeName.TIMESTAMP.getSpaceName(), (String)"not a timestamp", (SqlParserPos)SqlParserPos.ZERO), (DateTimeZone)DateTimeZone.UTC));
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Cannot get a timestamp from sql expression"));
        }
    }

    public static class FloorToGranularityConversionErrorsTest {
        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectFunctionCall() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.CEIL.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Invalid operator[CEIL] specified. PARTITIONED BY clause only supports FLOOR(__time TO <unit>) and TIME_FLOOR(__time, period) functions.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithIncorrectFunctionCall$0((SqlNode)sqlNode));
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("FLOOR in PARTITIONED BY clause must have 2 arguments, but only [1] provided.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments$1((SqlNode)sqlNode));
        }

        @Test
        public void testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("timestamps", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Invalid argument[timestamps] provided. The first argument to FLOOR in PARTITIONED BY clause must be __time.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction$2((SqlNode)sqlNode));
        }

        @Test
        public void testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("timestamps", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)"PT1H", (SqlParserPos)SqlParserPos.ZERO));
            SqlCall sqlNode = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Invalid argument[timestamps] provided. The first argument to TIME_FLOOR in PARTITIONED BY clause must be __time.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction$3((SqlNode)sqlNode));
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.ISOYEAR, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("ISOYEAR is not a valid period granularity for ingestion.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction$4((SqlNode)sqlNode));
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)"abc", (SqlParserPos)SqlParserPos.ZERO));
            SqlCall sqlNode = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("granularity['abc'] is an invalid period literal.").assertThrowsAndMatches(() -> FloorToGranularityConversionErrorsTest.lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction$5((SqlNode)sqlNode));
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction$5(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction$4(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction$3(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction$2(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments$1(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectFunctionCall$0(SqlNode sqlNode) {
            DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
        }
    }

    public static class ClusteredByColumnsValidationTest {
        @Test
        public void testEmptyClusteredByColumnsValid() {
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            DruidSqlParserUtils.validateClusteredByColumns((SqlNodeList)clusteredByArgs);
        }

        @Test
        public void testClusteredByColumnsValid() {
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM1", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM2 ASC", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"3", (SqlParserPos)SqlParserPos.ZERO));
            DruidSqlParserUtils.validateClusteredByColumns((SqlNodeList)clusteredByArgs);
        }

        @Test
        public void testClusteredByColumnsWithDescThrowsException() {
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM1", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM2 ASC", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"3", (SqlParserPos)SqlParserPos.ZERO));
            SqlBasicCall sqlBasicCall = new SqlBasicCall((SqlOperator)new SqlPostfixOperator("DESC", SqlKind.DESCENDING, 2, null, null, null), new SqlNode[]{new SqlIdentifier("DIM4", SqlParserPos.ZERO)}, new SqlParserPos(0, 3));
            clusteredByArgs.add((SqlNode)sqlBasicCall);
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Invalid CLUSTERED BY clause [`DIM4` DESC]: cannot sort in descending order.").assertThrowsAndMatches(() -> DruidSqlParserUtils.validateClusteredByColumns((SqlNodeList)clusteredByArgs));
        }

        @Test
        public void testClusteredByColumnsWithNegativeOrdinalThrowsException() {
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM1", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)new SqlIdentifier("DIM2", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)new SqlIdentifier("3", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"-10", (SqlParserPos)SqlParserPos.ZERO));
            DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Ordinal [-10] specified in the CLUSTERED BY clause is invalid. It must be a positive integer.").assertThrowsAndMatches(() -> DruidSqlParserUtils.validateClusteredByColumns((SqlNodeList)clusteredByArgs));
        }
    }

    public static class ResolveClusteredByColumnsTest {
        @Test
        public void testNullClusteredByAndSource() {
            Assert.assertNull((Object)DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns(null, null));
        }

        @Test
        public void testNullClusteredBy() {
            PairList fields = PairList.builder().add((Object)1, (Object)"__time").add((Object)2, (Object)"foo").add((Object)3, (Object)"bar").build();
            Assert.assertNull((Object)DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns(null, (List)fields));
        }

        @Test
        public void testSimpledClusteredByWithNullSource() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIdentifier("FOO", new SqlParserPos(0, 2)));
            SqlBasicCall sqlBasicCall1 = new SqlBasicCall((SqlOperator)new SqlAsOperator(), new SqlNode[]{new SqlIdentifier("DIM3", SqlParserPos.ZERO), new SqlIdentifier("DIM3_ALIAS", SqlParserPos.ZERO)}, new SqlParserPos(0, 3));
            args.add((SqlNode)sqlBasicCall1);
            Assert.assertEquals(Arrays.asList("__time", "FOO", "DIM3_ALIAS"), (Object)DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns((SqlNodeList)args, null));
        }

        @Test
        public void testSimpleClusteredBy() {
            PairList sourceFieldMappings = PairList.builder().add((Object)1, (Object)"__time").add((Object)2, (Object)"FOO").add((Object)3, (Object)"BOO").build();
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            clusteredByArgs.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)new SqlIdentifier("FOO", SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"3", (SqlParserPos)SqlParserPos.ZERO));
            Assert.assertEquals(Arrays.asList("__time", "FOO", "BOO"), (Object)DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns((SqlNodeList)clusteredByArgs, (List)sourceFieldMappings));
        }

        @Test
        public void testClusteredByOrdinalsAndAliases() {
            PairList sourceFieldMappings = PairList.builder().add((Object)1, (Object)"__time").add((Object)2, (Object)"DIM3").add((Object)3, (Object)"DIM3_ALIAS").add((Object)4, (Object)"floor_dim4_time").add((Object)5, (Object)"DIM5").add((Object)5, (Object)"DIM6").add((Object)7, (Object)"TIME_FLOOR(\"timestamps\", 'PT1H')").build();
            SqlNodeList clusteredByArgs = new SqlNodeList(SqlParserPos.ZERO);
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"3", (SqlParserPos)SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"4", (SqlParserPos)SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"5", (SqlParserPos)SqlParserPos.ZERO));
            clusteredByArgs.add((SqlNode)SqlLiteral.createExactNumeric((String)"7", (SqlParserPos)SqlParserPos.ZERO));
            Assert.assertEquals(Arrays.asList("DIM3_ALIAS", "floor_dim4_time", "DIM5", "TIME_FLOOR(\"timestamps\", 'PT1H')"), (Object)DruidSqlParserUtils.resolveClusteredByColumnsToOutputColumns((SqlNodeList)clusteredByArgs, (List)sourceFieldMappings));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class FloorToGranularityConversionTest {
        TimeUnit timeUnit;
        Period period;
        Granularity expectedGranularity;

        @Parameterized.Parameters(name="{1}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{TimeUnit.SECOND, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.SECOND), Granularities.SECOND}, (Object)new Object[]{TimeUnit.MINUTE, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.MINUTE), Granularities.MINUTE}, (Object)new Object[]{TimeUnit.HOUR, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.HOUR), Granularities.HOUR}, (Object)new Object[]{TimeUnit.DAY, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.DAY), Granularities.DAY}, (Object)new Object[]{TimeUnit.WEEK, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.WEEK), Granularities.WEEK}, (Object)new Object[]{TimeUnit.MONTH, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.MONTH), Granularities.MONTH}, (Object)new Object[]{TimeUnit.QUARTER, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.QUARTER), Granularities.QUARTER}, (Object)new Object[]{TimeUnit.YEAR, TimeUnits.toPeriod((TimeUnitRange)TimeUnitRange.YEAR), Granularities.YEAR});
        }

        public FloorToGranularityConversionTest(TimeUnit timeUnit, Period period, Granularity expectedGranularity) {
            this.timeUnit = timeUnit;
            this.period = period;
            this.expectedGranularity = expectedGranularity;
        }

        @Test
        public void testGetGranularityFromFloor() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(this.timeUnit, null, SqlParserPos.ZERO));
            SqlCall floorCall = SqlStdOperatorTable.FLOOR.createCall(args);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)floorCall);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }

        @Test
        public void testConvertSqlNodeToGranularityAsLiteral() {
            SqlCharStringLiteral sqlNode = SqlLiteral.createCharString((String)this.timeUnit.name(), (SqlParserPos)SqlParserPos.ZERO);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }

        @Test
        public void testConvertSqlNodeToPeriodFormGranularityAsIdentifier() {
            SqlIdentifier sqlNode = new SqlIdentifier(this.period.toString(), SqlParserPos.ZERO);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }

        @Test
        public void testConvertSqlNodeToPeriodFormGranularityAsLiteral() {
            SqlCharStringLiteral sqlNode = SqlLiteral.createCharString((String)this.period.toString(), (SqlParserPos)SqlParserPos.ZERO);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)sqlNode);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TimeFloorToGranularityConversionTest {
        String periodString;
        Granularity expectedGranularity;

        @Parameterized.Parameters(name="{1}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{"PT1H", Granularities.HOUR});
        }

        public TimeFloorToGranularityConversionTest(String periodString, Granularity expectedGranularity) {
            this.periodString = periodString;
            this.expectedGranularity = expectedGranularity;
        }

        @Test
        public void testGranularityFromTimeFloor() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)this.periodString, (SqlParserPos)SqlParserPos.ZERO));
            SqlCall timeFloorCall = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularity((SqlNode)timeFloorCall);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }
    }
}

