/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.quidem.DruidQTestInfo;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlSchema;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.http.SqlParameter;

public class QueryTestBuilder {
    protected final QueryTestConfig config;
    protected PlannerConfig plannerConfig = BaseCalciteQueryTest.PLANNER_CONFIG_DEFAULT;
    protected Map<String, Object> queryContext;
    protected List<SqlParameter> parameters = CalciteTestBase.DEFAULT_PARAMETERS;
    protected String sql;
    protected AuthenticationResult authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
    protected List<Query<?>> expectedQueries;
    protected List<Object[]> expectedResults;
    protected List<QueryTestRunner.QueryRunStepFactory> customRunners = new ArrayList<QueryTestRunner.QueryRunStepFactory>();
    protected List<QueryTestRunner.QueryVerifyStepFactory> customVerifications = new ArrayList<QueryTestRunner.QueryVerifyStepFactory>();
    protected RowSignature expectedResultSignature;
    protected List<ResourceAction> expectedResources;
    protected BaseCalciteQueryTest.ResultsVerifier expectedResultsVerifier;
    protected boolean skipVectorize;
    protected boolean queryCannotVectorize;
    protected Predicate<List<Query<?>>> verifyNativeQueries = xs -> true;
    protected AuthConfig authConfig = new AuthConfig();
    protected SqlTestFramework.PlannerFixture plannerFixture;
    protected String expectedLogicalPlan;
    protected SqlSchema expectedSqlSchema;
    protected BaseCalciteQueryTest.ResultMatchMode expectedResultMatchMode;

    public QueryTestBuilder(QueryTestConfig config) {
        Preconditions.checkNotNull(config.baseQueryContext(), (Object)"config's queryContext is null - probably set it to BaseCalciteQueryTest.QUERY_CONTEXT_DEFAULT");
        this.config = config;
        this.queryContext = config.baseQueryContext();
    }

    public QueryTestBuilder plannerConfig(PlannerConfig plannerConfig) {
        this.plannerConfig = plannerConfig;
        return this;
    }

    public QueryTestBuilder queryContext(Map<String, Object> queryContext) {
        this.queryContext = QueryContexts.override(this.queryContext, queryContext);
        return this;
    }

    public QueryTestBuilder parameters(List<SqlParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public QueryTestBuilder sql(String sql) {
        this.sql = sql;
        return this;
    }

    public QueryTestBuilder authResult(AuthenticationResult authenticationResult) {
        this.authenticationResult = authenticationResult;
        return this;
    }

    public QueryTestBuilder expectedQuery(Query<?> expectedQuery) {
        if (expectedQuery == null) {
            return this;
        }
        return this.expectedQueries(Collections.singletonList(expectedQuery));
    }

    public QueryTestBuilder expectedQueries(List<Query<?>> expectedQueries) {
        this.expectedQueries = expectedQueries;
        return this;
    }

    public QueryTestBuilder expectedResults(List<Object[]> expectedResults) {
        return this.expectedResults(BaseCalciteQueryTest.ResultMatchMode.EQUALS, expectedResults);
    }

    public QueryTestBuilder expectedResults(BaseCalciteQueryTest.ResultMatchMode expecteMatchMode, List<Object[]> expectedResults) {
        this.expectedResultMatchMode = expecteMatchMode;
        this.expectedResults = expectedResults;
        return this;
    }

    public QueryTestBuilder addCustomRunner(QueryTestRunner.QueryRunStepFactory factory) {
        this.customRunners.add(factory);
        return this;
    }

    public QueryTestBuilder addCustomVerification(QueryTestRunner.QueryVerifyStepFactory factory) {
        this.customVerifications.add(factory);
        return this;
    }

    public QueryTestBuilder expectedSignature(RowSignature expectedResultSignature) {
        this.expectedResultSignature = expectedResultSignature;
        return this;
    }

    public QueryTestBuilder expectedResults(BaseCalciteQueryTest.ResultsVerifier expectedResultsVerifier) {
        this.expectedResultsVerifier = expectedResultsVerifier;
        return this;
    }

    public QueryTestBuilder expectedResources(List<ResourceAction> expectedResources) {
        this.expectedResources = expectedResources;
        return this;
    }

    public QueryTestBuilder skipVectorize() {
        return this.skipVectorize(true);
    }

    public QueryTestBuilder skipVectorize(boolean skipVectorize) {
        this.skipVectorize = skipVectorize;
        return this;
    }

    public QueryTestBuilder verifyNativeQueries(Predicate<List<Query<?>>> verifyNativeQueries) {
        this.verifyNativeQueries = verifyNativeQueries;
        return this;
    }

    public QueryTestBuilder cannotVectorize() {
        return this.cannotVectorize(true);
    }

    public QueryTestBuilder cannotVectorize(boolean cannotVectorize) {
        this.queryCannotVectorize = cannotVectorize;
        return this;
    }

    public QueryTestBuilder authConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public QueryTestBuilder plannerFixture(SqlTestFramework.PlannerFixture plannerFixture) {
        this.plannerFixture = plannerFixture;
        return this;
    }

    public QueryTestBuilder expectedLogicalPlan(String expectedLogicalPlan) {
        this.expectedLogicalPlan = expectedLogicalPlan;
        return this;
    }

    public Map<String, Object> getQueryContext() {
        return this.queryContext;
    }

    public List<Query<?>> getExpectedQueries() {
        return this.expectedQueries;
    }

    public QueryTestRunner build() {
        return new QueryTestRunner(this);
    }

    protected SqlStatementFactory statementFactory() {
        if (this.plannerFixture != null) {
            return this.plannerFixture.statementFactory();
        }
        return this.config.plannerFixture(this.plannerConfig, this.authConfig).statementFactory();
    }

    public void run() {
        this.build().run();
    }

    public QueryTestRunner.QueryResults results() {
        return this.build().resultsOnly();
    }

    public boolean isDecoupledMode() {
        String mode = (String)this.queryContext.getOrDefault("plannerStrategy", "");
        return "DECOUPLED".equalsIgnoreCase(mode);
    }

    public static interface QueryTestConfig {
        public ObjectMapper jsonMapper();

        public SqlTestFramework.PlannerFixture plannerFixture(PlannerConfig var1, AuthConfig var2);

        public BaseCalciteQueryTest.ResultsVerifier defaultResultsVerifier(List<Object[]> var1, BaseCalciteQueryTest.ResultMatchMode var2, RowSignature var3);

        public boolean isRunningMSQ();

        public Map<String, Object> baseQueryContext();

        default public DruidQTestInfo getQTestInfo() {
            return null;
        }

        public SqlTestFramework queryFramework();
    }
}

