/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.quidem.DruidQTestInfo;
import org.apache.druid.quidem.DruidQuidemTestBase;
import org.apache.druid.sql.calcite.QueryTestRunner;

public class QTestCase {
    private StringBuffer sb;
    private DruidQTestInfo testInfo;

    public QTestCase(DruidQTestInfo testInfo) {
        this.testInfo = testInfo;
        this.sb = new StringBuffer();
        this.sb.append("# ");
        this.sb.append(testInfo.comment);
        this.sb.append("\n");
    }

    public void println(String str) {
        this.sb.append(str);
        this.sb.append("\n");
    }

    public QueryTestRunner.QueryRunStep toRunner() {
        return new QueryTestRunner.QueryRunStep(null){

            @Override
            public void run() {
                try {
                    if (DruidQuidemTestBase.DruidQuidemRunner.isOverwrite()) {
                        QTestCase.this.writeCaseTo(QTestCase.this.testInfo.getIQFile());
                    } else {
                        QTestCase.this.isValidTestCaseFile(QTestCase.this.testInfo.getIQFile());
                    }
                    DruidQuidemTestBase.DruidQuidemRunner runner = new DruidQuidemTestBase.DruidQuidemRunner();
                    runner.run(QTestCase.this.testInfo.getIQFile());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error running quidem test", e);
                }
            }
        };
    }

    protected void isValidTestCaseFile(File iqFile) {
        if (!iqFile.exists()) {
            throw new IllegalStateException("testcase doesn't exists; run with (-Dquidem.overwrite) : " + iqFile);
        }
        try {
            String header = this.makeHeader();
            String testCaseFirstLine = Files.asCharSource((File)iqFile, (Charset)StandardCharsets.UTF_8).readFirstLine();
            if (!header.equals(testCaseFirstLine)) {
                throw new IllegalStateException("backing quidem testcase doesn't match test - run with (-Dquidem.overwrite) : " + iqFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String makeHeader() {
        HashCode hash = Hashing.crc32().hashBytes(this.sb.toString().getBytes(StandardCharsets.UTF_8));
        return StringUtils.format((String)"# %s case-crc:%s", (Object[])new Object[]{this.testInfo.testName, hash});
    }

    public void writeCaseTo(File file) throws IOException {
        FileUtils.mkdirp((File)file.getParentFile());
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(this.makeHeader().getBytes(StandardCharsets.UTF_8));
            fos.write(10);
            fos.write(this.sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing testcase to: " + file, e);
        }
    }
}

