/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.Throwables;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.opentest4j.IncompleteExecutionException;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface NotYetSupported {
    public Modes[] value();

    public static class NotYetSupportedProcessor
    implements InvocationInterceptor {
        private final Scope scope;

        public NotYetSupportedProcessor(Scope scope) {
            this.scope = scope;
        }

        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            Method method = (Method)extensionContext.getTestMethod().get();
            NotYetSupported annotation = method.getAnnotation(NotYetSupported.class);
            Modes ignoreMode = this.getModeForScope(annotation);
            if (ignoreMode == null) {
                invocation.proceed();
                return;
            }
            Throwable e = null;
            try {
                invocation.proceed();
            }
            catch (Throwable t) {
                e = t;
            }
            if (e instanceof AssumptionViolatedException) {
                throw (AssumptionViolatedException)e;
            }
            if (e instanceof IncompleteExecutionException) {
                throw (IncompleteExecutionException)e;
            }
            Throwable finalE = e;
            Assert.assertThrows((String)"Expected that this testcase will fail - it might got fixed; or failure have changed?", ignoreMode.throwableClass, () -> {
                if (finalE != null) {
                    throw finalE;
                }
            });
            String trace = Throwables.getStackTraceAsString((Throwable)e);
            Matcher m = ignoreMode.getPattern().matcher(trace);
            if (!m.find()) {
                throw new AssertionError("Exception stacktrace doesn't match regex: " + ignoreMode.regex, e);
            }
            throw new AssumptionViolatedException("Test is not-yet supported; ignored with:" + annotation);
        }

        private Modes getModeForScope(@Nullable NotYetSupported annotation) {
            if (annotation == null) {
                return null;
            }
            for (Modes mode : annotation.value()) {
                if (mode.scope != this.scope) continue;
                return mode;
            }
            return null;
        }

        public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            this.interceptTestMethod(invocation, invocationContext, extensionContext);
        }
    }

    public static enum Modes {
        DISTINCT_AGGREGATE_NOT_SUPPORTED(Scope.WINDOWING, DruidException.class, "DISTINCT is not supported"),
        NULLS_FIRST_LAST(Scope.WINDOWING, DruidException.class, "NULLS (FIRST|LAST)"),
        BIGINT_TO_DATE(Scope.WINDOWING, DruidException.class, "BIGINT to type (DATE|TIME)"),
        AGGREGATION_NOT_SUPPORT_TYPE(Scope.WINDOWING, DruidException.class, "Aggregation \\[(MIN|MAX)\\] does not support type \\[STRING\\]"),
        ALLDATA_CSV(Scope.WINDOWING, DruidException.class, "allData.csv"),
        BIGINT_TIME_COMPARE(Scope.WINDOWING, DruidException.class, "Cannot apply '.' to arguments of type"),
        VIEWS_NOT_SUPPORTED(Scope.WINDOWING, DruidException.class, "Incorrect syntax near the keyword 'CREATE'"),
        RESULT_MISMATCH(Scope.WINDOWING, AssertionError.class, "(assertResulEquals|AssertionError: column content mismatch)"),
        LONG_CASTING(Scope.WINDOWING, AssertionError.class, "expected: java.lang.Long"),
        UNSUPPORTED_NULL_ORDERING(Scope.WINDOWING, DruidException.class, "(A|DE)SCENDING ordering with NULLS (LAST|FIRST)"),
        EXPRESSION_NOT_GROUPED(Scope.BINDABLE, DruidException.class, "Expression '[a-z]+' is not being grouped"),
        NOT_ENOUGH_RULES(Scope.DECOUPLED, DruidException.class, "There are not enough rules to produce a node"),
        SORT_REMOVE_TROUBLE(Scope.DECOUPLED, DruidException.class, "Calcite assertion violated.*Sort\\.<init>"),
        UNNEST_INLINED(Scope.DECOUPLED, Exception.class, "Missing conversion is Uncollect"),
        UNNEST_RESULT_MISMATCH(Scope.DECOUPLED, AssertionError.class, "(Result count mismatch|column content mismatch)"),
        DD_RESTRICTED_DATASOURCE_SUPPORT(Scope.DECOUPLED_DART, DruidException.class, "ForbiddenException: Unauthorized"),
        DD_RESTRICTED_DATASOURCE_SUPPORT2(Scope.DECOUPLED_DART, AssertionError.class, "Unauthorized"),
        DD_INCORRECT_RESULTS_EMPTY_STRING(Scope.DECOUPLED_DART, AssertionError.class, "column content mismatch at"),
        NO_INFORMATION_SCHEMA_SUPPORT(Scope.DECOUPLED_DART, DruidException.class, "INFORMATION_SCHEMA"),
        DD_NULL_COLUMN_ORDER(Scope.DECOUPLED_DART, DruidException.class, "sort: \\[\\] -> \\[1\\]"),
        DD_UNION(Scope.DECOUPLED_DART, DruidException.class, "DruidUnion.DRUID_LOGICAL"),
        DD_WINDOW(Scope.DECOUPLED_DART, DruidException.class, "DruidWindow.DRUID_LOGICAL"),
        DD_UNNEST_RESULT_MISMATCH(Scope.DECOUPLED_DART, AssertionError.class, "(Result count mismatch|column content mismatch)"),
        DD_UNNEST_INLINED(Scope.DECOUPLED_DART, Exception.class, "Missing conversion is Uncollect"),
        DD_SORT_REMOVE_TROUBLE(Scope.DECOUPLED_DART, DruidException.class, "Calcite assertion violated.*Sort\\.<init>"),
        DD_JOIN_CONDITION_NORMALIZATION(Scope.DECOUPLED_DART, DruidException.class, "Cannot handle equality"),
        DD_RESULT_MISMATCH_FLOAT_DOUBLE(Scope.DECOUPLED_DART, AssertionError.class, "column content mismatch");

        public Scope scope;
        public Class<? extends Throwable> throwableClass;
        public String regex;

        private Modes(Scope scope, Class<? extends Throwable> cl, String regex) {
            this.scope = scope;
            this.throwableClass = cl;
            this.regex = regex;
        }

        private Modes(Class<? extends Throwable> cl, String regex) {
            this(Scope.DECOUPLED, cl, regex);
        }

        Pattern getPattern() {
            return Pattern.compile(this.regex, 40);
        }

        public String toString() {
            return this.name() + "{" + this.regex + "}";
        }
    }

    public static enum Scope {
        WINDOWING,
        DECOUPLED,
        DECOUPLED_DART,
        BINDABLE;

    }
}

