/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Query;
import org.apache.druid.quidem.DruidQTestInfo;
import org.apache.druid.quidem.ProjectPathUtils;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.DecoupledTestConfig;
import org.apache.druid.sql.calcite.QueryTestBuilder;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DecoupledExtension
implements BeforeEachCallback {
    private BaseCalciteQueryTest baseTest;
    private File qCaseDir;
    private static final ImmutableMap<String, Object> CONTEXT_OVERRIDES = ImmutableMap.builder().putAll(BaseCalciteQueryTest.QUERY_CONTEXT_DEFAULT).put((Object)"plannerStrategy", (Object)"DECOUPLED").put((Object)"debug", (Object)true).build();

    public DecoupledExtension(BaseCalciteQueryTest baseTest) {
        this.baseTest = baseTest;
    }

    public void beforeEach(ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().get();
        this.qCaseDir = ProjectPathUtils.getPathFromProjectRoot("sql/src/test/quidem/" + testClass.getName());
    }

    public QueryTestBuilder testBuilder() {
        final DecoupledTestConfig decTestConfig = BaseCalciteQueryTest.queryFrameworkRule.getAnnotation(DecoupledTestConfig.class);
        final boolean runQuidem = decTestConfig != null && decTestConfig.quidemReason().isPresent();
        final boolean ignoreQueries = decTestConfig != null && decTestConfig.ignoreExpectedQueriesReason().isPresent();
        BaseCalciteQueryTest baseCalciteQueryTest = this.baseTest;
        Objects.requireNonNull(baseCalciteQueryTest);
        BaseCalciteQueryTest.CalciteTestConfig testConfig = new BaseCalciteQueryTest.CalciteTestConfig(baseCalciteQueryTest, (Map)CONTEXT_OVERRIDES){
            {
                BaseCalciteQueryTest baseCalciteQueryTest = x0;
                Objects.requireNonNull(baseCalciteQueryTest);
                super(baseQueryContext);
            }

            @Override
            public SqlTestFramework.PlannerFixture plannerFixture(PlannerConfig plannerConfig, AuthConfig authConfig) {
                plannerConfig = plannerConfig.withOverrides(CONTEXT_OVERRIDES);
                return DecoupledExtension.this.baseTest.queryFramework().plannerFixture(plannerConfig, authConfig);
            }

            @Override
            public DruidQTestInfo getQTestInfo() {
                if (runQuidem) {
                    String testName = BaseCalciteQueryTest.queryFrameworkRule.testName();
                    return new DruidQTestInfo(DecoupledExtension.this.qCaseDir, testName, "quidem testcase reason: " + decTestConfig.quidemReason());
                }
                return null;
            }
        };
        QueryTestBuilder builder = new QueryTestBuilder(testConfig){

            @Override
            public QueryTestBuilder expectedQueries(List<Query<?>> expectedQueries) {
                if (ignoreQueries) {
                    return this;
                }
                return super.expectedQueries(expectedQueries);
            }
        };
        boolean cannotVectorize = this.baseTest.cannotVectorize || !ExpressionProcessing.allowVectorizeFallback() && this.baseTest.cannotVectorizeUnlessFallback;
        return builder.cannotVectorize(cannotVectorize).skipVectorize(this.baseTest.skipVectorize);
    }
}

