/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=ScanSignatureComponentSupplier.class)
public class CalciteScanSignatureTest
extends BaseCalciteQueryTest {
    @Test
    public void testScanSignature() {
        HashMap context = new HashMap(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteScanSignatureTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteScanSignatureTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteScanSignatureTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"def-def_def"}, (Object)new Object[]{"abc-abc_abc"}));
    }

    @Test
    public void testScanSignatureWithDimAsValuePrimitiveByteArr() {
        HashMap context = new HashMap(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT CAST(dim1 AS BIGINT) as dimX FROM foo2 limit 2", (List<Query<?>>)ImmutableList.of((Object)CalciteScanSignatureTest.newScanQueryBuilder().dataSource("foo2").intervals(CalciteScanSignatureTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteScanSignatureTest.expressionVirtualColumn("v0", "CAST(\"dim1\", 'LONG')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).limit(2L).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    static class ScanSignatureComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        public ScanSignatureComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }
    }
}

