/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.OperatorFactoryBuilders;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.WindowOperatorQueryBuilder;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.DecoupledTestConfig;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;
import org.apache.druid.sql.http.SqlParameter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CalciteQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testInformationSchemaSchemata() {
        this.msqIncompatible();
        this.testQuery("SELECT DISTINCT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"lookup"}, (Object)new Object[]{"view"}, (Object)new Object[]{"druid"}, (Object)new Object[]{"sys"}, (Object)new Object[]{"INFORMATION_SCHEMA"}));
    }

    @Test
    public void testInformationSchemaTables() {
        this.msqIncompatible();
        this.testQuery("SELECT TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, IS_JOINABLE, IS_BROADCAST\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE IN ('SYSTEM_TABLE', 'TABLE', 'VIEW')", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{"druid", "arrays", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "broadcast", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "foo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo2", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo4", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", TestDataSet.LARRY.getName(), "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "lotsocolumns", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "numfoo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "restrictedBroadcastDatasource_m1_is_6", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "restrictedDatasource_m1_is_6", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "some_datasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "somexdatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "visits", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "wikipedia", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "wikipedia_first_last", "TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "COLUMNS", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "ROUTINES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "SCHEMATA", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "TABLES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"lookup", "lookyloo", "TABLE", "YES", "YES"}).add((Object)new Object[]{"lookup", "lookyloo-chain", "TABLE", "YES", "YES"}).add((Object)new Object[]{"lookup", "lookyloo121", "TABLE", "YES", "YES"}).add((Object)new Object[]{"sys", "segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "server_segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "servers", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "supervisors", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "tasks", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"view", "aview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "bview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "cview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "dview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "invalidView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "restrictedView", "VIEW", "NO", "NO"}).build());
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, IS_JOINABLE, IS_BROADCAST\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE IN ('SYSTEM_TABLE', 'TABLE', 'VIEW')", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{"druid", "arrays", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "broadcast", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "foo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo2", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo4", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "forbiddenDatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", TestDataSet.LARRY.getName(), "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "lotsocolumns", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "numfoo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "restrictedBroadcastDatasource_m1_is_6", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "restrictedDatasource_m1_is_6", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "some_datasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "somexdatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "visits", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "wikipedia", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "wikipedia_first_last", "TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "COLUMNS", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "ROUTINES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "SCHEMATA", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "TABLES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"lookup", "lookyloo", "TABLE", "YES", "YES"}).add((Object)new Object[]{"lookup", "lookyloo-chain", "TABLE", "YES", "YES"}).add((Object)new Object[]{"lookup", "lookyloo121", "TABLE", "YES", "YES"}).add((Object)new Object[]{"sys", "segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "server_segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "servers", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "supervisors", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "tasks", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"view", "aview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "bview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "cview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "dview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "forbiddenView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "invalidView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "restrictedView", "VIEW", "NO", "NO"}).build());
    }

    @Test
    public void testInformationSchemaColumnsOnTable() {
        this.msqIncompatible();
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"__time", "TIMESTAMP", "NO"}, (Object)new Object[]{"dim1", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"dim3", "VARCHAR", "YES"}, (Object)new Object[]{"cnt", "BIGINT", "YES"}, (Object)new Object[]{"m1", "FLOAT", "YES"}, (Object)new Object[]{"m2", "DOUBLE", "YES"}, (Object)new Object[]{"unique_dim1", "COMPLEX<hyperUnique>", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnForbiddenTable() {
        this.msqIncompatible();
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'forbiddenDatasource'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'forbiddenDatasource'", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"__time", "TIMESTAMP", "NO"}, (Object)new Object[]{"dim1", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"cnt", "BIGINT", "YES"}, (Object)new Object[]{"m1", "FLOAT", "YES"}, (Object)new Object[]{"m2", "DOUBLE", "YES"}, (Object)new Object[]{"unique_dim1", "COMPLEX<hyperUnique>", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnView() {
        this.msqIncompatible();
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'view' AND TABLE_NAME = 'aview'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dim1_firstchar", "VARCHAR", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnAnotherView() {
        this.msqIncompatible();
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'view' AND TABLE_NAME = 'cview'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dim1_firstchar", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"l2", "BIGINT", "YES"}));
    }

    @Test
    public void testCannotInsertWithNativeEngine() {
        this.msqIncompatible();
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testQuery("INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("INSERT operations are not supported by requested SQL engine [native], consider using MSQ."));
    }

    @Test
    public void testCannotReplaceWithNativeEngine() {
        this.msqIncompatible();
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testQuery("REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("REPLACE operations are not supported by the requested SQL engine [native].  Consider using MSQ."));
    }

    @NotYetSupported(value={NotYetSupported.Modes.NO_INFORMATION_SCHEMA_SUPPORT})
    @Test
    public void testAggregatorsOnInformationSchemaColumns() {
        this.msqIncompatible();
        this.testQuery("SELECT\n  COUNT(JDBC_TYPE),\n  SUM(JDBC_TYPE),\n  AVG(JDBC_TYPE),\n  MIN(JDBC_TYPE),\n  MAX(JDBC_TYPE)\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{8L, 1249L, 156.125, -5L, 1111L}));
    }

    @Test
    public void testFilterAggregatorFunctionsOnInformationSchemaRoutines() {
        this.msqIncompatible();
        this.testQuery("SELECT\n  COUNT(*)\nFROM INFORMATION_SCHEMA.ROUTINES\nWHERE IS_AGGREGATOR = 'YES' AND ROUTINE_NAME = 'COUNT'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testFilterScalarFunctionsOnInformationSchemaRoutines() {
        this.msqIncompatible();
        this.testQuery("SELECT\n  COUNT(*)\nFROM INFORMATION_SCHEMA.ROUTINES\nWHERE IS_AGGREGATOR = 'NO' AND ROUTINE_NAME = 'CEIL'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testNonExistentSchemaOnInformationSchemaRoutines() {
        this.msqIncompatible();
        this.testQuery("SELECT *\nFROM INFORMATION_SCHEMA.ROUTINES\nWHERE ROUTINE_SCHEMA = 'boo'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTopNLimitWrapping() {
        this.msqIncompatible();
        Map context = QueryContexts.override((Map)OUTER_LIMIT_CONTEXT, (String)"useLexicographicTopN", (Object)true);
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"def", 1L}, (Object)new Object[]{"abc", 1L});
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).threshold(2).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).context(context).build()), (List<Object[]>)expected);
    }

    @Test
    public void testTopNLimitWrappingOrderByAgg() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).threshold(2).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric("a0").context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}));
    }

    @Test
    public void testGroupByLimitWrapping() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"def", "abc", 1L}, (Object)new Object[]{"abc", null, 1L});
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY dim1, dim2 ORDER BY dim1 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).limit(2).build()).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testGroupByWithForceLimitPushDown() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("forceLimitPushDown", true);
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY dim1, dim2 limit 1", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(1))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1L}));
    }

    @Test
    public void testSafeDivide() {
        this.cannotVectorizeUnlessFallback();
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("select count(*) c from foo where ((floor(safe_divide(cast(cast(m1 as char) as bigint), 2))) = 0)", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(safe_divide(CAST(CAST(\"m1\", 'STRING'), 'LONG'),2))", ColumnType.LONG)}).filters(CalciteQueryTest.equality("v0", 0L, ColumnType.LONG)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testDiv() {
        this.testQuery("select cnt, m1, div(m1, 2), div(cnt+2, cnt+1) from foo", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "div(\"m1\",2)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "div((\"cnt\" + 2),(\"cnt\" + 1))", ColumnType.LONG)}).columns(new String[]{"cnt", "m1", "v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.LONG, ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), 0L, 1L}, (Object)new Object[]{1L, Float.valueOf(2.0f), 1L, 1L}, (Object)new Object[]{1L, Float.valueOf(3.0f), 1L, 1L}, (Object)new Object[]{1L, Float.valueOf(4.0f), 2L, 1L}, (Object)new Object[]{1L, Float.valueOf(5.0f), 2L, 1L}, (Object)new Object[]{1L, Float.valueOf(6.0f), 3L, 1L}));
    }

    @Test
    public void testGroupByLimitWrappingOrderByAgg() {
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY 1, 2 ORDER BY 3 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)}).limit(2).build()).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1L}, (Object)new Object[]{"1", "a", 1L}));
    }

    @Test
    public void testGroupBySingleColumnDescendingNoTopN() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"2"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"1"}, (Object)new Object[]{""}));
    }

    @Test
    public void testEarliestAggregators() {
        this.testQuery("SELECT EARLIEST(cnt), EARLIEST(m1), EARLIEST(dim1, 10), EARLIEST(dim1, CAST(10 AS INTEGER)), EARLIEST(cnt + 1), EARLIEST(m1 + 1), EARLIEST(dim1 || CAST(cnt AS VARCHAR), 10), EARLIEST_BY(cnt, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(m1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(dim1, MILLIS_TO_TIMESTAMP(l1), 10), EARLIEST_BY(cnt + 1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(m1 + 1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), 10), EARLIEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), 10) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "cnt", null), new FloatFirstAggregatorFactory("a1", "m1", null), new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(10)), new LongFirstAggregatorFactory("a3", "v0", null), new FloatFirstAggregatorFactory("a4", "v1", null), new StringFirstAggregatorFactory("a5", "v2", null, Integer.valueOf(10)), new LongFirstAggregatorFactory("a6", "cnt", "l1"), new FloatFirstAggregatorFactory("a7", "m1", "l1"), new StringFirstAggregatorFactory("a8", "dim1", "l1", Integer.valueOf(10)), new LongFirstAggregatorFactory("a9", "v0", "l1"), new FloatFirstAggregatorFactory("a10", "v1", "l1"), new StringFirstAggregatorFactory("a11", "v2", "l1", Integer.valueOf(10))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), "", "", 2L, Float.valueOf(2.0f), "1", 1L, Float.valueOf(3.0f), "2", 2L, Float.valueOf(4.0f), "21", "21"}));
    }

    @Test
    public void testGroupingOnStringSerializablePairLongString() {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM (SELECT string_first_added FROM druid.wikipedia_first_last GROUP BY 1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("string_first_added", "d0", ColumnType.ofComplex((String)"serializablePairLongString"))}).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions((List)ImmutableList.of()).setContext(QUERY_CONTEXT_DEFAULT).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{39244L}));
    }

    @Test
    public void testGroupingOnStringSerializablePairLongLong() {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM (SELECT long_first_added FROM druid.wikipedia_first_last GROUP BY 1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("long_first_added", "d0", ColumnType.ofComplex((String)"serializablePairLongLong"))}).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions((List)ImmutableList.of()).setContext(QUERY_CONTEXT_DEFAULT).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2315L}));
    }

    @Test
    public void testGroupingOnStringSerializablePairLongDouble() {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM (SELECT double_first_added FROM druid.wikipedia_first_last GROUP BY 1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("double_first_added", "d0", ColumnType.ofComplex((String)"serializablePairLongDouble"))}).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions((List)ImmutableList.of()).setContext(QUERY_CONTEXT_DEFAULT).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2315L}));
    }

    @Test
    public void testGroupingOnStringSerializablePairLongFloat() {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM (SELECT float_first_added FROM druid.wikipedia_first_last GROUP BY 1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("float_first_added", "d0", ColumnType.ofComplex((String)"serializablePairLongFloat"))}).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions((List)ImmutableList.of()).setContext(QUERY_CONTEXT_DEFAULT).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2315L}));
    }

    @Test
    public void testLatestToLatestByConversion() {
        this.msqIncompatible();
        this.testQuery("SELECT LATEST(dim1,10) FROM (SELECT DISTINCT __time, dim1 from foo)", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d1", ColumnType.STRING)})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new StringLastAggregatorFactory("a0", "d1", "d0", Integer.valueOf(10))}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}));
    }

    @Test
    public void testLatestVectorAggregators() {
        this.msqIncompatible();
        this.testQuery("SELECT LATEST(cnt), LATEST(cnt + 1), LATEST(m1), LATEST(m1+1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "cnt", null), new LongLastAggregatorFactory("a1", "v0", null), new FloatLastAggregatorFactory("a2", "m1", null), new FloatLastAggregatorFactory("a3", "v1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 2L, Float.valueOf(6.0f), Float.valueOf(7.0f)}));
    }

    @Test
    public void testLatestAggregators() {
        this.msqIncompatible();
        this.testQuery("SELECT LATEST(cnt), LATEST(m1), LATEST(dim1, 10), LATEST(dim1, CAST(10 AS INTEGER)), LATEST(cnt + 1), LATEST(m1 + 1), LATEST(dim1 || CAST(cnt AS VARCHAR), 10), LATEST_BY(cnt, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(m1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(dim1, MILLIS_TO_TIMESTAMP(l1), 10), LATEST_BY(cnt + 1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(m1 + 1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), 10), LATEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), CAST(10 AS INTEGER)) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "cnt", null), new FloatLastAggregatorFactory("a1", "m1", null), new StringLastAggregatorFactory("a2", "dim1", null, Integer.valueOf(10)), new LongLastAggregatorFactory("a3", "v0", null), new FloatLastAggregatorFactory("a4", "v1", null), new StringLastAggregatorFactory("a5", "v2", null, Integer.valueOf(10)), new LongLastAggregatorFactory("a6", "cnt", "l1"), new FloatLastAggregatorFactory("a7", "m1", "l1"), new StringLastAggregatorFactory("a8", "dim1", "l1", Integer.valueOf(10)), new LongLastAggregatorFactory("a9", "v0", "l1"), new FloatLastAggregatorFactory("a10", "v1", "l1"), new StringLastAggregatorFactory("a11", "v2", "l1", Integer.valueOf(10))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(6.0f), "abc", "abc", 2L, Float.valueOf(7.0f), "abc1", 1L, Float.valueOf(2.0f), "10.1", 2L, Float.valueOf(3.0f), "10.11", "10.11"}));
    }

    @Test
    public void testEarliestByInvalidTimestamp() {
        this.testQueryThrows("SELECT EARLIEST_BY(m1, l1) FROM druid.numfoo", CalciteQueryTest.invalidSqlContains("Cannot apply 'EARLIEST_BY' to arguments of type 'EARLIEST_BY(<FLOAT>, <BIGINT>)"));
    }

    @Test
    public void testLatestByInvalidTimestamp() {
        this.testQueryThrows("SELECT LATEST_BY(m1, l1) FROM druid.numfoo", CalciteQueryTest.invalidSqlContains("Cannot apply 'LATEST_BY' to arguments of type 'LATEST_BY(<FLOAT>, <BIGINT>)"));
    }

    @Test
    public void testAnyAggregator() {
        this.cannotVectorize();
        this.testQuery("SELECT ANY_VALUE(cnt), ANY_VALUE(m1), ANY_VALUE(m2), ANY_VALUE(dim1, 10), ANY_VALUE(cnt + 1), ANY_VALUE(m1 + 1), ANY_VALUE(dim1 || CAST(cnt AS VARCHAR), 10) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "cnt"), new FloatAnyAggregatorFactory("a1", "m1"), new DoubleAnyAggregatorFactory("a2", "m2"), new StringAnyAggregatorFactory("a3", "dim1", Integer.valueOf(10), Boolean.valueOf(true)), new LongAnyAggregatorFactory("a4", "v0"), new FloatAnyAggregatorFactory("a5", "v1"), new StringAnyAggregatorFactory("a6", "v2", Integer.valueOf(10), Boolean.valueOf(true))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), 1.0, "", 2L, Float.valueOf(2.0f), "1"}));
    }

    @Test
    public void testAnyAggregatorsOnHeapNumericNulls() {
        this.testQuery("SELECT ANY_VALUE(l1), ANY_VALUE(dbl1), ANY_VALUE(f1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1"), new DoubleAnyAggregatorFactory("a1", "dbl1"), new FloatAnyAggregatorFactory("a2", "f1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}));
    }

    @Test
    public void testLatestVectorAggregatorsOnTimeExpression() {
        this.msqIncompatible();
        this.testQuery("SELECT \n  LATEST_BY(m1, MILLIS_TO_TIMESTAMP(BITWISE_SHIFT_RIGHT(TIMESTAMP_TO_MILLIS(__time), 3)))\n FROM druid.foo GROUP BY TIME_FLOOR(__time, 'P1Y', null, 'America/Los_Angeles')", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.years((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v1", "bitwiseShiftRight(\"__time\",3)", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0", "m1", "v1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(4.0f)}, (Object)new Object[]{Float.valueOf(6.0f)}));
    }

    @Test
    public void testAnyAggregatorsOffHeapNumericNulls() {
        this.testQuery("SELECT ANY_VALUE(l1), ANY_VALUE(dbl1), ANY_VALUE(f1) FROM druid.numfoo GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1"), new DoubleAnyAggregatorFactory("a1", "dbl1"), new FloatAnyAggregatorFactory("a2", "f1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{325323L, 1.7, Float.valueOf(0.1f)}, (Object)new Object[]{0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}, (Object)new Object[]{null, null, null}));
    }

    @Test
    public void testPrimitiveLatestInSubquery() {
        this.msqIncompatible();
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, LATEST(m1) AS val1, LATEST(cnt) AS val2, LATEST(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0:a", "m1", null), new LongLastAggregatorFactory("a1:a", "cnt", null), new DoubleLastAggregatorFactory("a2:a", "m2", null)})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{18.0, 4L, 18.0}));
    }

    @Test
    public void testPrimitiveLatestInSubqueryGroupBy() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, LATEST(m1) AS val1 FROM foo GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0", "m1", null)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, Float.valueOf(6.0f)}, (Object)new Object[]{"", Float.valueOf(3.0f)}, (Object)new Object[]{"a", Float.valueOf(4.0f)}, (Object)new Object[]{"abc", Float.valueOf(5.0f)}));
    }

    @Test
    public void testStringLatestGroupBy() {
        this.testQuery("SELECT dim2, LATEST(dim4,10) AS val1 FROM druid.numfoo GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringLastAggregatorFactory("a0", "dim4", null, Integer.valueOf(10))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "b"}, (Object)new Object[]{"", "a"}, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"abc", "b"}));
    }

    @Test
    public void testNumericLatestEarliestGroupBy() {
        this.testQuery("SELECT isNew, LATEST(long_last_added), EARLIEST(long_first_added), LATEST(float_last_added), EARLIEST(float_first_added), LATEST(double_last_added), EARLIEST(double_first_added) FROM wikipedia_first_last GROUP BY isNew", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("isNew", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "long_last_added", null), new LongFirstAggregatorFactory("a1", "long_first_added", null), new FloatLastAggregatorFactory("a2", "float_last_added", null), new FloatFirstAggregatorFactory("a3", "float_first_added", null), new DoubleLastAggregatorFactory("a4", "double_last_added", null), new DoubleFirstAggregatorFactory("a5", "double_first_added", null)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"false", 182L, 36L, Float.valueOf(182.0f), Float.valueOf(36.0f), 182.0, 36.0}, (Object)new Object[]{"true", 113L, 345L, Float.valueOf(113.0f), Float.valueOf(345.0f), 113.0, 345.0}));
    }

    @Test
    public void testNumericLatestEarliestWithOpratorsGroupBy() {
        this.testQuery("SELECT isNew, LATEST(long_last_added)+4, EARLIEST(long_first_added)-4, LATEST(float_last_added)*2, EARLIEST(float_first_added)/2f, LATEST(double_last_added)+2.5, EARLIEST(double_first_added)-2.5 FROM wikipedia_first_last GROUP BY isNew", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("wikipedia_first_last").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("isNew", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "long_last_added", null), new LongFirstAggregatorFactory("a1", "long_first_added", null), new FloatLastAggregatorFactory("a2", "float_last_added", null), new FloatFirstAggregatorFactory("a3", "float_first_added", null), new DoubleLastAggregatorFactory("a4", "double_last_added", null), new DoubleFirstAggregatorFactory("a5", "double_first_added", null)})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + 4)", ColumnType.LONG), CalciteQueryTest.expressionPostAgg("p1", "(\"a1\" - 4)", ColumnType.LONG), CalciteQueryTest.expressionPostAgg("p2", "(\"a2\" * 2)", ColumnType.FLOAT), CalciteQueryTest.expressionPostAgg("p3", "(\"a3\" / 2)", ColumnType.FLOAT), CalciteQueryTest.expressionPostAgg("p4", "(\"a4\" + 2.5)", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p5", "(\"a5\" - 2.5)", ColumnType.DOUBLE)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"false", 186L, 32L, Float.valueOf(364.0f), Float.valueOf(18.0f), 184.5, 33.5}, (Object)new Object[]{"true", 117L, 341L, Float.valueOf(226.0f), Float.valueOf(172.5f), 115.5, 342.5}));
    }

    @Test
    public void testStringLatestGroupByWithAlwaysFalseCondition() {
        this.testQuery("SELECT LATEST(dim4, 10), dim2 FROM numfoo WHERE (dim1 = 'something' AND dim1 IN('something else')) GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("dim2", ColumnType.STRING).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testStringLatestByGroupByWithAlwaysFalseCondition() {
        this.testQuery("SELECT LATEST_BY(dim4, __time, 10), dim2 FROM numfoo WHERE (dim1 = 'something' AND dim1 IN('something else')) GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("dim2", ColumnType.STRING).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testPrimitiveEarliestInSubquery() {
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, EARLIEST(m1) AS val1, EARLIEST(cnt) AS val2, EARLIEST(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("a0:a", "m1", null), new LongFirstAggregatorFactory("a1:a", "cnt", null), new DoubleFirstAggregatorFactory("a2:a", "m2", null)})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, 4L, 11.0}));
    }

    @Test
    public void testStringLatestInSubquery() {
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, LATEST(dim1, 10) AS val FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringLastAggregatorFactory("a0:a", "dim1", null, Integer.valueOf(10))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3.0}));
    }

    @Test
    public void testStringEarliestInSubquery() {
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, EARLIEST(dim1,10) AS val FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0:a", "dim1", null, Integer.valueOf(10))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{12.1}));
    }

    @Test
    public void testPrimitiveAnyInSubquery() {
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, ANY_VALUE(m1) AS val1, ANY_VALUE(cnt) AS val2, ANY_VALUE(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatAnyAggregatorFactory("a0:a", "m1"), new LongAnyAggregatorFactory("a1:a", "cnt"), new DoubleAnyAggregatorFactory("a2:a", "m2")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, 4L, 11.0}));
    }

    @Test
    public void testStringEarliestSingleStringDim() {
        this.testQuery("SELECT dim2, EARLIEST(dim1,10) AS val FROM foo GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim1", null, Integer.valueOf(10))})).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "10.1"}, (Object)new Object[]{"", "2"}, (Object)new Object[]{"a", ""}, (Object)new Object[]{"abc", "def"}));
    }

    @Test
    public void testStringEarliestMultiStringDim() {
        this.testQuery("SELECT dim2, EARLIEST(dim3,10) AS val FROM foo GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim3", null, Integer.valueOf(10))})).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "[b, c]"}, (Object)new Object[]{"", "d"}, (Object)new Object[]{"a", "[a, b]"}, (Object)new Object[]{"abc", null}));
    }

    @Test
    public void testStringAnyInSubquery() {
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, ANY_VALUE(dim1, 10) AS val FROM foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0:a", "dim1", Integer.valueOf(10), Boolean.valueOf(true))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{12.1}));
    }

    @Test
    public void testEarliestAggregatorsNumericNulls() {
        this.testQuery("SELECT EARLIEST(l1), EARLIEST(dbl1), EARLIEST(f1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "l1", null), new DoubleFirstAggregatorFactory("a1", "dbl1", null), new FloatFirstAggregatorFactory("a2", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}));
    }

    @Test
    public void testLatestAggregatorsNumericNull() {
        this.msqIncompatible();
        this.testQuery("SELECT LATEST(l1), LATEST(dbl1), LATEST(f1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "l1", null), new DoubleLastAggregatorFactory("a1", "dbl1", null), new FloatLastAggregatorFactory("a2", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null}));
    }

    @Test
    public void testFirstLatestAggregatorsSkipNulls() {
        AndDimFilter filter = CalciteQueryTest.and(CalciteQueryTest.notNull("dim1"), CalciteQueryTest.notNull("l1"), CalciteQueryTest.notNull("dbl1"), CalciteQueryTest.notNull("f1"));
        this.testQuery("SELECT EARLIEST(dim1, 32), LATEST(l1), LATEST(dbl1), LATEST(f1) FROM druid.numfoo WHERE dim1 IS NOT NULL AND l1 IS NOT NULL AND dbl1 IS NOT NULL AND f1 is NOT NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)filter).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim1", null, Integer.valueOf(32)), new LongLastAggregatorFactory("a1", "l1", null), new DoubleLastAggregatorFactory("a2", "dbl1", null), new FloatLastAggregatorFactory("a3", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 0L, 0.0, Float.valueOf(0.0f)}));
    }

    @Test
    public void testAnyAggregatorsDoesNotSkipNulls() {
        this.testQuery("SELECT ANY_VALUE(dim1, 32), ANY_VALUE(l2), ANY_VALUE(dbl2), ANY_VALUE(f2) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(32), Boolean.valueOf(true)), new LongAnyAggregatorFactory("a1", "l2"), new DoubleAnyAggregatorFactory("a2", "dbl2"), new FloatAnyAggregatorFactory("a3", "f2")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null, null, null}));
    }

    @Test
    public void testAnyAggregatorsSkipNullsWithFilter() {
        AndDimFilter filter = CalciteQueryTest.and(CalciteQueryTest.notNull("dim1"), CalciteQueryTest.notNull("l2"), CalciteQueryTest.notNull("dbl2"), CalciteQueryTest.notNull("f2"));
        this.testQuery("SELECT ANY_VALUE(dim1, 32), ANY_VALUE(l2), ANY_VALUE(dbl2), ANY_VALUE(f2) FROM druid.numfoo WHERE dim1 IS NOT NULL AND l2 IS NOT NULL AND dbl2 IS NOT NULL AND f2 is NOT NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)filter).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(32), Boolean.valueOf(true)), new LongAnyAggregatorFactory("a1", "l2"), new DoubleAnyAggregatorFactory("a2", "dbl2"), new FloatAnyAggregatorFactory("a3", "f2")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 325323L, 1.7, Float.valueOf(0.1f)}));
    }

    @Test
    public void testOrderByEarliestFloat() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)});
        this.testQuery("SELECT dim1, EARLIEST(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("a0", "f1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByEarliestDouble() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7});
        this.testQuery("SELECT dim1, EARLIEST(dbl1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleFirstAggregatorFactory("a0", "dbl1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByEarliestLong() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L});
        this.testQuery("SELECT dim1, EARLIEST(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "l1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestFloat() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)});
        this.testQuery("SELECT dim1, LATEST(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0", "f1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestDouble() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7});
        this.testQuery("SELECT dim1, LATEST(dbl1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleLastAggregatorFactory("a0", "dbl1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestLong() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L});
        this.testQuery("SELECT dim1, LATEST(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "l1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyFloat() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatAnyAggregatorFactory("a0", "f1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyDouble() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(dbl1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleAnyAggregatorFactory("a0", "dbl1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyLong() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testGroupByLong() {
        this.testQuery("SELECT cnt, COUNT(*) FROM druid.foo GROUP BY cnt", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByOrdinal() {
        this.testQuery("SELECT cnt, COUNT(*) FROM druid.foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    @Disabled(value="Disabled since GROUP BY alias can confuse the validator; see DruidConformance::isGroupByAlias")
    public void testGroupByAndOrderByAlias() {
        this.msqIncompatible();
        this.testQuery("SELECT cnt AS theCnt, COUNT(*) FROM druid.foo GROUP BY theCnt ORDER BY theCnt ASC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByExpressionAliasedAsOriginalColumnName() {
        this.testQuery("SELECT\nFLOOR(__time TO MONTH) AS __time,\nCOUNT(*)\nFROM druid.foo\nGROUP BY FLOOR(__time TO MONTH)", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testGroupByAndOrderByOrdinalOfAlias() {
        this.testQuery("SELECT cnt as theCnt, COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 1 ASC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByFloat() {
        this.testQuery("SELECT m1, COUNT(*) FROM druid.foo GROUP BY m1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(3.0f), 1L}, (Object)new Object[]{Float.valueOf(4.0f), 1L}, (Object)new Object[]{Float.valueOf(5.0f), 1L}, (Object)new Object[]{Float.valueOf(6.0f), 1L}));
    }

    @Test
    public void testGroupByDouble() {
        this.testQuery("SELECT m2, COUNT(*) FROM druid.foo GROUP BY m2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m2", "d0", ColumnType.DOUBLE)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, 1L}, (Object)new Object[]{2.0, 1L}, (Object)new Object[]{3.0, 1L}, (Object)new Object[]{4.0, 1L}, (Object)new Object[]{5.0, 1L}, (Object)new Object[]{6.0, 1L}));
    }

    @Test
    public void testFilterOnFloat() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE m1 = 1.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters(CalciteQueryTest.equality("m1", 1.0, ColumnType.DOUBLE)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testDECODE_BASE64_UTF8() {
        this.testQuery("SELECT DECODE_BASE64_UTF8('aGVsbG8=') FROM druid.foo limit 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'hello'", ColumnType.STRING)}).limit(1L).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"hello"}));
    }

    @Test
    public void testFilterOnDouble() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE m2 = 1.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters(CalciteQueryTest.equality("m2", 1.0, ColumnType.DOUBLE)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testHavingOnGrandTotal() {
        this.testQuery("SELECT SUM(m1) AS m1_sum FROM foo HAVING m1_sum = 21", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.equality("a0", 21.0, ColumnType.DOUBLE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testHavingOnDoubleSum() {
        this.testQuery("SELECT dim1, SUM(m1) AS m1_sum FROM druid.foo GROUP BY dim1 HAVING SUM(m1) > 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.range("a0", ColumnType.LONG, 1L, null, true, false))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 4.0}, (Object)new Object[]{"10.1", 2.0}, (Object)new Object[]{"2", 3.0}, (Object)new Object[]{"abc", 6.0}, (Object)new Object[]{"def", 5.0}));
    }

    @Test
    public void testHavingOnApproximateCountDistinct() {
        this.testQuery("SELECT dim2, COUNT(DISTINCT m1) FROM druid.foo GROUP BY dim2 HAVING COUNT(DISTINCT m1) > 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)), false, true)})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.range("a0", ColumnType.LONG, 1L, null, true, false))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"a", 2L}));
    }

    @Test
    public void testHavingOnExactCountDistinct() {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT dim2, COUNT(DISTINCT m1) FROM druid.foo GROUP BY dim2 HAVING COUNT(DISTINCT m1) > 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("d1"))})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.range("a0", ColumnType.LONG, 1L, null, true, false))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"a", 2L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testExactCountDistinctWithFilter() {
        this.msqIncompatible();
        String sqlQuery = "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo";
        this.testBuilder().plannerConfig(PLANNER_CONFIG_NO_HLL.withOverrides((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"false", (Object)"useApproximateCountDistinct", (Object)false))).sql("SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo").authResult(CalciteTests.REGULAR_USER_AUTH_RESULT).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 6L})).run();
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testExactCountDistinctWithFilter2() {
        this.cannotVectorizeUnlessFallback();
        String sqlQuery = "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo";
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true")), "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "istrue((\"cnt\" == 1))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("dim1", "v0"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of())).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.notNull("d0"), CalciteQueryTest.equality("a1", 0L, ColumnType.LONG), CalciteQueryTest.expressionFilter("\"d1\"")})), new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("_a1", "a0"), CalciteQueryTest.equality("a1", 3L, ColumnType.LONG))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 6L}));
    }

    @Test
    public void testHavingOnFloatSum() {
        this.testQuery("SELECT dim1, CAST(SUM(m1) AS FLOAT) AS m1_sum FROM druid.foo GROUP BY dim1 HAVING CAST(SUM(m1) AS FLOAT) > 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.range("a0", ColumnType.LONG, 1L, null, true, false))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", Float.valueOf(4.0f)}, (Object)new Object[]{"10.1", Float.valueOf(2.0f)}, (Object)new Object[]{"2", Float.valueOf(3.0f)}, (Object)new Object[]{"abc", Float.valueOf(6.0f)}, (Object)new Object[]{"def", Float.valueOf(5.0f)}));
    }

    @Test
    public void testColumnComparison() {
        this.testQuery("SELECT dim1, m1, COUNT(*) FROM druid.foo WHERE m1 - 1 = dim1 GROUP BY dim1, m1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.expressionFilter("((\"m1\" - 1) == CAST(\"dim1\", 'DOUBLE'))")).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2", Float.valueOf(3.0f), 1L}));
    }

    @Test
    public void testHavingOnRatio() {
        this.testQuery("SELECT\n  dim1,\n  COUNT(*) FILTER(WHERE dim2 <> 'a')/COUNT(*) as ratio\nFROM druid.foo\nGROUP BY dim1\nHAVING COUNT(*) FILTER(WHERE dim2 <> 'a')/COUNT(*) = 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING))), new CountAggregatorFactory("a1")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" / \"a1\")", ColumnType.LONG)}).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.expressionFilter("((\"a0\" / \"a1\") == 1)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testGroupByWithSelectProjections() {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)", ColumnType.STRING))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null}, (Object)new Object[]{"1", null}, (Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"2", null}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}));
    }

    @Test
    public void testGroupByWithSelectAndOrderByProjections() {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nORDER BY CHARACTER_LENGTH(dim1) DESC, dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)", ColumnType.STRING), (Object)CalciteQueryTest.expressionPostAgg("p1", "strlen(\"d0\")", ColumnType.LONG))).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}, (Object)new Object[]{"1", null}, (Object)new Object[]{"2", null}, (Object)new Object[]{"", null}));
    }

    @Test
    public void testTopNWithSelectProjections() {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nLIMIT 10", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("s0", "substring(\"d0\", 1, -1)", ColumnType.STRING)}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null}, (Object)new Object[]{"1", null}, (Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"2", null}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}));
    }

    @Test
    public void testTopNWithSelectAndOrderByProjections() {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nORDER BY CHARACTER_LENGTH(dim1) DESC\nLIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)", ColumnType.STRING), CalciteQueryTest.expressionPostAgg("p1", "strlen(\"d0\")", ColumnType.LONG)}).metric((TopNMetricSpec)new NumericTopNMetricSpec("p1")).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}, (Object)new Object[]{"1", null}, (Object)new Object[]{"2", null}, (Object)new Object[]{"", null}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNION_ALL_QUERY)
    @Test
    public void testUnionAllQueries() {
        this.msqIncompatible();
        this.skipVectorize();
        this.testQuery("SELECT COUNT(*) FROM foo UNION ALL SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{6L}, (Object)new Object[]{6L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNION_ALL_QUERY)
    @Test
    public void testUnionAllQueriesWithLimit() {
        this.msqIncompatible();
        this.testQuery("SELECT * FROM (SELECT COUNT(*) FROM foo UNION ALL SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo) LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{6L}));
    }

    @Test
    public void testPruneDeadAggregators() {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt)\n  WHEN 'foo' THEN SUM(m1)\n  WHEN 'baz' THEN SUM(m2)\n  END\nFROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testPruneDeadAggregatorsThroughPostProjection() {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt) / 10\n  WHEN 'foo' THEN SUM(m1) / 10\n  WHEN 'baz' THEN SUM(m2) / 10\n  END\nFROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" / 10)", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.1}));
    }

    @Test
    public void testPruneDeadAggregatorsThroughHaving() {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt)\n  WHEN 'foo' THEN SUM(m1)\n  WHEN 'baz' THEN SUM(m2)\n  END AS theCase\nFROM foo\nHAVING theCase = 21", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.equality("a0", 21.0, ColumnType.DOUBLE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testGroupByCaseWhen() {
        this.testQuery("SELECT\n  CASE EXTRACT(DAY FROM __time)\n    WHEN m1 THEN 'match-m1'\n    WHEN cnt THEN 'match-cnt'\n    WHEN 0 THEN 'zero'    END,  COUNT(*)\nFROM druid.foo\nGROUP BY  CASE EXTRACT(DAY FROM __time)\n    WHEN m1 THEN 'match-m1'\n    WHEN cnt THEN 'match-cnt'\n    WHEN 0 THEN 'zero'    END", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched((CAST(timestamp_extract(\"__time\",'DAY','UTC'), 'DOUBLE') == \"m1\"),'match-m1',(timestamp_extract(\"__time\",'DAY','UTC') == \"cnt\"),'match-cnt',(timestamp_extract(\"__time\",'DAY','UTC') == 0),'zero'," + DruidExpression.nullLiteral() + ")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"match-cnt", 1L}, (Object)new Object[]{"match-m1", 3L}));
    }

    @Test
    public void testDecomposeCaseWhenThreeArg() {
        this.testQuery("SELECT\n  dim1, dim2, CASE WHEN dim1 = 'abc' THEN dim1 ELSE dim2 END\nFROM druid.foo\nWHERE\n  CASE WHEN dim1 = 'abc' THEN dim1 ELSE dim2 END = 'abc'", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched((\"dim1\" == 'abc'),\"dim1\",\"dim2\")", ColumnType.STRING)}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "abc", ColumnType.STRING), CalciteQueryTest.not((DimFilter)CalciteQueryTest.istrue(CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING)))})})).columns(new String[]{"dim1", "dim2", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", "abc"}, (Object)new Object[]{"abc", null, "abc"}));
    }

    @Test
    public void testDecomposeCaseWhenTwoArg() {
        this.testQuery("SELECT\n  dim1, dim2, CASE WHEN dim1 = 'def' THEN dim2 END\nFROM druid.foo\nWHERE\n  CASE WHEN dim1 = 'def' THEN dim2 END = 'abc'", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'def'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "'abc'", ColumnType.STRING)}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("dim1", "def", ColumnType.STRING), CalciteQueryTest.equality("dim2", "abc", ColumnType.STRING))).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", "abc"}));
    }

    @Test
    public void testGroupByCaseWhenOfTripleAnd() {
        this.testQuery("SELECT\n  CASE WHEN m1 > 1 AND m1 < 5 AND cnt = 1 THEN 'x' ELSE NULL END,  COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched((((\"m1\" > 1) && (\"m1\" < 5)) && (\"cnt\" == 1)),'x',null)", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{"x", 3L}));
    }

    @Test
    public void testNullEmptyStringEquality() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.isNull("dim2"), CalciteQueryTest.not((DimFilter)CalciteQueryTest.istrue(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)))})})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testNullLongFilter() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.isNull("l1")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testNullDoubleFilter() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dbl1 IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.isNull("dbl1")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testNullFloatFilter() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE f1 IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.isNull("f1")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @NotYetSupported(value={NotYetSupported.Modes.DD_UNION})
    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testUnionAllSameTableThreeTimes() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo UNION ALL SELECT * FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"def", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 3.0, 3L}, (Object)new Object[]{"1", "a", 12.0, 3L}));
    }

    @NotYetSupported(value={NotYetSupported.Modes.DD_UNION})
    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testExactCountDistinctUsingSubqueryOnUnionAllTables() {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (\n  SELECT dim2, SUM(cnt) AS cnt\n  FROM (SELECT * FROM druid.foo UNION ALL SELECT * FROM druid.foo)\n  GROUP BY dim2\n)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{12L, 4L}));
    }

    @Test
    public void testNullDoubleTopN() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{1.7, 1L}, (Object)new Object[]{1.0, 1L}, (Object)new Object[]{0.0, 1L});
        this.testQuery("SELECT dbl1, COUNT(*) FROM druid.numfoo GROUP BY dbl1 ORDER BY dbl1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dbl1", "d0", ColumnType.DOUBLE)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)expected);
    }

    @Test
    public void testNullFloatTopN() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(0.1f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 1L});
        this.testQuery("SELECT f1, COUNT(*) FROM druid.numfoo GROUP BY f1 ORDER BY f1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("f1", "d0", ColumnType.FLOAT)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)expected);
    }

    @Test
    public void testNullLongTopN() {
        this.msqIncompatible();
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{325323L, 1L}, (Object)new Object[]{7L, 1L}, (Object)new Object[]{0L, 1L});
        this.testQuery("SELECT l1, COUNT(*) FROM druid.numfoo GROUP BY l1 ORDER BY l1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("l1", "d0", ColumnType.LONG)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)expected);
    }

    @Test
    public void testLongPredicateIsNull() {
        this.testQuery("SELECT l1 is null FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "isnull(\"l1\")", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{true}, (Object)new Object[]{true}, (Object)new Object[]{true}));
    }

    @Test
    public void testLongPredicateFilterNulls() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > 3", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("l1", ColumnType.LONG, 3L, null, true, false)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testDoublePredicateFilterNulls() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dbl1 > 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("dbl1", ColumnType.LONG, 0L, null, true, false)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testFloatPredicateFilterNulls() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE f1 > 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("f1", ColumnType.LONG, 0L, null, true, false)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testEmptyStringEquality() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') = ''", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("dim2", "", ColumnType.STRING)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testNullStringEquality() {
        this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') = null", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testCoalesceColumns() {
        this.testQuery("SELECT COALESCE(dim2, dim1), COUNT(*) FROM druid.foo GROUP BY COALESCE(dim2, dim1)\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}));
    }

    @Test
    public void testCoalesceColumnsFilter() {
        this.testQuery("SELECT COALESCE(dim2, dim1), COUNT(*) FROM druid.foo WHERE COALESCE(dim2, dim1) IN ('a', 'abc') GROUP BY COALESCE(dim2, dim1)\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.in("dim2", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"abc")), CalciteQueryTest.and(CalciteQueryTest.isNull("dim2"), CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"a", (Object)"abc")))})).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}));
    }

    @Test
    public void testCoalesceColumnsFilterWithEquality() {
        this.testQuery("SELECT COALESCE(dim2, dim1), COUNT(*) FROM druid.foo WHERE COALESCE(dim2, dim1) IN ('a', 'abc') GROUP BY COALESCE(dim2, dim1)", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.in("dim2", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"abc")), CalciteQueryTest.and(new DimFilter[]{NullFilter.forColumn((String)"dim2"), CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"a", (Object)"abc"))})})).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}));
    }

    @Test
    public void testCoalesceMoreColumns() {
        this.cannotVectorize();
        this.testQuery("SELECT COALESCE(dim2, dim1), COALESCE(dim2, dim3, dim1), COUNT(*) FROM druid.foo GROUP BY COALESCE(dim2, dim1), COALESCE(dim2, dim3, dim1)\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",\"dim1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "coalesce(\"dim2\",\"dim3\",\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "", 1L}, (Object)new Object[]{"10.1", "b", 1L}, (Object)new Object[]{"10.1", "c", 1L}, (Object)new Object[]{"a", "a", 3L}, (Object)new Object[]{"abc", "abc", 2L}));
    }

    @Test
    public void testColumnIsNull() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 IS NULL\n", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.isNull("dim2")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testGroupingWithNullInFilter() {
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 IN (NULL)", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupingWithNullPlusNonNullInFilter() {
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 IN (NULL, 'abc')", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testGroupingWithNotNullPlusNonNullInFilter() {
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 NOT IN (NULL, 'abc')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupByNothingWithLiterallyFalseFilter() {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE 1 = 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L, null}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, null}));
    }

    @Test
    public void testGroupByNothingWithImpossibleTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 01:00:00'\nOR FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 02:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval[0])).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupByWithImpossibleTimeFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo\nWHERE FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 01:00:00'\nOR FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 02:00:00'\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupByOneColumnWithLiterallyFalseFilter() {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE 1 = 0 GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupByWithFilterMatchingNothing() {
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE dim1 = 'foobar'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim1", "foobar", ColumnType.STRING)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongMaxAggregatorFactory("a1", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, null}));
    }

    @Test
    public void testGroupByWithGroupByEmpty() {
        this.testQuery("SELECT COUNT(*), SUM(cnt), MIN(cnt) FROM druid.foo GROUP BY ()", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongSumAggregatorFactory("a1", "cnt"), new LongMinAggregatorFactory("a2", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 6L, 1L}));
    }

    @Test
    public void testGroupByWithFilterMatchingNothingWithGroupByLiteral() {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE dim1 = 'foobar' GROUP BY 'dummy'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim1", "foobar", ColumnType.STRING)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongMaxAggregatorFactory("a1", "cnt")})).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testCountNonNullColumn() {
        this.testQuery("SELECT COUNT(cnt) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("cnt"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountNullableColumn() {
        this.testQuery("SELECT COUNT(dim2) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("dim2"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountNullableExpression() {
        this.testQuery("SELECT COUNT(CASE WHEN dim2 = 'abc' THEN 'yes' WHEN dim2 = 'def' THEN 'yes' END) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStar() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarOnCommonTableExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("WITH beep (dim1_firstchar) AS (SELECT SUBSTRING(dim1, 1, 1) FROM foo WHERE dim2 = 'a')\nSELECT COUNT(*) FROM beep WHERE dim1_firstchar <> 'z'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("v0", "z", ColumnType.STRING))})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarOnView() {
        this.cannotVectorizeUnlessFallback();
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("v0", "z", ColumnType.STRING))}));
        this.testQuery("SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("v0", "z", ColumnType.STRING))})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testConfusedView() {
        this.cannotVectorizeUnlessFallback();
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("v0", "z", ColumnType.STRING))}));
        this.testQuery("SELECT COUNT(*) FROM view.dview as druid WHERE druid.numfoo <> 'z'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("v0", "z", ColumnType.STRING))})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithLikeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim1 like 'a%' OR dim2 like '%xb%' escape 'x'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{new LikeDimFilter("dim1", "a%", null, null), new LikeDimFilter("dim2", "%xb%", "x", null)})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithLongColumnFilters() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= 3 OR cnt = 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(CalciteQueryTest.equality("cnt", 1L, ColumnType.LONG), CalciteQueryTest.range("cnt", ColumnType.LONG, 3L, null, false, false))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithLongColumnFiltersForceRange() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= 3 OR cnt = 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{new EqualityFilter("cnt", ColumnType.LONG, (Object)1L, null), new RangeFilter("cnt", ColumnType.LONG, (Object)3L, null, Boolean.valueOf(false), Boolean.valueOf(false), null)})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithLongColumnFiltersOnFloatLiterals() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt > 1.1 and cnt < 100000001.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("cnt", ColumnType.DOUBLE, 1.1, 1.00000001E8, true, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("cnt", 1.0, ColumnType.DOUBLE)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 100000001.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("cnt", 1.00000001E8, ColumnType.DOUBLE)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1.0 or cnt = 100000001.0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.in("cnt", ColumnType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.00000001E8))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithLongColumnFiltersOnTwoPoints() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1 OR cnt = 2", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.in("cnt", ColumnType.LONG, ImmutableList.of((Object)1L, (Object)2L))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testFilterOnStringAsNumber() {
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE dim1 = 10 OR (floor(CAST(dim1 AS float)) = 10.00 and CAST(dim1 AS float) > 9 and CAST(dim1 AS float) <= 10.5)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.DOUBLE)}).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.equality("dim1", 10L, ColumnType.LONG), CalciteQueryTest.and(CalciteQueryTest.equality("v0", 10.0, ColumnType.DOUBLE), CalciteQueryTest.range("dim1", ColumnType.DOUBLE, 9.0, 10.5, true, false))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testFilterOnStringAsNumber2() {
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE CAST(dim1 AS float) > 9 and CAST(dim1 AS float) <= 10.5", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter(CalciteQueryTest.range("dim1", ColumnType.DOUBLE, 9.0, 10.5, true, false)).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testSimpleLongAggregations() {
        this.testQuery("SELECT  MIN(l1), MIN(cnt), MAX(l1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "l1"), new LongMinAggregatorFactory("a1", "cnt"), new LongMaxAggregatorFactory("a2", "l1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 1L, 325323L}));
    }

    @Test
    public void testSimpleDoubleAggregations() {
        this.testQuery("SELECT  MIN(dbl1), MAX(dbl1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleMinAggregatorFactory("a0", "dbl1"), new DoubleMaxAggregatorFactory("a1", "dbl1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0.0, 1.7}));
    }

    @Test
    public void testSimpleFloatAggregations() {
        this.testQuery("SELECT  MIN(m1), MAX(m1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), Float.valueOf(6.0f)}));
    }

    @Test
    public void testSimpleAggregations() {
        this.testQuery("SELECT COUNT(*), COUNT(cnt), COUNT(dim1), AVG(cnt), SUM(cnt), SUM(cnt) + MIN(cnt) + MAX(cnt), COUNT(dim2), COUNT(dbl1), AVG(dbl1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), CalciteQueryTest.notNull("cnt")), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a2"), CalciteQueryTest.notNull("dim1")), new DoubleSumAggregatorFactory("a3:sum", "cnt"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a3:count"), CalciteQueryTest.notNull("cnt")), new LongSumAggregatorFactory("a4", "cnt"), new LongMinAggregatorFactory("a5", "cnt"), new LongMaxAggregatorFactory("a6", "cnt"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a7"), CalciteQueryTest.notNull("dim2")), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a8"), CalciteQueryTest.notNull("dbl1")), new DoubleSumAggregatorFactory("a9:sum", "dbl1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), CalciteQueryTest.notNull("dbl1"))})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a3", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a3:sum"), (Object)new FieldAccessPostAggregator(null, "a3:count"))), new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), CalciteQueryTest.expressionPostAgg("p0", "((\"a4\" + \"a5\") + \"a6\")", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 6L, 6L, 1.0, 6L, 8L, 4L, 3L, 0.9}));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationDefault() {
        this.testQuery("SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("p0"))).aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")", ColumnType.FLOAT)}).threshold(3).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationNoTopNConfig() {
        this.testQuery(PLANNER_CONFIG_NO_TOPN, "SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")", ColumnType.FLOAT)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).limit(3).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationNoTopNContext() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_NO_TOPN, "SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")", ColumnType.FLOAT)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).limit(3).build()).setContext(QUERY_CONTEXT_NO_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.EQUIV_PLAN)
    @Test
    public void testFilteredAggregations() {
        this.cannotVectorizeUnlessFallback();
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a0", "cnt"), CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a1", "cnt"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.istrue(CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING)))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a2", "cnt"), CalciteQueryTest.equality("v0", "a", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a3"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.notNull("dim2"), CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))})), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a4"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a5"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a6", "cnt"), CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a7", "cnt"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))})), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a8", "cnt"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new LongMaxAggregatorFactory("a9", "cnt"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a10", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)}), false, true), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a11", "cnt"), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.equality("dim1", "b", ColumnType.STRING)))}));
        this.testQuery("SELECT SUM(case dim1 when 'abc' then cnt end), SUM(case dim1 when 'abc' then null else cnt end), SUM(case substring(dim1, 1, 1) when 'a' then cnt end), COUNT(dim2) filter(WHERE dim1 <> '1'), COUNT(CASE WHEN dim1 <> '1' THEN 'dummy' END), SUM(CASE WHEN dim1 <> '1' THEN 1 ELSE 0 END), SUM(cnt) filter(WHERE dim2 = 'a'), SUM(case when dim1 <> '1' then cnt end) filter(WHERE dim2 = 'a'), SUM(CASE WHEN dim1 <> '1' THEN cnt ELSE 0 END), MAX(CASE WHEN dim1 <> '1' THEN cnt END), COUNT(DISTINCT CASE WHEN dim1 <> '1' THEN m1 END), SUM(cnt) filter(WHERE dim2 = 'a' AND dim1 = 'b') FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 5L, 1L, 3L, 5L, 5L, 2L, 1L, 5L, 1L, 5L, null}));
    }

    @Test
    public void testCaseFilteredAggregationWithGroupBy() {
        this.testQuery("SELECT\n  cnt,\n  SUM(CASE WHEN dim1 <> '1' THEN 1 ELSE 0 END) + SUM(cnt)\nFROM druid.foo\nGROUP BY cnt", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new LongSumAggregatorFactory("a1", "cnt")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")", ColumnType.LONG)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 11L}));
    }

    @Test
    public void testCaseFilteredAggregationWithGroupRewriteToSum() {
        this.testBuilder().sql("SELECT\n  cnt,\n  SUM(CASE WHEN dim1 <> '1' THEN 2 ELSE 0 END) + SUM(cnt)\nFROM druid.foo\nGROUP BY cnt").expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "2", ColumnType.LONG)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a0", "v0"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new LongSumAggregatorFactory("a1", "cnt")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")", ColumnType.LONG)}).setContext(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 16L})).run();
    }

    @Test
    public void testFilteredAggregationWithNotIn() {
        this.testQuery("SELECT\nCOUNT(*) filter(WHERE dim1 NOT IN ('1')),\nCOUNT(dim2) filter(WHERE dim1 NOT IN ('1'))\nFROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.notNull("dim2"), CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING))}))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L, 3L}));
    }

    @Test
    public void testExpressionAggregations() {
        this.cannotVectorizeUnlessFallback();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        this.testQuery("SELECT\n  SUM(cnt * 3),\n  LN(SUM(cnt) + SUM(m1)),\n  MOD(SUM(cnt), 4),\n  SUM(CHARACTER_LENGTH(CAST(cnt * 10 AS VARCHAR))),\n  MAX(CHARACTER_LENGTH(dim2) + LN(m1)),\n  MIN(CHARACTER_LENGTH(dim2) + LN(m1))\nFROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" * 3)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "strlen(CAST((\"cnt\" * 10), 'STRING'))", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "(strlen(\"dim2\") + log(\"m1\"))", ColumnType.DOUBLE)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, macroTable), new LongSumAggregatorFactory("a1", "cnt"), new DoubleSumAggregatorFactory("a2", "m1"), new LongSumAggregatorFactory("a3", "v1", null, macroTable), new DoubleMaxAggregatorFactory("a4", "v2", null, macroTable), new DoubleMinAggregatorFactory("a5", "v2", null, macroTable)})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "log((\"a1\" + \"a2\"))", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p1", "(\"a1\" % 4)", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{18L, 3.295836866004329, 2, 12L, 3.0 + Math.log(5.0), 1.0}));
    }

    @Test
    public void testExpressionFilteringAndGrouping() {
        this.testQuery("SELECT\n  FLOOR(m1 / 2) * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE FLOOR(m1 / 2) * 2 > -1\nGROUP BY FLOOR(m1 / 2) * 2\nORDER BY 1 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(floor((\"m1\" / 2)) * 2)", ColumnType.FLOAT)}).setDimFilter(CalciteQueryTest.range("v0", ColumnType.LONG, -1L, null, true, false)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), 1L}, (Object)new Object[]{Float.valueOf(4.0f), 2L}, (Object)new Object[]{Float.valueOf(2.0f), 2L}, (Object)new Object[]{Float.valueOf(0.0f), 1L}));
    }

    @Test
    public void testExpressionFilteringAndGroupingUsingCastToLong() {
        this.testQuery("SELECT\n  CAST(m1 AS BIGINT) / 2 * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE CAST(m1 AS BIGINT) / 2 * 2 > -1\nGROUP BY CAST(m1 AS BIGINT) / 2 * 2\nORDER BY 1 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "((CAST(\"m1\", 'LONG') / 2) * 2)", ColumnType.LONG)}).setDimFilter(CalciteQueryTest.range("v0", ColumnType.LONG, -1L, null, true, false)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 1L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{2L, 2L}, (Object)new Object[]{0L, 1L}));
    }

    @Test
    public void testExpressionFilteringAndGroupingOnStringCastToNumber() {
        this.testQuery("SELECT\n  FLOOR(CAST(dim1 AS FLOAT) / 2) * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE FLOOR(CAST(dim1 AS FLOAT) / 2) * 2 > -1\nGROUP BY FLOOR(CAST(dim1 AS FLOAT) / 2) * 2\nORDER BY 1 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(floor((CAST(\"dim1\", 'DOUBLE') / 2)) * 2)", ColumnType.FLOAT)}).setDimFilter(CalciteQueryTest.range("v0", ColumnType.LONG, -1L, null, true, false)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(10.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 1L}));
    }

    @Test
    public void testInFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IN ('ghi', 'abc', 'def') GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi"))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testNotInFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 NOT IN ('ghi', 'abc', 'def') GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi")))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testInIsNotTrueFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IN ('ghi', 'abc', 'def') IS NOT TRUE GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.istrue(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi"))))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testNotInOrIsNullFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 NOT IN ('ghi', 'abc', 'def') OR dim1 IS NULL GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.isNull("dim1"), CalciteQueryTest.not(CalciteQueryTest.in("dim1", ColumnType.STRING, ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi")))})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testNotInAndIsNotNullFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 NOT IN ('ghi', 'abc', 'def') AND dim1 IS NOT NULL GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.notNull("dim1"), CalciteQueryTest.not(CalciteQueryTest.in("dim1", ColumnType.STRING, ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi")))})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testNotInAndLessThanFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 NOT IN ('ghi', 'abc', 'def') AND dim1 < 'zzz' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.range("dim1", ColumnType.STRING, null, "zzz", false, true), CalciteQueryTest.not(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi")))})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testInIsNotTrueAndLessThanFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IN ('def', 'abc', 'ghi') IS NOT TRUE AND dim1 < 'zzz' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.istrue(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi")))), CalciteQueryTest.range("dim1", ColumnType.STRING, null, "zzz", false, true)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}));
    }

    @Test
    public void testInExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 IN ('abc', 'def', 'ghi'), COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "scalar_in_array(\"dim1\",array('abc','def','ghi'))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 4L}, (Object)new Object[]{true, 2L}));
    }

    @Test
    public void testInExpressionBelowThreshold() {
        this.testQuery("SELECT dim1 IN ('abc', 'def', 'ghi'), COUNT(*)\nFROM druid.foo\nGROUP BY 1", (Map<String, Object>)QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (String)"inFunctionExprThreshold", (Object)100), (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "((\"dim1\" == 'abc') || (\"dim1\" == 'def') || (\"dim1\" == 'ghi'))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 4L}, (Object)new Object[]{true, 2L}));
    }

    @Test
    public void testInOrIsNullExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 IN ('abc', 'def', 'ghi') OR dim1 IS NULL, COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(isnull(\"dim1\") || scalar_in_array(\"dim1\",array('abc','def','ghi')))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 4L}, (Object)new Object[]{true, 2L}));
    }

    @Test
    public void testNotInOrIsNullExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT NOT (dim1 IN ('abc', 'def', 'ghi') OR dim1 IS NULL), COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(notnull(\"dim1\") && (! scalar_in_array(\"dim1\",array('abc','def','ghi'))))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 2L}, (Object)new Object[]{true, 4L}));
    }

    @Test
    public void testNotInAndIsNotNullExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 NOT IN ('abc', 'def', 'ghi') AND dim1 IS NOT NULL, COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(notnull(\"dim1\") && (! scalar_in_array(\"dim1\",array('abc','def','ghi'))))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 2L}, (Object)new Object[]{true, 4L}));
    }

    @Test
    public void testInOrGreaterThanExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 IN ('abc', 'def', 'ghi') OR dim1 > 'zzz', COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(scalar_in_array(\"dim1\",array('abc','def','ghi')) || (\"dim1\" > 'zzz'))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 4L}, (Object)new Object[]{true, 2L}));
    }

    @Test
    public void testNotInAndLessThanExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 NOT IN ('abc', 'def', 'ghi') AND dim1 < 'zzz', COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "((\"dim1\" < 'zzz') && (! scalar_in_array(\"dim1\",array('abc','def','ghi'))))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 2L}, (Object)new Object[]{true, 4L}));
    }

    @Test
    public void testNotInOrEqualToOneOfThemExpression() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1 NOT IN ('abc', 'def', 'ghi') OR dim1 = 'def', COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(! scalar_in_array(\"dim1\",array('abc','ghi')))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 1L}, (Object)new Object[]{true, 5L}));
    }

    @Test
    public void testSqlIsNullToInFilter() {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IS NULL OR dim1 = 'abc' OR dim1 = 'def' OR dim1 = 'ghi' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.or(CalciteQueryTest.in("dim1", Arrays.asList("abc", "def", "ghi")), CalciteQueryTest.isNull("dim1"))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testInFilterWith23Elements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("abc");
        elements.add("def");
        elements.add("ghi");
        for (int i = 0; i < 20; ++i) {
            elements.add("dummy" + i);
        }
        String elementsString = Joiner.on((String)",").join(elements.stream().map(s -> "'" + s + "'").iterator());
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo\nWHERE dim1 IN (" + elementsString + ") OR dim1 = 'xyz' OR dim1 IS NULL\nGROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.or(CalciteQueryTest.in("dim1", (Collection<String>)ImmutableSet.builder().addAll(elements).add((Object)"xyz").build()), CalciteQueryTest.isNull("dim1"))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testInFilterWith23Elements_overScalarInArrayThreshold() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("abc");
        elements.add("def");
        elements.add("ghi");
        for (int i = 0; i < 20; ++i) {
            elements.add("dummy" + i);
        }
        String elementsString = Joiner.on((String)",").join(elements.stream().map(s -> "'" + s + "'").iterator());
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo\nWHERE dim1 IN (" + elementsString + ") OR dim1 = 'xyz' OR dim1 IS NULL\nGROUP BY dim1", (Map<String, Object>)QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (String)"inFunctionThreshold", (Object)20), (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.or(CalciteQueryTest.in("dim1", elements), CalciteQueryTest.isNull("dim1"), CalciteQueryTest.equality("dim1", "xyz", ColumnType.STRING))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testInFilterWith23Elements_overBothScalarInArrayAndInSubQueryThresholds() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("abc");
        elements.add("def");
        elements.add("ghi");
        for (int i = 0; i < 20; ++i) {
            elements.add("dummy" + i);
        }
        String elementsString = Joiner.on((String)",").join(elements.stream().map(s -> "'" + s + "'").iterator());
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo\nWHERE dim1 IN (" + elementsString + ") OR dim1 = 'xyz' OR dim1 IS NULL\nGROUP BY dim1", (Map<String, Object>)QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (Map)ImmutableMap.of((Object)"inFunctionThreshold", (Object)20, (Object)"inSubQueryThreshold", (Object)20)), (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteQueryTest.or(CalciteQueryTest.in("dim1", elements), CalciteQueryTest.isNull("dim1"), CalciteQueryTest.equality("dim1", "xyz", ColumnType.STRING))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testCountStarWithDegenerateFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and (dim1 > 'a' OR dim1 < 'b' OR dim1 IS NULL)", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithNotOfDegenerateFilter() {
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and not (dim1 > 'a' OR dim1 < 'b')", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testUnplannableScanOrderByNonTime() {
        this.msqIncompatible();
        this.assertQueryIsUnplannable("SELECT dim1 FROM druid.foo ORDER BY dim1", "SQL query requires ordering a table by non-time column [[dim1]], which is not supported.");
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyOnMetric() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE 2.5 < m1 AND m1 < 3.5", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("m1", ColumnType.DOUBLE, 2.5, 3.5, true, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyOr() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE (dim1 >= 'a' and dim1 < 'b') OR dim1 = 'ab'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("dim1", ColumnType.STRING, "a", "b", false, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testUnplannableExactCountDistinctOnSketch() {
        this.assertQueryIsUnplannable(PLANNER_CONFIG_NO_HLL, "SELECT unique_dim1, COUNT(*) FROM druid.foo GROUP BY 1", "SQL requires a group-by on a column with type [COMPLEX<hyperUnique>] that is unsupported.");
    }

    @Test
    public void testIsNotDistinctFromLiteral() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE (dim1 >= 'a' and dim1 < 'b') OR dim1 IS NOT DISTINCT FROM 'ab'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("dim1", ColumnType.STRING, "a", "b", false, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testArrayAggQueryOnComplexDatatypes() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(unique_dim1) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"unique_dim1"), "__acc", "ARRAY<COMPLEX<hyperUnique>>[]", "ARRAY<COMPLEX<hyperUnique>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"unique_dim1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, this.queryFramework().macroTable())})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"AQAAAEAAAA==\",\"AQAAAQAAAAHNBA==\",\"AQAAAQAAAAOzAg==\",\"AQAAAQAAAAFREA==\",\"AQAAAQAAAACyEA==\",\"AQAAAQAAAAEkAQ==\"]"}));
    }

    @Test
    public void testStringAggQueryOnComplexDatatypes() {
        try {
            this.testQuery("SELECT STRING_AGG(unique_dim1, ',') FROM druid.foo", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Aggregation [STRING_AGG] does not support type [COMPLEX<hyperUnique>]"));
            Assert.assertEquals((Object)"invalidInput", (Object)e.getErrorCode());
        }
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyAnd() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE (dim1 >= 'a' and dim1 < 'b') and dim1 = 'abc'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithFilterOnCastedString() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE CAST(dim1 AS bigint) = 2", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.equality("dim1", 2L, ColumnType.LONG)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithFloorTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE FLOOR(__time TO DAY) >= TIMESTAMP '2000-01-01 00:00:00' AND FLOOR(__time TO DAY) < TIMESTAMP '2001-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithFloorTimeFilterUsingMilliseconds() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE TIMESTAMP_TO_MILLIS(FLOOR(__time TO DAY)) >= 946684800000 AND TIMESTAMP_TO_MILLIS(FLOOR(__time TO DAY)) < 978307200000", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithMisalignedFloorTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE FLOOR(__time TO DAY) >= TIMESTAMP '2000-01-01 00:00:01' AND FLOOR(__time TO DAY) < TIMESTAMP '2001-01-01 00:00:01'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02/2001-01-02"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeInIntervalFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE TIME_IN_INTERVAL(__time, '2000-01-01/P1Y') AND TIME_IN_INTERVAL(CURRENT_TIMESTAMP, '2000/3000') -- Optimized away: always true", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeInCastedIntervalFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE TIME_IN_INTERVAL(__time, CAST('2000-01-01/P1Y' AS VARCHAR)) AND TIME_IN_INTERVAL(CURRENT_TIMESTAMP, '2000/3000') -- Optimized away: always true", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeInIntervalFilterLosAngeles() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE TIME_IN_INTERVAL(__time, '2000-01-01/P1Y')", (Map<String, Object>)QUERY_CONTEXT_LOS_ANGELES, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T08:00:00/2001-01-01T08:00:00"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testGroupByNullType() {
        this.cannotVectorize();
        this.testQuery("SELECT NULL as nullcol, COUNT(*) FROM druid.foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 6L}));
    }

    @NotYetSupported(value={NotYetSupported.Modes.DD_NULL_COLUMN_ORDER})
    @Test
    public void testOrderByNullType() {
        this.testQuery("SELECT dim1, NULL as nullcol FROM (SELECT DISTINCT dim1 FROM druid.foo LIMIT 1) ORDER BY 2", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of(WindowOperatorQueryBuilder.builder().setDataSource((Query<?>)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).threshold(1).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("s0", "null", ColumnType.STRING)}).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()).setSignature(RowSignature.builder().add("d0", ColumnType.STRING).add("s0", ColumnType.STRING).build()).setOperators(OperatorFactoryBuilders.naiveSortOperator("s0", ColumnWithDirection.Direction.ASC)).setLeafOperators(OperatorFactoryBuilders.scanOperatorFactoryBuilder().setOffsetLimit(0L, Long.MAX_VALUE).setProjectedColumns("d0", "s0").build()).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null}));
    }

    @Test
    public void testGroupByOrderByNullType() {
        this.cannotVectorize();
        this.testQuery("SELECT NULL as nullcol, COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 1", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NATURAL)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 6L}));
    }

    @Test
    public void testCountStarWithTimeInIntervalFilterInvalidInterval() {
        this.msqIncompatible();
        this.testQueryThrows("SELECT COUNT(*) FROM druid.foo WHERE TIME_IN_INTERVAL(__time, '2000-01-01/X')", CalciteContextException.class, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"From line 1, column 38 to line 1, column 77: Function 'TIME_IN_INTERVAL' second argument is not a valid ISO8601 interval: Invalid format: \"X\"")));
    }

    @Test
    public void testTimeInIntervalBooleanNullable() {
        this.testQuery("SELECT TIME_IN_INTERVAL(TIME_PARSE('2000-01-10'), '2000-01-01/P1Y')", (Map<String, Object>)QUERY_CONTEXT_LOS_ANGELES, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", ExprEval.of((long)1L).toExpr(), ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{true}));
    }

    @Test
    public void testCountStarWithTimeInIntervalFilterNonLiteral() {
        this.msqIncompatible();
        this.testQueryThrows("SELECT COUNT(*) FROM druid.foo WHERE TIME_IN_INTERVAL(__time, dim1)", DruidException.class, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Argument to function 'TIME_IN_INTERVAL' must be a literal (line [1], column [63])")));
    }

    @Test
    public void testCountStarWithBetweenTimeFilterUsingMilliseconds() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 23:59:59.999'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithBetweenFloorTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE FLOOR(__time TO DAY) BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithBetweenTimeFilterUsingMillisecondsInStringLiterals() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time BETWEEN '2000-01-01 00:00:00' AND '2000-12-31 23:59:59.999'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRemoveUselessCaseWhen() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\n  CASE\n    WHEN __time >= TIME_PARSE('2000-01-01 00:00:00', 'yyyy-MM-dd HH:mm:ss') AND __time < TIMESTAMP '2001-01-01 00:00:00'\n    THEN true\n    ELSE false\n  END\nOR\n  __time >= TIMESTAMP '2010-01-01 00:00:00' AND __time < TIMESTAMP '2011-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2001"), Intervals.of((String)"2010/2011"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeMillisecondFilters() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE __time = TIMESTAMP '2000-01-01 00:00:00.111'\nOR (__time >= TIMESTAMP '2000-01-01 00:00:00.888' AND __time < TIMESTAMP '2000-01-02 00:00:00.222')", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T00:00:00.111/2000-01-01T00:00:00.112"), Intervals.of((String)"2000-01-01T00:00:00.888/2000-01-02T00:00:00.222"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTimeFilterUsingStringLiterals() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE __time >= '2000-01-01 00:00:00' AND __time < '2001-01-01T00:00:00'\nOR __time >= '2001-02-01' AND __time < '2001-02-02'\nOR __time BETWEEN '2001-03-01' AND '2001-03-02'\nOR __time = '2001-04-01'\nOR __time = '2001-05-01 00:00:00'\nOR __time = '2001-06-01T00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"), Intervals.of((String)"2001-02-01/2001-02-02"), Intervals.of((String)"2001-03-01/2001-03-02T00:00:00.001"), Intervals.of((String)"2001-04-01/2001-04-01T00:00:00.001"), Intervals.of((String)"2001-05-01/2001-05-01T00:00:00.001"), Intervals.of((String)"2001-06-01/2001-06-01T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeFilterUsingStringLiteralsInvalid_isUnplannable() {
        String sql = "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= 'z2000-01-01 00:00:00' AND __time < '2001-01-01 00:00:00'\n";
        try {
            this.testBuilder().sql(sql).run();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("Illegal TIMESTAMP constant [CAST('z2000-01-01 00:00:00'):TIMESTAMP(3) NOT NULL]"));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Expected DruidException for query: %s", new Object[]{sql});
            Assert.fail((String)sql);
        }
    }

    @Test
    public void testCountStarWithSinglePointInTime() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time = TIMESTAMP '2000-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2000-01-01T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTwoPointsInTime() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time = TIMESTAMP '2000-01-01 00:00:00' OR __time = TIMESTAMP '2000-01-01 00:00:00' + INTERVAL '1' DAY", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2000-01-01T00:00:00.001"), Intervals.of((String)"2000-01-02/2000-01-02T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithComplexDisjointTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and (  (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')  OR (    (__time >= TIMESTAMP '2002-01-01 00:00:00' AND __time < TIMESTAMP '2003-05-01 00:00:00')    and (__time >= TIMESTAMP '2002-05-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00')    and dim1 = 'abc'  ))", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2001"), Intervals.of((String)"2002-05-01/2003-05-01"))).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.timeRange("2000/2001"), CalciteQueryTest.and(CalciteQueryTest.timeRange("2002-05-01/2003-05-01"), CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING))})})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithNotOfComplexDisjointTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE not (dim2 = 'a' and (    (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')    OR (      (__time >= TIMESTAMP '2002-01-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00')      and (__time >= TIMESTAMP '2002-05-01 00:00:00' AND __time < TIMESTAMP '2003-05-01 00:00:00')      and dim1 = 'abc'    )  ))", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.timeRange("2000/2001")), CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.timeRange("2002-05-01/2003-05-01")), CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "abc", ColumnType.STRING))})})})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountStarWithNotTimeFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim1 <> 'xxx' and not (    (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')    OR (__time >= TIMESTAMP '2003-01-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00'))", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000")), Intervals.of((String)"2001/2003"), new Interval((ReadableInstant)DateTimes.of((String)"2004"), (ReadableInstant)DateTimes.MAX))).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "xxx", ColumnType.STRING))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeAndDimFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 <> 'a' and __time BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 23:59:59.999'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTimeOrDimFilter() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 <> 'a' or __time BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 23:59:59.999'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)), CalciteQueryTest.range("__time", ColumnType.LONG, CalciteQueryTest.timestamp("2000-01-01"), CalciteQueryTest.timestamp("2000-12-31T23:59:59.999"), false, false)})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingExtractEpoch() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= EXTRACT(EPOCH FROM TIMESTAMP '1970-01-01 00:00:00') * 1000 AND cnt < EXTRACT(EPOCH FROM TIMESTAMP '1970-01-02 00:00:00') * 1000", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("cnt", ColumnType.LONG, DateTimes.of((String)"1970-01-01").getMillis(), DateTimes.of((String)"1970-01-02").getMillis(), false, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingExtractEpochFromDate() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= EXTRACT(EPOCH FROM DATE '1970-01-01') * 1000 AND cnt < EXTRACT(EPOCH FROM DATE '1970-01-02') * 1000", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("cnt", ColumnType.LONG, DateTimes.of((String)"1970-01-01").getMillis(), DateTimes.of((String)"1970-01-02").getMillis(), false, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingTimestampToMillis() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= TIMESTAMP_TO_MILLIS(TIMESTAMP '1970-01-01 00:00:00') AND cnt < TIMESTAMP_TO_MILLIS(TIMESTAMP '1970-01-02 00:00:00')", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.range("cnt", ColumnType.LONG, DateTimes.of((String)"1970-01-01").getMillis(), DateTimes.of((String)"1970-01-02").getMillis(), false, true)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testSumOfString() {
        this.testQuery("SELECT SUM(CAST(dim1 AS INTEGER)) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"dim1\", 'LONG')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, CalciteTests.createExprMacroTable())})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{13L}));
    }

    @Test
    public void testSumOfExtractionFn() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT SUM(CAST(SUBSTRING(dim1, 1, 10) AS INTEGER)) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(substring(\"dim1\", 0, 10), 'LONG')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, CalciteTests.createExprMacroTable())})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{13L}));
    }

    @Test
    public void testTimeseriesWithTimeFilterOnLongColumnUsingMillisToTimestamp() {
        this.testQuery("SELECT\n  FLOOR(MILLIS_TO_TIMESTAMP(cnt) TO YEAR),\n  COUNT(*)\nFROM\n  druid.foo\nWHERE\n  MILLIS_TO_TIMESTAMP(cnt) >= TIMESTAMP '1970-01-01 00:00:00'\n  AND MILLIS_TO_TIMESTAMP(cnt) < TIMESTAMP '1970-01-02 00:00:00'\nGROUP BY\n  FLOOR(MILLIS_TO_TIMESTAMP(cnt) TO YEAR)", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"cnt\",'P1Y',null,'UTC')", ColumnType.LONG)}).setDimFilter(CalciteQueryTest.range("cnt", ColumnType.LONG, DateTimes.of((String)"1970-01-01").getMillis(), DateTimes.of((String)"1970-01-02").getMillis(), false, true)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("1970-01-01"), 6L}));
    }

    @Test
    public void testCountDistinct() {
        this.msqIncompatible();
        this.testQuery("SELECT SUM(cnt), COUNT(distinct dim2), COUNT(distinct unique_dim1) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true), new HyperUniquesAggregatorFactory("a2", "unique_dim1", false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L, 6L}));
    }

    @Test
    public void testCountDistinctOfCaseWhen() {
        this.testQuery("SELECT\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN m1 END),\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN dim1 END),\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN unique_dim1 END)\nFROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)), false, true), CalciteQueryTest.range("m1", ColumnType.LONG, 4L, null, false, false)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("dim1", "dim1", ColumnType.STRING)), false, true), CalciteQueryTest.range("m1", ColumnType.LONG, 4L, null, false, false)), new FilteredAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("a2", "unique_dim1", false, true), CalciteQueryTest.range("m1", ColumnType.LONG, 4L, null, false, false))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, 3L, 3L}));
    }

    @Test
    public void testExactCountDistinct() {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT COUNT(distinct dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("d0"))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @NotYetSupported(value={NotYetSupported.Modes.DD_INCORRECT_RESULTS_EMPTY_STRING})
    @Test
    public void testApproxCountDistinctWhenHllDisabled() {
        this.msqIncompatible();
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT APPROX_COUNT_DISTINCT(dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testApproxCountDistinctBuiltin() {
        this.msqIncompatible();
        this.testQuery("SELECT APPROX_COUNT_DISTINCT_BUILTIN(dim2) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.AGG_COL_EXCHANGE)
    @Test
    public void testExactCountDistinctWithGroupingAndOtherAggregators() {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT dim2, SUM(cnt), COUNT(distinct dim1) FROM druid.foo GROUP BY dim2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("dim1", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), CalciteQueryTest.notNull("d1"))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L, 2L}, (Object)new Object[]{"", 1L, 1L}, (Object)new Object[]{"a", 2L, 2L}, (Object)new Object[]{"abc", 1L, 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.AGG_COL_EXCHANGE)
    @Test
    public void testMultipleExactCountDistinctWithGroupingAndOtherAggregatorsUsingJoin() {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT dim2, COUNT(*), COUNT(distinct dim1), COUNT(distinct cnt) FROM druid.foo GROUP BY dim2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)CalciteQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setGranularity(Granularities.ALL).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setGranularity(Granularities.ALL).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim1", "d1", ColumnType.STRING)}).build())).setGranularity(Granularities.ALL).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)new NotDimFilter(CalciteQueryTest.isNull("d1", null)))}).build()), "j0.", "notdistinctfrom(\"d0\",\"j0._d0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setGranularity(Granularities.ALL).setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setGranularity(Granularities.ALL).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING), new DefaultDimensionSpec("cnt", "d1", ColumnType.LONG)}).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)new NotDimFilter(CalciteQueryTest.isNull("d1", null)))}).build()), "_j0.", "notdistinctfrom(\"d0\",\"_j0._d0\")", JoinType.INNER)).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"d0", "a0", "j0.a0", "_j0.a0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L, 2L, 1L}, (Object)new Object[]{"", 1L, 1L, 1L}, (Object)new Object[]{"a", 2L, 2L, 1L}, (Object)new Object[]{"abc", 1L, 1L, 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN_EXTRA_COLUMNS)
    @Test
    public void testTimeFilterOnSubquery() {
        this.testQuery("SELECT __time, m1 FROM (SELECT * FROM \"foo\" LIMIT 100)\nWHERE TIME_IN_INTERVAL(__time, '2000/P1D') OR TIME_IN_INTERVAL(__time, '2001/P1D')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((Query)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context(QUERY_CONTEXT_DEFAULT).build()).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(CalciteQueryTest.range("__time", ColumnType.LONG, DateTimes.of((String)"2000").getMillis(), DateTimes.of((String)"2000-01-02").getMillis(), false, true), CalciteQueryTest.range("__time", ColumnType.LONG, DateTimes.of((String)"2001").getMillis(), DateTimes.of((String)"2001-01-02").getMillis(), false, true))).columns(new String[]{"__time", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), Float.valueOf(1.0f)}, (Object)new Object[]{DateTimes.of((String)"2001-01-01").getMillis(), Float.valueOf(4.0f)}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=4)
    @Test
    public void testMultipleExactCountDistinctWithGroupingUsingGroupingSets() {
        this.msqIncompatible();
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true")), "SELECT FLOOR(__time to day), COUNT(distinct city), COUNT(distinct user) FROM druid.visits GROUP BY 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("visits").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("city", "d1"), new DefaultDimensionSpec("user", "d2")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new GroupingAggregatorFactory("a0", Arrays.asList("v0", "city", "user"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0", (Object)"d2"))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.DAY)).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("d1"), CalciteQueryTest.equality("a0", 1L, ColumnType.LONG))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("d2"), CalciteQueryTest.equality("a0", 2L, ColumnType.LONG)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1609459200000L, 3L, 2L}, (Object)new Object[]{1609545600000L, 3L, 4L}, (Object)new Object[]{1609632000000L, 1L, 1L}));
    }

    @Test
    public void testApproxCountDistinct() {
        this.cannotVectorizeUnlessFallback();
        this.msqIncompatible();
        this.testQuery("SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT(dim2),\n  approx_count_distinct(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT(SUBSTRING(dim2, 1, 1) || 'x'),\n  approx_count_distinct(unique_dim1)\nFROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "concat(substring(\"dim2\", 0, 1),'x')", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"dim2")}), false, true), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a2", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"dim2")}), false, true), (DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "", ColumnType.STRING))), new CardinalityAggregatorFactory("a3", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}), false, true), new CardinalityAggregatorFactory("a4", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v1")}), false, true), new HyperUniquesAggregatorFactory("a5", "unique_dim1", false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L, 2L, 1L, 1L, 6L}));
    }

    @Test
    public void testApproxCountDistinctOnVectorizableSingleStringExpression() {
        this.testQuery("SELECT APPROX_COUNT_DISTINCT(dim1 || 'hello') FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'hello')", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testNestedGroupBy() {
        this.testQuery("SELECT\n    FLOOR(__time to hour) AS __time,\n    dim1,\n    COUNT(m2)\nFROM (\n    SELECT\n        MAX(__time) AS __time,\n        m2,\n        dim1\n    FROM druid.foo\n    WHERE 1=1\n        AND m1 = '5.0'\n    GROUP BY m2, dim1\n)\nGROUP BY FLOOR(__time to hour), dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("m2", "d1", ColumnType.DOUBLE)})).setDimFilter(CalciteQueryTest.equality("m1", 5.0, ColumnType.FLOAT)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"a0\",'PT1H',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG), new DefaultDimensionSpec("d0", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), CalciteQueryTest.notNull("d1"))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{978393600000L, "def", 1L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testDoubleNestedGroupBy() {
        this.testQuery("SELECT SUM(cnt), COUNT(*) FROM (\n  SELECT dim2, SUM(t1.cnt) cnt FROM (\n    SELECT\n      dim1,\n      dim2,\n      COUNT(*) cnt\n    FROM druid.foo\n    GROUP BY dim1, dim2\n  ) t1\n  GROUP BY dim2\n) t2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "_a0"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 4L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testDoubleNestedGroupBy2() {
        this.testQuery("SELECT MAX(cnt) FROM (\n  SELECT dim2, MAX(t1.cnt) cnt FROM (\n    SELECT\n      dim1,\n      dim2,\n      COUNT(*) cnt\n    FROM druid.foo\n    GROUP BY dim1, dim2\n  ) t1\n  GROUP BY dim2\n) t2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "_a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testExactCountDistinctUsingSubquery() {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 4L}));
    }

    @Test
    public void testAvgDailyCountDistinct() {
        this.cannotVectorize();
        this.testQuery("SELECT\n  AVG(u)\nFROM (SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT(cnt) AS u FROM druid.foo GROUP BY 1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0:a", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "cnt", ColumnType.LONG)}), false, true)}).postAggregators((List)ImmutableList.of((Object)new HyperUniqueFinalizingPostAggregator("a0", "a0:a"))).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), CalciteQueryTest.notNull("a0"))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a0:sum"), (Object)new FieldAccessPostAggregator(null, "_a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0}));
    }

    @Test
    public void testHighestMaxNumericInFilter() {
        Throwable exception = Assertions.assertThrows(UOE.class, () -> this.testQuery(PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER, (Map<String, Object>)ImmutableMap.of((Object)"maxNumericInFilters", (Object)20000), "SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dim6 IN (\n1,2,3\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Expected parameter[maxNumericInFilters] cannot exceed system set value of [100]"));
    }

    @Test
    public void testExactCountDistinctUsingSubqueryWithWherePushDown() {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)\nWHERE dim2 <> ''", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "", ColumnType.STRING))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, 2L}));
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)\nWHERE dim2 IS NOT NULL", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteQueryTest.notNull("dim2")).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L, 3L}));
    }

    @Test
    public void testCompareExactAndApproximateCountDistinctUsingSubquery() {
        this.testQuery("SELECT\n  COUNT(*) AS exact_count,\n  COUNT(DISTINCT dim1) AS approx_count,\n  (CAST(1 AS FLOAT) - COUNT(DISTINCT dim1) / COUNT(*)) * 100 AS error_pct\nFROM (SELECT DISTINCT dim1 FROM druid.foo WHERE dim1 <> '')", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "", ColumnType.STRING))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", null)}), false, true)})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "((1.0 - (\"a1\" / \"a0\")) * 100)", ColumnType.FLOAT)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L, 5L, Float.valueOf(0.0f)}));
    }

    @Test
    public void testHistogramUsingSubquery() {
        this.testQuery("SELECT\n  CAST(thecnt AS VARCHAR),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS thecnt FROM druid.foo GROUP BY dim2)\nGROUP BY CAST(thecnt AS VARCHAR)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("a0", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 2L}, (Object)new Object[]{"2", 2L}));
    }

    @Test
    public void testHistogramUsingSubqueryWithSort() {
        this.testQuery("SELECT\n  CAST(thecnt AS VARCHAR),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS thecnt FROM druid.foo GROUP BY dim2)\nGROUP BY CAST(thecnt AS VARCHAR) ORDER BY CAST(thecnt AS VARCHAR) LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("a0", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 2L}, (Object)new Object[]{"2", 2L}));
    }

    @Test
    public void testCountDistinctArithmetic() {
        this.msqIncompatible();
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(DISTINCT dim2),\n  CAST(COUNT(DISTINCT dim2) AS FLOAT),\n  SUM(cnt) / COUNT(DISTINCT dim2),\n  SUM(cnt) / COUNT(DISTINCT dim2) + 3,\n  CAST(SUM(cnt) AS FLOAT) / CAST(COUNT(DISTINCT dim2) AS FLOAT) + 3\nFROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "CAST(\"a1\", 'DOUBLE')", ColumnType.FLOAT), CalciteQueryTest.expressionPostAgg("p1", "(\"a0\" / \"a1\")", ColumnType.LONG), CalciteQueryTest.expressionPostAgg("p2", "((\"a0\" / \"a1\") + 3)", ColumnType.LONG), CalciteQueryTest.expressionPostAgg("p3", "((CAST(\"a0\", 'DOUBLE') / CAST(\"a1\", 'DOUBLE')) + 3)", ColumnType.FLOAT)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L, Float.valueOf(3.0f), 2L, 5L, Float.valueOf(5.0f)}));
    }

    @Test
    public void testCountDistinctOfSubstring() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT COUNT(DISTINCT SUBSTRING(dim1, 1, 1)) FROM druid.foo WHERE dim1 <> ''", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "", ColumnType.STRING))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountDistinctOfSubstringWithExtractionFn() {
        this.cannotVectorize();
        Map queryContext = QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (Map)ImmutableMap.of((Object)"sqlUseExtractionFns", (Object)true));
        this.testQuery("SELECT COUNT(DISTINCT SUBSTRING(dim1, 1, 1)) FROM druid.foo WHERE dim1 <> ''", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "", ColumnType.STRING))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", null, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}), false, true)})).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountDistinctOfTrim() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT COUNT(DISTINCT TRIM(BOTH ' ' FROM dim1)) FROM druid.foo WHERE TRIM(dim1) <> ''", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "trim(\"dim1\",' ')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("v0", "", ColumnType.STRING))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testSillyQuarters() {
        this.testQuery("SELECT CAST((EXTRACT(MONTH FROM __time) - 1 ) / 3 + 1 AS INTEGER) AS quarter, COUNT(*)\nFROM foo\nGROUP BY CAST((EXTRACT(MONTH FROM __time) - 1 ) / 3 + 1 AS INTEGER)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(((timestamp_extract(\"__time\",'MONTH','UTC') - 1) / 3) + 1)", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1, 6L}));
    }

    @Test
    public void testRegexpExtract() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT DISTINCT\n  REGEXP_EXTRACT(dim1, '^.'),\n  REGEXP_EXTRACT(dim1, '^(.)', 1)\nFROM foo\nWHERE REGEXP_EXTRACT(dim1, '^(.)', 1) <> 'x'", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "regexp_extract(\"dim1\",'^(.)',1)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "regexp_extract(\"dim1\",'^.')", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("v0", "x", ColumnType.STRING))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0"), new DefaultDimensionSpec("v0", "d1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", "1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"a", "a"}, (Object)new Object[]{"d", "d"}));
    }

    @Test
    public void testRegexpExtractWithExtractionFn() {
        this.cannotVectorize();
        Map queryContext = QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (Map)ImmutableMap.of((Object)"sqlUseExtractionFns", (Object)true));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new RegexDimExtractionFn("^.", Integer.valueOf(0), Boolean.valueOf(true), null)), new ExtractionDimensionSpec("dim1", "d1", (ExtractionFn)new RegexDimExtractionFn("^(.)", Integer.valueOf(1), Boolean.valueOf(true), null))})).setContext(QUERY_CONTEXT_DEFAULT).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "regexp_extract(\"dim1\",'^(.)',1)", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("v0", "x", ColumnType.STRING)));
        this.testQuery("SELECT DISTINCT\n  REGEXP_EXTRACT(dim1, '^.'),\n  REGEXP_EXTRACT(dim1, '^(.)', 1)\nFROM foo\nWHERE REGEXP_EXTRACT(dim1, '^(.)', 1) <> 'x'", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", "1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"a", "a"}, (Object)new Object[]{"d", "d"}));
    }

    @Test
    public void testRegexpExtractWithBadRegexPattern() {
        this.cannotVectorize();
        this.testQueryThrows("SELECT DISTINCT\n  REGEXP_EXTRACT(dim1, '^(.))', 1)\nFROM foo", DruidExceptionMatcher.invalidInput().expectMessageContains("An invalid pattern [^(.))] was provided for the regexp_extract function, error: [Unmatched closing ')' near index 3\n^(.))\n   ^]"));
    }

    @Test
    public void testRegexpExtractWithBadRegexPatternWithExtractionFn() {
        this.cannotVectorize();
        this.testQueryThrows("SELECT DISTINCT\n  REGEXP_EXTRACT(dim1, '^(.))', 1)\nFROM foo", QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (Map)ImmutableMap.of((Object)"sqlUseExtractionFns", (Object)true)), DruidException.class, (Matcher<Throwable>)CalciteQueryTest.invalidSqlContains("An invalid pattern [^(.))] was provided for the REGEXP_EXTRACT function, error: [Unmatched closing ')' near index 3\n^(.))\n   ^]"));
    }

    @Test
    public void testRegexpExtractFilterViaNotNullCheck() {
        this.cannotVectorizeUnlessFallback();
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "regexp_extract(\"dim1\",'^1')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "regexp_extract(concat('Z',\"dim1\"),'^Z2')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(CalciteQueryTest.notNull("v0"), CalciteQueryTest.notNull("v1")));
        this.testQuery("SELECT COUNT(*)\nFROM foo\nWHERE REGEXP_EXTRACT(dim1, '^1') IS NOT NULL OR REGEXP_EXTRACT('Z' || dim1, '^Z2') IS NOT NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "regexp_extract(\"dim1\",'^1')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "regexp_extract(concat('Z',\"dim1\"),'^Z2')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(CalciteQueryTest.notNull("v0"), CalciteQueryTest.notNull("v1"))).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRegexpLikeFilter() {
        this.testQuery("SELECT COUNT(*)\nFROM foo\nWHERE REGEXP_LIKE(dim1, '^1') OR REGEXP_LIKE('Z' || dim1, '^Z2')", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat('Z',\"dim1\")", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{new RegexDimFilter("dim1", "^1", null), new RegexDimFilter("v0", "^Z2", null)})).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.AGG_COL_EXCHANGE)
    @Test
    public void testGroupBySortPushDown() {
        this.testQuery("SELECT dim2, dim1, SUM(cnt) FROM druid.foo GROUP BY dim2, dim1 ORDER BY dim1 LIMIT 4", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("dim1", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(4))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "", 1L}, (Object)new Object[]{"a", "1", 1L}, (Object)new Object[]{null, "10.1", 1L}, (Object)new Object[]{"", "2", 1L}));
    }

    @Test
    public void testGroupByLimitPushDownWithHavingOnLong() {
        this.testQuery("SELECT dim1, dim2, SUM(cnt) AS thecnt FROM druid.foo group by dim1, dim2 having SUM(cnt) = 1 order by dim2 limit 4", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(4))).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.equality("a0", 1L, ColumnType.LONG))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", null, 1L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"2", "", 1L}, (Object)new Object[]{"", "a", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testGroupByLimitPushdownExtraction() {
        this.skipVectorize();
        this.testQuery("SELECT dim4, substring(dim5, 1, 1), count(*) FROM druid.numfoo WHERE dim4 = 'a' GROUP BY 1,2 LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "substring(\"dim5\", 0, 1)", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1")})).setDimFilter(CalciteQueryTest.equality("dim4", "a", ColumnType.STRING)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a", 2L}, (Object)new Object[]{"a", "b", 1L}));
    }

    @Test
    public void testFilterOnTimeFloor() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) = TIMESTAMP '2000-01-01 00:00:00'\nOR FLOOR(__time TO MONTH) = TIMESTAMP '2000-02-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/P2M"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testGroupAndFilterOnTimeFloorWithTimeZone() {
        this.testQuery("SELECT TIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles'), COUNT(*)\nFROM druid.foo\nWHERE\nTIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles') =   TIME_PARSE('2000-01-01 00:00:00', NULL, 'America/Los_Angeles')\nOR TIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles') =   TIME_PARSE('2000-02-01 00:00:00', NULL, 'America/Los_Angeles')\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T00-08:00/2000-03-01T00-08:00"))).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)new DateTime((Object)"2000-01-01", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (DateTimeZone)DateTimeZone.UTC), 2L}));
    }

    @Test
    public void testFilterOnCurrentTimestampWithIntervalArithmetic() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\n  __time >= CURRENT_TIMESTAMP + INTERVAL '01:02' HOUR TO MINUTE\n  AND __time < TIMESTAMP '2003-02-02 01:00:00' - INTERVAL '1 1' DAY TO HOUR - INTERVAL '1-1' YEAR TO MONTH", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T01:02/2002"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampLosAngeles() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= CURRENT_TIMESTAMP + INTERVAL '1' DAY AND __time < TIMESTAMP '2002-01-01 00:00:00'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00Z/2002-01-01T08Z"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampOnView() {
        this.testQuery("SELECT * FROM view.bview", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02/2002"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampLosAngelesOnView() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT * FROM view.bview", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00Z/2002-01-01T08Z"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnNotTimeFloor() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) <> TIMESTAMP '2001-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2001-01-01")), new Interval((ReadableInstant)DateTimes.of((String)"2001-02-01"), (ReadableInstant)DateTimes.MAX))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeFloorComparison() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) < TIMESTAMP '2000-02-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000-02-01")))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeFloorComparisonMisaligned() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) < TIMESTAMP '2000-02-01 00:00:01'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000-03-01")))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeExtract() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(MONTH FROM __time) = 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("v0", 2000L, ColumnType.LONG), CalciteQueryTest.equality("v1", 1L, ColumnType.LONG))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeExtractWithMultipleDays() {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(DAY FROM __time) IN (2, 3, 5)", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'DAY','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("v0", 2000L, ColumnType.LONG), CalciteQueryTest.in("v1", ColumnType.LONG, ImmutableList.of((Object)2L, (Object)3L, (Object)5L)))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testFilterOnTimeExtractWithVariousTimeUnits() {
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*) FROM druid.foo4\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(MILLISECOND FROM __time) = 695\nAND EXTRACT(ISODOW FROM __time) = 6\nAND EXTRACT(ISOYEAR FROM __time) = 2000\nAND EXTRACT(DECADE FROM __time) = 200\nAND EXTRACT(CENTURY FROM __time) = 20\nAND EXTRACT(MILLENNIUM FROM __time) = 2\n", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo4").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'MILLISECOND','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "timestamp_extract(\"__time\",'ISODOW','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v3", "timestamp_extract(\"__time\",'ISOYEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v4", "timestamp_extract(\"__time\",'DECADE','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v5", "timestamp_extract(\"__time\",'CENTURY','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v6", "timestamp_extract(\"__time\",'MILLENNIUM','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("v0", 2000L, ColumnType.LONG), CalciteQueryTest.equality("v1", 695L, ColumnType.LONG), CalciteQueryTest.equality("v2", 6L, ColumnType.LONG), CalciteQueryTest.equality("v3", 2000L, ColumnType.LONG), CalciteQueryTest.equality("v4", 200L, ColumnType.LONG), CalciteQueryTest.equality("v5", 20L, ColumnType.LONG), CalciteQueryTest.equality("v6", 2L, ColumnType.LONG))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testFilterOnTimeFloorMisaligned() {
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE floor(__time TO month) = TIMESTAMP '2000-01-01 00:00:01'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval[0])).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupByFloor() {
        this.testQuery("SELECT floor(CAST(dim1 AS float)), COUNT(*) FROM druid.foo GROUP BY floor(CAST(dim1 AS float))", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.FLOAT)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(10.0f), 1L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testQueryWithSelectProjectAndIdentityProjectDoesNotRename() {
        this.msqIncompatible();
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true")), "SELECT\n(SUM(CASE WHEN (TIMESTAMP '2000-01-04 17:00:00'<=__time AND __time<TIMESTAMP '2022-01-05 17:00:00') THEN 1 ELSE 0 END)*1.0/COUNT(DISTINCT CASE WHEN (TIMESTAMP '2000-01-04 17:00:00'<=__time AND __time<TIMESTAMP '2022-01-05 17:00:00') THEN dim1 END))\nFROM druid.foo\nGROUP BY ()", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "((\"__time\" >= 947005200000) && (\"__time\" < 1641402000000))", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.range("__time", ColumnType.LONG, CalciteQueryTest.timestamp("2000-01-04T17:00:00"), CalciteQueryTest.timestamp("2022-01-05T17:00:00"), false, true)), new GroupingAggregatorFactory("a1", (List)ImmutableList.of((Object)"v0", (Object)"dim1"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of())).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("_a0", "a0"), CalciteQueryTest.equality("a1", 3L, ColumnType.LONG)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.notNull("d1"), CalciteQueryTest.equality("a1", 0L, ColumnType.LONG), CalciteQueryTest.expressionFilter("\"d0\"")}))})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(CAST(\"_a0\", 'DOUBLE') / \"_a1\")", ColumnType.DOUBLE)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0}));
    }

    @Test
    public void testGroupByFloorWithOrderBy() {
        this.testQuery("SELECT floor(CAST(dim1 AS float)) AS fl, COUNT(*) FROM druid.foo GROUP BY floor(CAST(dim1 AS float)) ORDER BY fl DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.FLOAT)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(10.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{null, 3L}));
    }

    @Test
    public void testGroupByOrderByBoolean() {
        this.testQuery("SELECT dim1 = 'abc', COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 1, 2 LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"dim1\" == 'abc')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false, 5L}, (Object)new Object[]{true, 1L}));
    }

    @Test
    public void testGroupByFloorTimeAndOneOtherDimensionWithOrderBy() {
        this.testQuery("SELECT floor(__time TO year), dim2, COUNT(*) FROM druid.foo GROUP BY floor(__time TO year), dim2 ORDER BY floor(__time TO year), dim2, COUNT(*) DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1Y',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), (Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.YEAR)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000"), null, 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000"), "", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), null, 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "abc", 1L}));
    }

    @Test
    public void testGroupByStringLength() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT CHARACTER_LENGTH(dim1), COUNT(*) FROM druid.foo GROUP BY CHARACTER_LENGTH(dim1)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "strlen(\"dim1\")", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0, 1L}, (Object)new Object[]{1, 2L}, (Object)new Object[]{3, 2L}, (Object)new Object[]{4, 1L}));
    }

    @Test
    public void testGroupByExpressionFromLookup() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT SUBSTRING(v, 1, 1), COUNT(*) FROM lookup.lookyloo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"v\", 0, 1)", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"m", 1L}, (Object)new Object[]{"x", 3L}));
    }

    @Test
    public void testTimeseries() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesDontUseGranularity() {
        Map context = QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (String)"sqlUseGranularity", (Object)false);
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testFilteredTimeAggregators() {
        this.testQuery("SELECT\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2000-01-01 00:00:00'\n                    AND __time <  TIMESTAMP '2000-02-01 00:00:00'),\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2000-01-01 00:00:01'\n                    AND __time <  TIMESTAMP '2000-02-01 00:00:00'),\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2001-01-01 00:00:00'\n                    AND __time <  TIMESTAMP '2001-02-01 00:00:00')\nFROM foo\nWHERE\n  __time >= TIMESTAMP '2000-01-01 00:00:00'\n  AND __time < TIMESTAMP '2001-02-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-02-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a0", "cnt"), CalciteQueryTest.range("__time", ColumnType.LONG, CalciteQueryTest.timestamp("2000-01-01T00:00:00"), CalciteQueryTest.timestamp("2000-02-01"), false, true)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a1", "cnt"), CalciteQueryTest.range("__time", ColumnType.LONG, CalciteQueryTest.timestamp("2000-01-01T00:00:01"), CalciteQueryTest.timestamp("2000-02-01"), false, true)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a2", "cnt"), CalciteQueryTest.range("__time", ColumnType.LONG, CalciteQueryTest.timestamp("2001-01-01"), CalciteQueryTest.timestamp("2001-02-01"), false, true))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, 2L, 3L}));
    }

    @Test
    public void testTimeseriesLosAngelesViaQueryContext() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT SUM(cnt), gran FROM (\n  SELECT FLOOR(__time TO MONTH) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_LOS_ANGELES, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesLosAngelesViaPlannerConfig() {
        this.testQuery(PLANNER_CONFIG_LOS_ANGELES, QUERY_CONTEXT_DEFAULT, "SELECT SUM(cnt), gran FROM (\n  SELECT\n    FLOOR(__time TO MONTH) AS gran,\n    cnt\n  FROM druid.foo\n  WHERE __time >= TIME_PARSE('1999-12-01 00:00:00') AND __time < TIME_PARSE('2002-01-01 00:00:00')\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"1999-12-01T00-08:00/2002-01-01T00-08:00"))).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloor() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithTimeShift() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(TIME_SHIFT(__time, 'P1D', -1), 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(timestamp_shift(\"__time\",'P1D',-1,'UTC'),'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithTimestampAdd() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(TIMESTAMPADD(DAY, -1, __time), 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor((\"__time\" + -86400000),'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithOrigin() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M', TIMESTAMP '1970-01-01 01:02:03') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), DateTimes.of((String)"1970-01-01T01:02:03"), DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01T01:02:03")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01T01:02:03")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01T01:02:03")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01T01:02:03")}));
    }

    @Test
    public void testTimeseriesLosAngelesUsingTimeFloorConnectionUtc() {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M', CAST(NULL AS TIMESTAMP), 'America/Los_Angeles') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01T08")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01T08")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01T08")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01T08")}));
    }

    @Test
    public void testTimeseriesLosAngelesUsingTimeFloorConnectionLosAngeles() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_LOS_ANGELES, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesDontSkipEmptyBuckets() {
        this.msqIncompatible();
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS, "SELECT SUM(cnt), gran FROM (\n  SELECT floor(__time TO HOUR) AS gran, cnt FROM druid.foo\n  WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2000-01-02"))).granularity((Granularity)new PeriodGranularity(Period.hours((int)1), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS, "d0")).build()), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-01-01")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T01")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T02")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T03")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T04")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T05")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T06")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T07")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T08")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T09")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T10")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T11")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T12")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T13")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T14")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T15")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T16")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T17")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T18")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T19")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T20")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T21")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T22")}).add((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01T23")}).build());
    }

    @Test
    public void testTimeseriesUsingCastAsDate() {
        this.testQuery("SELECT SUM(cnt), dt FROM (\n  SELECT CAST(__time AS DATE) AS dt,\n  cnt FROM druid.foo\n) AS x\nGROUP BY dt\nORDER BY dt", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.day("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.day("2000-01-02")}, (Object)new Object[]{1L, CalciteQueryTest.day("2000-01-03")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-02")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-03")}));
    }

    @Test
    public void testTimeseriesUsingFloorPlusCastAsDate() {
        this.testQuery("SELECT SUM(cnt), dt FROM (\n  SELECT CAST(FLOOR(__time TO QUARTER) AS DATE) AS dt,\n  cnt FROM druid.foo\n) AS x\nGROUP BY dt\nORDER BY dt", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)3), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.day("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.day("2001-01-01")}));
    }

    @Test
    public void testTimeseriesDescending() {
        this.cannotVectorize();
        this.testQuery("SELECT gran, SUM(cnt) FROM (\n  SELECT floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran DESC", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).descending(true).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesEmptyResultsAggregatorDefaultValues() {
        this.testQuery("SELECT\n count(*),\n COUNT(DISTINCT dim1),\n APPROX_COUNT_DISTINCT(distinct dim1),\n sum(dbl1),\n max(dbl1),\n min(dbl1),\n sum(l1),\n max(l1),\n min(l1),\n avg(l1),\n avg(dbl1)\nFROM druid.numfoo WHERE dim2 = 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim2", 0L, ColumnType.LONG)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new CardinalityAggregatorFactory("a2", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new DoubleSumAggregatorFactory("a3", "dbl1"), new DoubleMaxAggregatorFactory("a4", "dbl1"), new DoubleMinAggregatorFactory("a5", "dbl1"), new LongSumAggregatorFactory("a6", "l1"), new LongMaxAggregatorFactory("a7", "l1"), new LongMinAggregatorFactory("a8", "l1"), new DoubleSumAggregatorFactory("a9:sum", "l1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), CalciteQueryTest.notNull("l1")), new DoubleSumAggregatorFactory("a10:sum", "dbl1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), CalciteQueryTest.notNull("dbl1"))})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), new ArithmeticPostAggregator("a10", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a10:sum"), (Object)new FieldAccessPostAggregator(null, "a10:count")))}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 0L, 0L, null, null, null, null, null, null, null, null}));
    }

    @Test
    public void testEmptyResultsAggregatorWithHavingTrue() {
        this.testQuery("SELECT\n COUNT(*)\nFROM druid.numfoo\nWHERE __time >= TIMESTAMP '4000-01-01 00:00:00' AND __time < TIMESTAMP '4001-01-01 00:00:00'\nHAVING COUNT(*) = 0", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"4000/P1Y"))).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.equality("a0", 0L, ColumnType.LONG))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testEmptyResultsAggregatorWithHavingFalse() {
        this.testQuery("SELECT\n COUNT(*)\nFROM druid.numfoo\nWHERE __time >= TIMESTAMP '4000-01-01 00:00:00' AND __time < TIMESTAMP '4001-01-01 00:00:00'\nHAVING COUNT(*) = 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"4000/P1Y"))).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.equality("a0", 1L, ColumnType.LONG))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTimeseriesEmptyResultsAggregatorDefaultValuesTimeFilterMatchesNothing() {
        this.testQuery("SELECT\n count(*),\n COUNT(DISTINCT dim1),\n APPROX_COUNT_DISTINCT(distinct dim1),\n sum(dbl1),\n max(dbl1),\n min(dbl1),\n sum(l1),\n max(l1),\n min(l1),\n avg(l1),\n avg(dbl1)\nFROM druid.numfoo\nWHERE __time >= TIMESTAMP '4000-01-01 00:00:00' AND __time < TIMESTAMP '4001-01-01 00:00:00'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"4000/P1Y"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new CardinalityAggregatorFactory("a2", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new DoubleSumAggregatorFactory("a3", "dbl1"), new DoubleMaxAggregatorFactory("a4", "dbl1"), new DoubleMinAggregatorFactory("a5", "dbl1"), new LongSumAggregatorFactory("a6", "l1"), new LongMaxAggregatorFactory("a7", "l1"), new LongMinAggregatorFactory("a8", "l1"), new DoubleSumAggregatorFactory("a9:sum", "l1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), CalciteQueryTest.notNull("l1")), new DoubleSumAggregatorFactory("a10:sum", "dbl1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), CalciteQueryTest.notNull("dbl1"))})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), new ArithmeticPostAggregator("a10", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a10:sum"), (Object)new FieldAccessPostAggregator(null, "a10:count")))}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 0L, 0L, null, null, null, null, null, null, null, null}));
    }

    @Test
    public void testTimeseriesEmptyResultsAggregatorDefaultValuesNonVectorized() {
        this.cannotVectorize();
        this.testQuery("SELECT\n ANY_VALUE(dim1, 1024),\n ANY_VALUE(l1),\n EARLIEST(dim1, 1024),\n EARLIEST(l1),\n LATEST(dim1, 1024),\n LATEST(l1),\n ARRAY_AGG(DISTINCT dim3),\n STRING_AGG(DISTINCT dim3, '|'),\n LISTAGG(DISTINCT dim3, '|'),\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo WHERE dim2 = 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim2", 0L, ColumnType.LONG)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(1024), Boolean.valueOf(true)), new LongAnyAggregatorFactory("a1", "l1"), new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(1024)), new LongFirstAggregatorFactory("a3", "l1", null), new StringLastAggregatorFactory("a4", "dim1", null, Integer.valueOf(1024)), new LongLastAggregatorFactory("a5", "l1", null), new ExpressionLambdaAggregatorFactory("a6", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a6\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a7", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a7\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim3")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a8", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a8\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim3")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a9", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a9\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a10", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a10\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a11", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a11\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, null, null, null, null, null, null, null, null, null}));
    }

    @Test
    public void testGroupByAggregatorDefaultValues() {
        this.testQuery("SELECT\n dim2,\n count(*) FILTER(WHERE dim1 = 'nonexistent'),\n COUNT(DISTINCT dim1) FILTER(WHERE dim1 = 'nonexistent'),\n APPROX_COUNT_DISTINCT(distinct dim1) FILTER(WHERE dim1 = 'nonexistent'),\n sum(dbl1) FILTER(WHERE dim1 = 'nonexistent'),\n max(dbl1) FILTER(WHERE dim1 = 'nonexistent'),\n min(dbl1) FILTER(WHERE dim1 = 'nonexistent'),\n sum(l1) FILTER(WHERE dim1 = 'nonexistent'),\n max(l1) FILTER(WHERE dim1 = 'nonexistent'),\n min(l1) FILTER(WHERE dim1 = 'nonexistent'),\n avg(l1) FILTER(WHERE dim1 = 'nonexistent'),\n avg(dbl1) FILTER(WHERE dim1 = 'nonexistent')\nFROM druid.numfoo WHERE dim2 = 'a' GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a2", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a3", "dbl1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleMaxAggregatorFactory("a4", "dbl1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleMinAggregatorFactory("a5", "dbl1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a6", "l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongMaxAggregatorFactory("a7", "l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("a8", "l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a9:sum", "l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a10:sum", "dbl1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("dbl1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), (Object)new ArithmeticPostAggregator("a10", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a10:sum"), (Object)new FieldAccessPostAggregator(null, "a10:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 0L, 0L, 0L, null, null, null, null, null, null, null, null}));
    }

    @Test
    public void testGroupByAggregatorDefaultValuesNonVectorized() {
        this.cannotVectorize();
        this.testQuery("SELECT\n dim2,\n ANY_VALUE(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n ANY_VALUE(l1) FILTER(WHERE dim1 = 'nonexistent'),\n EARLIEST(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n EARLIEST(l1) FILTER(WHERE dim1 = 'nonexistent'),\n LATEST(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n LATEST(l1) FILTER(WHERE dim1 = 'nonexistent'),\n ARRAY_AGG(DISTINCT dim3) FILTER(WHERE dim1 = 'nonexistent'),\n STRING_AGG(DISTINCT dim3, '|') FILTER(WHERE dim1 = 'nonexistent'),\n LISTAGG(DISTINCT dim3, '|') FILTER(WHERE dim1 = 'nonexistent'),\n BIT_AND(l1) FILTER(WHERE dim1 = 'nonexistent'),\n BIT_OR(l1) FILTER(WHERE dim1 = 'nonexistent'),\n BIT_XOR(l1) FILTER(WHERE dim1 = 'nonexistent')\nFROM druid.numfoo WHERE dim2 = 'a' GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(1024), Boolean.valueOf(true)), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongAnyAggregatorFactory("a1", "l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(1024)), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongFirstAggregatorFactory("a3", "l1", null), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new StringLastAggregatorFactory("a4", "dim1", null, Integer.valueOf(1024)), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new LongLastAggregatorFactory("a5", "l1", null), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a6", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a6\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a7", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a7\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("dim3"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a8", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a8\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("dim3"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a9", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a9\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a10", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a10\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a11", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a11\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("l1"), CalciteQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", null, null, null, null, null, null, null, null, null, null, null, null}));
    }

    @Test
    public void testGroupByExtractYear() {
        this.testQuery("SELECT\n  EXTRACT(YEAR FROM __time) AS \"year\",\n  SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM __time)\nORDER BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 3L}));
    }

    @Test
    public void testGroupByFormatYearAndMonth() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT\n  TIME_FORMAt(__time, 'yyyy MM') AS \"year\",\n  SUM(cnt)\nFROM druid.foo\nGROUP BY TIME_FORMAt(__time, 'yyyy MM')\nORDER BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_format(\"__time\",'yyyy MM','UTC')", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2000 01", 3L}, (Object)new Object[]{"2001 01", 3L}));
    }

    @Test
    public void testGroupByExtractFloorTime() {
        this.testQuery("SELECT\nEXTRACT(YEAR FROM FLOOR(__time TO YEAR)) AS \"year\", SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM FLOOR(__time TO YEAR))", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(timestamp_floor(\"__time\",'P1Y',null,'UTC'),'YEAR','UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 3L}));
    }

    @Test
    public void testGroupByExtractFloorTimeLosAngeles() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT\nEXTRACT(YEAR FROM FLOOR(__time TO YEAR)) AS \"year\", SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM FLOOR(__time TO YEAR))", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(timestamp_floor(\"__time\",'P1Y',null,'America/Los_Angeles'),'YEAR','America/Los_Angeles')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1999L, 1L}, (Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 2L}));
    }

    @Test
    public void testTimeseriesWithLimitNoTopN() {
        this.testQuery(PLANNER_CONFIG_NO_TOPN, "SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran\nLIMIT 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithLimit() {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nLIMIT 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithLimitAndOffset() {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nLIMIT 2\nOFFSET 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().offset(1).limit(2).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithOrderByAndLimit() {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran\nLIMIT 1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testGroupByTimeAndOtherDimension() {
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, dim2, cnt FROM druid.foo) AS x\nGROUP BY dim2, gran\nORDER BY dim2, gran", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByTimeAndOtherDimensionDontUseGranularity() {
        Map context = QueryContexts.override((Map)QUERY_CONTEXT_DEFAULT, (String)"sqlUseGranularity", (Object)false);
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, dim2, cnt FROM druid.foo) AS x\nGROUP BY dim2, gran\nORDER BY dim2, gran", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testGroupByTimeFloorAndDimOnGroupByTimeFloorAndDim() {
        this.testQuery("SELECT dim2, time_floor(gran, 'P1M') gran, sum(s)\nFROM (SELECT time_floor(__time, 'P1D') AS gran, dim2, sum(m1) as s FROM druid.foo GROUP BY 1, 2 HAVING sum(m1) > 1) AS x\nGROUP BY 1, 2\nORDER BY dim2, gran desc", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "timestamp_floor(\"d0\",'P1M',null,'UTC')", ColumnType.LONG)}).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.range("a0", ColumnType.LONG, 1L, null, true, false))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.DAY)).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0"), new DefaultDimensionSpec("p0", "_d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d0", OrderByColumnSpec.Direction.ASCENDING), (Object)new OrderByColumnSpec("_d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 6.0}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 2.0}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 3.0}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 4.0}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 5.0}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSets() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt), GROUPING(dim2, gran)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("v0", "v1"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L, 0L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"", null, 3L, 1L}, (Object)new Object[]{"a", null, 2L, 1L}, (Object)new Object[]{"abc", null, 1L, 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L, 2L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L, 2L}, (Object)new Object[]{null, null, 6L, 3L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingAggregatorDifferentOrder() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt), GROUPING(gran, dim2)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("v1", "v0"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L, 0L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"", null, 3L, 2L}, (Object)new Object[]{"a", null, 2L, 2L}, (Object)new Object[]{"abc", null, 1L, 2L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L, 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L, 1L}, (Object)new Object[]{null, null, 6L, 3L}));
    }

    @Test
    public void testGroupingAggregatorWithPostAggregator() {
        this.msqIncompatible();
        ImmutableList resultList = ImmutableList.of((Object)new Object[]{null, 2L, 0L, null}, (Object)new Object[]{"", 1L, 0L, ""}, (Object)new Object[]{"a", 2L, 0L, "a"}, (Object)new Object[]{"abc", 1L, 0L, "abc"}, (Object)new Object[]{null, 6L, 1L, "ALL"});
        this.testQuery("SELECT dim2, SUM(cnt), GROUPING(dim2), \nCASE WHEN GROUPING(dim2) = 1 THEN 'ALL' ELSE dim2 END\nFROM druid.foo\nGROUP BY GROUPING SETS ( (dim2), () )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Collections.singletonList("dim2"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "case_searched((\"a1\" == 1),'ALL',\"d0\")", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)resultList);
    }

    @Test
    public void testGroupingSetsWithNumericDimension() {
        this.msqIncompatible();
        this.testQuery("SELECT cnt, COUNT(*)\nFROM foo\nGROUP BY GROUPING SETS ( (cnt), () )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}, (Object)new Object[]{null, 6L}));
    }

    @Test
    public void testGroupByRollup() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY ROLLUP (dim2, gran)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{null, null, 6L}));
    }

    @Test
    public void testGroupByRollupDifferentOrder() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY ROLLUP (gran, dim2)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "nvl(\"dim2\",'')", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("v1", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{null, null, 6L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupByCube() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY CUBE (dim2, gran)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{null, null, 6L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithDummyDimension() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, 'dummy', gran), (dim2), (gran), ('dummy') )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v2", "d2", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d2"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"d2"))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d2", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{null, null, 6L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsNoSuperset() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{null, null, 6L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithOrderByDimension() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY gran, dim2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{null, null, 6L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithOrderByAggregator() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY SUM(cnt)\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{null, null, 6L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithOrderByAggregatorWithLimit() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY SUM(cnt)\nLIMIT 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(1))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}));
    }

    @Test
    public void testTimeExtractWithTooFewArguments() {
        try {
            this.testQuery("SELECT TIME_EXTRACT(__time) FROM druid.foo", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("Invalid number of arguments to function 'TIME_EXTRACT'. Was expecting 2 arguments (line [1], column [8])"));
        }
    }

    @Test
    public void testUsingSubqueryWithoutLimit() {
        this.testQuery("SELECT COUNT(*) AS cnt FROM ( SELECT * FROM druid.foo ) tmpA", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testUnicodeFilterAndGroupBy() {
        this.testQuery("SELECT\n  dim1,\n  dim2,\n  COUNT(*)\nFROM foo2\nWHERE\n  dim1 LIKE U&'\u05d3\\05E8%'\n  OR dim1 = '\u0434\u0440\u0443\u0438\u0434'\nGROUP BY dim1, dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo2").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{new LikeDimFilter("dim1", "\u05d3\u05e8%", null, null), CalciteQueryTest.equality("dim1", "\u0434\u0440\u0443\u0438\u0434", ColumnType.STRING)})).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"\u0434\u0440\u0443\u0438\u0434", "ru", 1L}, (Object)new Object[]{"\u05d3\u05e8\u05d5\u05d0\u05d9\u05d3", "he", 1L}));
    }

    @Test
    public void testOrderByAlongWithAliasOrderByTimeGroupByMulti() {
        this.testQuery("select  __time as bug, dim2  from druid.foo group by 1, 2 order by 1 limit 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)})).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(1))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "a"}));
    }

    @Test
    public void testOrderByAlongWithAliasOrderByTimeGroupByOneCol() {
        this.testQuery("select __time as bug from druid.foo group by 1 order by 1 limit 1", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)).threshold(1).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L}));
    }

    @Test
    public void testProjectAfterSort() {
        this.testQuery("select dim1 from (select dim1, dim2, count(*) cnt from druid.foo group by dim1, dim2 order by cnt)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testProjectAfterSort2() {
        this.testQuery("select s / cnt, dim1, dim2, s from (select dim1, dim2, count(*) cnt, sum(m2) s from druid.foo group by dim1, dim2 order by cnt)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a1\" / \"a0\")", ColumnType.DOUBLE)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, "", "a", 1.0}, (Object)new Object[]{4.0, "1", "a", 4.0}, (Object)new Object[]{2.0, "10.1", null, 2.0}, (Object)new Object[]{3.0, "2", "", 3.0}, (Object)new Object[]{6.0, "abc", null, 6.0}, (Object)new Object[]{5.0, "def", "abc", 5.0}));
    }

    @Test
    @Disabled(value="In Calcite 1.17, this test worked, but after upgrading to Calcite 1.21, this query fails with: org.apache.calcite.sql.validate.SqlValidatorException: Column 'dim1' is ambiguous")
    public void testProjectAfterSort3() {
        this.msqIncompatible();
        this.testQuery("select dim1 from (select dim1, dim1, count(*) cnt from druid.foo group by dim1, dim1 order by cnt)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testProjectAfterSort3WithoutAmbiguity() {
        this.msqIncompatible();
        this.testQuery("select copydim1 from (select dim1, dim1 AS copydim1, count(*) cnt from druid.foo group by dim1, dim1 order by cnt)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSortProjectAfterNestedGroupBy() {
        this.testQuery("SELECT   cnt FROM (  SELECT     __time,     dim1,     COUNT(m2) AS cnt   FROM (    SELECT         __time,         m2,         dim1     FROM druid.foo     GROUP BY __time, m2, dim1   )   GROUP BY __time, dim1   ORDER BY cnt)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d1"), new DefaultDimensionSpec("m2", "d2", ColumnType.DOUBLE)})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.LONG), new DefaultDimensionSpec("d1", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("d2"))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}));
    }

    @Test
    public void testPostAggWithTimeseries() {
        this.cannotVectorize();
        this.testQuery("SELECT   FLOOR(__time TO YEAR),   SUM(m1),   SUM(m1) + SUM(m2) FROM   druid.foo WHERE   dim2 = 'a' GROUP BY FLOOR(__time TO YEAR) ORDER BY FLOOR(__time TO YEAR) desc", Collections.singletonList(Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)).granularity(Granularities.YEAR).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("s0", "(\"a0\" + \"a1\")", ColumnType.DOUBLE)}).descending(true).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{978307200000L, 4.0, 8.0}, (Object)new Object[]{946684800000L, 1.0, 2.0}));
    }

    @Test
    public void testPostAggWithTopN() {
        this.testQuery("SELECT   AVG(m2),   SUM(m1) + SUM(m2) FROM   druid.foo WHERE   dim2 = 'a' GROUP BY m1 ORDER BY m1 LIMIT 5", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, Collections.singletonList(new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)).filters(CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), CalciteQueryTest.notNull("m2")), new DoubleSumAggregatorFactory("a1", "m1"), new DoubleSumAggregatorFactory("a2", "m2")})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))), CalciteQueryTest.expressionPostAgg("s0", "(\"a1\" + \"a2\")", ColumnType.DOUBLE)}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(5).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, 2.0}, (Object)new Object[]{4.0, 8.0}));
    }

    @Test
    public void testConcat() {
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"def-def_def"}, (Object)new Object[]{"abc-abc_abc"}));
    }

    @Test
    public void testConcat2() {
        this.testQuery("SELECT CONCAt(dim1, CONCAt(dim2,concat('x', 'y')), m2, 9999, dim1) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\",'xy',\"m2\",9999,\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"axy1.09999"}, (Object)new Object[]{null}, (Object)new Object[]{"2xy3.099992"}, (Object)new Object[]{"1axy4.099991"}, (Object)new Object[]{"defabcxy5.09999def"}, (Object)new Object[]{null}));
    }

    @Test
    public void testConcatGroup() {
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"abc-abc_abc"}, (Object)new Object[]{"def-def_def"}));
    }

    @Test
    public void testConcatGroup2() {
        ImmutableList results = ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"1ax4.099991"}, (Object)new Object[]{"2x3.099992"}, (Object)new Object[]{"ax1.09999"}, (Object)new Object[]{"defabcx5.09999def"});
        this.testQuery("SELECT CONCAT(dim1, CONCAT(dim2,'x'), m2, 9999, dim1) as dimX FROM foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\",'x',\"m2\",9999,\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testConcatDecomposeAlwaysFalseOrUnknown() {
        this.testQuery("SELECT CONCAT(dim1, 'x', dim2) as dimX\nFROM foo\nWHERE CONCAT(dim1, 'x', dim2) IN ('1a', '3x4')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'3x4'", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("dim1", "3", ColumnType.STRING), CalciteQueryTest.equality("dim2", "4", ColumnType.STRING))).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testConcatDecomposeAlwaysFalseOrUnknownNegated() {
        this.testQuery("SELECT CONCAT(dim1, 'x', dim2) as dimX\nFROM foo\nWHERE CONCAT(dim1, 'x', dim2) NOT IN ('1a', '3x4', '4x5')\n", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'x',\"dim2\")", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "3", ColumnType.STRING)), CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "4", ColumnType.STRING))}), CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "4", ColumnType.STRING)), CalciteQueryTest.not(CalciteQueryTest.equality("dim2", "5", ColumnType.STRING))}), CalciteQueryTest.notNull("dim1"), CalciteQueryTest.notNull("dim2")})).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xa"}, (Object)new Object[]{"2x"}, (Object)new Object[]{"1xa"}, (Object)new Object[]{"defxabc"}));
    }

    @Test
    public void testConcatDecomposeIsNull() {
        this.testQuery("SELECT dim1, dim2, CONCAT(dim1, 'x', dim2) as dimX\nFROM foo\nWHERE CONCAT(dim1, 'x', dim2) IS NULL", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'x',\"dim2\")", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(CalciteQueryTest.isNull("dim1"), CalciteQueryTest.isNull("dim2"))).columns(new String[]{"dim1", "dim2", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", null, null}, (Object)new Object[]{"abc", null, null}));
    }

    @Test
    public void testConcatDoubleBarsDecompose() {
        this.testQuery("SELECT dim1 || LOWER('x') || dim2 || 'z' as dimX\nFROM foo\nWHERE dim1 || LOWER('x') || dim2 || 'z' IN ('1xaz', '3x4z')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'x',\"dim2\",'z')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.and(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING), CalciteQueryTest.equality("dim2", "a", ColumnType.STRING)), CalciteQueryTest.and(CalciteQueryTest.equality("dim1", "3", ColumnType.STRING), CalciteQueryTest.equality("dim2", "4", ColumnType.STRING))})).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1xaz"}));
    }

    @Test
    public void testTextcat() {
        this.testQuery("SELECT textcat(dim1, dim1) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"10.110.1"}, (Object)new Object[]{"22"}, (Object)new Object[]{"11"}, (Object)new Object[]{"defdef"}, (Object)new Object[]{"abcabc"}));
    }

    @Test
    public void testTextcat2() {
        this.testQuery("SELECT textcat(dim1, CAST(m2 as VARCHAR)) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",CAST(\"m2\", 'STRING'))", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1.0"}, (Object)new Object[]{"10.12.0"}, (Object)new Object[]{"23.0"}, (Object)new Object[]{"14.0"}, (Object)new Object[]{"def5.0"}, (Object)new Object[]{"abc6.0"}));
    }

    @Test
    public void testRequireTimeConditionPositive() {
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT SUM(cnt), gran FROM (\n  SELECT __time as t, floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nWHERE t >= '2000-01-01' and t < '2002-01-01'GROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2002-01-01"))).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testRequireTimeConditionPositive2() {
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo WHERE __time >= '2000-01-01' GROUP BY dim2)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 4L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    @Test
    public void testRequireTimeConditionPositive3() {
        this.cannotVectorize();
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= '2000-01-01' AND SUBSTRING(dim2, 1, 1) IN (\n  SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo\n  WHERE dim1 <> '' AND __time >= '2000-01-01'\n)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).setDimFilter((DimFilter)CalciteQueryTest.not(CalciteQueryTest.equality("dim1", "", ColumnType.STRING))).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteQueryTest.equalsCondition(CalciteQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRequireTimeConditionLogicalValuePositive() {
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT 2 + 2 AS a", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{4L}), (RowSignature)RowSignature.builder().add("a", ColumnType.LONG).build())).columns(new String[]{"a"}).columnTypes(new ColumnType[]{ColumnType.LONG}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4}));
    }

    @Test
    public void testRequireTimeConditionSimpleQueryNegative() {
        this.msqIncompatible();
        Throwable exception = Assertions.assertThrows(CannotBuildQueryException.class, () -> this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT SUM(cnt), gran FROM (\n  SELECT __time as t, floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("__time column"));
    }

    @Test
    public void testRequireTimeConditionSubQueryNegative() {
        this.msqIncompatible();
        Throwable exception = Assertions.assertThrows(CannotBuildQueryException.class, () -> this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("__time column"));
    }

    @Test
    public void testRequireTimeConditionSemiJoinNegative() {
        this.msqIncompatible();
        Throwable exception = Assertions.assertThrows(CannotBuildQueryException.class, () -> this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT COUNT(*) FROM druid.foo\nWHERE SUBSTRING(dim2, 1, 1) IN (\n  SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo\n  WHERE dim1 <> '' AND __time >= '2000-01-01'\n)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("__time column"));
    }

    @Test
    public void testFilterFloatDimension() {
        this.testQuery("SELECT dim1 FROM numfoo WHERE f1 = 0.1 LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).filters(CalciteQueryTest.equality("f1", 0.1, ColumnType.DOUBLE)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testFilterDoubleDimension() {
        this.testQuery("SELECT dim1 FROM numfoo WHERE dbl1 = 1.7 LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).filters(CalciteQueryTest.equality("dbl1", 1.7, ColumnType.DOUBLE)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testFilterLongDimension() {
        this.testQuery("SELECT dim1 FROM numfoo WHERE l1 = 7 LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).filters(CalciteQueryTest.equality("l1", 7L, ColumnType.LONG)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}));
    }

    @Test
    public void testTrigonometricFunction() {
        this.msqIncompatible();
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sin(pi / 6), cos(pi / 6), tan(pi / 6), cot(pi / 6),asin(exp(count(*)) / 2), acos(exp(count(*)) / 2), atan(exp(count(*)) / 2), atan2(exp(count(*)), 1) FROM druid.foo WHERE  dim2 = 0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim2", 0L, ColumnType.LONG)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p1", "0.49999999999999994", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p2", "0.8660254037844387", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p3", "0.5773502691896257", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p4", "1.7320508075688776", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p5", "asin((exp(\"a0\") / 2))", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p6", "acos((exp(\"a0\") / 2))", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p7", "atan((exp(\"a0\") / 2))", ColumnType.DOUBLE), CalciteQueryTest.expressionPostAgg("p8", "atan2(exp(\"a0\"),1)", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, Math.sin(0.5235987755982988), Math.cos(0.5235987755982988), Math.tan(0.5235987755982988), Math.cos(0.5235987755982988) / Math.sin(0.5235987755982988), Math.asin(0.5), Math.acos(0.5), Math.atan(0.5), Math.atan2(1.0, 1.0)}));
    }

    @Test
    public void testRadiansAndDegrees() {
        this.testQuery("SELECT RADIANS(m1 * 15)/DEGREES(m2) FROM numfoo WHERE dim1 = '1'", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(toRadians((\"m1\" * 15)) / toDegrees(\"m2\"))", ColumnType.DOUBLE)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE}).filters(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Math.toRadians(60.0) / Math.toDegrees(4.0)}));
    }

    @Test
    public void testTimestampDiff() {
        this.testQuery("SELECT TIMESTAMPDIFF(DAY, TIMESTAMP '1999-01-01 00:00:00', __time), \nTIMESTAMPDIFF(DAY, __time, DATE '2001-01-01'), \nTIMESTAMPDIFF(HOUR, TIMESTAMP '1999-12-31 01:00:00', __time), \nTIMESTAMPDIFF(MINUTE, TIMESTAMP '1999-12-31 23:58:03', __time), \nTIMESTAMPDIFF(SECOND, TIMESTAMP '1999-12-31 23:59:03', __time), \nTIMESTAMPDIFF(MONTH, TIMESTAMP '1999-11-01 00:00:00', __time), \nTIMESTAMPDIFF(YEAR, TIMESTAMP '1996-11-01 00:00:00', __time), \nTIMESTAMPDIFF(QUARTER, TIMESTAMP '1996-10-01 00:00:00', __time), \nTIMESTAMPDIFF(WEEK, TIMESTAMP '1998-10-01 00:00:00', __time) \nFROM druid.foo\nLIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "div((\"__time\" - 915148800000),86400000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "div((978307200000 - \"__time\"),86400000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "div((\"__time\" - 946602000000),3600000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v3", "div((\"__time\" - 946684683000),60000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v4", "div((\"__time\" - 946684743000),1000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v5", "subtract_months(\"__time\",941414400000,'UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v6", "div(subtract_months(\"__time\",846806400000,'UTC'),12)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v7", "div(subtract_months(\"__time\",844128000000,'UTC'),3)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v8", "div(div((\"__time\" - 907200000000),1000),604800)", ColumnType.LONG)}).columns(new String[]{"v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{365, 366, 23, 1, 57, 2, 3, 13, 65}, (Object)new Object[]{366, 365, 47, 1441, 86457, 2, 3, 13, 65}));
    }

    @Test
    public void testTimestampCeil() {
        this.testQuery("SELECT CEIL(TIMESTAMP '2000-01-01 00:00:00' TO DAY), \nCEIL(TIMESTAMP '2000-01-01 01:00:00' TO DAY) \nFROM druid.foo\nLIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "946684800000", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "946771200000", ColumnType.LONG)}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).limit(1L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)"2000-01-01"), (DateTimeZone)DateTimeZone.UTC), Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)"2000-01-02"), (DateTimeZone)DateTimeZone.UTC)}));
    }

    @Test
    public void testNvlColumns() {
        this.testQuery("SELECT NVL(dim2, dim1), COUNT(*) FROM druid.foo GROUP BY NVL(dim2, dim1)\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testGroupByWithLiteralInSubqueryGrouping() {
        this.testQuery("SELECT \n   t1, t2\n  FROM\n   ( SELECT\n     'dummy' as t1,\n     CASE\n       WHEN \n         dim4 = 'b'\n       THEN dim4\n       ELSE NULL\n     END AS t2\n     FROM\n       numfoo\n     GROUP BY\n       dim4\n   )\n GROUP BY\n   t1,t2\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'dummy'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "case_searched((\"d0\" == 'b'),\"d0\",null)", ColumnType.STRING)}).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "_d1", ColumnType.STRING)})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dummy", null}, (Object)new Object[]{"dummy", "b"}));
    }

    @Test
    public void testLeftRightStringOperators() {
        this.testQuery("SELECT\n  dim1,  LEFT(dim1, 2),\n  RIGHT(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "left(\"d0\",2)", ColumnType.STRING), (Object)CalciteQueryTest.expressionPostAgg("p1", "right(\"d0\",2)", ColumnType.STRING))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "", ""}, (Object)new Object[]{"1", "1", "1"}, (Object)new Object[]{"10.1", "10", ".1"}, (Object)new Object[]{"2", "2", "2"}, (Object)new Object[]{"abc", "ab", "bc"}, (Object)new Object[]{"def", "de", "ef"}));
    }

    @Test
    public void testQueryContextOuterLimit() {
        this.msqIncompatible();
        HashMap<String, Object> outerLimitContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        outerLimitContext.put("sqlOuterLimit", 4);
        outerLimitContext.put("useLexicographicTopN", true);
        TopNQueryBuilder baseBuilder = new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).context(outerLimitContext);
        ImmutableList results1 = ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"2"}, (Object)new Object[]{"10.1"});
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)baseBuilder.threshold(4).build()), (List<Object[]>)results1);
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC LIMIT 9", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)baseBuilder.threshold(4).build()), (List<Object[]>)results1);
        ImmutableList results2 = ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"});
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)baseBuilder.threshold(2).build()), (List<Object[]>)results2);
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testRepeatedIdenticalVirtualExpressionGrouping() {
        String query = "SELECT \n\tCASE dim1 WHEN NULL THEN FALSE ELSE TRUE END AS col_a,\n\tCASE dim2 WHEN NULL THEN FALSE ELSE TRUE END AS col_b\nFROM foo\nGROUP BY 1, 2";
        this.testQuery("SELECT \n\tCASE dim1 WHEN NULL THEN FALSE ELSE TRUE END AS col_a,\n\tCASE dim2 WHEN NULL THEN FALSE ELSE TRUE END AS col_b\nFROM foo\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "1", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{true, true}));
    }

    @Test
    public void testValidationErrorNullLiteralIllegal() {
        this.testQueryThrows("SELECT REGEXP_LIKE('x', NULL)", CalciteQueryTest.invalidSqlContains("Illegal use of 'NULL'"));
    }

    @Test
    public void testValidationErrorNonLiteralIllegal() {
        this.testQueryThrows("SELECT REGEXP_LIKE('x', dim1) FROM foo", CalciteQueryTest.invalidSqlContains("Argument to function 'REGEXP_LIKE' must be a literal"));
    }

    @Test
    public void testValidationErrorWrongTypeLiteral() {
        this.testQueryThrows("SELECT REGEXP_LIKE('x', 1) FROM foo", CalciteQueryTest.invalidSqlContains("Cannot apply 'REGEXP_LIKE' to arguments"));
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroDayPeriod() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroMonthPeriod() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroYearPeriod() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testTimeStampAddConversion() {
        PeriodGranularity periodGranularity = new PeriodGranularity(new Period((Object)"P1M"), null, null);
        this.testQuery("SELECT TIMESTAMPADD(MONTH, 1, \"__time\") FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_shift(\"__time\",'P1M',1,'UTC')", ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), TestDataBuilder.ROWS1.stream().map(r -> new Object[]{periodGranularity.increment(r.getTimestamp()).getMillis()}).collect(Collectors.toList()));
        this.testQuery("SELECT TIMESTAMPADD(MONTH, \"cnt\", \"__time\") FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_shift(\"__time\",concat('P', (1 * \"cnt\"), 'M'),1,'UTC')", ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), TestDataBuilder.ROWS1.stream().map(row -> new Object[]{periodGranularity.increment(row.getTimestamp()).getMillis()}).collect(Collectors.toList()));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithLimit() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () ) LIMIT 100", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(100))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{null, null, 6L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithLimitOrderByGran() {
        this.msqIncompatible();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () ) ORDER BY x.gran LIMIT 100", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "nvl(\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, (StringComparator)new StringComparators.NumericComparator())), Integer.valueOf(100))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.builder().add((Object[])new Object[][]{{"", null, 3L}, {"a", null, 2L}, {"abc", null, 1L}, {null, null, 6L}, {"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, {"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, {null, CalciteQueryTest.timestamp("2000-01-01"), 3L}, {"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {null, CalciteQueryTest.timestamp("2001-01-01"), 3L}}).build());
    }

    @Test
    public void testRoundFunc() {
        this.testQuery("SELECT f1, round(f1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "round(\"f1\")", ColumnType.FLOAT)}).columns(new String[]{"f1", "v0"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(0.1f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}));
    }

    @Test
    public void testCountAndAverageByConstantVirtualColumn() {
        ImmutableList virtualColumns = ImmutableList.of((Object)CalciteQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING), (Object)CalciteQueryTest.expressionVirtualColumn("v1", "325323", ColumnType.LONG));
        ImmutableList aggs = ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("v0")), (Object)new DoubleSumAggregatorFactory("a1:sum", "v1"), (Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1:count"), CalciteQueryTest.notNull("v1")));
        this.testQuery("SELECT dim5, COUNT(dim1), AVG(l1) FROM druid.numfoo WHERE dim1 = '10.1' AND l1 = 325323 GROUP BY dim5", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("dim1", "10.1", ColumnType.STRING), CalciteQueryTest.equality("l1", 325323L, ColumnType.LONG))).setGranularity(Granularities.ALL).setVirtualColumns(VirtualColumns.create((List)virtualColumns)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim5", "d0", ColumnType.STRING)}).setAggregatorSpecs((List)aggs).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a1", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a1:sum"), (Object)new FieldAccessPostAggregator(null, "a1:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"ab", 1L, 325323.0}));
    }

    @Test
    public void testExpressionCounts() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT\n COUNT(reverse(dim2)),\n COUNT(left(dim2, 5)),\n COUNT(strpos(dim2, 'a'))\nFROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "reverse(\"dim2\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "left(\"dim2\",5)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "(strpos(\"dim2\",'a') + 1)", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("v0")), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), CalciteQueryTest.notNull("v1")), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a2"), CalciteQueryTest.notNull("v2"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L, 4L, 4L}));
    }

    @Test
    public void testBitwiseAggregatorsTimeseries() {
        this.cannotVectorize();
        this.testQuery("SELECT\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 325327L, 325324L}));
    }

    @Test
    public void testBitwiseAggregatorsGroupBy() {
        this.cannotVectorize();
        this.testQuery("SELECT\n dim2,\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo GROUP BY 1 ORDER BY 4", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1"))})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("a2", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, null, null}, (Object)new Object[]{"", 0L, 0L, 0L}, (Object)new Object[]{"a", 0L, 7L, 7L}, (Object)new Object[]{null, 0L, 325323L, 325323L}));
    }

    @Test
    public void testStringAgg() {
        this.cannotVectorize();
        this.testQuery("SELECT STRING_AGG(dim1,','), STRING_AGG(DISTINCT dim1, ','), STRING_AGG(DISTINCT dim1,',') FILTER(WHERE dim1 = 'shazbot') FROM foo WHERE dim1 is not null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.notNull("dim1")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dim1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a2\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(CalciteQueryTest.notNull("dim1"), CalciteQueryTest.equality("dim1", "shazbot", ColumnType.STRING)))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{",10.1,2,1,def,abc", ",1,10.1,2,abc,def", null}));
    }

    @Test
    public void testStringAggMultiValue() {
        this.cannotVectorize();
        this.testQuery("SELECT STRING_AGG(dim3, ','), STRING_AGG(DISTINCT dim3, ',') FROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dim3\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim3")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dim3"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a,b,b,c,d,", ",a,b,c,d"}));
    }

    @Test
    public void testStringAggNumeric() {
        this.cannotVectorize();
        this.testQuery("SELECT STRING_AGG(l1, ','), STRING_AGG(DISTINCT l1, ','), STRING_AGG(dbl1, ','), STRING_AGG(DISTINCT dbl1, ','), STRING_AGG(f1, ','), STRING_AGG(DISTINCT f1, ',') FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dbl1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dbl1\")", "array_concat(\"__acc\", \"a2\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dbl1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a3", (Set)ImmutableSet.of((Object)"dbl1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dbl1\")", "array_set_add_all(\"__acc\", \"a3\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("dbl1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a4", (Set)ImmutableSet.of((Object)"f1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"f1\")", "array_concat(\"__acc\", \"a4\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("f1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a5", (Set)ImmutableSet.of((Object)"f1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"f1\")", "array_set_add_all(\"__acc\", \"a5\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("f1"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"7,325323,0", "0,325323,7", "1.0,1.7,0.0", "0.0,1.0,1.7", "1.0,0.10000000149011612,0.0", "0.0,0.10000000149011612,1.0"}));
    }

    @Test
    public void testStringAggExpression() {
        this.cannotVectorize();
        this.testQuery("SELECT\n  STRING_AGG(DISTINCT CONCAT(dim1, dim2), ','),\n  STRING_AGG(DISTINCT CONCAT(dim1, dim2), CONCAT('|', '|'))\nFROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\")", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("v0")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, '||'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("v0"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1a,2,a,defabc", "1a||2||a||defabc"}));
    }

    @Test
    public void testStringAggExpressionNonConstantSeparator() {
        Assertions.assertThrows(DruidException.class, () -> this.testQuery("SELECT STRING_AGG(DISTINCT CONCAT(dim1, dim2), CONCAT('|', dim1)) FROM foo", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
    }

    @Test
    public void testStringAnyAggArgValidation() {
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT ANY_VALUE(dim3, 1000, 'true') FROM foo").queryContext((Map<String, Object>)ImmutableMap.of()).run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("Cannot apply 'ANY_VALUE' to arguments of type 'ANY_VALUE(<VARCHAR>, <INTEGER>, <CHAR(4)>)'. Supported form(s): 'ANY_VALUE(<expr>, [<maxBytesPerStringInt>, [<aggregateMultipleValuesBoolean>]])' (line [1], column [8])"));
        DruidException e1 = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT ANY_VALUE(dim3, 1000, null) FROM foo").queryContext((Map<String, Object>)ImmutableMap.of()).run());
        Assert.assertEquals((Object)"Illegal use of 'NULL' (line [1], column [30])", (Object)e1.getMessage());
        DruidException e2 = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT ANY_VALUE(dim3, null, true) FROM foo").queryContext((Map<String, Object>)ImmutableMap.of()).run());
        Assert.assertEquals((Object)"Illegal use of 'NULL' (line [1], column [24])", (Object)e2.getMessage());
    }

    @Test
    public void testStringAggMaxBytes() {
        this.cannotVectorize();
        this.testQuery("SELECT STRING_AGG(l1, ',', 128), STRING_AGG(DISTINCT l1, ',', CAST(128 AS INTEGER)) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1")), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("l1"))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"7,325323,0", "0,325323,7"}));
    }

    @Test
    public void testHumanReadableFormatFunction() {
        this.testQuery("SELECT m1, HUMAN_READABLE_BINARY_BYTE_FORMAT(45678),HUMAN_READABLE_BINARY_BYTE_FORMAT(m1*12345),HUMAN_READABLE_BINARY_BYTE_FORMAT(m1*12345, 0), HUMAN_READABLE_DECIMAL_BYTE_FORMAT(m1*12345), HUMAN_READABLE_DECIMAL_FORMAT(m1*12345), HUMAN_READABLE_BINARY_BYTE_FORMAT(l1),HUMAN_READABLE_DECIMAL_BYTE_FORMAT(l1), HUMAN_READABLE_DECIMAL_FORMAT(l1) FROM numfoo WHERE dim1 = '1' LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'44.61 KiB'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "human_readable_binary_byte_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "human_readable_binary_byte_format((\"m1\" * 12345),0)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v3", "human_readable_decimal_byte_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v4", "human_readable_decimal_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v5", "human_readable_binary_byte_format(\"l1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v6", "human_readable_decimal_byte_format(\"l1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v7", "human_readable_decimal_format(\"l1\")", ColumnType.STRING)}).columns(new String[]{"m1", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).filters(CalciteQueryTest.equality("dim1", "1", ColumnType.STRING)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(4.0f), "44.61 KiB", "48.22 KiB", "48 KiB", "49.38 KB", "49.38 K", null, null, null}));
    }

    @Test
    public void testHumanReadableFormatFunctionExceptionWithWrongNumberType() {
        this.testQueryThrows("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT('45678')", CalciteQueryTest.invalidSqlContains("Supported form(s): HUMAN_READABLE_BINARY_BYTE_FORMAT(Number, [Precision])"));
    }

    @Test
    public void testHumanReadableFormatFunctionWithWrongPrecisionType() {
        this.testQueryThrows("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT(45678, '2')", CalciteQueryTest.invalidSqlContains("Supported form(s): HUMAN_READABLE_BINARY_BYTE_FORMAT(Number, [Precision])"));
    }

    @Test
    public void testHumanReadableFormatFunctionWithInvalidNumberOfArguments() {
        this.testQueryThrows("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT(45678, 2, 1)", CalciteQueryTest.invalidSqlContains("Invalid number of arguments to function 'HUMAN_READABLE_BINARY_BYTE_FORMAT'. Was expecting 1 arguments"));
    }

    @Test
    public void testCommonVirtualExpressionWithDifferentValueType() {
        this.testQuery("select\n dim1,\n sum(cast(0 as bigint)) as s1,\n sum(cast(0 as double)) as s2\nfrom druid.foo\nwhere dim1 = 'none'\ngroup by dim1\nlimit 1", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteQueryTest.equality("dim1", "none", ColumnType.STRING)).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'none'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "0", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "0.0", ColumnType.DOUBLE)}).dimension((DimensionSpec)new DefaultDimensionSpec("v0", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v1", null, ExprMacroTable.nil()), new DoubleSumAggregatorFactory("a1", "v2", null, ExprMacroTable.nil())})).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testReturnEmptyRowWhenGroupByIsConvertedToTimeseriesWithSingleConstantDimension() {
        this.testQuery("SELECT 'A' from foo WHERE m1 = 50 AND dim1 = 'wat' GROUP BY 'foobar'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("m1", 50.0, ColumnType.FLOAT), CalciteQueryTest.equality("dim1", "wat", ColumnType.STRING))).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "'A'", ColumnType.STRING)}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT 'A' from foo WHERE dim1 = 'wat' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).setDimFilter(CalciteQueryTest.equality("dim1", "wat", ColumnType.STRING)).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "'A'", ColumnType.STRING))).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testReturnEmptyRowWhenGroupByIsConvertedToTimeseriesWithMultipleConstantDimensions() {
        this.testQuery("SELECT 'A', dim1 from foo WHERE m1 = 50 AND dim1 = 'wat' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("m1", 50.0, ColumnType.FLOAT), CalciteQueryTest.equality("dim1", "wat", ColumnType.STRING))).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "'A'", ColumnType.STRING), CalciteQueryTest.expressionPostAgg("p1", "'wat'", ColumnType.STRING)}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT 'A', dim1 from foo WHERE m1 = 2.0 AND dim1 = '10.1' GROUP BY dim1", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(CalciteQueryTest.equality("m1", 2.0, ColumnType.DOUBLE), CalciteQueryTest.equality("dim1", "10.1", ColumnType.STRING))).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "'A'", ColumnType.STRING), CalciteQueryTest.expressionPostAgg("p1", "'10.1'", ColumnType.STRING)}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"A", "10.1"}));
    }

    @Test
    public void testPlanWithInFilterLessThanInSubQueryThreshold() {
        String query = "SELECT l1 FROM numfoo WHERE l1 IN (4842, 4844, 4845, 14905, 4853, 29064)";
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)DEFAULT_PARAMETERS, query, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").columns(new String[]{"l1"}).columnTypes(new ColumnType[]{ColumnType.LONG}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_DEFAULT).filters(CalciteQueryTest.in("l1", ColumnType.LONG, ImmutableList.of((Object)4842L, (Object)4844L, (Object)4845L, (Object)14905L, (Object)4853L, (Object)29064L))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (String sql, QueryTestRunner.QueryResults result) -> {});
    }

    @Test
    public void testGreatestFunctionForNumberWithIsNull() {
        this.cannotVectorizeUnlessFallback();
        String query = "SELECT dim1, MAX(GREATEST(l1, l2)) IS NULL FROM druid.numfoo GROUP BY dim1";
        ImmutableList expectedResult = ImmutableList.of((Object)new Object[]{"", false}, (Object)new Object[]{"1", true}, (Object)new Object[]{"10.1", false}, (Object)new Object[]{"2", false}, (Object)new Object[]{"abc", true}, (Object)new Object[]{"def", true});
        ImmutableList expectedQueries = ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "greatest(\"l1\",\"l2\")", ColumnType.LONG)}).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).addAggregator((AggregatorFactory)new LongMaxAggregatorFactory("a0", "v0")).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "isnull(\"a0\")", ColumnType.LONG))).build());
        this.testQuery(query, (List<Query<?>>)expectedQueries, (List<Object[]>)expectedResult);
    }

    @Test
    public void testGreatestFunctionForStringWithIsNull() {
        this.cannotVectorizeUnlessFallback();
        this.msqIncompatible();
        String query = "SELECT l1, LATEST(GREATEST(dim1, dim2)) IS NULL FROM druid.numfoo GROUP BY l1";
        this.testQuery(query, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "greatest(\"dim1\",\"dim2\")", ColumnType.STRING)}).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("l1", "d0", ColumnType.LONG)).addAggregator((AggregatorFactory)new StringLastAggregatorFactory("a0", "v0", null, Integer.valueOf(1024))).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "isnull(\"a0\")", ColumnType.LONG))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, false}, (Object)new Object[]{0L, false}, (Object)new Object[]{7L, false}, (Object)new Object[]{325323L, false}));
    }

    @Test
    public void testGreatestLeastTypes() {
        this.cannotVectorizeUnlessFallback();
        String query = "SELECT\n__time,\nl1,\nm1,\nl2,\nGREATEST(l1, l2),\nGREATEST(l1, dim1),\nGREATEST(dim1, l1),\nGREATEST(l1, m1),\nGREATEST(m1, l1),\nGREATEST(l1, CAST(l2 AS VARCHAR)),\nGREATEST(__time, __time + INTERVAL '1' HOUR),\nGREATEST(l1, NULL),\nGREATEST(NULL, NULL)\nFROM druid.numfoo";
        ScanQuery expectedQuery = Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "l1", "m1", "l2", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.FLOAT, ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.STRING, ColumnType.LONG, ColumnType.LONG, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "greatest(\"l1\",\"l2\")", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "greatest(\"l1\",\"dim1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "greatest(\"dim1\",\"l1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v3", "greatest(\"l1\",\"m1\")", ColumnType.DOUBLE), CalciteQueryTest.expressionVirtualColumn("v4", "greatest(\"m1\",\"l1\")", ColumnType.DOUBLE), CalciteQueryTest.expressionVirtualColumn("v5", "greatest(\"l1\",CAST(\"l2\", 'STRING'))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v6", "greatest(\"__time\",(\"__time\" + 3600000))", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v7", "greatest(\"l1\",null)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v8", "null", ColumnType.STRING)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        this.testQuery(query, List.of(expectedQuery), List.of(new Object[]{946684800000L, 7L, Float.valueOf(1.0f), null, 7L, "7", "7", 7.0, 7.0, "7", 946688400000L, 7L, null}, new Object[]{946771200000L, 325323L, Float.valueOf(2.0f), 325323L, 325323L, "325323", "325323", 325323.0, 325323.0, "325323", 946774800000L, 325323L, null}, new Object[]{946857600000L, 0L, Float.valueOf(3.0f), 0L, 0L, "2", "2", 3.0, 3.0, "0", 946861200000L, 0L, null}, new Object[]{978307200000L, null, Float.valueOf(4.0f), null, null, "1", "1", 4.0, 4.0, null, 978310800000L, null, null}, new Object[]{978393600000L, null, Float.valueOf(5.0f), null, null, "def", "def", 5.0, 5.0, null, 978397200000L, null, null}, new Object[]{978480000000L, null, Float.valueOf(6.0f), null, null, "abc", "abc", 6.0, 6.0, null, 978483600000L, null, null}));
    }

    @Test
    public void testSubqueryTypeMismatchWithLiterals() {
        this.testQuery("SELECT \n  dim1,\n  SUM(CASE WHEN sum_l1 = 0 THEN 1 ELSE 0 END) AS outer_l1\nfrom (\n  select \n    dim1,\n    SUM(l1) as sum_l1\n  from numfoo\n  group by dim1\n)\ngroup by 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("a0", "l1")).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "case_searched((\"a0\" == 0),1,0)", ColumnType.LONG))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 0L}, (Object)new Object[]{"1", 0L}, (Object)new Object[]{"10.1", 0L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 0L}, (Object)new Object[]{"def", 0L}));
    }

    @Test
    public void testComplexDecode() {
        for (String complexDecode : Arrays.asList("COMPLEX_DECODE_BASE64", "DECODE_BASE64_COMPLEX")) {
            this.testQuery(StringUtils.format((String)"SELECT %s('hyperUnique',PARSE_JSON(TO_JSON_STRING(unique_dim1))) from druid.foo LIMIT 10", (Object[])new Object[]{complexDecode}), (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.ofComplex((String)"hyperUnique")}).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "complex_decode_base64('hyperUnique',parse_json(to_json_string(\"unique_dim1\")))", ColumnType.ofComplex((String)"hyperUnique"))}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(10L).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"\"AQAAAEAAAA==\""}, (Object)new Object[]{"\"AQAAAQAAAAHNBA==\""}, (Object)new Object[]{"\"AQAAAQAAAAOzAg==\""}, (Object)new Object[]{"\"AQAAAQAAAAFREA==\""}, (Object)new Object[]{"\"AQAAAQAAAACyEA==\""}, (Object)new Object[]{"\"AQAAAQAAAAEkAQ==\""}));
        }
    }

    @Test
    public void testComplexDecodeAgg() {
        this.cannotVectorizeUnlessFallback();
        this.msqIncompatible();
        this.testQuery("SELECT APPROX_COUNT_DISTINCT_BUILTIN(COMPLEX_DECODE_BASE64('hyperUnique',PARSE_JSON(TO_JSON_STRING(unique_dim1)))) from druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "complex_decode_base64('hyperUnique',parse_json(to_json_string(\"unique_dim1\")))", ColumnType.ofComplex((String)"hyperUnique"))}).aggregators(new AggregatorFactory[]{new HyperUniquesAggregatorFactory("a0", "v0", false, true)}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testComplexDecodeAggWithCastedTypeName() {
        this.cannotVectorizeUnlessFallback();
        this.msqIncompatible();
        this.testQuery("SELECT APPROX_COUNT_DISTINCT_BUILTIN(COMPLEX_DECODE_BASE64(CAST('hyperUnique' AS VARCHAR),PARSE_JSON(TO_JSON_STRING(unique_dim1)))) FROM druid.foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "complex_decode_base64('hyperUnique',parse_json(to_json_string(\"unique_dim1\")))", ColumnType.ofComplex((String)"hyperUnique"))}).aggregators(new AggregatorFactory[]{new HyperUniquesAggregatorFactory("a0", "v0", false, true)}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testOrderByAlongWithInternalScanQuery() {
        this.testQuery("select __time as t, m1 from druid.foo where (m1 in (select distinct m1 from druid.foo)) order by 1 limit 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setGranularity(Granularities.ALL).setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)}).build()), (String)"j0.", (String)"(\"m1\" == \"j0.d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).limit(1L).columns(new String[]{"__time", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).order(Order.ASCENDING).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f)}));
    }

    @Test
    public void testOrderByAlongWithInternalScanQueryNoDistinct() {
        this.testQuery("select __time, m1 from druid.foo where (m1 in (select m1 from druid.foo)) order by __time DESC limit 1", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setGranularity(Granularities.ALL).setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)}).build()), (String)"j0.", (String)"(\"m1\" == \"j0.d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).limit(1L).columns(new String[]{"__time", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).order(Order.DESCENDING).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{978480000000L, Float.valueOf(6.0f)}));
    }

    @Test
    public void testFilterWithNVLAndNotIn() {
        this.testQuery("select __time, dim1 from druid.foo where nvl(dim1, '') NOT IN ('a' , '')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)new TableDataSource("foo")).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.in("dim1", Arrays.asList("", "a")))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946771200000L, "10.1"}, (Object)new Object[]{946857600000L, "2"}, (Object)new Object[]{978307200000L, "1"}, (Object)new Object[]{978393600000L, "def"}, (Object)new Object[]{978480000000L, "abc"}));
    }

    @Test
    public void testFilterWithNVLAndInIsNotTrue() {
        this.testQuery("select __time, dim1 from druid.foo where (nvl(dim1, '') IN ('a' , '')) IS NOT TRUE", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)new TableDataSource("foo")).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.in("dim1", Arrays.asList("", "a")))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946771200000L, "10.1"}, (Object)new Object[]{946857600000L, "2"}, (Object)new Object[]{978307200000L, "1"}, (Object)new Object[]{978393600000L, "def"}, (Object)new Object[]{978480000000L, "abc"}));
    }

    @Test
    public void testFilterWithNvlishCaseAndNotIn() {
        this.testQuery("select __time, dim1 from druid.foo where CASE WHEN dim1 IS NULL THEN '' ELSE dim1 END NOT IN ('a' , '')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)new TableDataSource("foo")).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.in("dim1", Arrays.asList("", "a")))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946771200000L, "10.1"}, (Object)new Object[]{946857600000L, "2"}, (Object)new Object[]{978307200000L, "1"}, (Object)new Object[]{978393600000L, "def"}, (Object)new Object[]{978480000000L, "abc"}));
    }

    @Test
    public void testFilterWithNvlishCase2AndNotIn() {
        this.testQuery("select __time, dim1 from druid.foo where CASE WHEN dim1 IS NOT NULL THEN dim1 ELSE '' END NOT IN ('a' , '')", (List<Query<?>>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)new TableDataSource("foo")).context(QUERY_CONTEXT_DEFAULT).intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).filters((DimFilter)CalciteQueryTest.not(CalciteQueryTest.in("dim1", Arrays.asList("", "a")))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946771200000L, "10.1"}, (Object)new Object[]{946857600000L, "2"}, (Object)new Object[]{978307200000L, "1"}, (Object)new Object[]{978393600000L, "def"}, (Object)new Object[]{978480000000L, "abc"}));
    }

    @Test
    public void testGroupByDateTrunc() {
        this.testQuery("select DATE_TRUNC('HOUR', __time), COUNT(*) from druid.foo group by DATE_TRUNC('HOUR', __time)", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.HOUR).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L}, (Object)new Object[]{946771200000L, 1L}, (Object)new Object[]{946857600000L, 1L}, (Object)new Object[]{978307200000L, 1L}, (Object)new Object[]{978393600000L, 1L}, (Object)new Object[]{978480000000L, 1L}));
    }

    @Test
    public void testLatestByOnStringColumnWithoutMaxBytesSpecified() {
        this.testQuery("SELECT dim2,LATEST(dim3),LATEST_BY(dim1, __time),EARLIEST(dim3),EARLIEST_BY(dim1, __time),ANY_VALUE(dim3) FROM druid.foo where dim2='abc' group by 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'abc'", ColumnType.STRING)}).setDimFilter(CalciteQueryTest.equality("dim2", "abc", ColumnType.STRING)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringLastAggregatorFactory("a0", "dim3", "__time", Integer.valueOf(1024)), new StringLastAggregatorFactory("a1", "dim1", "__time", Integer.valueOf(1024)), new StringFirstAggregatorFactory("a2", "dim3", "__time", Integer.valueOf(1024)), new StringFirstAggregatorFactory("a3", "dim1", "__time", Integer.valueOf(1024)), new StringAnyAggregatorFactory("a4", "dim3", Integer.valueOf(1024), Boolean.valueOf(true))})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, "def", null, "def", null}));
    }

    @Test
    public void testDistinctSumNotSupportedWithApproximation() {
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().queryContext((Map<String, Object>)ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)true)).sql("SELECT sum(distinct m1) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlContains("Aggregation [SUM] with DISTINCT is not supported"));
    }

    @Test
    public void testUnSupportedNullsFirst() {
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT dim1,ROW_NUMBER() OVER (ORDER BY dim1 DESC NULLS FIRST) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("DESCENDING ordering with NULLS FIRST is not supported! (line [1], column [41])"));
    }

    @Test
    public void testUnSupportedNullsLast() {
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT dim1,ROW_NUMBER() OVER (ORDER BY dim1 NULLS LAST) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("ASCENDING ordering with NULLS LAST is not supported! (line [1], column [41])"));
    }

    @Test
    public void testUnSupportedRangeBounds() {
        this.assumeFeatureAvailable(EngineFeature.WINDOW_FUNCTIONS);
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT dim1,ROW_NUMBER() OVER (ORDER BY dim1 RANGE BETWEEN 3 PRECEDING AND 2 FOLLOWING) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("Order By with RANGE clause currently supports only UNBOUNDED or CURRENT ROW. Use ROWS clause instead. (line [1], column [31])"));
    }

    @Test
    public void testUnSupportedWindowBoundExpressions() {
        this.assumeFeatureAvailable(EngineFeature.WINDOW_FUNCTIONS);
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT dim1,ROW_NUMBER() OVER (ORDER BY dim1 ROWS BETWEEN dim1 PRECEDING AND dim1 FOLLOWING) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlIs("Window frames with expression based lower/upper bounds are not supported. (line [1], column [31])"));
    }

    @Test
    public void testNtileNotSupportedWithFrame() {
        this.assumeFeatureAvailable(EngineFeature.WINDOW_FUNCTIONS);
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT ntile(4) OVER (ORDER BY dim1 ROWS BETWEEN 1 FOLLOWING AND CURRENT ROW) from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlContains("Framing of NTILE is not supported"));
    }

    @Test
    public void testDistinctNotSupportedWithWindow() {
        this.assumeFeatureAvailable(EngineFeature.WINDOW_FUNCTIONS);
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT count(distinct dim1) OVER () from druid.foo").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlContains("DISTINCT is not supported for window functions"));
    }

    @Test
    public void testLogicalCorrelateTrimFieldsStillNeeded() {
        Assertions.assertEquals((Object)"1.37.0", (Object)RelNode.class.getPackage().getImplementationVersion(), (String)"Calcite version changed; check if DruidRelFieldTrimmer#trimFields(LogicalCorrelate correlate,...) is still needed or not!");
    }

    @Test
    public void testUnSupportedAggInSelectWindow() {
        Assertions.assertEquals((Object)"1.37.0", (Object)RelNode.class.getPackage().getImplementationVersion(), (String)"Calcite version changed; check if CALCITE-6500 is fixed and update:\n * method DruidSqlValidator#validateWindowClause");
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT dim1, ROW_NUMBER() OVER W from druid.foo WINDOW W as (ORDER BY max(length(dim1)))").run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteQueryTest.invalidSqlContains("not supported with syntax WINDOW W AS <DEF>"));
    }

    @Test
    public void testInGroupByLimitOutGroupByOrderBy() {
        this.testBuilder().sql("with t AS (SELECT m2, COUNT(m1) as trend_score\nFROM \"foo\"\nGROUP BY 1 \nLIMIT 10\n)\nselect m2, (MAX(trend_score)) from t\nwhere m2 > 2\nGROUP BY 1 \nORDER BY 2 DESC").queryContext(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).expectedQuery(WindowOperatorQueryBuilder.builder().setDataSource((Query<?>)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("m2", "d0", ColumnType.DOUBLE)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("m1"))})).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()).setSignature(RowSignature.builder().add("d0", ColumnType.DOUBLE).add("a0", ColumnType.LONG).build()).setOperators(OperatorFactoryBuilders.naiveSortOperator("a0", ColumnWithDirection.Direction.DESC)).setLeafOperators(OperatorFactoryBuilders.scanOperatorFactoryBuilder().setOffsetLimit(0L, Long.MAX_VALUE).setFilter(CalciteQueryTest.range("d0", ColumnType.LONG, 2L, null, true, false)).setProjectedColumns("d0", "a0").build()).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{3.0, 1L}, (Object)new Object[]{4.0, 1L}, (Object)new Object[]{5.0, 1L}, (Object)new Object[]{6.0, 1L})).run();
    }

    @Test
    public void testInGroupByOrderByLimitOutGroupByOrderByLimit() {
        String sql = "with t AS (SELECT m2 as mo, COUNT(m1) as trend_score\nFROM \"foo\"\nGROUP BY 1\nORDER BY trend_score DESC\nLIMIT 10)\nselect mo, (MAX(trend_score)) from t\nwhere mo > 2\nGROUP BY 1 \nORDER BY 2 DESC  LIMIT 2 OFFSET 1\n";
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{4.0, 1L}, (Object)new Object[]{5.0, 1L});
        this.testBuilder().sql(sql).expectedQuery(WindowOperatorQueryBuilder.builder().setDataSource((Query<?>)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("m2", "d0", ColumnType.DOUBLE)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("m1"))})).metric((TopNMetricSpec)new NumericTopNMetricSpec("a0")).context(OUTER_LIMIT_CONTEXT).build()).setSignature(RowSignature.builder().add("d0", ColumnType.DOUBLE).add("a0", ColumnType.LONG).build()).setOperators(OperatorFactoryBuilders.naiveSortOperator("a0", ColumnWithDirection.Direction.DESC), OperatorFactoryBuilders.scanOperatorFactoryBuilder().setOffsetLimit(1L, 2L).build()).setLeafOperators(OperatorFactoryBuilders.scanOperatorFactoryBuilder().setOffsetLimit(0L, Long.MAX_VALUE).setFilter(CalciteQueryTest.range("d0", ColumnType.LONG, 2L, null, true, false)).setProjectedColumns("d0", "a0").build()).build()).expectedResults((List<Object[]>)expectedResults).run();
    }

    @Test
    public void testScanAndSortCanGetSchemaFromScanQuery() {
        this.msqIncompatible();
        String sql = "select * from (select * from \"wikipedia\" limit 3) order by \"user\"";
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1442018825474L, "#en.wikipedia", "Auburn", "/* Status of peremptory norms under international law */ fixed spelling of 'Wimbledon'", "AU", "Australia", "true", "false", "false", "false", "false", null, "Main", "Peremptory norm", "NSW", "New South Wales", "60.225.66.142", 0L, 0L, 0L}, (Object)new Object[]{1442018818771L, "#en.wikipedia", null, "added project", null, null, "false", "false", "false", "false", "false", null, "Talk", "Talk:Oswald Tilghman", null, null, "GELongstreet", 36L, 36L, 0L}, (Object)new Object[]{1442018820496L, "#ca.wikipedia", null, "Robot inserta {{Commonscat}} que enlla\u00e7a amb [[commons:category:Rallicula]]", null, null, "false", "true", "false", "true", "false", null, "Main", "Rallicula", null, null, "PereBot", 17L, 17L, 0L});
        this.testBuilder().sql(sql).expectedResults((List<Object[]>)expectedResults).run();
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_PLAN)
    @Test
    public void testWindowingWithScanAndSort() {
        this.msqIncompatible();
        String sql = "with t AS (\nSELECT  \n    RANK() OVER (PARTITION BY m2 ORDER BY m2 ASC) \n      AS ranking,\n    COUNT(m1) as trend_score\nFROM foo\nGROUP BY m2,m1 LIMIT 10\n)\nselect ranking, trend_score from t ORDER BY trend_score";
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1L, 1L}, (Object)new Object[]{1L, 1L}, (Object)new Object[]{1L, 1L}, (Object)new Object[]{1L, 1L}, (Object)new Object[]{1L, 1L}, (Object)new Object[]{1L, 1L});
        this.testBuilder().sql(sql).expectedQuery(WindowOperatorQueryBuilder.builder().setDataSource((Query<?>)Druids.newScanQueryBuilder().dataSource(new WindowOperatorQueryBuilder().setDataSource((Query<?>)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m2", "d0", ColumnType.DOUBLE), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("m1"))})).build()).setOperators(new OperatorFactory[]{OperatorFactoryBuilders.naivePartitionOperator("d0"), OperatorFactoryBuilders.windowOperators(OperatorFactoryBuilders.rankProcessor("w0", "d0"))}).setSignature(RowSignature.builder().add("w0", ColumnType.LONG).add("a0", ColumnType.LONG).build()).build()).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"w0", "a0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(10L).build()).setSignature(RowSignature.builder().add("w0", ColumnType.LONG).add("a0", ColumnType.LONG).build()).setOperators(OperatorFactoryBuilders.naiveSortOperator("a0", ColumnWithDirection.Direction.ASC)).setLeafOperators(OperatorFactoryBuilders.scanOperatorFactoryBuilder().setOffsetLimit(0L, Long.MAX_VALUE).setProjectedColumns("w0", "a0").build()).build()).expectedResults((List<Object[]>)expectedResults).run();
    }

    @Test
    public void testWindowingWithOrderBy() {
        this.msqIncompatible();
        this.testBuilder().sql("SELECT\n  FLOOR(__time TO DAY) t,\n  SUM(cnt) c,\n  SUM(SUM(cnt)) OVER (ORDER BY FLOOR(__time TO DAY)) cc\nFROM foo\nGROUP BY FLOOR(__time TO DAY)").queryContext((Map<String, Object>)ImmutableMap.of((Object)"debug", (Object)true)).expectedQuery(WindowOperatorQueryBuilder.builder().setDataSource((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.DAY).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).context(OUTER_LIMIT_CONTEXT).build()).setSignature(RowSignature.builder().add("d0", ColumnType.LONG).add("a0", ColumnType.LONG).add("w0", ColumnType.LONG).build()).setOperators(new OperatorFactory[]{OperatorFactoryBuilders.naivePartitionOperator(new String[0]), OperatorFactoryBuilders.windowOperators(OperatorFactoryBuilders.framedAggregateProcessor(WindowFrame.forOrderBy((String[])new String[]{"d0"}), new AggregatorFactory[]{new LongSumAggregatorFactory("w0", "a0")}))}).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L, 1L}, (Object)new Object[]{946771200000L, 1L, 2L}, (Object)new Object[]{946857600000L, 1L, 3L}, (Object)new Object[]{978307200000L, 1L, 4L}, (Object)new Object[]{978393600000L, 1L, 5L}, (Object)new Object[]{978480000000L, 1L, 6L})).run();
    }

    @Test
    public void testScanAndSortOnJoin() {
        this.msqIncompatible();
        this.testBuilder().sql("with main as (select dim1 as pickup,count(*) as cnt from foo group by 1 order by 2 desc limit 200),compare0 as (select dim1 as pickup,count(*) as cnt from numfoo group by 1 order by 2 desc limit 200) SELECT  main.pickup, main.cnt, coalesce(compare0.cnt,0) as prevCount, safe_divide(100.0 * (main.cnt - compare0.cnt), compare0.cnt) as delta from main left join compare0 on main.pickup is not distinct from compare0.pickup order by delta desc").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L, 1L, 0.0}, (Object)new Object[]{"1", 1L, 1L, 0.0}, (Object)new Object[]{"10.1", 1L, 1L, 0.0}, (Object)new Object[]{"2", 1L, 1L, 0.0}, (Object)new Object[]{"abc", 1L, 1L, 0.0}, (Object)new Object[]{"def", 1L, 1L, 0.0})).run();
    }

    @NotYetSupported(value={NotYetSupported.Modes.DD_WINDOW})
    @Test
    public void testWindowingOverJoin() {
        this.testBuilder().sql("with main as (select dim1 as pickup,count(*) as cnt from foo group by 1 order by 2 desc limit 200),compare0 as (select dim1 as pickup,count(*) as cnt from numfoo group by 1 order by 2 desc limit 200) SELECT  main.pickup, main.cnt, compare0.cnt, SUM(main.cnt) OVER (ORDER BY main.pickup)from main left join compare0 on main.pickup is not distinct from compare0.pickup ").queryContext((Map<String, Object>)ImmutableMap.of((Object)"debug", (Object)true)).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L, 1L, 1L}, (Object)new Object[]{"1", 1L, 1L, 2L}, (Object)new Object[]{"10.1", 1L, 1L, 3L}, (Object)new Object[]{"2", 1L, 1L, 4L}, (Object)new Object[]{"abc", 1L, 1L, 5L}, (Object)new Object[]{"def", 1L, 1L, 6L})).run();
    }

    @Test
    public void testCastCharToVarcharInFlattenConcat() {
        this.testQuery("select 'A'||cast(col as char)||'B' from (values(1)) as t(col)", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"A1B"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"A1B"}));
    }

    @Test
    public void testFilterParseLongNullable() {
        this.testQuery("select count(*) from druid.foo where parse_long(dim1, 10) is null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "parse_long(\"dim1\",10)", ColumnType.LONG)}).filters(CalciteQueryTest.isNull("v0")).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testLatestByAggregatorOnSecondaryTimestampGroupBy() {
        this.msqIncompatible();
        this.testQuery("SELECT __time, m1, LATEST_BY(m1, MILLIS_TO_TIMESTAMP(CAST(m2 AS NUMERIC))) from druid.numfoo GROUP BY 1,2", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0", "m1", "m2")})).setContext(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), Float.valueOf(1.0f)}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), Float.valueOf(2.0f)}, (Object)new Object[]{946857600000L, Float.valueOf(3.0f), Float.valueOf(3.0f)}, (Object)new Object[]{978307200000L, Float.valueOf(4.0f), Float.valueOf(4.0f)}, (Object)new Object[]{978393600000L, Float.valueOf(5.0f), Float.valueOf(5.0f)}, (Object)new Object[]{978480000000L, Float.valueOf(6.0f), Float.valueOf(6.0f)}));
    }

    @Test
    public void testIpv4ParseWithNullableType() {
        this.testQuery("select ipv4_parse('1.2.3') from (values(1)) as t(col)", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}));
    }

    @Test
    public void testIpv4ParseWithBigintOutput() {
        this.testQuery("select ipv4_parse('192.168.0.1') from (values(1)) as t(col)", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L}), (RowSignature)RowSignature.builder().add("col", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "3232235521", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3232235521L}));
    }

    @Test
    public void testBitwiseXor() {
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("select count(*) from (\n  select __time, cityName, bit_xor(cityName) c2\n  from wikipedia\n  group by __time, cityName\n  having bit_xor(cityName) is null\n)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)new GroupByQuery.Builder().setDataSource("wikipedia").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("cityName", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"cityName"), "__acc", "0", "0", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"cityName\")", "bitwiseXor(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteQueryTest.notNull("cityName"))})).setHavingSpec((HavingSpec)CalciteQueryTest.having(CalciteQueryTest.isNull("a0"))).setContext(OUTER_LIMIT_CONTEXT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{37091L}));
    }

    @Test
    public void testStringOperationsNullableInference() {
        this.testBuilder().sql("SELECT ICONTAINS_STRING(dim3, 'a'), REGEXP_LIKE(dim3,'x'), SUBSTRING(dim3, 1, 1) from druid.numfoo where dim3 is NULL LIMIT 1").queryContext(QUERY_CONTEXT_LOS_ANGELES).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "null", ColumnType.LONG, ExprMacroTable.nil()), new ExpressionVirtualColumn("v1", "null", ColumnType.STRING, ExprMacroTable.nil())}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).filters(CalciteQueryTest.isNull("dim3")).limit(1L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_LOS_ANGELES).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null})).run();
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=4)
    @Test
    public void testGroupingSetsWithAggregateCase() {
        this.cannotVectorizeUnlessFallback();
        this.msqIncompatible();
        ImmutableMap queryContext = ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)false, (Object)"useGroupingSetForExactDistinct", (Object)true);
        this.testBuilder().sql("SELECT\n  TIME_FLOOR(\"__time\", 'PT1H') ,\n  COUNT(DISTINCT \"page\") ,\n  COUNT(DISTINCT CASE WHEN \"channel\" = '#it.wikipedia' THEN \"user\" END), \n  COUNT(DISTINCT \"user\") FILTER (WHERE \"channel\" = '#it.wikipedia'),   COUNT(DISTINCT \"user\") \nFROM \"wikipedia\"\nGROUP BY 1").queryContext((Map<String, Object>)queryContext).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1442016000000L, 264L, 5L, 5L, 149L}, (Object)new Object[]{1442019600000L, 1090L, 14L, 14L, 506L}, (Object)new Object[]{1442023200000L, 1045L, 10L, 10L, 459L}, (Object)new Object[]{1442026800000L, 766L, 10L, 10L, 427L}, (Object)new Object[]{1442030400000L, 781L, 6L, 6L, 427L}, (Object)new Object[]{1442034000000L, 1223L, 10L, 10L, 448L}, (Object)new Object[]{1442037600000L, 2092L, 13L, 13L, 498L}, (Object)new Object[]{1442041200000L, 2181L, 21L, 21L, 574L}, (Object)new Object[]{1442044800000L, 1552L, 36L, 36L, 707L}, (Object)new Object[]{1442048400000L, 1624L, 44L, 44L, 770L}, (Object)new Object[]{1442052000000L, 1710L, 37L, 37L, 785L}, (Object)new Object[]{1442055600000L, 1532L, 40L, 40L, 799L}, (Object[])new Object[][]{{1442059200000L, 1633L, 45L, 45L, 855L}, {1442062800000L, 1958L, 44L, 44L, 905L}, {1442066400000L, 1779L, 48L, 48L, 886L}, {1442070000000L, 1868L, 37L, 37L, 949L}, {1442073600000L, 1846L, 50L, 50L, 969L}, {1442077200000L, 2168L, 38L, 38L, 941L}, {1442080800000L, 2043L, 40L, 40L, 925L}, {1442084400000L, 1924L, 32L, 32L, 930L}, {1442088000000L, 1736L, 31L, 31L, 882L}, {1442091600000L, 1672L, 40L, 40L, 861L}, {1442095200000L, 1504L, 28L, 28L, 716L}, {1442098800000L, 1407L, 20L, 20L, 631L}})).run();
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testGroupingSetsWithDifferentOrderLimitSpec() {
        this.msqIncompatible();
        this.testBuilder().sql("SELECT\n  isNew, isRobot, COUNT(*) AS \"Cnt\"\nFROM \"wikipedia\"\nGROUP BY GROUPING SETS ((isRobot), (isNew))\nORDER BY 2, 1\nlimit 100").expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{"false", null, 36966L}, (Object)new Object[]{"true", null, 2278L}, (Object)new Object[]{null, "false", 23824L}, (Object)new Object[]{null, "true", 15420L})).run();
    }

    @Test
    public void testMultiStatementSetsContext() {
        HashMap<String, Object> expectedContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        expectedContext.put("useApproximateCountDistinct", true);
        expectedContext.put("timeout", 9000.0);
        expectedContext.put("vectorize", "force");
        expectedContext.put("sqlQueryId", "dummy2");
        this.testBuilder().sql("set useApproximateCountDistinct = TRUE; set timeout = 90000; set vectorize = 'force'; set sqlQueryId = 'dummy2'; select 3;;;").expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable(List.of(new Object[]{3L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(expectedContext).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{3})).run();
    }

    @Test
    public void testMultiStatementSetsContextTimezone() {
        this.testBuilder().sql("SET sqlTimeZone = 'America/Los_Angeles';\nSELECT\nEXTRACT(YEAR FROM FLOOR(__time TO YEAR)) AS \"year\", SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM FLOOR(__time TO YEAR))").expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(timestamp_floor(\"__time\",'P1Y',null,'America/Los_Angeles'),'YEAR','America/Los_Angeles')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_LOS_ANGELES).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1999L, 1L}, (Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 2L})).run();
    }

    @Test
    public void testMultiStatementSetsInvalidNoNonSetStatement() {
        this.testQueryThrows("set useApproximateCountDistinct = TRUE; set timeout = 90000", DruidException.class, "Statement list is missing a non-SET statement to execute");
    }

    @Test
    public void testMultiStatementSetsInvalidRegularStatementInMiddle() {
        this.testQueryThrows("set useApproximateCountDistinct = TRUE; SELECT 1 + 1; set timeout = 90000", DruidException.class, "Only SET statements can appear before the final statement in a statement list, but found non-SET statement[SELECT 1 + 1]");
    }

    @Test
    public void testMultiStatementSetsInvalidSetNotLiteral() {
        this.testQueryThrows("set useApproximateCountDistinct = vectorize; SELECT 1 + 1;", DruidException.class, "Assigned value must be a literal for SET statement[SET \"useApproximateCountDistinct\" = \"vectorize\"]");
    }

    @Test
    public void testMultiStatementSetsInvalidTooManyNonSetStatements() {
        this.testQueryThrows("set useApproximateCountDistinct = TRUE; set timeout = 90000; select 1; select 2", DruidException.class, "Only SET statements can appear before the final statement in a statement list, but found non-SET statement[SELECT 1]");
    }

    @Test
    public void testSetUseApproximateCountDistinctFalse() {
        this.testBuilder().sql("SET useApproximateCountDistinct = FALSE;\nSELECT COUNT(DISTINCT dim2) FROM druid.foo").expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext((Map)ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"useApproximateCountDistinct", (Object)false).build()).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteQueryTest.notNull("d0"))})).setContext((Map)ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"useApproximateCountDistinct", (Object)false).build()).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{3L})).run();
    }
}

