/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.ResourceInputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ArrayContainsElementFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=NestedComponentSupplier.class)
public class CalciteNestedDataQueryTest
extends BaseCalciteQueryTest {
    public static final String DATA_SOURCE = "nested";
    public static final String DATA_SOURCE_MIXED = "nested_mix";
    public static final String DATA_SOURCE_MIXED_2 = "nested_mix_2";
    public static final String DATA_SOURCE_ARRAYS = "arrays";
    public static final String DATA_SOURCE_ALL = "all_auto";
    public static final String DATA_SOURCE_ALL_REALTIME = "all_auto_realtime";
    public static final List<ImmutableMap<String, Object>> RAW_ROWS = ImmutableList.of((Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"string", (Object)"aaa").put((Object)"string_sparse", (Object)"zzz").put((Object)"nest", (Object)ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)2.02, (Object)"z", (Object)"300", (Object)"mixed", (Object)1L, (Object)"mixed2", (Object)"1")).put((Object)"nester", (Object)ImmutableMap.of((Object)"array", (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)"n", (Object)ImmutableMap.of((Object)"x", (Object)"hello"))).put((Object)"long", (Object)5L).build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"string", (Object)"bbb").put((Object)"long", (Object)4L).put((Object)"nester", (Object)"hello").build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"string", (Object)"ccc").put((Object)"string_sparse", (Object)"10").put((Object)"nest", (Object)ImmutableMap.of((Object)"x", (Object)200L, (Object)"y", (Object)3.03, (Object)"z", (Object)"abcdef", (Object)"mixed", (Object)1.1, (Object)"mixed2", (Object)1L)).put((Object)"long", (Object)3L).build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"string", (Object)"ddd").put((Object)"string_sparse", (Object)"yyy").put((Object)"long", (Object)2L).build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"string", (Object)"eee").put((Object)"long", (Object)1L).build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-02").put((Object)"string", (Object)"aaa").put((Object)"nest", (Object)ImmutableMap.of((Object)"x", (Object)100L, (Object)"y", (Object)2.02, (Object)"z", (Object)"400", (Object)"mixed2", (Object)1.1)).put((Object)"nester", (Object)ImmutableMap.of((Object)"array", (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)"n", (Object)ImmutableMap.of((Object)"x", (Object)1L))).put((Object)"long", (Object)5L).build(), (Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-02").put((Object)"string", (Object)"ddd").put((Object)"long", (Object)2L).put((Object)"nester", (Object)2L).build());
    public static final InputRowSchema ALL_JSON_COLUMNS = new InputRowSchema(new TimestampSpec("t", "iso", null), DimensionsSpec.builder().setDimensions((List)ImmutableList.builder().add((Object)AutoTypeColumnSchema.of((String)"string")).add((Object)AutoTypeColumnSchema.of((String)"nest")).add((Object)AutoTypeColumnSchema.of((String)"nester")).add((Object)AutoTypeColumnSchema.of((String)"long")).add((Object)AutoTypeColumnSchema.of((String)"string_sparse")).build()).build(), null);
    public static final InputRowSchema JSON_AND_SCALAR_MIX = new InputRowSchema(new TimestampSpec("t", "iso", null), DimensionsSpec.builder().setDimensions((List)ImmutableList.builder().add((Object)new StringDimensionSchema("string")).add((Object)AutoTypeColumnSchema.of((String)"nest")).add((Object)AutoTypeColumnSchema.of((String)"nester")).add((Object)new LongDimensionSchema("long")).add((Object)new StringDimensionSchema("string_sparse")).build()).build(), null);
    public static final List<InputRow> ROWS = RAW_ROWS.stream().map(raw -> TestDataBuilder.createRow(raw, ALL_JSON_COLUMNS)).collect(Collectors.toList());
    public static final List<InputRow> ROWS_MIX = RAW_ROWS.stream().map(raw -> TestDataBuilder.createRow(raw, JSON_AND_SCALAR_MIX)).collect(Collectors.toList());

    @Test
    public void testGroupByPath() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupJsonValueAny() {
        this.testQuery("SELECT JSON_VALUE_ANY(nest, '$.x'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", null)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByJsonValue() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testTopNPath() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested GROUP BY 1 LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_LEXICOGRAPHIC_TOPN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).dimension((DimensionSpec)new DefaultDimensionSpec("v0", "d0")).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_LEXICOGRAPHIC_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}));
    }

    @Test
    public void testGroupByOnNestedColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}, (Object)new Object[]{"2", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}", 3L}));
    }

    @Test
    public void testGroupByOnNestedColumnWithOrderBy() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}, (Object)new Object[]{"2", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}", 3L}));
    }

    @Test
    public void testGroupByOnNestedColumnWithOrderByAndLimit() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1 ORDER BY 1 LIMIT 100", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NATURAL)), Integer.valueOf(100))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}, (Object)new Object[]{"2", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}", 3L}));
    }

    @Test
    public void testGroupByOnNestedColumnWithOrderByAndLimit2() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1 ORDER BY 1 LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NATURAL)), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}));
    }

    @Test
    public void testGroupByOnNestedColumnWithLimit() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1 LIMIT 100", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(100))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}, (Object)new Object[]{"2", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}", 3L}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}", 3L}));
    }

    @Test
    public void testGroupByOnNestedColumnWithLimit2() {
        this.cannotVectorize();
        this.testQuery("SELECT nester, SUM(strlen(string)) FROM druid.nested GROUP BY 1 LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "strlen(\"string\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("nester", "d0", ColumnType.NESTED_DATA)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"\"hello\"", 3L}));
    }

    @Test
    public void testGroupByRootPath() {
        this.testQuery("SELECT JSON_VALUE(nester, '$'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"hello", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeLong() {
        this.testQuery("SELECT long, SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L}, (Object)new Object[]{2L, 2L}, (Object)new Object[]{3L, 1L}, (Object)new Object[]{4L, 1L}, (Object)new Object[]{5L, 2L}), RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeString() {
        this.testQuery("SELECT string, SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"aaa", 2L}, (Object)new Object[]{"bbb", 1L}, (Object)new Object[]{"ccc", 1L}, (Object)new Object[]{"ddd", 2L}, (Object)new Object[]{"eee", 1L}), RowSignature.builder().add("string", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeLongMixed1() {
        this.testQuery("SELECT long, SUM(cnt) FROM druid.nested_mix GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 2L}, (Object)new Object[]{2L, 4L}, (Object)new Object[]{3L, 2L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{5L, 4L}), RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed1() {
        this.testQuery("SELECT string, SUM(cnt) FROM druid.nested_mix GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"aaa", 4L}, (Object)new Object[]{"bbb", 2L}, (Object)new Object[]{"ccc", 2L}, (Object)new Object[]{"ddd", 4L}, (Object)new Object[]{"eee", 2L}), RowSignature.builder().add("string", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed1Sparse() {
        this.testQuery("SELECT string_sparse, SUM(cnt) FROM druid.nested_mix GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string_sparse", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"10", 2L}, (Object)new Object[]{"yyy", 2L}, (Object)new Object[]{"zzz", 2L}), RowSignature.builder().add("string_sparse", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeLongMixed2() {
        this.testQuery("SELECT long, SUM(cnt) FROM druid.nested_mix_2 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED_2).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 2L}, (Object)new Object[]{2L, 4L}, (Object)new Object[]{3L, 2L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{5L, 4L}), RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed2() {
        this.testQuery("SELECT string, SUM(cnt) FROM druid.nested_mix_2 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED_2).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"aaa", 4L}, (Object)new Object[]{"bbb", 2L}, (Object)new Object[]{"ccc", 2L}, (Object)new Object[]{"ddd", 4L}, (Object)new Object[]{"eee", 2L}), RowSignature.builder().add("string", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed2Sparse() {
        this.testQuery("SELECT string_sparse, SUM(cnt) FROM druid.nested_mix_2 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED_2).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string_sparse", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"10", 2L}, (Object)new Object[]{"yyy", 2L}, (Object)new Object[]{"zzz", 2L}), RowSignature.builder().add("string_sparse", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed2SparseJsonValueNonExistentPath() {
        this.msqIncompatible();
        this.testQuery("SELECT JSON_VALUE(string_sparse, '$[1]'), SUM(cnt) FROM druid.nested_mix_2 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED_2).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("string_sparse", "$[1]", "v0", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 14L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testJsonValueArrays() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayString, '$' RETURNING VARCHAR ARRAY), JSON_VALUE(arrayLong, '$' RETURNING BIGINT ARRAY), JSON_VALUE(arrayDouble, '$' RETURNING DOUBLE ARRAY), JSON_VALUE(arrayNestedLong, '$[0]' RETURNING BIGINT ARRAY) FROM druid.arrays").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ARRAYS).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayString", "$", "v0", ColumnType.STRING_ARRAY), new NestedFieldVirtualColumn("arrayLong", "$", "v1", ColumnType.LONG_ARRAY), new NestedFieldVirtualColumn("arrayDouble", "$", "v2", ColumnType.DOUBLE_ARRAY), new NestedFieldVirtualColumn("arrayNestedLong", "$[0]", "v3", ColumnType.LONG_ARRAY)}).columns(new String[]{"v0", "v1", "v2", "v3"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.DOUBLE_ARRAY, ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, Arrays.asList(1L, 2L, 3L), Arrays.asList(1.1, 2.2, 3.3), null}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{Arrays.asList("d", "e"), Arrays.asList(1L, 4L), Arrays.asList(2.2, 3.3, 4.0), Arrays.asList(1L, 2L)}, (Object)new Object[]{Arrays.asList("a", "b"), null, null, Collections.singletonList(1L)}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, 2L, 3L), Arrays.asList(1.1, 2.2, 3.3), Arrays.asList(1L, 2L, null)}, (Object)new Object[]{Arrays.asList("b", "c"), Arrays.asList(1L, 2L, 3L, 4L), Arrays.asList(1.1, 3.3), Collections.singletonList(1L)}, (Object)new Object[]{Arrays.asList("a", "b", "c"), Arrays.asList(2L, 3L), Arrays.asList(3.3, 4.4, 5.5), null}, (Object)new Object[]{null, Arrays.asList(1L, 2L, 3L), Arrays.asList(1.1, 2.2, 3.3), null}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{Arrays.asList("d", "e"), Arrays.asList(1L, 4L), Arrays.asList(2.2, 3.3, 4.0), Arrays.asList(1L, 2L)}, (Object)new Object[]{Arrays.asList("a", "b"), null, null, null}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, 2L, 3L), Arrays.asList(1.1, 2.2, 3.3), Arrays.asList(2L, 3L)}, (Object[])new Object[][]{{Arrays.asList("b", "c"), Arrays.asList(1L, 2L, 3L, 4L), Arrays.asList(1.1, 3.3), Collections.singletonList(1L)}, {Arrays.asList("a", "b", "c"), Arrays.asList(2L, 3L), Arrays.asList(3.3, 4.4, 5.5), null}})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG_ARRAY).add("EXPR$2", ColumnType.DOUBLE_ARRAY).add("EXPR$3", ColumnType.LONG_ARRAY).build()).run();
    }

    @Test
    public void testUnnestRootSingleTypeArrayLongNulls() {
        this.testBuilder().sql("SELECT longs FROM druid.arrays, UNNEST(arrayLongNulls) as u(longs)").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null)).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{null}, (Object)new Object[]{2L}, (Object)new Object[]{9L}, (Object)new Object[]{1L}, (Object)new Object[]{null}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object[])new Object[][]{{2L}, {3L}, {null}, {null}, {2L}, {9L}, {1L}, {null}, {3L}, {1L}, {2L}, {3L}})).expectedSignature(RowSignature.builder().add("longs", ColumnType.LONG).build()).run();
    }

    @Test
    public void testUnnestRootSingleTypeArrayStringNulls() {
        this.testBuilder().sql("SELECT strings FROM druid.arrays, UNNEST(arrayStringNulls) as u(strings)").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null)).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"d"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object[])new Object[][]{{"b"}, {"b"}, {"b"}, {null}, {"d"}, {null}, {"b"}, {null}, {"b"}})).expectedSignature(RowSignature.builder().add("strings", ColumnType.STRING).build()).run();
    }

    @Test
    public void testUnnestRootSingleTypeArrayDoubleNulls() {
        this.testBuilder().sql("SELECT doubles FROM druid.arrays, UNNEST(arrayDoubleNulls) as u(doubles)").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), null)).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{999.0}, (Object)new Object[]{5.5}, (Object)new Object[]{null}, (Object)new Object[]{1.1}, (Object)new Object[]{2.2}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{2.2}, (Object)new Object[]{null}, (Object)new Object[]{999.0}, (Object)new Object[]{null}, (Object[])new Object[][]{{5.5}, {null}, {1.1}, {999.0}, {5.5}, {null}, {1.1}, {2.2}, {null}, {null}, {2.2}, {null}, {999.0}, {null}, {5.5}})).expectedSignature(RowSignature.builder().add("doubles", ColumnType.DOUBLE).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLong() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLong, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLong", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L), 4L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L, 4L), 2L}, (Object)new Object[]{Arrays.asList(1L, 4L), 2L}, (Object)new Object[]{Arrays.asList(2L, 3L), 2L})).expectedSignature(RowSignature.builder().add("arrayLong", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongFilteredArrayEquality() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLong, SUM(cnt) FROM druid.arrays WHERE arrayLong = ARRAY[1, 2, 3] GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)new EqualityFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, null)).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLong", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList(1L, 2L, 3L), 4L})).expectedSignature(RowSignature.builder().add("arrayLong", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNulls() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLongNulls, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLongNulls", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Arrays.asList(null, 2L, 9L), 2L}, (Object)new Object[]{Collections.singletonList(1L), 1L}, (Object)new Object[]{Arrays.asList(1L, null, 3L), 2L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L), 2L}, (Object)new Object[]{Arrays.asList(2L, 3L), 2L})).expectedSignature(RowSignature.builder().add("arrayLongNulls", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeLongJsonValueFilter() {
        this.testQuery("SELECT long, SUM(cnt) FROM druid.nested WHERE JSON_VALUE(long, '$.') = '1' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("long", "v0", ColumnType.STRING, Collections.emptyList(), Boolean.valueOf(false), null, Boolean.valueOf(false))}).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "1", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L}), RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsFilteredArrayEquality() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLongNulls, SUM(cnt) FROM druid.arrays WHERE arrayLongNulls = ARRAY[null, 2, 9] OR arrayLongNulls IS NULL GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteNestedDataQueryTest.or(CalciteNestedDataQueryTest.equality("arrayLongNulls", new Object[]{null, 2L, 9L}, ColumnType.LONG_ARRAY), CalciteNestedDataQueryTest.isNull("arrayLongNulls"))).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLongNulls", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Arrays.asList(null, 2L, 9L), 2L})).expectedSignature(RowSignature.builder().add("arrayLongNulls", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsUnnest() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT longs, SUM(cnt) FROM druid.arrays, UNNEST(arrayLongNulls) as u (longs) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQuery((Query<?>)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{1L, 5L}, (Object)new Object[]{2L, 6L}, (Object)new Object[]{3L, 6L}, (Object)new Object[]{9L, 2L})).expectedSignature(RowSignature.builder().add("longs", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsFiltered() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLongNulls, SUM(cnt), SUM(ARRAY_LENGTH(arrayLongNulls)) FROM druid.arrays WHERE ARRAY_CONTAINS(arrayLongNulls, 1) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLongNulls", "d0", ColumnType.LONG_ARRAY)})).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array_length(\"arrayLongNulls\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimFilter((DimFilter)new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)1, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new LongSumAggregatorFactory("a1", "v0")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(1L), 1L, 1L}, (Object)new Object[]{Arrays.asList(1L, null, 3L), 2L, 6L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L), 2L, 6L})).expectedSignature(RowSignature.builder().add("arrayLongNulls", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsFilteredMore() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayLongNulls, SUM(cnt) FROM druid.arrays WHERE ARRAY_CONTAINS(arrayLongNulls, 1) OR ARRAY_OVERLAP(arrayLongNulls, ARRAY[2, 3]) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLongNulls", "d0", ColumnType.LONG_ARRAY)})).setDimFilter((DimFilter)CalciteNestedDataQueryTest.or(new DimFilter[]{new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)1L, null), new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)2L, null), new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)3L, null)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList(null, 2L, 9L), 2L}, (Object)new Object[]{Collections.singletonList(1L), 1L}, (Object)new Object[]{Arrays.asList(1L, null, 3L), 2L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L), 2L}, (Object)new Object[]{Arrays.asList(2L, 3L), 2L})).expectedSignature(RowSignature.builder().add("arrayLongNulls", ColumnType.LONG_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayString() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayString, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayString", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{Arrays.asList("a", "b"), 4L}, (Object)new Object[]{Arrays.asList("a", "b", "c"), 2L}, (Object)new Object[]{Arrays.asList("b", "c"), 2L}, (Object)new Object[]{Arrays.asList("d", "e"), 2L})).expectedSignature(RowSignature.builder().add("arrayString", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringNulls() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayStringNulls, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayStringNulls", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Arrays.asList(null, "b"), 2L}, (Object)new Object[]{Arrays.asList("a", "b"), 3L}, (Object)new Object[]{Arrays.asList("b", "b"), 2L}, (Object)new Object[]{Arrays.asList("d", null, "b"), 2L})).expectedSignature(RowSignature.builder().add("arrayStringNulls", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringNullsUnnest() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT strings, SUM(cnt) FROM druid.arrays, unnest(arrayStringNulls) as u (strings) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"a", 3L}, (Object)new Object[]{"b", 11L}, (Object)new Object[]{"d", 2L})).expectedSignature(RowSignature.builder().add("strings", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringNullsFiltered() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayStringNulls, SUM(cnt), SUM(ARRAY_LENGTH(arrayStringNulls)) FROM druid.arrays WHERE ARRAY_CONTAINS(arrayStringNulls, 'b') GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayStringNulls", "d0", ColumnType.STRING_ARRAY)})).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array_length(\"arrayStringNulls\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimFilter((DimFilter)new ArrayContainsElementFilter("arrayStringNulls", ColumnType.STRING, (Object)"b", null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new LongSumAggregatorFactory("a1", "v0")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList(null, "b"), 2L, 4L}, (Object)new Object[]{Arrays.asList("a", "b"), 3L, 6L}, (Object)new Object[]{Arrays.asList("b", "b"), 2L, 4L}, (Object)new Object[]{Arrays.asList("d", null, "b"), 2L, 6L})).expectedSignature(RowSignature.builder().add("arrayStringNulls", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDouble() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayDouble, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayDouble", "d0", ColumnType.DOUBLE_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{Arrays.asList(1.1, 2.2, 3.3), 4L}, (Object)new Object[]{Arrays.asList(1.1, 3.3), 2L}, (Object)new Object[]{Arrays.asList(2.2, 3.3, 4.0), 2L}, (Object)new Object[]{Arrays.asList(3.3, 4.4, 5.5), 2L})).expectedSignature(RowSignature.builder().add("arrayDouble", ColumnType.DOUBLE_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDoubleNulls() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayDoubleNulls, SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayDoubleNulls", "d0", ColumnType.DOUBLE_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Arrays.asList(null, 1.1), 1L}, (Object)new Object[]{Arrays.asList(null, 2.2, null), 2L}, (Object)new Object[]{Arrays.asList(1.1, 2.2, null), 2L}, (Object)new Object[]{Arrays.asList(999.0, null, 5.5), 2L}, (Object)new Object[]{Arrays.asList(999.0, 5.5, null), 2L})).expectedSignature(RowSignature.builder().add("arrayDoubleNulls", ColumnType.DOUBLE_ARRAY).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDoubleNullsUnnest() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT doubles, SUM(cnt) FROM druid.arrays, UNNEST(arrayDoubleNulls) as u (doubles) GROUP BY doubles").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), null)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.DOUBLE)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 12L}, (Object)new Object[]{1.1, 3L}, (Object)new Object[]{2.2, 4L}, (Object)new Object[]{5.5, 4L}, (Object)new Object[]{999.0, 4L})).expectedSignature(RowSignature.builder().add("doubles", ColumnType.DOUBLE).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDoubleNullsFiltered() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT arrayDoubleNulls, SUM(cnt), SUM(ARRAY_LENGTH(arrayDoubleNulls)) FROM druid.arrays WHERE ARRAY_CONTAINS(arrayDoubleNulls, 2.2)GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayDoubleNulls", "d0", ColumnType.DOUBLE_ARRAY)})).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array_length(\"arrayDoubleNulls\")", ColumnType.LONG, this.queryFramework().macroTable())}).setDimFilter((DimFilter)new ArrayContainsElementFilter("arrayDoubleNulls", ColumnType.DOUBLE, (Object)2.2, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new LongSumAggregatorFactory("a1", "v0")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList(null, 2.2, null), 2L, 6L}, (Object)new Object[]{Arrays.asList(1.1, 2.2, null), 2L, 6L})).expectedSignature(RowSignature.builder().add("arrayDoubleNulls", ColumnType.DOUBLE_ARRAY).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongElement() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayLong, '$[1]' RETURNING BIGINT),SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[1]", "v0", ColumnType.LONG)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{2L, 6L}, (Object)new Object[]{3L, 2L}, (Object)new Object[]{4L, 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongElementFiltered() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayLong, '$[1]' RETURNING BIGINT),SUM(cnt) FROM druid.arrays WHERE JSON_VALUE(arrayLong, '$[1]' RETURNING BIGINT) = 2GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[1]", "v0", ColumnType.LONG)}).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 2L, ColumnType.LONG)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{2L, 6L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongElementDefault() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayLong, '$[1]'),SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[1]", "v0", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"2", 6L}, (Object)new Object[]{"3", 2L}, (Object)new Object[]{"4", 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringElement() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayStringNulls, '$[1]'),SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayStringNulls", "$[1]", "v0", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 7L}, (Object)new Object[]{"b", 7L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringElementFiltered() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayStringNulls, '$[1]'),SUM(cnt) FROM druid.arrays WHERE JSON_VALUE(arrayStringNulls, '$[1]') = 'b'GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayStringNulls", "$[1]", "v0", ColumnType.STRING)}).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "b", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 7L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDoubleElement() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayDoubleNulls, '$[2]' RETURNING DOUBLE),SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.DOUBLE)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayDoubleNulls", "$[2]", "v0", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 12L}, (Object)new Object[]{5.5, 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayDoubleElementFiltered() {
        this.testBuilder().sql("SELECT JSON_VALUE(arrayDoubleNulls, '$[2]' RETURNING DOUBLE),SUM(cnt) FROM druid.arrays WHERE JSON_VALUE(arrayDoubleNulls, '$[2]' RETURNING DOUBLE) = 5.5GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.DOUBLE)})).setDimFilter((DimFilter)new EqualityFilter("v0", ColumnType.DOUBLE, (Object)5.5, null)).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayDoubleNulls", "$[2]", "v0", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{5.5, 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByJsonValues() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), JSON_VALUE(nest, '$[''x'']'), SUM(cnt) FROM druid.nested GROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v0", "d1")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, 4L}, (Object)new Object[]{"100", "100", 2L}, (Object)new Object[]{"200", "200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.STRING).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilter() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') = '100' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "100", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterCoalesce() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE COALESCE(JSON_VALUE(nest, '$.x'), '0') = '100' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter((DimFilter)CalciteNestedDataQueryTest.expressionFilter("case_searched(notnull(json_value(\"nest\",'$.x', 'STRING')),(json_value(\"nest\",'$.x', 'STRING') == '100'),0)")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testJsonAndArrayAgg() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT string, ARRAY_AGG(nest, 16384), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"nest"), "__acc", "ARRAY<COMPLEX<json>>[]", "ARRAY<COMPLEX<json>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"nest\")", "array_concat(\"__acc\", \"a0\")", null, null, HumanReadableBytes.valueOf((int)16384), this.queryFramework().macroTable()), new LongSumAggregatorFactory("a1", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"aaa", "[{\"x\":100,\"y\":2.02,\"z\":\"300\",\"mixed\":1,\"mixed2\":\"1\"},{\"x\":100,\"y\":2.02,\"z\":\"400\",\"mixed2\":1.1}]", 2L}, (Object)new Object[]{"bbb", "[null]", 1L}, (Object)new Object[]{"ccc", "[{\"x\":200,\"y\":3.03,\"z\":\"abcdef\",\"mixed\":1.1,\"mixed2\":1}]", 1L}, (Object)new Object[]{"ddd", "[null,null]", 2L}, (Object)new Object[]{"eee", "[null]", 1L}), RowSignature.builder().add("string", ColumnType.STRING).add("EXPR$1", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterLong() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') = 100 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 100L, ColumnType.LONG)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterDouble() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') = 2.02 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 2.02, ColumnType.DOUBLE)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterString() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') = '400' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "400", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x') = 1 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 1L, ColumnType.LONG)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant2() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.mixed2') = '1' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed2", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "1", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant2Int() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.mixed2') = 1 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed2", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 1L, ColumnType.LONG)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant2Double() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.mixed2') = 1.1 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed2", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", 1.1, ColumnType.DOUBLE)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant2BothTypesMatcher() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.mixed2') = '1' OR JSON_VALUE(nest, '$.mixed2') = 1 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed2", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.mixed2", "v1", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v2", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v2", "d0")})).setDimFilter((DimFilter)CalciteNestedDataQueryTest.or(CalciteNestedDataQueryTest.equality("v0", "1", ColumnType.STRING), CalciteNestedDataQueryTest.equality("v1", 1L, ColumnType.LONG))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariant3() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.mixed2') in ('1', '1.1') GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed2", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.in("v0", (Collection<String>)ImmutableList.of((Object)"1", (Object)"1.1"))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterNonExistent() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.missing') = 'no way' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.missing", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("v0", "no way", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of(), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterNull() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') IS NOT NULL GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.notNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLong() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') >= '100' AND JSON_VALUE(nest, '$.x') <= '300' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "100", "300", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLongNoUpper() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') >= '100' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "100", null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLongNoLower() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') <= '100' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, null, "100", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLongNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') >= 100 AND JSON_VALUE(nest, '$.x') <= 300 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, 100L, 300L, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLongNoUpperNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') >= 100 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, 100L, null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathNumericBoundFilterLongNoUpperNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x' RETURNING BIGINT),SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x' RETURNING BIGINT) >= 100 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, 100L, null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{100L, 2L}, (Object)new Object[]{200L, 1L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterLongNoLowerNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') <= 100 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, null, 100L, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterDouble() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') >= '1.01' AND JSON_VALUE(nest, '$.y') <= '3.03' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "1.01", "3.03", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}, (Object)new Object[]{"3.03", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterDoubleNoUpper() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') >= '1.01' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "1.01", null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}, (Object)new Object[]{"3.03", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterDoubleNoLower() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') <= '2.02' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, null, "2.02", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundDoubleFilterNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') >= 2.0 AND JSON_VALUE(nest, '$.y') <= 3.5 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.y", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.DOUBLE, 2.0, 3.5, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}, (Object)new Object[]{"3.03", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterDoubleNoUpperNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') >= 1.0 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.y", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.DOUBLE, 1.0, null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}, (Object)new Object[]{"3.03", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterDoubleNoLowerNumeric() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.y'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') <= 2.02 GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.y", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.DOUBLE, null, 2.02, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2.02", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterString() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') >= '100' AND JSON_VALUE(nest, '$.x') <= '300' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "100", "300", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterStringNoUpper() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') >= '400' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, "400", null, false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathBoundFilterStringNoLower() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') <= '400' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.range("v0", ColumnType.STRING, null, "400", false, false)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathLikeFilter() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') LIKE '10%' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setDimFilter((DimFilter)new LikeDimFilter("v0", "10%", null, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathLikeFilterStringPrefix() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') LIKE '30%' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter((DimFilter)new LikeDimFilter("v0", "30%", null, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathLikeFilterString() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') LIKE '%00%' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter((DimFilter)new LikeDimFilter("v0", "%00%", null, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathLikeFilterVariant() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x') LIKE '%ell%' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter((DimFilter)new LikeDimFilter("v0", "%ell%", null, null)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathInFilter() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.x') in (100, 200) GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.in("v0", ColumnType.LONG, ImmutableList.of((Object)100L, (Object)200L))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathInFilterDouble() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.y') in (2.02, 3.03) GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.in("v0", ColumnType.DOUBLE, ImmutableList.of((Object)2.02, (Object)3.03))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathInFilterString() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nest, '$.z') in ('300', 'abcdef') GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.in("v0", (Collection<String>)ImmutableSet.of((Object)"300", (Object)"abcdef"))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathInFilterVariant() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x') in ('hello', 1) GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0")})).setDimFilter(CalciteNestedDataQueryTest.in("v0", (Collection<String>)ImmutableSet.of((Object)"hello", (Object)"1"))).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testSumPath() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x')) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{400.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testSumPathFilteredAggDouble() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x')) FILTER(WHERE((JSON_VALUE(nest, '$.y'))=2.02))FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a0", "v1"), CalciteNestedDataQueryTest.equality("v0", 2.02, ColumnType.DOUBLE))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{200.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testSumPathFilteredAggString() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x')) FILTER(WHERE((JSON_VALUE(nest, '$.z'))='300'))FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a0", "v1"), CalciteNestedDataQueryTest.equality("v0", "300", ColumnType.STRING))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{100.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testSumPathMixed() {
        this.skipVectorize();
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.mixed')) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.1}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testSumPathMixedFilteredAggLong() {
        this.skipVectorize();
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.mixed')) FILTER(WHERE((JSON_VALUE(nest, '$.mixed'))=1))FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.mixed", "v1", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a0", "v1"), CalciteNestedDataQueryTest.equality("v0", 1L, ColumnType.LONG))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.1}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testSumPathMixedFilteredAggDouble() {
        this.skipVectorize();
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.mixed')) FILTER(WHERE((JSON_VALUE(nest, '$.mixed'))=1.1))FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.mixed", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a0", "v0"), CalciteNestedDataQueryTest.equality("v0", 1.1, ColumnType.DOUBLE))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.1}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testCastAndSumPath() {
        this.testQuery("SELECT SUM(CAST(JSON_VALUE(nest, '$.x') as BIGINT)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{400L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testCastAndSumPathStrings() {
        this.testQuery("SELECT SUM(CAST(JSON_VALUE(nest, '$.z') as BIGINT)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{700L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testReturningAndSumPath() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x' RETURNING BIGINT)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{400L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testReturningAndSumPathWithMaths() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x' RETURNING BIGINT) / 100) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "(\"v1\" / 100)", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testReturningAndSumPathDouble() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x' RETURNING DOUBLE)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{400.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testReturningAndSumPathDecimal() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x' RETURNING DECIMAL)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{400.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testReturningAndSumPathDecimalWithMaths() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.x' RETURNING DECIMAL) / 100.0) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "(\"v1\" / 100.0)", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4.0}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testReturningAndSumPathStrings() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.z' RETURNING BIGINT)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{700L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootKeys() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_KEYS(nester, '$'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_keys(\"nester\",'$')", ColumnType.STRING_ARRAY, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"[\"array\",\"n\"]", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootKeysJsonPath() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_KEYS(nester, '$.'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_keys(\"nester\",'$.')", ColumnType.STRING_ARRAY, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"[\"array\",\"n\"]", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootKeys2() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_KEYS(nest, '$'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_keys(\"nest\",'$')", ColumnType.STRING_ARRAY, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"[\"x\",\"y\",\"z\",\"mixed\",\"mixed2\"]", 2L}, (Object)new Object[]{"[\"x\",\"y\",\"z\",\"mixed2\"]", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByCastedRootKeysJsonPath() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_KEYS(nester, CAST('$.' AS VARCHAR)), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_keys(\"nester\",'$.')", ColumnType.STRING_ARRAY, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"[\"array\",\"n\"]", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByAllPaths() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_PATHS(nester), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_paths(\"nester\")", ColumnType.STRING_ARRAY, this.queryFramework().macroTable())}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"$\"]", 5L}, (Object)new Object[]{"[\"$.array\",\"$.n.x\"]", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByNestedArrayPath() {
        this.testQuery("SELECT JSON_VALUE(nester, '$.array[1]'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.array[1]", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"b", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByInvalidPath() {
        this.testQueryThrows("SELECT JSON_VALUE(nester, '.array.[1]'), SUM(cnt) FROM druid.nested GROUP BY 1", DruidExceptionMatcher.invalidInput().expectMessageIs("JSONPath [.array.[1]] is invalid, it must start with '$'"));
    }

    @Test
    public void testJsonQuery() {
        this.testQuery("SELECT JSON_QUERY(nester, '$.n'), JSON_QUERY(nester, '$')\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "v0", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.n", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "v1", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.", Boolean.valueOf(false))}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.NESTED_DATA, ColumnType.NESTED_DATA}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"{\"x\":\"hello\"}", "{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}"}, (Object)new Object[]{null, "\"hello\""}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{"{\"x\":1}", "{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}"}, (Object)new Object[]{null, "2"}), RowSignature.builder().add("EXPR$0", ColumnType.NESTED_DATA).add("EXPR$1", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testJsonQueryAndJsonObject() {
        this.testQuery("SELECT JSON_OBJECT(KEY 'n' VALUE JSON_QUERY(nester, '$.n'), KEY 'x' VALUE JSON_VALUE(nest, '$.x'))\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_object('n',\"v1\",'x',\"v2\")", ColumnType.NESTED_DATA, this.queryFramework().macroTable()), new NestedFieldVirtualColumn("nester", "v1", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.n", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nest", "$.x", "v2", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.NESTED_DATA}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"{\"x\":\"100\",\"n\":{\"x\":\"hello\"}}"}, (Object)new Object[]{"{\"x\":null,\"n\":null}"}, (Object)new Object[]{"{\"x\":\"200\",\"n\":null}"}, (Object)new Object[]{"{\"x\":null,\"n\":null}"}, (Object)new Object[]{"{\"x\":null,\"n\":null}"}, (Object)new Object[]{"{\"x\":\"100\",\"n\":{\"x\":1}}"}, (Object)new Object[]{"{\"x\":null,\"n\":null}"}), RowSignature.builder().add("EXPR$0", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testJsonMerging() {
        this.testQuery("SELECT JSON_MERGE('{\"a\":\"x\"}',JSON_OBJECT(KEY 'x' VALUE JSON_VALUE(nest, '$.x')))\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_merge('{\\u0022a\\u0022:\\u0022x\\u0022}',json_object('x',\"v1\"))", ColumnType.NESTED_DATA, this.queryFramework().macroTable()), new NestedFieldVirtualColumn("nest", "v1", ColumnType.STRING, (List)ImmutableList.of((Object)new NestedPathField("x")), Boolean.valueOf(false), null, Boolean.valueOf(false))}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.ofComplex((String)"json")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"{\"a\":\"x\",\"x\":\"100\"}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":null}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":\"200\"}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":null}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":null}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":\"100\"}"}, (Object)new Object[]{"{\"a\":\"x\",\"x\":null}"}), RowSignature.builder().add("EXPR$0", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testCompositionTyping() {
        this.testQuery("SELECT JSON_VALUE((JSON_OBJECT(KEY 'x' VALUE JSON_VALUE(nest, '$.x' RETURNING BIGINT))), '$.x' RETURNING BIGINT)\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "json_value(json_object('x',\"v1\"),'$.x', 'LONG')", ColumnType.LONG, this.queryFramework().macroTable()), new NestedFieldVirtualColumn("nest", "v1", ColumnType.LONG, null, Boolean.valueOf(false), "$.x", Boolean.valueOf(false))}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{100L}, (Object)new Object[]{null}, (Object)new Object[]{200L}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{100L}, (Object)new Object[]{null}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testToJsonAndParseJson() {
        ExprMacroTable macroTable = this.queryFramework().macroTable();
        this.testQuery("SELECT string, TRY_PARSE_JSON(TO_JSON_STRING(string)), PARSE_JSON('{\"foo\":1}'), PARSE_JSON(TO_JSON_STRING(nester))\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "try_parse_json(to_json_string(\"string\"))", ColumnType.NESTED_DATA, macroTable), new ExpressionVirtualColumn("v1", "parse_json('{\\u0022foo\\u0022:1}')", ColumnType.NESTED_DATA, macroTable), new ExpressionVirtualColumn("v2", "parse_json(to_json_string(\"nester\"))", ColumnType.NESTED_DATA, macroTable)}).columns(new String[]{"string", "v0", "v1", "v2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.NESTED_DATA, ColumnType.NESTED_DATA, ColumnType.NESTED_DATA}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"aaa", "\"aaa\"", "{\"foo\":1}", "{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}"}, (Object)new Object[]{"bbb", "\"bbb\"", "{\"foo\":1}", "\"hello\""}, (Object)new Object[]{"ccc", "\"ccc\"", "{\"foo\":1}", null}, (Object)new Object[]{"ddd", "\"ddd\"", "{\"foo\":1}", null}, (Object)new Object[]{"eee", "\"eee\"", "{\"foo\":1}", null}, (Object)new Object[]{"aaa", "\"aaa\"", "{\"foo\":1}", "{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}"}, (Object)new Object[]{"ddd", "\"ddd\"", "{\"foo\":1}", "2"}), RowSignature.builder().add("string", ColumnType.STRING).add("EXPR$1", ColumnType.NESTED_DATA).add("EXPR$2", ColumnType.NESTED_DATA).add("EXPR$3", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testGroupByNegativeJsonPathIndex() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_VALUE(nester, '$.array[-1]'), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.array[-1]", "v0", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"b", 2L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testJsonPathNegativeIndex() {
        this.testQuery("SELECT JSON_VALUE(nester, '$.array[-1]'), JSON_QUERY(nester, '$.array[-1]'), JSON_KEYS(nester, '$.array[-1]') FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "v0", ColumnType.STRING, null, Boolean.valueOf(false), "$.array[-1]", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "v1", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.array[-1]", Boolean.valueOf(false)), CalciteNestedDataQueryTest.expressionVirtualColumn("v2", "json_keys(\"nester\",'$.array[-1]')", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0", "v1", "v2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.NESTED_DATA, ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", "\"b\"", null}, (Object)new Object[]{null, null, null}, (Object)new Object[]{null, null, null}, (Object)new Object[]{null, null, null}, (Object)new Object[]{null, null, null}, (Object)new Object[]{"b", "\"b\"", null}, (Object)new Object[]{null, null, null}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.NESTED_DATA).add("EXPR$2", ColumnType.STRING_ARRAY).build());
    }

    @Test
    public void testJsonPathsNonJsonInput() {
        this.testQuery("SELECT JSON_PATHS(string), JSON_PATHS(1234), JSON_PATHS('1234'), JSON_PATHS(1.1), JSON_PATHS(null)\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "json_paths(\"string\")", ColumnType.STRING_ARRAY), CalciteNestedDataQueryTest.expressionVirtualColumn("v1", "array('$')", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}, (Object)new Object[]{"[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]", "[\"$\"]"}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.STRING_ARRAY).add("EXPR$2", ColumnType.STRING_ARRAY).add("EXPR$3", ColumnType.STRING_ARRAY).add("EXPR$4", ColumnType.STRING_ARRAY).build());
    }

    @Test
    public void testJsonKeysNonJsonInput() {
        this.testQuery("SELECT JSON_KEYS(string, '$'), JSON_KEYS(1234, '$'), JSON_KEYS('1234', '$'), JSON_KEYS(1.1, '$'), JSON_KEYS(null, '$')\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "json_keys(\"string\",'$')", ColumnType.STRING_ARRAY), CalciteNestedDataQueryTest.expressionVirtualColumn("v1", "null", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.STRING_ARRAY).add("EXPR$2", ColumnType.STRING_ARRAY).add("EXPR$3", ColumnType.STRING_ARRAY).add("EXPR$4", ColumnType.STRING_ARRAY).build());
    }

    @Test
    public void testJsonValueUnDocumentedButSupportedOptions() {
        this.testQuery("SELECT SUM(JSON_VALUE(nest, '$.z' RETURNING BIGINT NULL ON EMPTY NULL ON ERROR)) FROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.z", "v0", ColumnType.LONG)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{700L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testJsonValueUnsupportedOptions() {
        this.testQueryThrows("SELECT SUM(JSON_VALUE(nest, '$.z' RETURNING BIGINT ERROR ON EMPTY ERROR ON ERROR)) FROM druid.nested", IllegalArgumentException.class, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Unsupported JSON_VALUE parameter 'ON EMPTY' defined - please re-issue this query without this argument")));
    }

    @Test
    public void testGroupByPathSelectorFilterVariantNull() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), JSON_VALUE(nester, '$.n.x' RETURNING BIGINT), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x' RETURNING BIGINT) IS NULL GROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setDimFilter(CalciteNestedDataQueryTest.isNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, 4L}, (Object)new Object[]{"100", null, 1L}, (Object)new Object[]{"200", null, 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testSelectPathSelectorFilterVariantNull() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), JSON_VALUE(nester, '$.n.x' RETURNING BIGINT) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x' RETURNING BIGINT) IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).columns(new String[]{"v1", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).filters(CalciteNestedDataQueryTest.isNull("v0")).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", null}, (Object)new Object[]{null, null}, (Object)new Object[]{"200", null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathSelectorFilterVariantNotNull() {
        this.testQuery("SELECT JSON_VALUE(nest, '$.x'), JSON_VALUE(nester, '$.n.x' RETURNING BIGINT), SUM(cnt) FROM druid.nested WHERE JSON_VALUE(nester, '$.n.x' RETURNING BIGINT) IS NOT NULL GROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nester", "$.n.x", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setDimFilter(CalciteNestedDataQueryTest.notNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"100", 1L, 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRegularLongLongMixed1FilterNotNull() {
        this.testQuery("SELECT JSON_VALUE(long, '$' RETURNING BIGINT), SUM(cnt) FROM druid.nested_mix WHERE JSON_VALUE(long, '$' RETURNING BIGINT) IS NOT NULL GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("long", "$", "v0", ColumnType.LONG)}).setDimFilter(CalciteNestedDataQueryTest.notNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 2L}, (Object)new Object[]{2L, 4L}, (Object)new Object[]{3L, 2L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{5L, 4L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed1SparseNotNull() {
        this.testQuery("SELECT JSON_VALUE(string_sparse, '$' RETURNING BIGINT), SUM(cnt) FROM druid.nested_mix_2 WHERE JSON_VALUE(string_sparse, '$' RETURNING BIGINT) IS NOT NULL GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED_2).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("string_sparse", "$", "v0", ColumnType.LONG)}).setDimFilter(CalciteNestedDataQueryTest.notNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{10L, 2L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testJoinOnNestedColumnThrows() {
        DruidException e = (DruidException)Assertions.assertThrows(DruidException.class, () -> this.testBuilder().sql("SELECT * FROM druid.nested a INNER JOIN druid.nested b ON a.nester = b.nester").run());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot join when the join condition has column of type [COMPLEX<json>]"));
    }

    @Test
    public void testScanStringNotNullCast() {
        this.skipVectorize();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{10L}, (Object)new Object[]{10L});
        this.testQuery("SELECT CAST(string_sparse as BIGINT)FROM druid.nested_mix WHERE CAST(string_sparse as BIGINT) IS NOT NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_MIXED).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "CAST(\"string_sparse\", 'LONG')", ColumnType.LONG)}).filters(CalciteNestedDataQueryTest.notNull("v0")).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)expectedResults, RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeStringMixed1SparseNotNullCast2() {
        this.testQuery("SELECT CAST(string_sparse as BIGINT), SUM(cnt) FROM druid.nested_mix WHERE CAST(string_sparse as BIGINT) IS NOT NULL GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_MIXED).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("string_sparse", "d0", ColumnType.LONG)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "CAST(\"string_sparse\", 'LONG')", ColumnType.LONG)}).setDimFilter(CalciteNestedDataQueryTest.notNull("v0")).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{10L, 2L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsAsMvd() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(arrayLongNulls), SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(\"arrayLongNulls\")", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"1", 5L}, (Object)new Object[]{"2", 6L}, (Object)new Object[]{"3", 6L}, (Object)new Object[]{"9", 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsAsMvdWithExpression() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(ARRAY_CONCAT(arrayLongNulls, arrayLong)), SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(array_concat(\"arrayLongNulls\",\"arrayLong\"))", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 10L}, (Object)new Object[]{"1", 12L}, (Object)new Object[]{"2", 7L}, (Object)new Object[]{"3", 9L}, (Object)new Object[]{"4", 4L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsAsMvdFiltered() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(arrayLongNulls), SUM(cnt), SUM(MV_LENGTH(ARRAY_TO_MV(arrayLongNulls))) FROM druid.arrays WHERE MV_CONTAINS(ARRAY_TO_MV(arrayLongNulls), '1') GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(\"arrayLongNulls\")", ColumnType.STRING), CalciteNestedDataQueryTest.expressionVirtualColumn("v1", "array_length(array_to_mv(\"arrayLongNulls\"))", ColumnType.LONG)}).setDimFilter((DimFilter)new ExpressionDimFilter("mv_contains(array_to_mv(\"arrayLongNulls\"),'1')", this.queryFramework().macroTable())).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new LongSumAggregatorFactory("a1", "v1")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L, 6L}, (Object)new Object[]{"1", 5L, 13L}, (Object)new Object[]{"2", 2L, 6L}, (Object)new Object[]{"3", 4L, 12L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayLongNullsAsMvdFilteredMore() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(arrayLongNulls), SUM(cnt) FROM druid.arrays WHERE MV_CONTAINS(ARRAY_TO_MV(arrayLongNulls), '1') OR MV_OVERLAP(ARRAY_TO_MV(arrayLongNulls), ARRAY['2', '3']) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(\"arrayLongNulls\")", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteNestedDataQueryTest.or(new DimFilter[]{CalciteNestedDataQueryTest.expressionFilter("mv_contains(array_to_mv(\"arrayLongNulls\"),'1')"), CalciteNestedDataQueryTest.expressionFilter("mv_overlap(array_to_mv(\"arrayLongNulls\"),array('2','3'))")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"1", 5L}, (Object)new Object[]{"2", 6L}, (Object)new Object[]{"3", 6L}, (Object)new Object[]{"9", 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringNullsAsMvdUnnest() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(arrayStringNulls), SUM(cnt) FROM druid.arrays GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(\"arrayStringNulls\")", ColumnType.STRING)}).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 9L}, (Object)new Object[]{"a", 3L}, (Object)new Object[]{"b", 11L}, (Object)new Object[]{"d", 2L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByRootSingleTypeArrayStringNullsFilteredAsMvd() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT ARRAY_TO_MV(arrayStringNulls), SUM(cnt), SUM(MV_LENGTH(ARRAY_TO_MV(arrayStringNulls))) FROM druid.arrays WHERE MV_CONTAINS(ARRAY_TO_MV(arrayStringNulls), 'b') GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ARRAYS).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "array_to_mv(\"arrayStringNulls\")", ColumnType.STRING), new ExpressionVirtualColumn("v1", "array_length(array_to_mv(\"arrayStringNulls\"))", ColumnType.LONG, this.queryFramework().macroTable())}).setDimFilter((DimFilter)new ExpressionDimFilter("mv_contains(array_to_mv(\"arrayStringNulls\"),'b')", this.queryFramework().macroTable())).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new LongSumAggregatorFactory("a1", "v1")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L, 10L}, (Object)new Object[]{"a", 3L, 6L}, (Object)new Object[]{"b", 11L, 24L}, (Object)new Object[]{"d", 2L, 6L})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build()).run();
    }

    @Test
    public void testGroupByAndFilterVariant() {
        this.testQuery("SELECT variant, SUM(cnt) FROM druid.all_auto WHERE variant = '1' GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("variant", "d0")})).setDimFilter(CalciteNestedDataQueryTest.equality("variant", "1", ColumnType.STRING)).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 2L}), RowSignature.builder().add("variant", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testScanAllTypesAuto() {
        this.msqIncompatible();
        this.skipVectorize();
        this.testQuery("SELECT * FROM druid.all_auto", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "str", "long", "double", "bool", "variant", "variantNumeric", "variantEmptyObj", "variantEmtpyArray", "variantWithArrays", "obj", "complexObj", "arrayString", "arrayStringNulls", "arrayLong", "arrayLongNulls", "arrayDouble", "arrayDoubleNulls", "arrayVariant", "arrayBool", "arrayNestedLong", "arrayObject", "null", "cstr", "clong", "cdouble", "cObj", "cstringArray", "cLongArray", "cDoubleArray", "cEmptyArray", "cEmptyObj", "cNullArray", "cEmptyObjectArray", "cObjectArray", "cnt"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.LONG, ColumnType.STRING, ColumnType.DOUBLE, ColumnType.ofComplex((String)"json"), ColumnType.LONG_ARRAY, ColumnType.STRING_ARRAY, ColumnType.ofComplex((String)"json"), ColumnType.ofComplex((String)"json"), ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.LONG_ARRAY, ColumnType.DOUBLE_ARRAY, ColumnType.DOUBLE_ARRAY, ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.ofComplex((String)"json"), ColumnType.ofComplex((String)"json"), ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.ofComplex((String)"json"), ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.DOUBLE_ARRAY, ColumnType.LONG_ARRAY, ColumnType.ofComplex((String)"json"), ColumnType.LONG_ARRAY, ColumnType.ofComplex((String)"json"), ColumnType.ofComplex((String)"json"), ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1672531200000L, null, null, null, 1L, "51", -0.13, "1", "[]", "[51,-35]", "{\"a\":700,\"b\":{\"x\":\"g\",\"y\":1.1,\"z\":[9,null,9,9]},\"c\":null,\"v\":[]}", "{\"x\":400,\"y\":[{\"l\":[null],\"m\":100,\"n\":5},{\"l\":[\"a\",\"b\",\"c\"],\"m\":\"a\",\"n\":1}],\"z\":{}}", null, "[\"a\",\"b\"]", null, "[2,3]", null, "[null]", null, "[1,0,1]", null, "[{\"x\":1},{\"x\":2}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "", 2L, null, 0L, "b", 1.1, "\"b\"", "2", "b", "{\"a\":200,\"b\":{\"x\":\"b\",\"y\":1.1,\"z\":[2,4,6]},\"c\":[\"a\",\"b\"],\"v\":[]}", "{\"x\":10,\"y\":[{\"l\":[\"b\",\"b\",\"c\"],\"m\":\"b\",\"n\":2},[1,2,3]],\"z\":{\"a\":[5.5],\"b\":false}}", "[\"a\",\"b\",\"c\"]", "[null,\"b\"]", "[2,3]", null, "[3.3,4.4,5.5]", "[999.0,null,5.5]", "[null,null,2.2]", "[1,1]", "[null,[null],[]]", "[{\"x\":3},{\"x\":4}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "a", 1L, 1.0, 1L, "1", 1.0, "1", "1", "1", "{\"a\":100,\"b\":{\"x\":\"a\",\"y\":1.1,\"z\":[1,2,3,4]},\"c\":[100],\"v\":[]}", "{\"x\":1234,\"y\":[{\"l\":[\"a\",\"b\",\"c\"],\"m\":\"a\",\"n\":1},{\"l\":[\"a\",\"b\",\"c\"],\"m\":\"a\",\"n\":1}],\"z\":{\"a\":[1.1,2.2,3.3],\"b\":true}}", "[\"a\",\"b\"]", "[\"a\",\"b\"]", "[1,2,3]", "[1,null,3]", "[1.1,2.2,3.3]", "[1.1,2.2,null]", "[\"a\",\"1\",\"2.2\"]", "[1,0,1]", "[[1,2,null],[3,4]]", "[{\"x\":1},{\"x\":2}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "b", 4L, 3.3, 1L, "1", null, "{}", "4", "1", "{\"a\":400,\"b\":{\"x\":\"d\",\"y\":1.1,\"z\":[3,4]},\"c\":{\"a\":1},\"v\":[]}", "{\"x\":1234,\"z\":{\"a\":[1.1,2.2,3.3],\"b\":true}}", "[\"d\",\"e\"]", "[\"b\",\"b\"]", "[1,4]", "[1]", "[2.2,3.3,4.0]", null, "[\"a\",\"b\",\"c\"]", "[null,0,1]", "[[1,2],[3,4],[5,6,7]]", "[{\"x\":null},{\"x\":2}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "c", null, 4.4, 1L, "hello", -1000.0, "{}", "[]", "hello", "{\"a\":500,\"b\":{\"x\":\"e\",\"z\":[1,2,3,4]},\"c\":\"hello\",\"v\":\"a\"}", "{\"x\":11,\"y\":[],\"z\":{\"a\":[null],\"b\":false}}", null, null, "[1,2,3]", "[]", "[1.1,2.2,3.3]", null, null, "[0]", null, "[{\"x\":1000},{\"y\":2000}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "d", 5L, 5.9, 0L, null, 3.33, "\"a\"", "6", null, "{\"a\":600,\"b\":{\"x\":\"f\",\"y\":1.1,\"z\":[6,7,8,9]},\"c\":12.3,\"v\":\"b\"}", null, "[\"a\",\"b\"]", null, null, "[null,2,9]", null, "[999.0,5.5,null]", "[\"a\",\"1\",\"2.2\"]", "[]", "[[1],[1,2,null]]", "[{\"a\":1},{\"b\":2}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}, (Object)new Object[]{1672531200000L, "null", 3L, 2.0, null, "3.0", 1.0, "3.3", "3", "3.0", "{\"a\":300}", "{\"x\":4.4,\"y\":[{\"l\":[],\"m\":100,\"n\":3},{\"l\":[\"a\"]},{\"l\":[\"b\"],\"n\":[]}],\"z\":{\"a\":[],\"b\":true}}", "[\"b\",\"c\"]", "[\"d\",null,\"b\"]", "[1,2,3,4]", "[1,2,3]", "[1.1,3.3]", "[null,2.2,null]", "[1,null,1]", "[1,null,1]", "[[1],null,[1,2,3]]", "[null,{\"x\":2}]", null, "hello", 1234L, 1.234, "{\"x\":1,\"y\":\"hello\",\"z\":{\"a\":1.1,\"b\":1234,\"c\":[\"a\",\"b\",\"c\"],\"d\":[]}}", "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.1,2.2,3.3]", "[]", "{}", "[null,null]", "[{},{},{}]", "[{\"a\":\"b\",\"x\":1,\"y\":1.3}]", 1L}), RowSignature.builder().add("__time", ColumnType.LONG).add("str", ColumnType.STRING).add("long", ColumnType.LONG).add("double", ColumnType.DOUBLE).add("bool", ColumnType.LONG).add("variant", ColumnType.STRING).add("variantNumeric", ColumnType.DOUBLE).add("variantEmptyObj", ColumnType.NESTED_DATA).add("variantEmtpyArray", ColumnType.LONG_ARRAY).add("variantWithArrays", ColumnType.STRING_ARRAY).add("obj", ColumnType.NESTED_DATA).add("complexObj", ColumnType.NESTED_DATA).add("arrayString", ColumnType.STRING_ARRAY).add("arrayStringNulls", ColumnType.STRING_ARRAY).add("arrayLong", ColumnType.LONG_ARRAY).add("arrayLongNulls", ColumnType.LONG_ARRAY).add("arrayDouble", ColumnType.DOUBLE_ARRAY).add("arrayDoubleNulls", ColumnType.DOUBLE_ARRAY).add("arrayVariant", ColumnType.STRING_ARRAY).add("arrayBool", ColumnType.LONG_ARRAY).add("arrayNestedLong", ColumnType.NESTED_DATA).add("arrayObject", ColumnType.NESTED_DATA).add("null", ColumnType.STRING).add("cstr", ColumnType.STRING).add("clong", ColumnType.LONG).add("cdouble", ColumnType.DOUBLE).add("cObj", ColumnType.NESTED_DATA).add("cstringArray", ColumnType.STRING_ARRAY).add("cLongArray", ColumnType.LONG_ARRAY).add("cDoubleArray", ColumnType.DOUBLE_ARRAY).add("cEmptyArray", ColumnType.LONG_ARRAY).add("cEmptyObj", ColumnType.NESTED_DATA).add("cNullArray", ColumnType.LONG_ARRAY).add("cEmptyObjectArray", ColumnType.NESTED_DATA).add("cObjectArray", ColumnType.NESTED_DATA).add("cnt", ColumnType.LONG).build());
    }

    @Test
    public void testFilterJsonIsNotNull() {
        this.testQuery("SELECT nest\nFROM druid.nested WHERE nest IS NOT NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"nest"}).columnTypes(new ColumnType[]{ColumnType.NESTED_DATA}).filters(CalciteNestedDataQueryTest.notNull("nest")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"{\"x\":100,\"y\":2.02,\"z\":\"300\",\"mixed\":1,\"mixed2\":\"1\"}"}, (Object)new Object[]{"{\"x\":200,\"y\":3.03,\"z\":\"abcdef\",\"mixed\":1.1,\"mixed2\":1}"}, (Object)new Object[]{"{\"x\":100,\"y\":2.02,\"z\":\"400\",\"mixed2\":1.1}"}), RowSignature.builder().add("nest", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testFilterJsonIsNull() {
        this.testQuery("SELECT nest, nester\nFROM druid.nested WHERE nest IS NULL", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"nest", "nester"}).columnTypes(new ColumnType[]{ColumnType.ofComplex((String)"json"), ColumnType.ofComplex((String)"json")}).filters(CalciteNestedDataQueryTest.isNull("nest")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "\"hello\""}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, "2"}), RowSignature.builder().add("nest", ColumnType.NESTED_DATA).add("nester", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testCoalesceOnNestedColumns() {
        this.testBuilder().sql("select c,long,coalesce(c,long) as col  from druid.all_auto, unnest(json_value(arrayNestedLong, '$[1]' returning bigint array)) as u(c) ").expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource(DATA_SOURCE_ALL), (VirtualColumn)new NestedFieldVirtualColumn("arrayNestedLong", "$[1]", "j0.unnest", ColumnType.LONG_ARRAY), null)).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "nvl(\"j0.unnest\",\"long\")", ColumnType.LONG)}).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.unnest", "long", "v0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L, 2L}, (Object)new Object[]{3L, 1L, 3L}, (Object)new Object[]{4L, 1L, 4L}, (Object)new Object[]{3L, 4L, 3L}, (Object)new Object[]{4L, 4L, 4L}, (Object)new Object[]{1L, 5L, 1L}, (Object)new Object[]{2L, 5L, 2L}, (Object)new Object[]{null, 5L, 5L})).expectedSignature(RowSignature.builder().add("c", ColumnType.LONG).add("long", ColumnType.LONG).add("col", ColumnType.LONG).build()).run();
    }

    @Test
    public void testCoalesceOnNestedColumnsLater() {
        this.testQuery("select coalesce(long,c) as col  from druid.all_auto, unnest(json_value(arrayNestedLong, '$[1]' returning bigint array)) as u(c) ", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource(DATA_SOURCE_ALL), (VirtualColumn)new NestedFieldVirtualColumn("arrayNestedLong", "$[1]", "j0.unnest", ColumnType.LONG_ARRAY), null)).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "nvl(\"long\",\"j0.unnest\")", ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{4L}, (Object)new Object[]{4L}, (Object)new Object[]{5L}, (Object)new Object[]{5L}, (Object)new Object[]{5L}), RowSignature.builder().add("col", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByPathDynamicArg() {
        this.cannotVectorize();
        this.testQuery("SELECT JSON_VALUE(nest, ARRAY_OFFSET(JSON_PATHS(nest), 0)), SUM(cnt) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "json_value(\"nest\",array_offset(json_paths(\"nest\"),0),'STRING')", ColumnType.STRING)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 1L}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testJsonQueryDynamicArg() {
        this.testQuery("SELECT JSON_PATHS(nester), JSON_QUERY(nester, ARRAY_OFFSET(JSON_PATHS(nester), 0))\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "json_paths(\"nester\")", ColumnType.STRING_ARRAY), CalciteNestedDataQueryTest.expressionVirtualColumn("v1", "json_query(\"nester\",array_offset(json_paths(\"nester\"),0))", ColumnType.NESTED_DATA)}).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.ofComplex((String)"json")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"$.array\",\"$.n.x\"]", "[\"a\",\"b\"]"}, (Object)new Object[]{"[\"$\"]", "\"hello\""}, (Object)new Object[]{"[\"$\"]", null}, (Object)new Object[]{"[\"$\"]", null}, (Object)new Object[]{"[\"$\"]", null}, (Object)new Object[]{"[\"$.array\",\"$.n.x\"]", "[\"a\",\"b\"]"}, (Object)new Object[]{"[\"$\"]", "2"}), RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).add("EXPR$1", ColumnType.NESTED_DATA).build());
    }

    @Test
    public void testJsonQueryArrays() {
        this.msqIncompatible();
        this.testBuilder().sql("SELECT JSON_QUERY_ARRAY(arrayObject, '$') FROM druid.arrays").queryContext(QUERY_CONTEXT_DEFAULT).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ARRAYS).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "json_query_array(\"arrayObject\",'$')", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA))}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"x\":1000},{\"y\":2000}]"}, (Object)new Object[]{"[{\"x\":1},{\"x\":2}]"}, (Object)new Object[]{"[{\"x\":null},{\"x\":2}]"}, (Object)new Object[]{"[{\"a\":1},{\"b\":2}]"}, (Object)new Object[]{"[{\"x\":1},{\"x\":2}]"}, (Object)new Object[]{"[null,{\"x\":2}]"}, (Object)new Object[]{"[{\"x\":3},{\"x\":4}]"}, (Object)new Object[]{"[{\"x\":1000},{\"y\":2000}]"}, (Object)new Object[]{"[{\"x\":1},{\"x\":2}]"}, (Object)new Object[]{"[{\"x\":null},{\"x\":2}]"}, (Object)new Object[]{"[{\"a\":1},{\"b\":2}]"}, (Object)new Object[]{"[{\"x\":1},{\"x\":2}]"}, (Object[])new Object[][]{{"[null,{\"x\":2}]"}, {"[{\"x\":3},{\"x\":4}]"}})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)).build()).run();
    }

    @Test
    public void testJsonQueryArrayNullArray() {
        this.msqIncompatible();
        this.testBuilder().sql("SELECT JSON_QUERY_ARRAY(arrayObject, '$.') FROM druid.arrays where arrayObject is null limit 1").queryContext(QUERY_CONTEXT_DEFAULT).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ARRAYS).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "null", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA))}).filters(CalciteNestedDataQueryTest.isNull("arrayObject")).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)}).limit(1L).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of()).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)).build()).run();
    }

    @Test
    public void testUnnestJsonQueryArrays() {
        this.testBuilder().sql("SELECT objects FROM druid.arrays, UNNEST(JSON_QUERY_ARRAY(arrayObject, '$')) as u(objects)").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "json_query_array(\"arrayObject\",'$')", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)), null)).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.ofComplex((String)"json")}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"{\"x\":1000}"}, (Object)new Object[]{"{\"y\":2000}"}, (Object)new Object[]{"{\"x\":1}"}, (Object)new Object[]{"{\"x\":2}"}, (Object)new Object[]{"{\"x\":null}"}, (Object)new Object[]{"{\"x\":2}"}, (Object)new Object[]{"{\"a\":1}"}, (Object)new Object[]{"{\"b\":2}"}, (Object)new Object[]{"{\"x\":1}"}, (Object)new Object[]{"{\"x\":2}"}, (Object)new Object[]{null}, (Object)new Object[]{"{\"x\":2}"}, (Object[])new Object[][]{{"{\"x\":3}"}, {"{\"x\":4}"}, {"{\"x\":1000}"}, {"{\"y\":2000}"}, {"{\"x\":1}"}, {"{\"x\":2}"}, {"{\"x\":null}"}, {"{\"x\":2}"}, {"{\"a\":1}"}, {"{\"b\":2}"}, {"{\"x\":1}"}, {"{\"x\":2}"}, {null}, {"{\"x\":2}"}, {"{\"x\":3}"}, {"{\"x\":4}"}})).expectedSignature(RowSignature.builder().add("objects", ColumnType.NESTED_DATA).build()).run();
    }

    @Test
    public void testUnnestJsonQueryArraysJsonValue() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT json_value(objects, '$.x' returning bigint) as x, count(*) FROM druid.arrays, UNNEST(JSON_QUERY_ARRAY(arrayObject, '$')) as u(objects) GROUP BY 1").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "json_query_array(\"arrayObject\",'$')", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)), null)).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("j0.unnest", "$.x", "v0", ColumnType.LONG)}).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 10L}, (Object)new Object[]{1L, 4L}, (Object)new Object[]{2L, 8L}, (Object)new Object[]{3L, 2L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{1000L, 2L})).expectedSignature(RowSignature.builder().add("x", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build()).run();
    }

    @Test
    public void testUnnestJsonQueryArraysJsonValueSum() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT sum(json_value(objects, '$.x' returning bigint)) as xs FROM druid.arrays, UNNEST(JSON_QUERY_ARRAY(arrayObject, '$')) as u(objects)").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)UnnestDataSource.create((DataSource)TableDataSource.create((String)DATA_SOURCE_ARRAYS), (VirtualColumn)CalciteNestedDataQueryTest.expressionVirtualColumn("j0.unnest", "json_query_array(\"arrayObject\",'$')", ColumnType.ofArray((ColumnType)ColumnType.NESTED_DATA)), null)).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("j0.unnest", "$.x", "v0", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0")}).context(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{2034L})).expectedSignature(RowSignature.builder().add("xs", ColumnType.LONG).build()).run();
    }

    @Test
    public void testJsonValueNestedEmptyArray() {
        this.skipVectorize();
        this.testBuilder().sql("SELECT json_value(cObj, '$.z.d') FROM druid.all_auto").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("cObj", "$.z.d", "v0", ColumnType.STRING)}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING).build()).run();
    }

    @Test
    public void testJsonValueNestedEmptyArrayReturning() {
        this.skipVectorize();
        this.testBuilder().sql("SELECT json_value(cObj, '$.z.d' returning varchar array) FROM druid.all_auto").queryContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY}).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("cObj", "$.z.d", "v0", ColumnType.STRING_ARRAY)}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()})).expectedSignature(RowSignature.builder().add("EXPR$0", ColumnType.STRING_ARRAY).build()).run();
    }

    @Test
    public void testNvlJsonValueDoubleMissingColumn() {
        this.testQuery("SELECT\nJSON_VALUE(nest, '$.nonexistent' RETURNING DOUBLE),\nNVL(JSON_VALUE(nest, '$.nonexistent' RETURNING DOUBLE), 1.0),\nNVL(JSON_VALUE(nest, '$.nonexistent' RETURNING DOUBLE), 1.0) > 0\nFROM druid.nested\nWHERE NVL(JSON_VALUE(nest, '$.nonexistent' RETURNING DOUBLE), 1.0) > 0\nLIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteNestedDataQueryTest.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",1.0)", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.nonexistent", "v1", ColumnType.DOUBLE), CalciteNestedDataQueryTest.expressionVirtualColumn("v2", "notnull(nvl(\"v1\",1.0))", ColumnType.LONG)}).filters(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, 0.0, null, true, false)).limit(1L).columns(new String[]{"v1", "v0", "v2"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 1.0, true}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.DOUBLE).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testNvlJsonValueDoubleSometimesMissing() {
        this.testQuery("SELECT\nJSON_VALUE(nest, '$.y' RETURNING DOUBLE),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) > 0,\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) = 1.0\nFROM druid.nested", (List<Query<?>>)ImmutableList.of((Object)CalciteNestedDataQueryTest.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.y", "v0", ColumnType.DOUBLE), CalciteNestedDataQueryTest.expressionVirtualColumn("v1", "nvl(\"v0\",1.0)", ColumnType.DOUBLE), CalciteNestedDataQueryTest.expressionVirtualColumn("v2", "(nvl(\"v0\",1.0) > 0)", ColumnType.LONG), CalciteNestedDataQueryTest.expressionVirtualColumn("v3", "(nvl(\"v0\",1.0) == 1.0)", ColumnType.LONG)}).columns(new String[]{"v0", "v1", "v2", "v3"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.LONG, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.02, 2.02, true, false}, (Object)new Object[]{null, 1.0, true, true}, (Object)new Object[]{3.03, 3.03, true, false}, (Object)new Object[]{null, 1.0, true, true}, (Object)new Object[]{null, 1.0, true, true}, (Object)new Object[]{2.02, 2.02, true, false}, (Object)new Object[]{null, 1.0, true, true}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.DOUBLE).add("EXPR$2", ColumnType.LONG).add("EXPR$3", ColumnType.LONG).build());
    }

    @Test
    public void testNvlJsonValueDoubleSometimesMissingRangeFilter() {
        this.testQuery("SELECT\nJSON_VALUE(nest, '$.y' RETURNING DOUBLE),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) > 0\nFROM druid.nested\nWHERE NVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) > 0", (List<Query<?>>)ImmutableList.of((Object)CalciteNestedDataQueryTest.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",1.0)", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.y", "v1", ColumnType.DOUBLE), CalciteNestedDataQueryTest.expressionVirtualColumn("v2", "notnull(nvl(\"v1\",1.0))", ColumnType.LONG)}).filters(CalciteNestedDataQueryTest.range("v0", ColumnType.LONG, 0.0, null, true, false)).columns(new String[]{"v1", "v0", "v2"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.02, 2.02, true}, (Object)new Object[]{null, 1.0, true}, (Object)new Object[]{3.03, 3.03, true}, (Object)new Object[]{null, 1.0, true}, (Object)new Object[]{null, 1.0, true}, (Object)new Object[]{2.02, 2.02, true}, (Object)new Object[]{null, 1.0, true}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.DOUBLE).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testApproxCountDistinctOnUnsupportedComplexColumn() {
        this.assertQueryIsUnplannable("SELECT COUNT(DISTINCT nester) FROM druid.nested", "Using APPROX_COUNT_DISTINCT() or enabling approximation with COUNT(DISTINCT) is not supported for column type [COMPLEX<json>]. You can disable approximation by setting [useApproximateCountDistinct: false] in the query context.");
    }

    @Test
    public void testApproxCountDistinctFunctionOnUnsupportedComplexColumn() {
        DruidException druidException = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testQuery("SELECT APPROX_COUNT_DISTINCT(nester) FROM druid.nested", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assert.assertTrue((boolean)druidException.getMessage().contains("Cannot apply 'APPROX_COUNT_DISTINCT' to arguments of type 'APPROX_COUNT_DISTINCT(<COMPLEX<JSON>>)'"));
    }

    @Test
    public void testNvlJsonValueDoubleSometimesMissingEqualityFilter() {
        this.testQuery("SELECT\nJSON_VALUE(nest, '$.y' RETURNING DOUBLE),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0),\nNVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) > 0\nFROM druid.nested\nWHERE NVL(JSON_VALUE(nest, '$.y' RETURNING DOUBLE), 1.0) = 1.0", (List<Query<?>>)ImmutableList.of((Object)CalciteNestedDataQueryTest.newScanQueryBuilder().dataSource(DATA_SOURCE).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",1.0)", ColumnType.DOUBLE), new NestedFieldVirtualColumn("nest", "$.y", "v1", ColumnType.DOUBLE), CalciteNestedDataQueryTest.expressionVirtualColumn("v2", "notnull(nvl(\"v1\",1.0))", ColumnType.LONG)}).filters(CalciteNestedDataQueryTest.equality("v0", 1.0, ColumnType.DOUBLE)).columns(new String[]{"v1", "v0", "v2"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 1.0, true}, (Object)new Object[]{null, 1.0, true}, (Object)new Object[]{null, 1.0, true}, (Object)new Object[]{null, 1.0, true}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).add("EXPR$1", ColumnType.DOUBLE).add("EXPR$2", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByAutoString() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}, (Object)new Object[]{"null", 1L});
        this.testQuery("SELECT str, SUM(cnt) FROM druid.all_auto GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("str", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("str", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("SELECT str, SUM(cnt) FROM druid.all_auto_realtime GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL_REALTIME).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("str", "d0")})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("str", ColumnType.STRING).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByAutoLong() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{1L, 1L}, (Object)new Object[]{2L, 1L}, (Object)new Object[]{3L, 1L}, (Object)new Object[]{4L, 1L}, (Object)new Object[]{5L, 1L});
        this.testQuery("SELECT long, SUM(cnt) FROM druid.all_auto GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("SELECT long, SUM(cnt) FROM druid.all_auto_realtime GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL_REALTIME).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("long", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("long", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testGroupByAutoDouble() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{1.0, 1L}, (Object)new Object[]{2.0, 1L}, (Object)new Object[]{3.3, 1L}, (Object)new Object[]{4.4, 1L}, (Object)new Object[]{5.9, 1L});
        this.testQuery("SELECT \"double\", SUM(cnt) FROM druid.all_auto GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("double", "d0", ColumnType.DOUBLE)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("double", ColumnType.DOUBLE).add("EXPR$1", ColumnType.LONG).build());
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("SELECT \"double\", SUM(cnt) FROM druid.all_auto_realtime GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE_ALL_REALTIME).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("double", "d0", ColumnType.DOUBLE)})).setAggregatorSpecs(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected, RowSignature.builder().add("double", ColumnType.DOUBLE).add("EXPR$1", ColumnType.LONG).build());
    }

    @Test
    public void testToJsonString() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT TO_JSON_STRING(nester) FROM druid.nested GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteNestedDataQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setVirtualColumns(new VirtualColumn[]{CalciteNestedDataQueryTest.expressionVirtualColumn("v0", "to_json_string(\"nester\")", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"\"hello\""}, (Object)new Object[]{"2"}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":\"hello\"}}"}, (Object)new Object[]{"{\"array\":[\"a\",\"b\"],\"n\":{\"x\":1}}"}), RowSignature.builder().add("EXPR$0", ColumnType.STRING).build());
    }

    @Test
    public void testSumPathWithArrays() {
        this.testQuery("SELECT SUM(JSON_VALUE(obj, '$.c')) FROM druid.all_auto", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{112.3}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testCountPathWithArrays() {
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c')) FROM druid.all_auto", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.STRING)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testCountPathWithArraysReturningNumber() {
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c' RETURNING DOUBLE)) FROM druid.all_auto", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testCountPathWithArraysReturning() {
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c' RETURNING VARCHAR ARRAY)) FROM druid.all_auto", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.STRING_ARRAY)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testSumPathWithArraysRealtime() {
        this.skipVectorize();
        this.testQuery("SELECT SUM(JSON_VALUE(obj, '$.c')) FROM druid.all_auto_realtime", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL_REALTIME).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{112.3}), RowSignature.builder().add("EXPR$0", ColumnType.DOUBLE).build());
    }

    @Test
    public void testCountPathWithArraysRealtime() {
        this.skipVectorize();
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c')) FROM druid.all_auto_realtime", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL_REALTIME).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.STRING)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testCountPathWithArraysReturningNumberRealtime() {
        this.skipVectorize();
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c' RETURNING DOUBLE)) FROM druid.all_auto_realtime", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL_REALTIME).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.DOUBLE)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    @Test
    public void testCountPathWithArraysReturningRealtime() {
        this.skipVectorize();
        this.testQuery("SELECT COUNT(JSON_VALUE(obj, '$.c' RETURNING VARCHAR ARRAY)) FROM druid.all_auto_realtime", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE_ALL_REALTIME).intervals(CalciteNestedDataQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.c", "v0", ColumnType.STRING_ARRAY)}).aggregators(CalciteNestedDataQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteNestedDataQueryTest.not(CalciteNestedDataQueryTest.isNull("v0")))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}), RowSignature.builder().add("EXPR$0", ColumnType.LONG).build());
    }

    public static class NestedComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        public NestedComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker addSegmentsToWalker(SpecificSegmentsQuerySegmentWalker walker) {
            BuiltInTypesModule.registerHandlersAndSerde();
            QueryableIndex index = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withDimensionsSpec(ALL_JSON_COLUMNS.getDimensionsSpec()).withRollup(false).build()).rows(ROWS).buildMMappedIndex();
            QueryableIndex indexMix11 = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withDimensionsSpec(ALL_JSON_COLUMNS.getDimensionsSpec()).withRollup(false).build()).rows(ROWS).buildMMappedIndex();
            QueryableIndex indexMix12 = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withDimensionsSpec(JSON_AND_SCALAR_MIX.getDimensionsSpec()).withRollup(false).build()).rows(ROWS_MIX).buildMMappedIndex();
            QueryableIndex indexMix21 = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withDimensionsSpec(JSON_AND_SCALAR_MIX.getDimensionsSpec()).withRollup(false).build()).rows(ROWS_MIX).buildMMappedIndex();
            QueryableIndex indexMix22 = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withDimensionsSpec(ALL_JSON_COLUMNS.getDimensionsSpec()).withRollup(false).build()).rows(ROWS).buildMMappedIndex();
            QueryableIndex indexArrays = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(NestedDataTestUtils.AUTO_SCHEMA.getTimestampSpec()).withDimensionsSpec(NestedDataTestUtils.AUTO_SCHEMA.getDimensionsSpec()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withRollup(false).build()).inputSource((InputSource)ResourceInputSource.of((ClassLoader)NestedDataTestUtils.class.getClassLoader(), (String)"nested-array-test-data.json")).inputFormat((InputFormat)TestDataBuilder.DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(this.tempDirProducer.newTempFolder()).buildMMappedIndex();
            QueryableIndex indexAllTypesAuto = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(NestedDataTestUtils.AUTO_SCHEMA.getTimestampSpec()).withDimensionsSpec(NestedDataTestUtils.AUTO_SCHEMA.getDimensionsSpec()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withRollup(false).build()).inputSource((InputSource)ResourceInputSource.of((ClassLoader)NestedDataTestUtils.class.getClassLoader(), (String)"nested-all-types-test-data.json")).inputFormat((InputFormat)TestDataBuilder.DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(this.tempDirProducer.newTempFolder()).buildMMappedIndex();
            IncrementalIndex indexAllTypesAutoRealtime = IndexBuilder.create().tmpDir(this.tempDirProducer.newTempFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(NestedDataTestUtils.AUTO_SCHEMA.getTimestampSpec()).withDimensionsSpec(NestedDataTestUtils.AUTO_SCHEMA.getDimensionsSpec()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withRollup(false).build()).inputSource((InputSource)ResourceInputSource.of((ClassLoader)NestedDataTestUtils.class.getClassLoader(), (String)"nested-all-types-test-data.json")).inputFormat((InputFormat)TestDataBuilder.DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(this.tempDirProducer.newTempFolder()).buildIncrementalIndex();
            walker.add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_MIXED).interval(indexMix11.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexMix11).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_MIXED).interval(indexMix12.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), indexMix12).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_MIXED_2).interval(indexMix21.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexMix21).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_MIXED_2).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), indexMix22).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_ARRAYS).version("1").interval(indexArrays.getDataInterval()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), indexArrays).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_ALL).version("1").interval(indexAllTypesAuto.getDataInterval()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), indexAllTypesAuto).add(DataSegment.builder().dataSource(CalciteNestedDataQueryTest.DATA_SOURCE_ALL_REALTIME).version("1").interval(indexAllTypesAutoRealtime.getInterval()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), indexAllTypesAutoRealtime);
            return walker;
        }
    }
}

