/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Test;

public class CalciteLookupFunctionQueryTest
extends BaseCalciteQueryTest {
    private static final Map<String, Object> QUERY_CONTEXT = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"maxOptimizeCountForDruidReverseLookupRule", (Object)1).build();
    private static final Map<String, Object> QUERY_CONTEXT_WITH_EXTRACTION_FNS = ImmutableMap.builder().putAll(QUERY_CONTEXT).put((Object)"sqlUseExtractionFns", (Object)true).build();
    private static final String LOOKUP_EXPRESSION = "lookup(\"dim1\",'lookyloo')";
    private static final ExtractionFn EXTRACTION_FN = new RegisteredLookupExtractionFn(null, "lookyloo", false, null, null, Boolean.valueOf(false));

    @Test
    public void testFilterEquals() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') = 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xabc'", CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterLookupOfFunction() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("LOOKUP(LOWER(dim1), 'lookyloo') = 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lower(\"dim1\")", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterFunctionOfLookup() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("LOWER(LOOKUP(dim1, 'lookyloo')) = 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lower(lookup(\"dim1\",'lookyloo'))", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "xabc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(CONCAT(dim1, 'b', dim2), 'lookyloo') = 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xa'", (DimFilter)CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "a", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "c", ColumnType.STRING))), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterInLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(CONCAT(dim1, 'a', dim2), 'lookyloo') IN ('xa', 'xabc')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.or(new DimFilter[]{CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "", ColumnType.STRING)), CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "bc", ColumnType.STRING))})), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterScalarInArrayLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("SCALAR_IN_ARRAY(LOOKUP(CONCAT(dim1, 'a', dim2), 'lookyloo'), ARRAY['xa', 'xabc'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.or(new DimFilter[]{CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "", ColumnType.STRING)), CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "bc", ColumnType.STRING))})), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterConcatOfLookup() {
        this.testQuery(this.buildFilterTestSql("CONCAT(LOOKUP(dim1, 'lookyloo'), ' (', dim1, ')') = 'xabc (abc)'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xabc'", CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInConcatOfLookup() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"maxOptimizeCountForDruidReverseLookupRule", (Object)2).build();
        this.testQuery(this.buildFilterTestSql("CONCAT(LOOKUP(dim1, 'lookyloo'), ' (', dim1, ')') IN ('xa (a)', 'xabc (abc)')"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"a", (Object)"abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterConcatOfLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("CONCAT(LOOKUP(CONCAT(dim1, 'b', dim2), 'lookyloo'), ' (', CONCAT(dim1, 'b', dim2), ')') = 'xabc (abc)'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xa'", (DimFilter)CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "a", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "c", ColumnType.STRING))), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterInConcatOfLookupOfConcat() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"maxOptimizeCountForDruidReverseLookupRule", (Object)2).build();
        this.testQuery(this.buildFilterTestSql("CONCAT(LOOKUP(CONCAT(dim1, 'a', dim2), 'lookyloo'), ' (', CONCAT(dim1, 'a', dim2), ')')\nIN ('xa (a)', 'xabc (abc)')"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.or(new DimFilter[]{CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "", ColumnType.STRING)), CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "bc", ColumnType.STRING))})), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterConcatOfCoalesceLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("CONCAT(COALESCE(LOOKUP(CONCAT(dim1, 'b', dim2), 'lookyloo'), 'N/A'), ' (', CONCAT(dim1, 'b', dim2), ')') = 'xabc (abc)'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xa'", (DimFilter)CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.equality("dim1", "a", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("dim2", "c", ColumnType.STRING))), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterImpossibleLookupOfConcat() {
        this.testQuery(this.buildFilterTestSql("LOOKUP('key:' || dim1, 'lookyloo') = 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryAlwaysFalse(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterChainedEquals() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(LOOKUP(dim1, 'lookyloo'), 'lookyloo-chain') = 'zabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xabc'", CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterEqualsLiteralFirst() {
        this.testQuery(this.buildFilterTestSql("'xabc' = LOOKUP(dim1, 'lookyloo')"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xabc'", CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterEqualsAlwaysFalse() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') = 'nonexistent'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryAlwaysFalse(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterIsNotDistinctFrom() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS NOT DISTINCT FROM 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'xabc'", CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterMultipleIsNotDistinctFrom() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS NOT DISTINCT FROM 'xabc' OR LOOKUP(dim1, 'lookyloo') IS NOT DISTINCT FROM 'x6' OR LOOKUP(dim1, 'lookyloo') IS NOT DISTINCT FROM 'nonexistent'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("6", "abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterIn() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("6", "abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterScalarInArray() {
        this.testQuery(this.buildFilterTestSql("SCALAR_IN_ARRAY(LOOKUP(dim1, 'lookyloo'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("6", "abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInOverScalarInArrayThreshold() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"inFunctionThreshold", (Object)1).build();
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent')"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("6", "abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInOverMaxSize() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"sqlReverseLookupThreshold", (Object)1).build();
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent')"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), CalciteLookupFunctionQueryTest.in("v0", (Collection<String>)ImmutableList.of((Object)"nonexistent", (Object)"x6", (Object)"xabc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInOverMaxSize2() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"inSubQueryThreshold", (Object)1).build();
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') = 'xabc' OR LOOKUP(dim1, 'lookyloo') = 'x6'"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), CalciteLookupFunctionQueryTest.in("v0", (Collection<String>)ImmutableList.of((Object)"x6", (Object)"xabc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInOrIsNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent') OR LOOKUP(dim1, 'lookyloo') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.or(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("6", "abc")), CalciteLookupFunctionQueryTest.isNull("v0"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInAndIsNotNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent') AND LOOKUP(dim1, 'lookyloo') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"6", (Object)"abc")), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.isNull("v0"))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInOrIsNullInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') IN ('xabc', 'x6', 'nonexistent') OR LOOKUP(dim1, 'lookyloo121') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.or(CalciteLookupFunctionQueryTest.isNull("dim1"), CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotInAndIsNotNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') NOT IN ('x6', 'nonexistent') AND LOOKUP(dim1, 'lookyloo') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "nonexistent", ColumnType.STRING)), CalciteLookupFunctionQueryTest.notNull("v0")})), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInIsNotTrueAndIsNotNull() {
        this.testQuery(this.buildFilterTestSql("(LOOKUP(dim1, 'lookyloo') IN ('xabc', 'x6', 'nonexistent')) IS NOT TRUE AND LOOKUP(dim1, 'lookyloo') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"6", (Object)"abc")))), CalciteLookupFunctionQueryTest.notNull("v0")})), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterNotInAndIsNotNullInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') NOT IN ('xabc', 'xdef', 'nonexistent') AND LOOKUP(dim1, 'lookyloo121') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.isNull("dim1")), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def")))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}));
    }

    @Test
    public void testFilterNotInOrIsNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') NOT IN ('x6', 'nonexistent') OR LOOKUP(dim1, 'lookyloo') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.or(new DimFilter[]{CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "nonexistent", ColumnType.STRING))}), CalciteLookupFunctionQueryTest.isNull("v0")})), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInIsNotTrueOrIsNull() {
        this.testQuery(this.buildFilterTestSql("(LOOKUP(dim1, 'lookyloo') IN ('x6', 'nonexistent')) IS NOT TRUE OR LOOKUP(dim1, 'lookyloo') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.or(new DimFilter[]{CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING))), CalciteLookupFunctionQueryTest.isNull("v0")})), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotIn() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') NOT IN ('x6', 'nonexistent')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "nonexistent", ColumnType.STRING))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInIsNotTrue() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IN ('x6', 'nonexistent') IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotInInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') NOT IN ('xabc', 'xdef', 'nonexistent')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def")))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}));
    }

    @Test
    public void testFilterNotInWithReplaceMissingValue() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo', 'xyzzy') NOT IN ('xabc', 'x6', 'nonexistent')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"6", (Object)"abc")))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterInIsNotTrueWithReplaceMissingValue() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo', 'xyzzy') IN ('xabc', 'x6', 'nonexistent') IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"6", (Object)"abc"))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterMvContains() {
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(LOOKUP(dim1, 'lookyloo'), 'xabc')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterMvContainsNull() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(LOOKUP(dim1, 'lookyloo'), NULL)"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_contains(lookup(\"dim1\",'lookyloo'),null)")), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterMvContainsNullInjective() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(LOOKUP(dim1, 'lookyloo121'), NULL)"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_contains(\"dim1\",null)")), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterMvOverlap() {
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(lookup(dim1, 'lookyloo'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableSet.of((Object)"6", (Object)"abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterMvOverlapNull() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(lookup(dim1, 'lookyloo'), ARRAY['xabc', 'x6', 'nonexistent', NULL])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_overlap(lookup(\"dim1\",'lookyloo'),array('xabc','x6','nonexistent',null))")), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterMvOverlapNullInjective() {
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(lookup(dim1, 'lookyloo121'), ARRAY['xabc', 'x6', 'nonexistent', NULL])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList(null, "abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotMvContains() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("NOT MV_CONTAINS(lookup(dim1, 'lookyloo'), 'xabc')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_contains(lookup(\"dim1\",'lookyloo'),'xabc')"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterMvContainsIsNotTrue() {
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(lookup(dim1, 'lookyloo'), 'xabc') IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterNotMvContainsInjective() {
        this.testQuery(this.buildFilterTestSql("NOT MV_CONTAINS(LOOKUP(dim1, 'lookyloo121'), 'xabc')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterNotMvOverlap() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("NOT MV_OVERLAP(lookup(dim1, 'lookyloo'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_overlap(lookup(\"dim1\",'lookyloo'),array('xabc','x6','nonexistent'))"))), Collections.emptyList());
    }

    @Test
    public void testFilterMvOverlapIsNotTrue() {
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(lookup(dim1, 'lookyloo'), ARRAY['xabc', 'x6', 'nonexistent']) IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"6", (Object)"abc"))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterNotMvOverlapInjective() {
        this.testQuery(this.buildFilterTestSql("NOT MV_OVERLAP(lookup(dim1, 'lookyloo121'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterMultipleIsDistinctFrom() {
        ImmutableMap queryContext = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlReverseLookup", (Object)true).put((Object)"maxOptimizeCountForDruidReverseLookupRule", (Object)3).build();
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS DISTINCT FROM 'xabc' AND LOOKUP(dim1, 'lookyloo') IS DISTINCT FROM 'x6' AND LOOKUP(dim1, 'lookyloo') IS DISTINCT FROM 'nonexistent'"), (Map<String, Object>)queryContext, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterIsNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), CalciteLookupFunctionQueryTest.isNull("v0")), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterIsNullInjective() {
        this.cannotVectorize();
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') IS NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("null", CalciteLookupFunctionQueryTest.isNull("dim1")), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterIsNotNull() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.isNull("v0"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterIsNotNullInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') IS NOT NULL"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.isNull("dim1"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotEquals() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') <> 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotEqualsInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') <> 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterEqualsIsNotTrue() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') = 'x6' IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterEqualsIsNotTrueInjective() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo121') = 'xabc' IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterIsDistinctFrom() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') IS DISTINCT FROM 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterIsDistinctFromReplaceMissingValueWithSameLiteral() {
        this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo', 'x6') IS DISTINCT FROM 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo','x6')", ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotEquals2() {
        this.testQuery(this.buildFilterTestSql("NOT (LOOKUP(dim1, 'lookyloo') = 'x6' OR cnt = 2)"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("cnt", 2L, ColumnType.LONG))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterEqualsIsNotTrue2() {
        this.testQuery(this.buildFilterTestSql("(LOOKUP(dim1, 'lookyloo') = 'x6' OR cnt = 2) IS NOT TRUE"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not((DimFilter)CalciteLookupFunctionQueryTest.istrue((DimFilter)CalciteLookupFunctionQueryTest.or(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("cnt", 2L, ColumnType.LONG))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterNotEquals2Injective() {
        this.testQuery(this.buildFilterTestSql("NOT (LOOKUP(dim1, 'lookyloo121') = 'xdef' OR cnt = 2)"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.and(new DimFilter[]{CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "def", ColumnType.STRING)), CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("cnt", 2L, ColumnType.LONG))})), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceSameLiteral() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'x6') = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo','x6')", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterCoalesceSameLiteralInjective() {
        this.cannotVectorize();
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo121'), 'x6') = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("null", CalciteLookupFunctionQueryTest.isNull("dim1")), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterInCoalesceSameLiteral() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'x6') IN ('xa', 'xabc', 'x6')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo','x6')", ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.or(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("a", "abc")), CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterInCoalesceSameLiteralInjective() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo121'), 'x2') IN ('xabc', 'xdef', 'x2')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.or(CalciteLookupFunctionQueryTest.in("dim1", Arrays.asList("2", "abc", "def")), CalciteLookupFunctionQueryTest.isNull("dim1"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterMvContainsCoalesceSameLiteral() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(COALESCE(LOOKUP(dim1, 'lookyloo'), 'x6'), 'x6')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_contains(lookup(\"dim1\",'lookyloo','x6'),'x6')")), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterMvOverlapCoalesceSameLiteral() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(COALESCE(LOOKUP(dim1, 'lookyloo'), 'x6'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.expressionFilter("mv_overlap(lookup(\"dim1\",'lookyloo','x6'),array('xabc','x6','nonexistent'))")), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceSameLiteralNotEquals() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'x6') <> 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo','x6')", ColumnType.STRING), (DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceSameLiteralNotEqualsInjective() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo121'), 'xabc') <> 'xabc'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "abc", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}));
    }

    @Test
    public void testFilterCoalesceDifferentLiteral() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy') = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'x6'", CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterCoalesceDifferentLiteralAlwaysFalse() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy') = 'nonexistent'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryAlwaysFalse(), Collections.emptyList());
    }

    @Test
    public void testFilterCoalesceCastVarcharDifferentLiteral() {
        this.testQuery(this.buildFilterTestSql("COALESCE(CAST(LOOKUP(dim1, 'lookyloo') AS VARCHAR), 'xyzzy') = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQueryConstantDimension("'x6'", CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterCoalesceCastBigintDifferentLiteral() {
        this.testQuery(this.buildFilterTestSql("COALESCE(CAST(LOOKUP(dim1, 'lookyloo') AS BIGINT), 1) = 6"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "nvl(CAST(lookup(\"dim1\",'lookyloo'), 'LONG'),1)", ColumnType.LONG), CalciteLookupFunctionQueryTest.equality("v0", 6L, ColumnType.LONG)), Collections.emptyList());
    }

    @Test
    public void testFilterMvContainsCoalesceDifferentLiteral() {
        this.testQuery(this.buildFilterTestSql("MV_CONTAINS(COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy'), 'x6')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterMvOverlapCoalesceDifferentLiteral() {
        this.testQuery(this.buildFilterTestSql("MV_OVERLAP(COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy'), ARRAY['xabc', 'x6', 'nonexistent'])"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableSet.of((Object)"6", (Object)"abc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceDifferentLiteralNotEquals() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy') <> 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.equality("dim1", "6", ColumnType.STRING))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceDifferentLiteralNotEqualsAlwaysTrue() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), 'xyzzy') <> 'nonexistent'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery(null), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceSameColumn() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), dim1) = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "nvl(lookup(\"dim1\",'lookyloo'),\"dim1\")", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterInCoalesceSameColumn() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), dim1) IN ('xabc', '10.1')"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "nvl(lookup(\"dim1\",'lookyloo'),\"dim1\")", ColumnType.STRING), CalciteLookupFunctionQueryTest.in("v0", (Collection<String>)ImmutableList.of((Object)"10.1", (Object)"xabc"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testFilterCoalesceFunctionOfSameColumn() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), dim1 || '') = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "nvl(lookup(\"dim1\",'lookyloo'),concat(\"dim1\",''))", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterCoalesceDifferentColumn() {
        this.testQuery(this.buildFilterTestSql("COALESCE(LOOKUP(dim1, 'lookyloo'), dim2) = 'x6'"), QUERY_CONTEXT, this.buildFilterTestExpectedQuery((VirtualColumn)CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "nvl(lookup(\"dim1\",'lookyloo'),\"dim2\")", ColumnType.STRING), CalciteLookupFunctionQueryTest.equality("v0", "x6", ColumnType.STRING)), Collections.emptyList());
    }

    @Test
    public void testFilterMaxUnapplyCount() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testQuery(this.buildFilterTestSql("LOOKUP(dim1, 'lookyloo') = 'xabc' OR LOOKUP(dim2, 'lookyloo') = 'x6'"), QUERY_CONTEXT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Too many optimize calls[2]")));
    }

    @Test
    public void testLookupReplaceMissingValueWith() {
        this.testQuery("SELECT\n  LOOKUP(dim1, 'lookyloo', 'Missing_Value'),\n  COALESCE(LOOKUP(dim1, 'lookyloo'), 'Missing_Value'), -- converted to the first form\n  LOOKUP(dim1, 'lookyloo', null) as rmvNull,\n  COUNT(*)\nFROM foo\nGROUP BY 1,2,3", QUERY_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo','Missing_Value')", ColumnType.STRING), CalciteLookupFunctionQueryTest.expressionVirtualColumn("v1", "lookup(\"dim1\",'lookyloo',null)", ColumnType.STRING)}).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "d1", ColumnType.STRING), new DefaultDimensionSpec("v1", "d2", ColumnType.STRING)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Missing_Value", "Missing_Value", null, 5L}, (Object)new Object[]{"xabc", "xabc", "xabc", 1L}));
    }

    @Test
    public void testLookupReplaceMissingValueWithExtractionFns() {
        this.cannotVectorize();
        RegisteredLookupExtractionFn extractionFn1 = new RegisteredLookupExtractionFn(null, "lookyloo", false, "Missing_Value", null, Boolean.valueOf(false));
        this.testQuery("SELECT\n  LOOKUP(dim1, 'lookyloo', 'Missing_Value'),\n  COALESCE(LOOKUP(dim1, 'lookyloo'), 'Missing_Value'), -- converted to the first form\n  LOOKUP(dim1, 'lookyloo', null) as rmvNull,\n  COUNT(*)\nFROM foo\nGROUP BY 1,2,3", QUERY_CONTEXT_WITH_EXTRACTION_FNS, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", ColumnType.STRING, (ExtractionFn)extractionFn1), new ExtractionDimensionSpec("dim1", "d1", ColumnType.STRING, (ExtractionFn)extractionFn1), new ExtractionDimensionSpec("dim1", "d2", ColumnType.STRING, EXTRACTION_FN)})).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_WITH_EXTRACTION_FNS).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Missing_Value", "Missing_Value", null, 5L}, (Object)new Object[]{"xabc", "xabc", "xabc", 1L}));
    }

    @Test
    public void testCountDistinctOfLookup() {
        this.testQuery("SELECT COUNT(DISTINCT LOOKUP(dim1, 'lookyloo')) FROM foo", QUERY_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING)}).aggregators(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testLookupOnValueThatIsNull() {
        ImmutableList expected = ImmutableList.builder().add((Object[])new Object[][]{{null, null}, {null, null}}).build();
        this.testQuery("SELECT dim2 ,lookup(dim2,'lookyloo') from foo where dim2 is null", QUERY_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("foo").intervals(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).columnTypes(new ColumnType[]{ColumnType.STRING}).columns(new String[]{"v0"}).filters(CalciteLookupFunctionQueryTest.isNull("dim2")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testLookupOnValueThatIsNotDistinctFromNull() {
        ImmutableList expected = ImmutableList.builder().add((Object[])new Object[][]{{null, null}, {null, null}}).build();
        this.testQuery("SELECT dim2 ,lookup(dim2,'lookyloo') from foo where dim2 is not distinct from null", QUERY_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("foo").intervals(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).columnTypes(new ColumnType[]{ColumnType.STRING}).columns(new String[]{"v0"}).filters(CalciteLookupFunctionQueryTest.isNull("dim2")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testExactCountDistinct() {
        this.msqIncompatible();
        String sqlQuery = "SELECT CAST(LOOKUP(dim1, 'lookyloo') AS VARCHAR), COUNT(DISTINCT foo.dim2), SUM(foo.cnt) FROM druid.foo GROUP BY 1";
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true")), QUERY_CONTEXT, "SELECT CAST(LOOKUP(dim1, 'lookyloo') AS VARCHAR), COUNT(DISTINCT foo.dim2), SUM(foo.cnt) FROM druid.foo GROUP BY 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING)}).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("v0", "dim2"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"))).build())).setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteLookupFunctionQueryTest.and(CalciteLookupFunctionQueryTest.notNull("d1"), CalciteLookupFunctionQueryTest.equality("a1", 0L, ColumnType.LONG))), new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("_a1", "a0"), CalciteLookupFunctionQueryTest.equality("a1", 1L, ColumnType.LONG))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L, 5L}, (Object)new Object[]{"xabc", 0L, 1L}));
    }

    @Test
    public void testPullUpLookup() {
        this.testQuery("SELECT LOOKUP(dim1, 'lookyloo121'), COUNT(*) FROM druid.foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteLookupFunctionQueryTest.expressionPostAgg("p0", "lookup(\"d0\",'lookyloo121')", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"x", 1L}, (Object)new Object[]{"x1", 1L}, (Object)new Object[]{"x10.1", 1L}, (Object)new Object[]{"x2", 1L}, (Object)new Object[]{"xabc", 1L}, (Object)new Object[]{"xdef", 1L}));
    }

    @Test
    public void testPullUpAndReverseLookup() {
        this.testQuery("SELECT LOOKUP(dim1, 'lookyloo121'), COUNT(*)\nFROM druid.foo\nWHERE LOOKUP(dim1, 'lookyloo121') IN ('xabc', 'xdef')\nGROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteLookupFunctionQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def"))).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteLookupFunctionQueryTest.expressionPostAgg("p0", "lookup(\"d0\",'lookyloo121')", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}, (Object)new Object[]{"xdef", 1L}));
    }

    @Test
    public void testDontPullUpLookupWhenUsedByAggregation() {
        this.testQuery("SELECT LOOKUP(dim1, 'lookyloo121'), COUNT(LOOKUP(dim1, 'lookyloo121')) FROM druid.foo GROUP BY 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", "lookup(\"dim1\",'lookyloo121')", ColumnType.STRING)}).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteLookupFunctionQueryTest.not(CalciteLookupFunctionQueryTest.isNull("v0")))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"x", 1L}, (Object)new Object[]{"x1", 1L}, (Object)new Object[]{"x10.1", 1L}, (Object)new Object[]{"x2", 1L}, (Object)new Object[]{"xabc", 1L}, (Object)new Object[]{"xdef", 1L}));
    }

    @Test
    public void testPullUpLookupGroupOnLookupInput() {
        this.testQuery("SELECT dim1, LOOKUP(dim1, 'lookyloo121'), COUNT(*) FROM druid.foo GROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteLookupFunctionQueryTest.expressionPostAgg("p0", "lookup(\"d0\",'lookyloo121')", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "x", 1L}, (Object)new Object[]{"1", "x1", 1L}, (Object)new Object[]{"10.1", "x10.1", 1L}, (Object)new Object[]{"2", "x2", 1L}, (Object)new Object[]{"abc", "xabc", 1L}, (Object)new Object[]{"def", "xdef", 1L}));
    }

    @Test
    public void testPullUpLookupMoreDimensions() {
        this.testQuery("SELECT COUNT(*), dim2, dim1, LOOKUP(dim1, 'lookyloo121') FROM druid.foo GROUP BY 2, 3", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteLookupFunctionQueryTest.expressionPostAgg("p0", "lookup(\"d0\",'lookyloo121')", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, "a", "", "x"}, (Object)new Object[]{1L, "a", "1", "x1"}, (Object)new Object[]{1L, null, "10.1", "x10.1"}, (Object)new Object[]{1L, "", "2", "x2"}, (Object)new Object[]{1L, null, "abc", "xabc"}, (Object)new Object[]{1L, "abc", "def", "xdef"}));
    }

    @Test
    public void testPullUpLookupOneInjectiveOneNot() {
        this.testQuery("SELECT COUNT(*), LOOKUP(dim1, 'lookyloo'), LOOKUP(dim1, 'lookyloo121') FROM druid.foo GROUP BY 2, 3", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING)}).setDimensions(CalciteLookupFunctionQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim1", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteLookupFunctionQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteLookupFunctionQueryTest.expressionPostAgg("p0", "lookup(\"d1\",'lookyloo121')", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, null, "x"}, (Object)new Object[]{1L, null, "x1"}, (Object)new Object[]{1L, null, "x10.1"}, (Object)new Object[]{1L, null, "x2"}, (Object)new Object[]{1L, null, "xdef"}, (Object)new Object[]{1L, "xabc", "xabc"}));
    }

    private String buildFilterTestSql(String conditionSql) {
        return "SELECT LOOKUP(dim1, 'lookyloo'), COUNT(*) FROM foo\nWHERE (" + conditionSql + ") AND TIME_IN_INTERVAL(__time, '2000/3000')\nGROUP BY LOOKUP(dim1, 'lookyloo')";
    }

    private List<Query<?>> buildFilterTestExpectedQuery(@Nullable VirtualColumn expectedVirtualColumn, @Nullable DimFilter expectedFilter) {
        VirtualColumns virtualColumns;
        String groupByDimension;
        if (expectedVirtualColumn != null) {
            if (expectedVirtualColumn instanceof ExpressionVirtualColumn && LOOKUP_EXPRESSION.equals(((ExpressionVirtualColumn)expectedVirtualColumn).getExpression())) {
                groupByDimension = expectedVirtualColumn.getOutputName();
                virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{expectedVirtualColumn});
            } else {
                groupByDimension = "v1";
                virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{expectedVirtualColumn, CalciteLookupFunctionQueryTest.expressionVirtualColumn(groupByDimension, LOOKUP_EXPRESSION, ColumnType.STRING)});
            }
        } else {
            groupByDimension = "v0";
            virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", LOOKUP_EXPRESSION, ColumnType.STRING)});
        }
        return ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Intervals.of((String)"2000/3000"))).setVirtualColumns(virtualColumns).setGranularity(Granularities.ALL).setDimFilter(expectedFilter).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec(groupByDimension, "d0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT).build());
    }

    private List<Query<?>> buildFilterTestExpectedQuery(@Nullable DimFilter expectedFilter) {
        return this.buildFilterTestExpectedQuery(null, expectedFilter);
    }

    private List<Query<?>> buildFilterTestExpectedQueryConstantDimension(String expectedConstantDimension, @Nullable DimFilter expectedFilter) {
        return ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteLookupFunctionQueryTest.querySegmentSpec(Intervals.of((String)"2000/3000"))).setVirtualColumns(new VirtualColumn[]{CalciteLookupFunctionQueryTest.expressionVirtualColumn("v0", expectedConstantDimension, ColumnType.STRING)}).setGranularity(Granularities.ALL).setDimFilter(expectedFilter).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT).build());
    }

    private List<Query<?>> buildFilterTestExpectedQueryAlwaysFalse() {
        return ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("$f1", ColumnType.LONG).build())).intervals(CalciteLookupFunctionQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "$f1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT).build());
    }
}

