/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.IngestionTestSqlEngine;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.ExternalOperatorConversion;
import org.apache.druid.sql.calcite.external.HttpOperatorConversion;
import org.apache.druid.sql.calcite.external.InlineOperatorConversion;
import org.apache.druid.sql.calcite.external.LocalOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.guice.SqlBindings;
import org.apache.druid.sql.http.SqlParameter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.AfterEach;

@SqlTestFrameworkConfig.ComponentSupplier(value=IngestionDmlComponentSupplier.class)
public class CalciteIngestionDmlTest
extends BaseCalciteQueryTest {
    protected static final Map<String, Object> DEFAULT_CONTEXT = ImmutableMap.builder().put((Object)"sqlQueryId", (Object)"dummy").build();
    public static final Map<String, Object> PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)"{\"type\":\"all\"}");
    protected static final RowSignature FOO_TABLE_SIGNATURE = RowSignature.builder().addTimeColumn().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("dim3", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m1", ColumnType.FLOAT).add("m2", ColumnType.DOUBLE).add("unique_dim1", HyperUniquesAggregatorFactory.TYPE).build();
    protected final ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("a,b,1\nc,d,2\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.LONG).build());
    protected boolean didTest = false;

    @AfterEach
    public void tearDown() {
        if (!this.didTest) {
            throw new ISE("Test was not run; did you call verify() on a tester?", new Object[0]);
        }
    }

    protected String externSql(ExternalDataSource externalDataSource) {
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            return StringUtils.format((String)"TABLE(extern(%s, %s, %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputSource())), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputFormat())), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getSignature()))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> queryContextWithGranularity(Granularity granularity) {
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        String granularityString = null;
        try {
            granularityString = queryJsonMapper.writeValueAsString((Object)granularity);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)e.getMessage());
        }
        return ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)granularityString);
    }

    protected IngestionDmlTester testIngestionQuery() {
        return new IngestionDmlTester();
    }

    public class IngestionDmlTester {
        private String sql;
        private PlannerConfig plannerConfig = new PlannerConfig();
        private Map<String, Object> queryContext = DEFAULT_CONTEXT;
        private AuthenticationResult authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
        private String expectedTargetDataSource;
        private RowSignature expectedTargetSignature;
        private List<ResourceAction> expectedResources;
        private Query<?> expectedQuery;
        private Matcher<Throwable> validationErrorMatcher;
        private String expectedLogicalPlanResource;
        private List<SqlParameter> parameters;
        private AuthConfig authConfig;

        private IngestionDmlTester() {
        }

        public IngestionDmlTester sql(String sql) {
            this.sql = sql;
            return this;
        }

        protected IngestionDmlTester sql(String sqlPattern, Object arg, Object ... otherArgs) {
            Object[] args = new Object[otherArgs.length + 1];
            args[0] = arg;
            System.arraycopy(otherArgs, 0, args, 1, otherArgs.length);
            this.sql = StringUtils.format((String)sqlPattern, (Object[])args);
            return this;
        }

        public IngestionDmlTester context(Map<String, Object> context) {
            this.queryContext = context;
            return this;
        }

        public IngestionDmlTester authentication(AuthenticationResult authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public IngestionDmlTester parameters(List<SqlParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public IngestionDmlTester authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public IngestionDmlTester expectTarget(String expectedTargetDataSource, RowSignature expectedTargetSignature) {
            this.expectedTargetDataSource = (String)Preconditions.checkNotNull((Object)expectedTargetDataSource, (Object)"expectedTargetDataSource");
            this.expectedTargetSignature = (RowSignature)Preconditions.checkNotNull((Object)expectedTargetSignature, (Object)"expectedTargetSignature");
            return this;
        }

        public IngestionDmlTester expectResources(ResourceAction ... expectedResources) {
            this.expectedResources = Arrays.asList(expectedResources);
            return this;
        }

        public IngestionDmlTester expectQuery(Query expectedQuery) {
            this.expectedQuery = expectedQuery;
            return this;
        }

        public IngestionDmlTester expectValidationError(Matcher<Throwable> validationErrorMatcher) {
            this.validationErrorMatcher = validationErrorMatcher;
            return this;
        }

        public IngestionDmlTester expectValidationError(Class<? extends Throwable> clazz) {
            return this.expectValidationError((Matcher<Throwable>)CoreMatchers.instanceOf(clazz));
        }

        public IngestionDmlTester expectValidationError(Class<? extends Throwable> clazz, String message) {
            return this.expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(clazz), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)message))));
        }

        public IngestionDmlTester expectLogicalPlanFrom(String resource) {
            this.expectedLogicalPlanResource = resource;
            return this;
        }

        public void verify() {
            if (CalciteIngestionDmlTest.this.didTest) {
                throw new ISE("Use one @Test method per tester", new Object[0]);
            }
            CalciteIngestionDmlTest.this.didTest = true;
            if (this.sql == null) {
                throw new ISE("Test must have SQL statement", new Object[0]);
            }
            try {
                BaseCalciteQueryTest.log.info("SQL: %s", new Object[]{this.sql});
                if (this.validationErrorMatcher != null) {
                    this.verifyValidationError();
                } else {
                    this.verifySuccess();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void verifyValidationError() {
            if (this.expectedTargetDataSource != null) {
                throw new ISE("Test must not have expectedTargetDataSource", new Object[0]);
            }
            if (this.expectedResources != null) {
                throw new ISE("Test must not have expectedResources", new Object[0]);
            }
            if (this.expectedQuery != null) {
                throw new ISE("Test must not have expectedQuery", new Object[0]);
            }
            Throwable e = Assert.assertThrows(Throwable.class, () -> CalciteIngestionDmlTest.this.getSqlStatementFactory(this.plannerConfig, this.authConfig).directStatement(this.sqlQuery()).execute());
            MatcherAssert.assertThat((Object)e, this.validationErrorMatcher);
        }

        private void verifySuccess() {
            if (this.expectedTargetDataSource == null) {
                throw new ISE("Test must have expectedTargetDataSource", new Object[0]);
            }
            if (this.expectedResources == null) {
                throw new ISE("Test must have expectedResources", new Object[0]);
            }
            CalciteIngestionDmlTest.this.testBuilder().sql(this.sql).queryContext(this.queryContext).authResult(this.authenticationResult).parameters(this.parameters).plannerConfig(this.plannerConfig).authConfig(this.authConfig).expectedResources(this.expectedResources).run();
            String expectedLogicalPlan = this.expectedLogicalPlanResource != null ? StringUtils.getResource((Object)this, (String)("/calcite/expected/ingest/" + this.expectedLogicalPlanResource + "-logicalPlan.txt")) : null;
            CalciteIngestionDmlTest.this.testBuilder().sql(this.sql).queryContext(this.queryContext).authResult(this.authenticationResult).parameters(this.parameters).plannerConfig(this.plannerConfig).authConfig(this.authConfig).expectedQuery(this.expectedQuery).expectedResults(Collections.singletonList(new Object[]{this.expectedTargetDataSource, this.expectedTargetSignature})).expectedLogicalPlan(expectedLogicalPlan).run();
        }

        private SqlQueryPlus sqlQuery() {
            return SqlQueryPlus.builder((String)this.sql).queryContext(this.queryContext).auth(this.authenticationResult).build();
        }
    }

    static class CalciteIngestDmlTestException
    extends RuntimeException {
        public CalciteIngestDmlTestException(String message) {
            super(message);
        }
    }

    static class TestFileInputSource
    extends AbstractInputSource
    implements SplittableInputSource<File> {
        private final List<File> files;

        @JsonCreator
        TestFileInputSource(@JsonProperty(value="files") List<File> fileList) {
            this.files = fileList;
        }

        @JsonIgnore
        @Nonnull
        public Set<String> getTypes() {
            throw new CalciteIngestDmlTestException("getTypes()");
        }

        @JsonProperty
        public List<File> getFiles() {
            return this.files;
        }

        public Stream<InputSplit<File>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.files.stream().map(InputSplit::new);
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.files.size();
        }

        public SplittableInputSource<File> withSplit(InputSplit<File> split) {
            return new TestFileInputSource((List<File>)ImmutableList.of((Object)((File)split.get())));
        }

        public boolean needsFormat() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestFileInputSource that = (TestFileInputSource)((Object)o);
            return Objects.equals(this.files, that.files);
        }

        public int hashCode() {
            return Objects.hash(this.files);
        }
    }

    public static class IngestionDmlComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        public IngestionDmlComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public Class<? extends SqlEngine> getSqlEngineClass() {
            return IngestionTestSqlEngine.class;
        }

        @Override
        public DruidModule getCoreModule() {
            return DruidModuleCollection.of((Module[])new Module[]{super.getCoreModule(), new ExternalDataSourceModule(), new CustomInputSourceModule()});
        }

        private static final class ExternalDataSourceModule
        implements DruidModule {
            private ExternalDataSourceModule() {
            }

            public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
                return Collections.singletonList(new SimpleModule(this.getClass().getSimpleName()).registerSubtypes(new Class[]{ExternalDataSource.class}));
            }

            public void configure(Binder binder) {
            }
        }

        private static final class CustomInputSourceModule
        implements DruidModule {
            private CustomInputSourceModule() {
            }

            public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
                ArrayList<SimpleModule> modules = new ArrayList<SimpleModule>(new InputSourceModule().getJacksonModules());
                modules.add(new SimpleModule("test-module").registerSubtypes(new Class[]{TestFileInputSource.class}));
                return modules;
            }

            public void configure(Binder binder) {
                binder.install((Module)new InputSourceModule());
                SqlBindings.addOperatorConversion((Binder)binder, ExternalOperatorConversion.class);
                SqlBindings.addOperatorConversion((Binder)binder, HttpOperatorConversion.class);
                SqlBindings.addOperatorConversion((Binder)binder, InlineOperatorConversion.class);
                SqlBindings.addOperatorConversion((Binder)binder, LocalOperatorConversion.class);
            }
        }
    }
}

