/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.query.Query;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.junit.jupiter.api.Test;

public class CalciteExplainQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testExplainCountStarOnView() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'";
        String explanation = "[{\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"substring(\\\"dim1\\\", 0, 1)\",\"outputType\":\"STRING\"}],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"equals\",\"column\":\"dim2\",\"matchValueType\":\"STRING\",\"matchValue\":\"a\"},{\"type\":\"not\",\"field\":{\"type\":\"equals\",\"column\":\"v0\",\"matchValueType\":\"STRING\",\"matchValue\":\"z\"}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"a0\",\"outputColumn\":\"EXPR$0\"}]}]";
        String resources = "[{\"name\":\"aview\",\"type\":\"VIEW\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"substring(\\\"dim1\\\", 0, 1)\",\"outputType\":\"STRING\"}],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"equals\",\"column\":\"dim2\",\"matchValueType\":\"STRING\",\"matchValue\":\"a\"},{\"type\":\"not\",\"field\":{\"type\":\"equals\",\"column\":\"v0\",\"matchValueType\":\"STRING\",\"matchValue\":\"z\"}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"a0\",\"outputColumn\":\"EXPR$0\"}]}]", "[{\"name\":\"aview\",\"type\":\"VIEW\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainInformationSchemaColumns() {
        String explanation = "BindableProject(COLUMN_NAME=[$3], DATA_TYPE=[$7])\n  BindableFilter(condition=[AND(=($1, 'druid'), =($2, 'foo'))])\n    BindableTableScan(table=[[INFORMATION_SCHEMA, COLUMNS]])\n";
        String resources = "[]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("EXPLAIN PLAN FOR\nSELECT COLUMN_NAME, DATA_TYPE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"BindableProject(COLUMN_NAME=[$3], DATA_TYPE=[$7])\n  BindableFilter(condition=[AND(=($1, 'druid'), =($2, 'foo'))])\n    BindableTableScan(table=[[INFORMATION_SCHEMA, COLUMNS]])\n", "[]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainExactCountDistinctOfSemiJoinResult() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)";
        String explanation = "[{\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"table\",\"name\":\"foo\"},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"substring(\\\"dim1\\\", 0, 1)\",\"outputType\":\"STRING\"}],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"null\",\"column\":\"dim1\"}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"v0\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}},\"rightPrefix\":\"j0.\",\"condition\":\"(substring(\\\"dim2\\\", 0, 1) == \\\"j0.d0\\\")\",\"joinType\":\"INNER\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"a0\",\"outputColumn\":\"EXPR$0\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"table\",\"name\":\"foo\"},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"substring(\\\"dim1\\\", 0, 1)\",\"outputType\":\"STRING\"}],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"null\",\"column\":\"dim1\"}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"v0\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}},\"rightPrefix\":\"j0.\",\"condition\":\"(substring(\\\"dim2\\\", 0, 1) == \\\"j0.d0\\\")\",\"joinType\":\"INNER\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"a0\",\"outputColumn\":\"EXPR$0\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testSetStatementWithExplainSanity() {
        this.skipVectorize();
        String query = "SET plannerStrategy = 'DECOUPLED';\n EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)";
        String explanation = "DruidAggregate(group=[{}], EXPR$0=[COUNT()], druid=[logical])\n  DruidAggregate(group=[{0}], druid=[logical])\n    DruidJoin(condition=[=($1, $2)], joinType=[inner])\n      DruidProject(dim2=[$2], $f1=[SUBSTRING($2, 1, 1)], druid=[logical])\n        DruidTableScan(table=[[druid, foo]], druid=[logical])\n      DruidAggregate(group=[{0}], druid=[logical])\n        DruidProject(EXPR$0=[SUBSTRING($1, 1, 1)], druid=[logical])\n          DruidFilter(condition=[IS NOT NULL($1)])\n            DruidTableScan(table=[[druid, foo]], druid=[logical])\n";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("SET plannerStrategy = 'DECOUPLED';\n EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidAggregate(group=[{}], EXPR$0=[COUNT()], druid=[logical])\n  DruidAggregate(group=[{0}], druid=[logical])\n    DruidJoin(condition=[=($1, $2)], joinType=[inner])\n      DruidProject(dim2=[$2], $f1=[SUBSTRING($2, 1, 1)], druid=[logical])\n        DruidTableScan(table=[[druid, foo]], druid=[logical])\n      DruidAggregate(group=[{0}], druid=[logical])\n        DruidProject(EXPR$0=[SUBSTRING($1, 1, 1)], druid=[logical])\n          DruidFilter(condition=[IS NOT NULL($1)])\n            DruidTableScan(table=[[druid, foo]], druid=[logical])\n", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testMultiStatementSetsContextOverridesQueryContext() {
        this.skipVectorize();
        String query = "SET plannerStrategy = 'DECOUPLED';\n SET timeout = 90000;\n EXPLAIN PLAN FOR \nSELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)";
        String explanation = "DruidAggregate(group=[{}], EXPR$0=[COUNT()], druid=[logical])\n  DruidAggregate(group=[{0}], druid=[logical])\n    DruidJoin(condition=[=($1, $2)], joinType=[inner])\n      DruidProject(dim2=[$2], $f1=[SUBSTRING($2, 1, 1)], druid=[logical])\n        DruidTableScan(table=[[druid, foo]], druid=[logical])\n      DruidAggregate(group=[{0}], druid=[logical])\n        DruidProject(EXPR$0=[SUBSTRING($1, 1, 1)], druid=[logical])\n          DruidFilter(condition=[IS NOT NULL($1)])\n            DruidTableScan(table=[[druid, foo]], druid=[logical])\n";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("SET plannerStrategy = 'DECOUPLED';\n SET timeout = 90000;\n EXPLAIN PLAN FOR \nSELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)", (Map<String, Object>)ImmutableMap.of((Object)"plannerStrategy", (Object)"COUPLED"), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidAggregate(group=[{}], EXPR$0=[COUNT()], druid=[logical])\n  DruidAggregate(group=[{0}], druid=[logical])\n    DruidJoin(condition=[=($1, $2)], joinType=[inner])\n      DruidProject(dim2=[$2], $f1=[SUBSTRING($2, 1, 1)], druid=[logical])\n        DruidTableScan(table=[[druid, foo]], druid=[logical])\n      DruidAggregate(group=[{0}], druid=[logical])\n        DruidProject(EXPR$0=[SUBSTRING($1, 1, 1)], druid=[logical])\n          DruidFilter(condition=[IS NOT NULL($1)])\n            DruidTableScan(table=[[druid, foo]], druid=[logical])\n", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainSelectStar() {
        this.skipVectorize();
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]";
        String sql = "EXPLAIN PLAN FOR SELECT * FROM druid.foo";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery(sql, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{explanation, resources, "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainMultipleTopLevelUnionAllQueries() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT dim1 FROM druid.foo\nUNION ALL (SELECT dim1 FROM druid.foo WHERE dim1 = '42'\nUNION ALL SELECT dim1 FROM druid.foo WHERE dim1 = '44')";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"filter\":{\"type\":\"equals\",\"column\":\"dim1\",\"matchValueType\":\"STRING\",\"matchValue\":\"42\"},\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"filter\":{\"type\":\"equals\",\"column\":\"dim1\",\"matchValueType\":\"STRING\",\"matchValue\":\"44\"},\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT dim1 FROM druid.foo\nUNION ALL (SELECT dim1 FROM druid.foo WHERE dim1 = '42'\nUNION ALL SELECT dim1 FROM druid.foo WHERE dim1 = '44')", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"filter\":{\"type\":\"equals\",\"column\":\"dim1\",\"matchValueType\":\"STRING\",\"matchValue\":\"42\"},\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"filter\":{\"type\":\"equals\",\"column\":\"dim1\",\"matchValueType\":\"STRING\",\"matchValue\":\"44\"},\"columns\":[\"dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainSelectMvfilterExpressions() {
        this.skipVectorize();
        String explainSql = "EXPLAIN PLAN FOR SELECT MV_FILTER_ONLY(\"dim1\", ARRAY['true', 'false']), MV_FILTER_NONE(\"dim1\", ARRAY['true', 'false']), MV_FILTER_REGEX(\"dim1\", '^true$'), MV_FILTER_PREFIX(\"dim1\", 'tr') FROM druid.foo";
        HashMap<String, Object> defaultExprContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        defaultExprContext.put("useNativeQueryExplain", true);
        defaultExprContext.put("forceExpressionVirtualColumns", true);
        String expectedPlanWithDefaultExpressions = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"filter((x) -> array_contains(array('true','false'), x), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"filter((x) -> !array_contains(array('true','false'), x), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v2\",\"expression\":\"filter((x) -> regexp_like(x, \\\"^true$\\\"), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v3\",\"expression\":\"filter((x) -> (x != null && substring(x, 0, 2) == \\\"tr\\\"), \\\"dim1\\\")\",\"outputType\":\"STRING\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\",\"v1\",\"v2\",\"v3\"],\"context\":{\"defaultTimeout\":300000,\"forceExpressionVirtualColumns\":true,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"STRING\"},{\"name\":\"v2\",\"type\":\"STRING\"},{\"name\":\"v3\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"EXPR$1\"},{\"queryColumn\":\"v2\",\"outputColumn\":\"EXPR$2\"},{\"queryColumn\":\"v3\",\"outputColumn\":\"EXPR$3\"}]}]";
        String expectedResources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String expectedAttributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("EXPLAIN PLAN FOR SELECT MV_FILTER_ONLY(\"dim1\", ARRAY['true', 'false']), MV_FILTER_NONE(\"dim1\", ARRAY['true', 'false']), MV_FILTER_REGEX(\"dim1\", '^true$'), MV_FILTER_PREFIX(\"dim1\", 'tr') FROM druid.foo", (Map<String, Object>)defaultExprContext, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"filter((x) -> array_contains(array('true','false'), x), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"filter((x) -> !array_contains(array('true','false'), x), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v2\",\"expression\":\"filter((x) -> regexp_like(x, \\\"^true$\\\"), \\\"dim1\\\")\",\"outputType\":\"STRING\"},{\"type\":\"expression\",\"name\":\"v3\",\"expression\":\"filter((x) -> (x != null && substring(x, 0, 2) == \\\"tr\\\"), \\\"dim1\\\")\",\"outputType\":\"STRING\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\",\"v1\",\"v2\",\"v3\"],\"context\":{\"defaultTimeout\":300000,\"forceExpressionVirtualColumns\":true,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"STRING\"},{\"name\":\"v2\",\"type\":\"STRING\"},{\"name\":\"v3\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"EXPR$1\"},{\"queryColumn\":\"v2\",\"outputColumn\":\"EXPR$2\"},{\"queryColumn\":\"v3\",\"outputColumn\":\"EXPR$3\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
        String expectedPlanWithMvfiltered = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"mv-filtered\",\"name\":\"v0\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"values\":[\"true\",\"false\"],\"isAllowList\":true},{\"type\":\"mv-filtered\",\"name\":\"v1\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"values\":[\"true\",\"false\"],\"isAllowList\":false},{\"type\":\"mv-regex-filtered\",\"name\":\"v2\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"pattern\":\"^true$\"},{\"type\":\"mv-prefix-filtered\",\"name\":\"v3\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"prefix\":\"tr\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\",\"v1\",\"v2\",\"v3\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"STRING\"},{\"name\":\"v2\",\"type\":\"STRING\"},{\"name\":\"v3\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"EXPR$1\"},{\"queryColumn\":\"v2\",\"outputColumn\":\"EXPR$2\"},{\"queryColumn\":\"v3\",\"outputColumn\":\"EXPR$3\"}]}]";
        HashMap<String, Object> mvFilteredContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        mvFilteredContext.put("useNativeQueryExplain", true);
        this.testQuery("EXPLAIN PLAN FOR SELECT MV_FILTER_ONLY(\"dim1\", ARRAY['true', 'false']), MV_FILTER_NONE(\"dim1\", ARRAY['true', 'false']), MV_FILTER_REGEX(\"dim1\", '^true$'), MV_FILTER_PREFIX(\"dim1\", 'tr') FROM druid.foo", (Map<String, Object>)mvFilteredContext, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"mv-filtered\",\"name\":\"v0\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"values\":[\"true\",\"false\"],\"isAllowList\":true},{\"type\":\"mv-filtered\",\"name\":\"v1\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"values\":[\"true\",\"false\"],\"isAllowList\":false},{\"type\":\"mv-regex-filtered\",\"name\":\"v2\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"pattern\":\"^true$\"},{\"type\":\"mv-prefix-filtered\",\"name\":\"v3\",\"delegate\":{\"type\":\"default\",\"dimension\":\"dim1\",\"outputName\":\"dim1\",\"outputType\":\"STRING\"},\"prefix\":\"tr\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\",\"v1\",\"v2\",\"v3\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"STRING\"},{\"name\":\"v2\",\"type\":\"STRING\"},{\"name\":\"v3\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"EXPR$1\"},{\"queryColumn\":\"v2\",\"outputColumn\":\"EXPR$2\"},{\"queryColumn\":\"v3\",\"outputColumn\":\"EXPR$3\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testExplainSelectTimestampExpression() {
        this.skipVectorize();
        String explainSql = "EXPLAIN PLAN FOR SELECT TIME_PARSE(dim1) FROM druid.foo";
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("useNativeQueryExplain", true);
        String expectedPlan = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"timestamp_parse(\\\"dim1\\\",null,'UTC')\",\"outputType\":\"LONG\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"}]}]";
        String expectedResources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String expectedAttributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery("EXPLAIN PLAN FOR SELECT TIME_PARSE(dim1) FROM druid.foo", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"timestamp_parse(\\\"dim1\\\",null,'UTC')\",\"outputType\":\"LONG\"}],\"resultFormat\":\"compactedList\",\"columns\":[\"v0\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"EXPR$0\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }
}

