/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.CascadeExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.DrillWindowQueryTest;
import org.apache.druid.sql.calcite.QueryTestBuilder;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.http.SqlParameter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.RegisterExtension;

public class BaseCalciteQueryTest
extends CalciteTestBase {
    public static final double ASSERTION_EPSILON = 1.0E-5;
    public static final Logger log = new Logger(BaseCalciteQueryTest.class);
    public static final PlannerConfig PLANNER_CONFIG_DEFAULT = new PlannerConfig();
    public static final PlannerConfig PLANNER_CONFIG_REQUIRE_TIME_CONDITION = PlannerConfig.builder().requireTimeCondition(true).build();
    public static final PlannerConfig PLANNER_CONFIG_NO_TOPN = PlannerConfig.builder().maxTopNLimit(0).build();
    public static final PlannerConfig PLANNER_CONFIG_NO_HLL = PlannerConfig.builder().useApproximateCountDistinct(false).build();
    public static final String LOS_ANGELES = "America/Los_Angeles";
    public static final PlannerConfig PLANNER_CONFIG_LOS_ANGELES = PlannerConfig.builder().sqlTimeZone(DateTimes.inferTzFromString((String)"America/Los_Angeles")).build();
    public static final PlannerConfig PLANNER_CONFIG_AUTHORIZE_SYS_TABLES = PlannerConfig.builder().authorizeSystemTablesDirectly(true).build();
    public static final PlannerConfig PLANNER_CONFIG_LEGACY_QUERY_EXPLAIN = PlannerConfig.builder().useNativeQueryExplain(false).build();
    public static final PlannerConfig PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN = PlannerConfig.builder().useNativeQueryExplain(true).build();
    public static final int MAX_NUM_IN_FILTERS = 100;
    public static final PlannerConfig PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER = PlannerConfig.builder().maxNumericInFilters(100).build();
    public static final String DUMMY_SQL_ID = "dummy";
    public static final String PRETEND_CURRENT_TIME = "2000-01-01T00:00:00Z";
    public static final Map<String, Object> QUERY_CONTEXT_DEFAULT = ImmutableMap.builder().put((Object)"sqlQueryId", (Object)"dummy").put((Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z").put((Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS).put((Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE).build();
    public static final Map<String, Object> QUERY_CONTEXT_NO_STRINGIFY_ARRAY = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlStringifyArrays", (Object)false).build();
    public static final Map<String, Object> QUERY_CONTEXT_NO_STRINGIFY_ARRAY_USE_EQUALITY = ImmutableMap.builder().putAll(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build();
    public static final Map<String, Object> QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy", (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)false, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
    public static final Map<String, Object> QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy", (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)true, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
    public static final Map<String, Object> QUERY_CONTEXT_LEXICOGRAPHIC_TOPN = QueryContexts.override(QUERY_CONTEXT_DEFAULT, (String)"useLexicographicTopN", (Object)true);
    public static final Map<String, Object> QUERY_CONTEXT_NO_TOPN = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy", (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"useApproximateTopN", (Object)"false", (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
    public static final Map<String, Object> QUERY_CONTEXT_LOS_ANGELES = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy", (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"sqlTimeZone", (Object)"America/Los_Angeles", (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
    public static final Map<String, Object> TIMESERIES_CONTEXT_BY_GRAN = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy", (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)true, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
    public static final Map<String, Object> QUERY_CONTEXT_WITH_SUBQUERY_MEMORY_LIMIT = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"maxSubqueryBytes", (Object)"100000").put((Object)"maxSubqueryRows", (Object)"1").build();
    public static final Map<String, Object> TIMESERIES_CONTEXT_LOS_ANGELES = new HashMap<String, Object>();
    public static final Map<String, Object> OUTER_LIMIT_CONTEXT = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
    public boolean cannotVectorize = false;
    public boolean cannotVectorizeUnlessFallback = false;
    public boolean skipVectorize = false;
    @RegisterExtension
    protected static SqlTestFrameworkConfig.Rule queryFrameworkRule;

    public static Map<String, Object> getTimeseriesContextWithFloorTime(Map<String, Object> context, String timestampResultField) {
        return ImmutableMap.builder().putAll(context).put((Object)"timestampResultField", (Object)timestampResultField).build();
    }

    public static boolean developerIDEdetected() {
        String javaCmd = System.getProperties().getProperty("sun.java.command", "");
        boolean isEclipse = javaCmd.contains("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner");
        return isEclipse;
    }

    public static long timestamp(String timeString) {
        return Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)timeString), (DateTimeZone)DateTimeZone.UTC);
    }

    public static long timestamp(String timeString, String timeZoneString) {
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)timeZoneString);
        return Calcites.jodaToCalciteTimestamp((DateTime)new DateTime((Object)timeString, timeZone), (DateTimeZone)timeZone);
    }

    public static int day(String dayString) {
        return (int)(Intervals.utc((long)BaseCalciteQueryTest.timestamp("1970"), (long)BaseCalciteQueryTest.timestamp(dayString)).toDurationMillis() / 86400000L);
    }

    public static QuerySegmentSpec querySegmentSpec(Interval ... intervals) {
        return new MultipleIntervalSegmentSpec(Arrays.asList(intervals));
    }

    public static AndDimFilter and(DimFilter ... filters) {
        return new AndDimFilter(Arrays.asList(filters));
    }

    public static OrDimFilter or(DimFilter ... filters) {
        return new OrDimFilter(Arrays.asList(filters));
    }

    public static NotDimFilter not(DimFilter filter) {
        return new NotDimFilter(filter);
    }

    public static IsTrueDimFilter istrue(DimFilter filter) {
        return new IsTrueDimFilter(filter);
    }

    public static DimFilter in(String dimension, Collection<String> values) {
        return BaseCalciteQueryTest.in(dimension, ColumnType.STRING, new ArrayList<String>(values));
    }

    public static DimFilter in(String dimension, Collection<String> values, ExtractionFn extractionFn) {
        if (extractionFn == null) {
            return BaseCalciteQueryTest.in(dimension, ColumnType.STRING, new ArrayList<String>(values));
        }
        return new InDimFilter(dimension, values, extractionFn);
    }

    public static DimFilter in(String dimension, ColumnType matchValueType, List<?> values) {
        return new TypedInFilter(dimension, matchValueType, values, null, null);
    }

    public static DimFilter isNull(String fieldName) {
        return BaseCalciteQueryTest.isNull(fieldName, null);
    }

    public static DimFilter isNull(String fieldName, ExtractionFn extractionFn) {
        return new NullFilter(fieldName, null);
    }

    public static DimFilter notNull(String fieldName) {
        return BaseCalciteQueryTest.not(BaseCalciteQueryTest.isNull(fieldName));
    }

    public static DimFilter equality(String fieldName, Object matchValue, ColumnType matchValueType) {
        return new EqualityFilter(fieldName, matchValueType, matchValue, null);
    }

    public static ExpressionDimFilter expressionFilter(String expression) {
        return new ExpressionDimFilter(expression, CalciteTests.createExprMacroTable());
    }

    public static DimFilter range(String fieldName, ColumnType matchValueType, Object lower, Object upper, boolean lowerStrict, boolean upperStrict) {
        return new RangeFilter(fieldName, matchValueType, lower, upper, Boolean.valueOf(lowerStrict), Boolean.valueOf(upperStrict), null);
    }

    public static DimFilter timeRange(Object intervalObj) {
        Interval interval = new Interval(intervalObj, (Chronology)ISOChronology.getInstanceUTC());
        return BaseCalciteQueryTest.range("__time", ColumnType.LONG, interval.getStartMillis(), interval.getEndMillis(), false, true);
    }

    public static CascadeExtractionFn cascade(ExtractionFn ... fns) {
        return new CascadeExtractionFn(fns);
    }

    public static List<DimensionSpec> dimensions(DimensionSpec ... dimensionSpecs) {
        return Arrays.asList(dimensionSpecs);
    }

    public static List<AggregatorFactory> aggregators(AggregatorFactory ... aggregators) {
        return Arrays.asList(aggregators);
    }

    public static DimFilterHavingSpec having(DimFilter filter) {
        return new DimFilterHavingSpec(filter, Boolean.valueOf(true));
    }

    public static ExpressionVirtualColumn expressionVirtualColumn(String name, String expression, ColumnType outputType) {
        return new ExpressionVirtualColumn(name, expression, outputType, CalciteTests.createExprMacroTable());
    }

    public ExpressionVirtualColumn nestedExpressionVirtualColumn(String name, String expression, ColumnType outputType) {
        if (this.testBuilder().isDecoupledMode()) {
            expression = StringUtils.format((String)"mv_to_array(%s)", (Object[])new Object[]{expression});
            outputType = ColumnType.ofArray((ColumnType)outputType);
        }
        return BaseCalciteQueryTest.expressionVirtualColumn(name, expression, outputType);
    }

    public static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, String condition, JoinType joinType, DimFilter filter, JoinAlgorithm joinAlgorithm) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)condition, (JoinType)joinType, (DimFilter)filter, (ExprMacroTable)CalciteTests.createExprMacroTable(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)joinAlgorithm);
    }

    public static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, String condition, JoinType joinType, DimFilter filter) {
        return BaseCalciteQueryTest.join(left, right, rightPrefix, condition, joinType, filter, JoinAlgorithm.BROADCAST);
    }

    public static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, String condition, JoinType joinType) {
        return BaseCalciteQueryTest.join(left, right, rightPrefix, condition, joinType, null);
    }

    public static UnionDataSource unionDataSource(String ... datasources) {
        List sources = Stream.of(datasources).map(TableDataSource::new).collect(Collectors.toList());
        return new UnionDataSource(sources);
    }

    public static String equalsCondition(DruidExpression left, DruidExpression right) {
        return StringUtils.format((String)"(%s == %s)", (Object[])new Object[]{left.getExpression(), right.getExpression()});
    }

    public static ExpressionPostAggregator expressionPostAgg(String name, String expression, ColumnType outputType) {
        return new ExpressionPostAggregator(name, expression, null, outputType, CalciteTests.createExprMacroTable());
    }

    public static Druids.ScanQueryBuilder newScanQueryBuilder() {
        return new Druids.ScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST);
    }

    protected static DruidExceptionMatcher invalidSqlIs(String s) {
        return DruidExceptionMatcher.invalidSqlInput().expectMessageIs(s);
    }

    protected static DruidExceptionMatcher invalidSqlContains(String s) {
        return DruidExceptionMatcher.invalidSqlInput().expectMessageContains(s);
    }

    public SqlTestFramework queryFramework() {
        try {
            return queryFrameworkRule.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assumeFeatureAvailable(EngineFeature feature) {
        boolean featureAvailable = this.queryFramework().engine().featureAvailable(feature);
        Assumptions.assumeTrue((boolean)featureAvailable, (String)StringUtils.format((String)"test disabled; feature [%s] is not available!", (Object[])new Object[]{feature}));
    }

    public void assertQueryIsUnplannable(String sql, String expectedError) {
        this.assertQueryIsUnplannable(PLANNER_CONFIG_DEFAULT, sql, expectedError);
    }

    public void assertQueryIsUnplannable(PlannerConfig plannerConfig, String sql, String expectedError) {
        try {
            this.testQuery(plannerConfig, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)this.buildUnplannableExceptionMatcher().expectMessageContains(expectedError));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Expected DruidException for query: %s", new Object[]{sql});
            throw e;
        }
    }

    private DruidExceptionMatcher buildUnplannableExceptionMatcher() {
        if (this.testBuilder().isDecoupledMode()) {
            return new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput");
        }
        return new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "general");
    }

    public void assertQueryIsForbidden(String sql, AuthenticationResult authenticationResult) {
        this.assertQueryIsForbidden(PLANNER_CONFIG_DEFAULT, sql, authenticationResult);
    }

    public void assertQueryIsForbidden(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult) {
        Exception e = null;
        try {
            this.testQuery(plannerConfig, sql, authenticationResult, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        }
        catch (Exception e1) {
            e = e1;
        }
        if (!(e instanceof ForbiddenException)) {
            log.error((Throwable)e, "Expected ForbiddenException for query: %s with authResult: %s", new Object[]{sql, authenticationResult});
            Assert.fail((String)sql);
        }
    }

    public void testQuery(String sql, List<Query<?>> expectedQueries, List<Object[]> expectedResults) {
        this.testBuilder().sql(sql).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(String sql, List<Query<?>> expectedQueries, ResultMatchMode resultsMatchMode, List<Object[]> expectedResults) {
        this.testBuilder().sql(sql).expectedQueries(expectedQueries).expectedResults(resultsMatchMode, expectedResults).run();
    }

    public void testQuery(String sql, List<Query<?>> expectedQueries, List<Object[]> expectedResults, RowSignature expectedResultSignature) {
        this.testBuilder().sql(sql).expectedQueries(expectedQueries).expectedResults(expectedResults).expectedSignature(expectedResultSignature).run();
    }

    public void testQuery(String sql, Map<String, Object> queryContext, List<Query<?>> expectedQueries, List<Object[]> expectedResults) {
        this.testBuilder().queryContext(queryContext).sql(sql).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(String sql, List<Query<?>> expectedQueries, List<Object[]> expectedResults, List<SqlParameter> parameters) {
        this.testBuilder().sql(sql).parameters(parameters).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult, List<Query<?>> expectedQueries, List<Object[]> expectedResults) {
        this.testBuilder().plannerConfig(plannerConfig).sql(sql).authResult(authenticationResult).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(String sql, Map<String, Object> queryContext, List<Query<?>> expectedQueries, ResultsVerifier expectedResultsVerifier) {
        this.testBuilder().sql(sql).queryContext(queryContext).expectedQueries(expectedQueries).expectedResults(expectedResultsVerifier).run();
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, String sql, AuthenticationResult authenticationResult, List<Query<?>> expectedQueries, List<Object[]> expectedResults) {
        this.testBuilder().plannerConfig(plannerConfig).queryContext(queryContext).sql(sql).authResult(authenticationResult).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult, List<Query<?>> expectedQueries, List<Object[]> expectedResults) {
        this.testBuilder().plannerConfig(plannerConfig).queryContext(queryContext).parameters(parameters).sql(sql).authResult(authenticationResult).expectedQueries(expectedQueries).expectedResults(expectedResults).run();
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult, List<Query<?>> expectedQueries, ResultsVerifier expectedResultsVerifier) {
        this.testBuilder().plannerConfig(plannerConfig).queryContext(queryContext).parameters(parameters).sql(sql).authResult(authenticationResult).expectedQueries(expectedQueries).expectedResults(expectedResultsVerifier).run();
    }

    protected QueryTestBuilder testBuilder() {
        return new QueryTestBuilder(new CalciteTestConfig()).cannotVectorize(this.cannotVectorize || !ExpressionProcessing.allowVectorizeFallback() && this.cannotVectorizeUnlessFallback).skipVectorize(this.skipVectorize);
    }

    public CalciteTestConfig createCalciteTestConfig() {
        return new CalciteTestConfig();
    }

    public static void assertResultsValid(ResultMatchMode matchMode, List<Object[]> expected, QueryTestRunner.QueryResults queryResults) {
        List<Object[]> results = queryResults.results;
        Assert.assertEquals((String)"Result count mismatch", (long)expected.size(), (long)results.size());
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        for (int i = 0; i < queryResults.signature.getColumnNames().size(); ++i) {
            Optional columnType = queryResults.signature.getColumnType(i);
            if (columnType.isPresent()) {
                types.add((ValueType)((ColumnType)columnType.get()).getType());
                continue;
            }
            types.add(null);
        }
        int numRows = results.size();
        for (int row = 0; row < numRows; ++row) {
            Object[] expectedRow = expected.get(row);
            Object[] resultRow = results.get(row);
            Assert.assertEquals((String)("column count mismatch; at row#" + row), (long)expectedRow.length, (long)resultRow.length);
            for (int i = 0; i < resultRow.length; ++i) {
                Object resultCell = resultRow[i];
                Object expectedCell = expectedRow[i];
                matchMode.validate(row, i, (ValueType)types.get(i), expectedCell, resultCell);
            }
        }
    }

    public static void assertResultsEquals(String sql, List<Object[]> expectedResults, List<Object[]> results) {
        int minSize = Math.min(results.size(), expectedResults.size());
        for (int i = 0; i < minSize; ++i) {
            Assert.assertArrayEquals((String)StringUtils.format((String)"result #%d: %s", (Object[])new Object[]{i + 1, sql}), (Object[])expectedResults.get(i), (Object[])results.get(i));
        }
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
    }

    public <T extends Throwable> void testQueryThrows(String sql, DruidExceptionMatcher exceptionMatcher) {
        this.testQueryThrows(sql, null, DruidException.class, (Matcher<Throwable>)exceptionMatcher);
    }

    public <T extends Exception> void testQueryThrows(String sql, Class<T> exceptionType, String exceptionMessage) {
        this.testQueryThrows(sql, null, exceptionType, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)exceptionMessage)));
    }

    public <T extends Exception> void testQueryThrows(String sql, Class<T> exceptionType, Matcher<Throwable> exceptionMatcher) {
        this.testQueryThrows(sql, null, exceptionType, exceptionMatcher);
    }

    public <T extends Exception> void testQueryThrows(String sql, Map<String, Object> queryContext, Class<T> exceptionType, Matcher<Throwable> exceptionMatcher) {
        Exception e = (Exception)Assert.assertThrows(exceptionType, () -> this.testBuilder().sql(sql).queryContext(queryContext).build().run());
        MatcherAssert.assertThat((Object)e, exceptionMatcher);
    }

    public void analyzeResources(String sql, List<ResourceAction> expectedActions) {
        this.testBuilder().sql(sql).expectedResources(expectedActions).run();
    }

    public void analyzeResources(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult, List<ResourceAction> expectedActions) {
        this.testBuilder().plannerConfig(plannerConfig).sql(sql).authResult(authenticationResult).expectedResources(expectedActions).run();
    }

    public void analyzeResources(PlannerConfig plannerConfig, AuthConfig authConfig, String sql, Map<String, Object> contexts, AuthenticationResult authenticationResult, List<ResourceAction> expectedActions) {
        this.testBuilder().plannerConfig(plannerConfig).authConfig(authConfig).sql(sql).queryContext(contexts).authResult(authenticationResult).expectedResources(expectedActions).run();
    }

    public SqlStatementFactory getSqlStatementFactory(PlannerConfig plannerConfig) {
        return this.getSqlStatementFactory(plannerConfig, new AuthConfig());
    }

    SqlStatementFactory getSqlStatementFactory(PlannerConfig plannerConfig, AuthConfig authConfig) {
        return this.queryFramework().plannerFixture(plannerConfig, authConfig).statementFactory();
    }

    protected void cannotVectorize() {
        this.cannotVectorize = true;
    }

    protected void cannotVectorizeUnlessFallback() {
        this.cannotVectorizeUnlessFallback = true;
    }

    protected void skipVectorize() {
        this.skipVectorize = true;
    }

    protected void msqIncompatible() {
        Assumptions.assumeFalse((boolean)this.testBuilder().config.isRunningMSQ(), (String)"test case is not MSQ compatible");
    }

    protected boolean isRunningMSQ() {
        return this.testBuilder().config.isRunningMSQ();
    }

    protected static boolean isRewriteJoinToFilter(Map<String, Object> queryContext) {
        return (Boolean)queryContext.getOrDefault("enableRewriteJoinToFilter", true);
    }

    public static <T> Query<?> recursivelyClearContext(Query<T> query, ObjectMapper queryJsonMapper) {
        try {
            Query newQuery;
            if (query instanceof UnionQuery) {
                UnionQuery unionQuery = (UnionQuery)query;
                newQuery = unionQuery.withDataSources(BaseCalciteQueryTest.recursivelyClearDatasource(unionQuery.getDataSources(), queryJsonMapper));
            } else {
                newQuery = query.withDataSource(BaseCalciteQueryTest.recursivelyClearContext(query.getDataSource(), queryJsonMapper));
            }
            JsonNode newQueryNode = queryJsonMapper.valueToTree((Object)newQuery);
            ((ObjectNode)newQueryNode).remove("context");
            JsonNode fc = ((ObjectNode)newQueryNode).get("searchFilterContext");
            if (fc != null) {
                ((ObjectNode)fc).remove("nowMs");
            }
            return (Query)queryJsonMapper.treeToValue((TreeNode)newQueryNode, Query.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<DataSource> recursivelyClearDatasource(List<DataSource> dataSources, ObjectMapper queryJsonMapper) {
        ArrayList<DataSource> ret = new ArrayList<DataSource>();
        for (DataSource dataSource : dataSources) {
            ret.add(BaseCalciteQueryTest.recursivelyClearContext(dataSource, queryJsonMapper));
        }
        return ret;
    }

    private static DataSource recursivelyClearContext(DataSource dataSource, ObjectMapper queryJsonMapper) {
        if (dataSource instanceof QueryDataSource) {
            Query subquery = ((QueryDataSource)dataSource).getQuery();
            Query<?> newSubQuery = BaseCalciteQueryTest.recursivelyClearContext(subquery, queryJsonMapper);
            return new QueryDataSource(newSubQuery);
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(ds -> BaseCalciteQueryTest.recursivelyClearContext(ds, queryJsonMapper)).collect(Collectors.toList()));
    }

    public static Object[] provideQueryContexts() {
        return new Object[]{Named.of((String)"default", QUERY_CONTEXT_DEFAULT), Named.of((String)"all_enabled", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)true).build()), Named.of((String)"filter-on-value-column_disabled", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)true).build()), Named.of((String)"join-to-filter", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)true).build()), Named.of((String)"filter-rewrites-disabled", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)true).build()), Named.of((String)"filter-rewrites", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)false).build()), Named.of((String)"all_disabled", (Object)new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)false).build())};
    }

    protected Map<String, Object> withLeftDirectAccessEnabled(Map<String, Object> context) {
        HashMap<String, Object> newContext = new HashMap<String, Object>(context);
        newContext.put("enableJoinLeftTableScanDirect", true);
        return newContext;
    }

    protected Map<String, Object> withTimestampResultContext(Map<String, Object> input, String timestampResultField, int timestampResultFieldIndex, Granularity granularity) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        output.put("timestampResultField", timestampResultField);
        try {
            output.put("timestampResultFieldGranularity", this.queryFramework().queryJsonMapper().writeValueAsString((Object)granularity));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        output.put("timestampResultFieldInOriginalDimensions", timestampResultFieldIndex);
        return output;
    }

    private ResultsVerifier defaultResultsVerifier(List<Object[]> expectedResults, ResultMatchMode expectedResultMatchMode, RowSignature expectedSignature) {
        return new DefaultResultsVerifier(expectedResults, expectedResultMatchMode, expectedSignature);
    }

    public static String resultsToString(String name, List<Object[]> results) {
        return new ResultsPrinter(name, results).getResult();
    }

    public File getResourceAsTemporaryFile(String resource) {
        File file = this.newTempFile("resourceAsTempFile");
        InputStream stream = this.getClass().getResourceAsStream(resource);
        if (stream == null) {
            throw new RE(StringUtils.format((String)"No such resource [%s]", (Object[])new Object[]{resource}), new Object[0]);
        }
        try {
            ByteStreams.copy((InputStream)stream, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public String ds(String colName) {
        if (this.testBuilder().isDecoupledMode()) {
            return colName;
        }
        return "_" + colName;
    }

    static {
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlQueryId", DUMMY_SQL_ID);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlCurrentTimestamp", PRETEND_CURRENT_TIME);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlTimeZone", LOS_ANGELES);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("skipEmptyBuckets", true);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("defaultTimeout", QueryContexts.DEFAULT_TIMEOUT_MILLIS);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("maxScatterGatherBytes", Long.MAX_VALUE);
        OUTER_LIMIT_CONTEXT.put("sqlOuterLimit", 2);
        queryFrameworkRule = new SqlTestFrameworkConfig.Rule();
    }

    public static enum ResultMatchMode {
        EQUALS{

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                Assert.assertEquals((String)ResultMatchMode.mismatchMessage(row, column), (Object)expectedCell, (Object)resultCell);
            }
        }
        ,
        RELAX_NULLS{

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                if (expectedCell == null && resultCell == null) {
                    return;
                }
                EQUALS.validate(row, column, type, expectedCell, resultCell);
            }
        }
        ,
        EQUALS_EPS{

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                if (expectedCell instanceof Float) {
                    Assert.assertEquals((String)ResultMatchMode.mismatchMessage(row, column), (double)((Float)expectedCell).floatValue(), (double)((Float)resultCell).floatValue(), (double)1.0E-5);
                } else if (expectedCell instanceof Double) {
                    Assert.assertEquals((String)ResultMatchMode.mismatchMessage(row, column), (double)((Double)expectedCell), (double)((Double)resultCell), (double)1.0E-5);
                } else if (expectedCell instanceof Object[] || expectedCell instanceof List) {
                    Object[] resultCellCasted;
                    Object[] expectedCellCasted = ResultMatchMode.homogenizeArray(expectedCell);
                    if (expectedCellCasted.length != (resultCellCasted = ResultMatchMode.homogenizeArray(resultCell)).length) {
                        throw new RE("Mismatched array lengths: expected[%s] with length[%d], actual[%s] with length[%d]", new Object[]{Arrays.toString(expectedCellCasted), expectedCellCasted.length, Arrays.toString(resultCellCasted), resultCellCasted.length});
                    }
                    for (int i = 0; i < expectedCellCasted.length; ++i) {
                        this.validate(row, column, type, expectedCellCasted[i], resultCellCasted[i]);
                    }
                } else {
                    EQUALS.validate(row, column, type, expectedCell, resultCell);
                }
            }
        }
        ,
        RELAX_NULLS_EPS{

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                if (expectedCell == null && resultCell == null) {
                    return;
                }
                EQUALS_EPS.validate(row, column, type, expectedCell, resultCell);
            }
        }
        ,
        EQUALS_RELATIVE_1000_ULPS{
            private static final int ASSERTION_ERROR_ULPS = 1000;

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                if (expectedCell instanceof Float) {
                    float eps = 1000.0f * Math.ulp(((Float)expectedCell).floatValue());
                    Assert.assertEquals((String)ResultMatchMode.mismatchMessage(row, column), (float)((Float)expectedCell).floatValue(), (float)((Float)resultCell).floatValue(), (float)eps);
                } else if (expectedCell instanceof Double) {
                    double eps = 1000.0 * Math.ulp((Double)expectedCell);
                    Assert.assertEquals((String)ResultMatchMode.mismatchMessage(row, column), (double)((Double)expectedCell), (double)((Double)resultCell), (double)eps);
                } else if (expectedCell instanceof Object[] || expectedCell instanceof List) {
                    Object[] resultCellCasted;
                    Object[] expectedCellCasted = ResultMatchMode.homogenizeArray(expectedCell);
                    if (expectedCellCasted.length != (resultCellCasted = ResultMatchMode.homogenizeArray(resultCell)).length) {
                        throw new RE("Mismatched array lengths: expected[%s] with length[%d], actual[%s] with length[%d]", new Object[]{Arrays.toString(expectedCellCasted), expectedCellCasted.length, Arrays.toString(resultCellCasted), resultCellCasted.length});
                    }
                    for (int i = 0; i < expectedCellCasted.length; ++i) {
                        this.validate(row, column, type, expectedCellCasted[i], resultCellCasted[i]);
                    }
                } else {
                    EQUALS.validate(row, column, type, expectedCell, resultCell);
                }
            }
        }
        ,
        RELAX_NULLS_RELATIVE_1000_ULPS{

            @Override
            void validate(int row, int column, ValueType type, Object expectedCell, Object resultCell) {
                if (expectedCell == null && resultCell == null) {
                    return;
                }
                EQUALS_RELATIVE_1000_ULPS.validate(row, column, type, expectedCell, resultCell);
            }
        };


        abstract void validate(int var1, int var2, ValueType var3, Object var4, Object var5);

        private static String mismatchMessage(int row, int column) {
            return StringUtils.format((String)"column content mismatch at %d,%d", (Object[])new Object[]{row, column});
        }

        private static Object[] homogenizeArray(Object array) {
            if (array instanceof Object[]) {
                return (Object[])array;
            }
            if (array instanceof List) {
                return (Object[])ExprEval.coerceListToArray((List)((List)array), (boolean)true).rhs;
            }
            throw new ISE("Found array[%s] of type[%s] which is not handled", new Object[]{array.toString(), array.getClass().getName()});
        }
    }

    @FunctionalInterface
    public static interface ResultsVerifier {
        default public void verifyRowSignature(RowSignature rowSignature) {
        }

        public void verify(String var1, QueryTestRunner.QueryResults var2);
    }

    public class CalciteTestConfig
    implements QueryTestBuilder.QueryTestConfig {
        private boolean isRunningMSQ = false;
        private Map<String, Object> baseQueryContext;

        public CalciteTestConfig() {
            this(QUERY_CONTEXT_DEFAULT);
        }

        public CalciteTestConfig(boolean isRunningMSQ) {
            this();
            this.isRunningMSQ = isRunningMSQ;
        }

        public CalciteTestConfig(Map<String, Object> baseQueryContext, boolean isRunningMSQ) {
            this(baseQueryContext);
            this.isRunningMSQ = isRunningMSQ;
        }

        public CalciteTestConfig(Map<String, Object> baseQueryContext) {
            Preconditions.checkNotNull(baseQueryContext, (Object)"baseQueryContext is null");
            this.baseQueryContext = baseQueryContext;
            Preconditions.checkState((boolean)baseQueryContext.containsKey("sqlCurrentTimestamp"), (Object)"context must contain CTX_SQL_CURRENT_TIMESTAMP to ensure consistent behaviour!");
        }

        @Override
        public SqlTestFramework.PlannerFixture plannerFixture(PlannerConfig plannerConfig, AuthConfig authConfig) {
            return this.queryFramework().plannerFixture(plannerConfig, authConfig);
        }

        @Override
        public ObjectMapper jsonMapper() {
            return this.queryFramework().queryJsonMapper();
        }

        @Override
        public ResultsVerifier defaultResultsVerifier(List<Object[]> expectedResults, ResultMatchMode expectedResultMatchMode, RowSignature expectedResultSignature) {
            return BaseCalciteQueryTest.this.defaultResultsVerifier(expectedResults, expectedResultMatchMode, expectedResultSignature);
        }

        @Override
        public boolean isRunningMSQ() {
            return this.isRunningMSQ;
        }

        @Override
        public Map<String, Object> baseQueryContext() {
            return this.baseQueryContext;
        }

        @Override
        public SqlTestFramework queryFramework() {
            return BaseCalciteQueryTest.this.queryFramework();
        }
    }

    public static class DefaultResultsVerifier
    implements ResultsVerifier {
        protected final List<Object[]> expectedResults;
        @Nullable
        protected final RowSignature expectedResultRowSignature;
        protected final ResultMatchMode expectedResultMatchMode;

        public DefaultResultsVerifier(List<Object[]> expectedResults, ResultMatchMode expectedResultMatchMode, RowSignature expectedSignature) {
            this.expectedResults = expectedResults;
            this.expectedResultMatchMode = expectedResultMatchMode;
            this.expectedResultRowSignature = expectedSignature;
        }

        public DefaultResultsVerifier(List<Object[]> expectedResults, RowSignature expectedSignature) {
            this(expectedResults, ResultMatchMode.EQUALS, expectedSignature);
        }

        @Override
        public void verifyRowSignature(RowSignature rowSignature) {
            if (this.expectedResultRowSignature != null) {
                Assert.assertEquals((Object)this.expectedResultRowSignature, (Object)rowSignature);
            }
        }

        @Override
        public void verify(String sql, QueryTestRunner.QueryResults queryResults) {
            try {
                BaseCalciteQueryTest.assertResultsValid(this.expectedResultMatchMode, this.expectedResults, queryResults);
            }
            catch (AssertionError e) {
                log.info("sql: %s", new Object[]{sql});
                log.info(BaseCalciteQueryTest.resultsToString("Expected", this.expectedResults), new Object[0]);
                log.info(BaseCalciteQueryTest.resultsToString("Actual", queryResults.results), new Object[0]);
                throw e;
            }
        }
    }

    static class ResultsPrinter {
        private StringBuilder sb = new StringBuilder();

        private ResultsPrinter(String name, List<Object[]> results) {
            this.sb.append("-- ");
            this.sb.append(name);
            this.sb.append(" results --\n");
            for (int rowIndex = 0; rowIndex < results.size(); ++rowIndex) {
                this.printArray(results.get(rowIndex));
                if (rowIndex < results.size() - 1) {
                    this.outprint(",");
                }
                this.sb.append('\n');
            }
            this.sb.append("----");
        }

        private String getResult() {
            return this.sb.toString();
        }

        private void printArray(Object[] array) {
            this.printArrayImpl(array, "new Object[]{", "}");
        }

        private void printList(List<?> list) {
            this.printArrayImpl(list.toArray(new Object[0]), "ImmutableList.of(", ")");
        }

        private void printArrayImpl(Object[] array, String pre, String post) {
            this.sb.append(pre);
            for (int colIndex = 0; colIndex < array.length; ++colIndex) {
                Object col = array[colIndex];
                if (colIndex > 0) {
                    this.sb.append(", ");
                }
                if (col == null) {
                    this.sb.append("null");
                    continue;
                }
                if (col instanceof String) {
                    this.outprint("\"");
                    this.outprint(StringEscapeUtils.escapeJava((String)((String)col)));
                    this.outprint("\"");
                    continue;
                }
                if (col instanceof Long) {
                    this.outprint(col);
                    this.outprint("L");
                    continue;
                }
                if (col instanceof Double) {
                    this.outprint(col);
                    this.outprint("D");
                    continue;
                }
                if (col instanceof Float) {
                    this.outprint(col);
                    this.outprint("F");
                    continue;
                }
                if (col instanceof Object[]) {
                    this.printArray((Object[])col);
                    continue;
                }
                if (col instanceof List) {
                    this.printList((List)col);
                    continue;
                }
                this.outprint(col);
            }
            this.outprint(post);
        }

        private void outprint(Object post) {
            this.sb.append(post);
        }
    }

    public static class UnorderedResultsVerifier
    extends DefaultResultsVerifier {
        public UnorderedResultsVerifier(List<Object[]> expectedResults, ResultMatchMode expectedResultMatchMode, RowSignature expectedSignature) {
            super((List<Object[]>)ImmutableList.sortedCopyOf((Comparator)new DrillWindowQueryTest.ArrayRowCmp(), expectedResults), expectedResultMatchMode, expectedSignature);
        }

        @Override
        public void verify(String sql, QueryTestRunner.QueryResults queryResults) {
            queryResults.results.sort(new DrillWindowQueryTest.ArrayRowCmp());
            super.verify(sql, queryResults);
        }
    }
}

