/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidAvaticaHandlerTest;
import org.apache.druid.sql.avatica.DruidAvaticaProtobufHandler;
import org.apache.druid.sql.avatica.DruidMeta;
import org.easymock.EasyMock;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DruidAvaticaProtobufHandlerTest
extends DruidAvaticaHandlerTest {
    @Override
    protected String getJdbcUrlTail() {
        return StringUtils.format((String)"%s;serialization=protobuf", (Object[])new Object[]{"/druid/v2/sql/avatica-protobuf/"});
    }

    protected DruidAvaticaProtobufHandler getAvaticaHandler(DruidMeta druidMeta) {
        return new DruidAvaticaProtobufHandler(druidMeta, new DruidNode("dummy", "dummy", false, Integer.valueOf(1), null, true, false), new AvaticaMonitor());
    }

    @Test
    public void testNonPostRequestReturns405() throws Exception {
        DruidMeta druidMeta = (DruidMeta)EasyMock.mock(DruidMeta.class);
        DruidAvaticaProtobufHandler handler = new DruidAvaticaProtobufHandler(druidMeta, new DruidNode("dummy", "dummy", false, Integer.valueOf(1), null, true, false), new AvaticaMonitor());
        Request request = (Request)EasyMock.mock(Request.class);
        Response response = (Response)EasyMock.mock(Response.class);
        Callback callback = (Callback)EasyMock.mock(Callback.class);
        HttpURI httpURI = (HttpURI)EasyMock.mock(HttpURI.class);
        EasyMock.expect((Object)request.getHttpURI()).andReturn((Object)httpURI);
        EasyMock.expect((Object)httpURI.getPath()).andReturn((Object)"/druid/v2/sql/avatica-protobuf");
        EasyMock.expect((Object)request.getMethod()).andReturn((Object)"GET");
        response.setStatus(405);
        EasyMock.expectLastCall();
        response.write(EasyMock.eq((boolean)true), (ByteBuffer)EasyMock.anyObject(ByteBuffer.class), (Callback)EasyMock.eq((Object)callback));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{request, response, callback, httpURI});
        boolean handled = handler.handle(request, response, callback);
        Assertions.assertTrue((boolean)handled, (String)"Handler should have handled the request");
        EasyMock.verify((Object[])new Object[]{request, response, callback, httpURI});
    }
}

